/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.VariableRemapper;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0013H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/MakePropertyDelegateMethodsStaticLowering;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitSimpleFunction", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "isSyntheticDelegateMethod", "", "backend.jvm.lower"})
final class MakePropertyDelegateMethodsStaticLowering
extends IrElementTransformerVoid
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    public MakePropertyDelegateMethodsStaticLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter(context, "context");
        this.context = context;
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        irFile.transform((IrElementTransformer)this, (Object)null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IrStatement visitSimpleFunction(@NotNull IrSimpleFunction declaration) {
        Collection<IrValueParameter> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        IrSimpleFunction irSimpleFunction;
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        if (!this.isSyntheticDelegateMethod(declaration)) {
            return super.visitSimpleFunction(declaration);
        }
        IrValueParameter irValueParameter = declaration.getDispatchReceiverParameter();
        if (irValueParameter == null) {
            return super.visitSimpleFunction(declaration);
        }
        IrValueParameter oldParameter = irValueParameter;
        IrValueParameter newParameter = IrUtilsKt.copyTo$default(oldParameter, declaration, null, 0, 0, 0, null, null, null, null, null, false, false, false, 8186, null);
        IrSimpleFunction $this$visitSimpleFunction_u24lambda_u241 = irSimpleFunction = declaration;
        boolean bl = false;
        Iterable iterable = $this$visitSimpleFunction_u24lambda_u241.getValueParameters();
        Collection collection2 = CollectionsKt.listOf(newParameter);
        IrSimpleFunction irSimpleFunction2 = $this$visitSimpleFunction_u24lambda_u241;
        boolean $i$f$map = false;
        void var11_11 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrValueParameter irValueParameter2 = (IrValueParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(IrUtilsKt.copyTo$default((IrValueParameter)it, $this$visitSimpleFunction_u24lambda_u241, null, it.getIndex() + 1, 0, 0, null, null, null, null, null, false, false, false, 8186, null));
        }
        collection = (List)destination$iv$iv;
        irSimpleFunction2.setValueParameters(CollectionsKt.plus(collection2, (Iterable)collection));
        $this$visitSimpleFunction_u24lambda_u241.setDispatchReceiverParameter(null);
        IrBody irBody = $this$visitSimpleFunction_u24lambda_u241.getBody();
        $this$visitSimpleFunction_u24lambda_u241.setBody((IrBody)(irBody != null ? irBody.transform((IrElementTransformer)new VariableRemapper(MapsKt.mapOf(TuplesKt.to(oldParameter, newParameter))), (Object)null) : null));
        return irSimpleFunction;
    }

    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        if (this.isSyntheticDelegateMethod((IrSimpleFunction)expression2.getSymbol().getOwner())) {
            throw new IllegalStateException(("`$delegate` method should not be called. Please either remove the call, or support remapping of dispatch receiver in MakePropertyDelegateMethodsStaticLowering: " + RenderIrElementKt.render((IrElement)expression2.getSymbol().getOwner())).toString());
        }
        return super.visitCall(expression2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSyntheticDelegateMethod(IrSimpleFunction $this$isSyntheticDelegateMethod) {
        if (!Intrinsics.areEqual($this$isSyntheticDelegateMethod.getOrigin(), IrDeclarationOrigin.PROPERTY_DELEGATE.INSTANCE)) return false;
        String string2 = $this$isSyntheticDelegateMethod.getName().asString();
        Intrinsics.checkNotNullExpressionValue(string2, "name.asString()");
        if (!StringsKt.endsWith$default(string2, "$delegate", false, 2, null)) return false;
        return true;
    }
}

