/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.KotlinRetention;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnnotationUseSiteTarget;
import org.jetbrains.kotlin.resolve.AdditionalAnnotationChecker;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.checkers.ExperimentalMarkerDeclarationAnnotationChecker;
import org.jetbrains.kotlin.resolve.checkers.ExperimentalUsageChecker;
import org.jetbrains.kotlin.resolve.checkers.Experimentality;
import org.jetbrains.kotlin.resolve.checkers.OptInNames;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J>\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001e\u0010\u0012\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\f\u001a\u00020\rH\u0002J*\u0010\u0013\u001a\u00020\u00062\u0010\u0010\u0014\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00150\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\tH\u0002J$\u0010\u0017\u001a\u00020\u0018*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u000e\b\u0002\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00190\u001dH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalMarkerDeclarationAnnotationChecker;", "Lorg/jetbrains/kotlin/resolve/AdditionalAnnotationChecker;", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;)V", "checkEntries", "", "entries", "", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "actualTargets", "Lorg/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "annotated", "Lorg/jetbrains/kotlin/psi/KtAnnotated;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "checkMarkerTargetsAndRetention", "checkOptInUsage", "annotationClasses", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "entry", "hasExperimentalOverriddenDescriptors", "", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "experimentalFqName", "Lorg/jetbrains/kotlin/name/FqName;", "visited", "", "frontend"})
public final class ExperimentalMarkerDeclarationAnnotationChecker
implements AdditionalAnnotationChecker {
    @NotNull
    private final ModuleDescriptor module;

    public ExperimentalMarkerDeclarationAnnotationChecker(@NotNull ModuleDescriptor module2) {
        Intrinsics.checkNotNullParameter(module2, "module");
        this.module = module2;
    }

    @Override
    public void checkEntries(@NotNull List<? extends KtAnnotationEntry> entries, @NotNull List<? extends KotlinTarget> actualTargets, @NotNull BindingTrace trace, @Nullable KtAnnotated annotated, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter(entries, "entries");
        Intrinsics.checkNotNullParameter(actualTargets, "actualTargets");
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        boolean isAnnotatedWithExperimental = false;
        for (KtAnnotationEntry ktAnnotationEntry : entries) {
            AnnotationUseSiteTarget annotationUseSiteTarget;
            boolean bl;
            ClassDescriptor annotationClass;
            block13: {
                Iterator $this$safeAs$iv;
                AnnotationDescriptor annotation2;
                if ((AnnotationDescriptor)trace.getBindingContext().get(BindingContext.ANNOTATION, ktAnnotationEntry) == null) continue;
                FqName fqName2 = annotation2.getFqName();
                if (CollectionsKt.contains((Iterable)OptInNames.INSTANCE.getOPT_IN_FQ_NAMES(), fqName2)) {
                    ConstantValue<?> constantValue = annotation2.getAllValueArguments().get(OptInNames.INSTANCE.getUSE_EXPERIMENTAL_ANNOTATION_CLASS());
                    boolean $i$f$safeAs = false;
                    Iterator iterator2 = $this$safeAs$iv;
                    if (!(iterator2 instanceof ArrayValue)) {
                        iterator2 = null;
                    }
                    ArrayValue arrayValue = (ArrayValue)((Object)iterator2);
                    List<Object> list2 = arrayValue != null ? (List)arrayValue.getValue() : null;
                    if (list2 == null) {
                        list2 = CollectionsKt.emptyList();
                    }
                    List annotationClasses = list2;
                    this.checkOptInUsage(annotationClasses, trace, ktAnnotationEntry);
                } else if (CollectionsKt.contains((Iterable)OptInNames.INSTANCE.getREQUIRES_OPT_IN_FQ_NAMES(), fqName2)) {
                    isAnnotatedWithExperimental = true;
                }
                if (DescriptorUtilsKt.getAnnotationClass(annotation2) == null) continue;
                Iterable $this$any$iv = annotationClass.getAnnotations();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    $this$safeAs$iv = $this$any$iv.iterator();
                    while ($this$safeAs$iv.hasNext()) {
                        Object element$iv = $this$safeAs$iv.next();
                        AnnotationDescriptor it = (AnnotationDescriptor)element$iv;
                        boolean bl2 = false;
                        if (!CollectionsKt.contains((Iterable)OptInNames.INSTANCE.getREQUIRES_OPT_IN_FQ_NAMES(), it.getFqName())) continue;
                        bl = true;
                        break block13;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            Set<KotlinTarget> applicableTargets = AnnotationChecker.Companion.applicableTargetSet(annotationClass);
            Set possibleTargets = CollectionsKt.intersect((Iterable)applicableTargets, (Iterable)actualTargets);
            KtAnnotationUseSiteTarget ktAnnotationUseSiteTarget = ktAnnotationEntry.getUseSiteTarget();
            AnnotationUseSiteTarget annotationUseSiteTarget2 = annotationUseSiteTarget = ktAnnotationUseSiteTarget != null ? ktAnnotationUseSiteTarget.getAnnotationUseSiteTarget() : null;
            if (possibleTargets.contains((Object)KotlinTarget.PROPERTY_GETTER) || annotationUseSiteTarget == AnnotationUseSiteTarget.PROPERTY_GETTER) {
                trace.report(Errors.OPT_IN_MARKER_ON_WRONG_TARGET.on((KtAnnotationEntry)((PsiElement)ktAnnotationEntry), "getter"));
            }
            if (possibleTargets.contains((Object)KotlinTarget.VALUE_PARAMETER) && annotationUseSiteTarget == null || annotationUseSiteTarget == AnnotationUseSiteTarget.RECEIVER || annotationUseSiteTarget == AnnotationUseSiteTarget.SETTER_PARAMETER || annotationUseSiteTarget == AnnotationUseSiteTarget.CONSTRUCTOR_PARAMETER) {
                trace.report(Errors.OPT_IN_MARKER_ON_WRONG_TARGET.on((KtAnnotationEntry)((PsiElement)ktAnnotationEntry), "parameter"));
            }
            if (possibleTargets.contains((Object)KotlinTarget.LOCAL_VARIABLE)) {
                trace.report(Errors.OPT_IN_MARKER_ON_WRONG_TARGET.on((KtAnnotationEntry)((PsiElement)ktAnnotationEntry), "variable"));
            }
            if (annotationUseSiteTarget != AnnotationUseSiteTarget.FIELD && annotationUseSiteTarget != AnnotationUseSiteTarget.PROPERTY_DELEGATE_FIELD) continue;
            trace.report(Errors.OPT_IN_MARKER_ON_WRONG_TARGET.on((KtAnnotationEntry)((PsiElement)ktAnnotationEntry), "field"));
        }
        if (isAnnotatedWithExperimental) {
            this.checkMarkerTargetsAndRetention(entries, trace);
        }
    }

    private final void checkOptInUsage(List<? extends ConstantValue<?>> annotationClasses, BindingTrace trace, KtAnnotationEntry entry) {
        if (annotationClasses.isEmpty()) {
            trace.report(Errors.OPT_IN_WITHOUT_ARGUMENTS.on((KtAnnotationEntry)((PsiElement)entry)));
            return;
        }
        for (ConstantValue<?> annotationClass : annotationClasses) {
            ClassDescriptor classDescriptor;
            ClassifierDescriptor classifierDescriptor;
            Object object = annotationClass instanceof KClassValue ? (KClassValue)annotationClass : null;
            ClassifierDescriptor classifierDescriptor2 = classifierDescriptor = object != null && (object = ((KClassValue)object).getArgumentType(this.module)) != null && (object = ((KotlinType)object).getConstructor()) != null ? object.getDeclarationDescriptor() : null;
            if ((classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null) == null) continue;
            classDescriptor = classDescriptor;
            ExperimentalUsageChecker.Companion $this$checkOptInUsage_u24lambda_u2d3 = ExperimentalUsageChecker.Companion;
            boolean bl = false;
            Experimentality experimentality = ExperimentalUsageChecker.Companion.loadExperimentalityForMarkerAnnotation$frontend$default($this$checkOptInUsage_u24lambda_u2d3, classDescriptor, false, 1, null);
            if (experimentality != null) continue;
            trace.report(Errors.OPT_IN_ARGUMENT_IS_NOT_MARKER.on((KtAnnotationEntry)((PsiElement)entry), DescriptorUtilsKt.getFqNameSafe(classDescriptor)));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkMarkerTargetsAndRetention(List<? extends KtAnnotationEntry> entries, BindingTrace trace) {
        Object v5;
        block9: {
            Object v1;
            Set associatedEntries;
            block8: {
                Iterable $this$associateWith$iv = entries;
                boolean $i$f$associateWith = false;
                LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateWith$iv, 10)), 16));
                Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
                boolean $i$f$associateWithTo = false;
                Object object = $this$associateWithTo$iv$iv.iterator();
                while (object.hasNext()) {
                    void entry;
                    Object element$iv$iv = object.next();
                    KtAnnotationEntry ktAnnotationEntry = (KtAnnotationEntry)element$iv$iv;
                    Object t = element$iv$iv;
                    Map map = result$iv;
                    boolean bl = false;
                    AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)trace.getBindingContext().get(BindingContext.ANNOTATION, entry);
                    map.put(t, annotationDescriptor);
                }
                associatedEntries = ((Map)result$iv).entrySet();
                Iterable $this$firstOrNull$iv = associatedEntries;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    AnnotationDescriptor descriptor2;
                    object = (Map.Entry)element$iv;
                    boolean bl = false;
                    AnnotationDescriptor annotationDescriptor = descriptor2 = (AnnotationDescriptor)object.getValue();
                    if (!Intrinsics.areEqual(annotationDescriptor != null ? annotationDescriptor.getFqName() : null, StandardNames.FqNames.target)) continue;
                    v1 = element$iv;
                    break block8;
                }
                v1 = null;
            }
            Map.Entry targetEntry = v1;
            if (targetEntry != null) {
                AnnotationDescriptor descriptor3;
                KtAnnotationEntry entry = (KtAnnotationEntry)targetEntry.getKey();
                AnnotationDescriptor annotationDescriptor = descriptor3 = (AnnotationDescriptor)targetEntry.getValue();
                Intrinsics.checkNotNull(annotationDescriptor);
                Set<KotlinTarget> set = AnnotationChecker.Companion.loadAnnotationTargets(annotationDescriptor);
                if (set == null) {
                    return;
                }
                Set<KotlinTarget> allowedTargets = set;
                Set wrongTargets = CollectionsKt.intersect((Iterable)allowedTargets, (Iterable)Experimentality.Companion.getWRONG_TARGETS_FOR_MARKER());
                if (!((Collection)wrongTargets).isEmpty()) {
                    trace.report(Errors.OPT_IN_MARKER_WITH_WRONG_TARGET.on((KtAnnotationEntry)((PsiElement)entry), CollectionsKt.joinToString$default(wrongTargets, null, null, null, 0, null, checkMarkerTargetsAndRetention.1.INSTANCE, 31, null)));
                }
            }
            Iterable $this$firstOrNull$iv = associatedEntries;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                AnnotationDescriptor descriptor4;
                Map.Entry entry = (Map.Entry)element$iv;
                boolean bl = false;
                AnnotationDescriptor annotationDescriptor = descriptor4 = (AnnotationDescriptor)entry.getValue();
                if (!Intrinsics.areEqual(annotationDescriptor != null ? annotationDescriptor.getFqName() : null, StandardNames.FqNames.retention)) continue;
                v5 = element$iv;
                break block9;
            }
            v5 = null;
        }
        Map.Entry retentionEntry = v5;
        if (retentionEntry != null) {
            AnnotationDescriptor descriptor5;
            KtAnnotationEntry entry = (KtAnnotationEntry)retentionEntry.getKey();
            AnnotationDescriptor annotationDescriptor = descriptor5 = (AnnotationDescriptor)retentionEntry.getValue();
            if ((annotationDescriptor != null ? DescriptorUtilsKt.getAnnotationRetention(annotationDescriptor) : null) == KotlinRetention.SOURCE) {
                trace.report(Errors.OPT_IN_MARKER_WITH_WRONG_RETENTION.on(entry));
            }
        }
    }
}

