/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.state.reflection;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0004J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0004J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0004J\u001c\u0010\u0014\u001a\u00020\u000e2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0016H\u0002J\f\u0010\u0018\u001a\u00020\u000e*\u00020\u0016H\u0004R$\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004j\u0002`\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/state/reflection/ReflectionState;", "Lorg/jetbrains/kotlin/ir/interpreter/state/State;", "()V", "fields", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "Lorg/jetbrains/kotlin/ir/interpreter/stack/Fields;", "getFields", "()Ljava/util/Map;", "getIrFunctionByIrCall", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "renderFunction", "", "irFunction", "renderLambda", "renderProperty", "property", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "renderReceivers", "dispatchReceiver", "Lorg/jetbrains/kotlin/ir/types/IrType;", "extensionReceiver", "renderType", "ir.interpreter"})
public abstract class ReflectionState
implements State {
    @NotNull
    private final Map<IrSymbol, State> fields = new LinkedHashMap();

    @Override
    @NotNull
    public Map<IrSymbol, State> getFields() {
        return this.fields;
    }

    @Override
    @Nullable
    public IrFunction getIrFunctionByIrCall(@NotNull IrCall expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        return null;
    }

    private final String renderReceivers(IrType dispatchReceiver, IrType extensionReceiver) {
        StringBuilder stringBuilder2;
        StringBuilder $this$renderReceivers_u24lambda_u2d0 = stringBuilder2 = new StringBuilder();
        boolean bl = false;
        if (dispatchReceiver != null) {
            $this$renderReceivers_u24lambda_u2d0.append(this.renderType(dispatchReceiver)).append(".");
        }
        if (extensionReceiver != null) {
            boolean addParentheses;
            boolean bl2 = addParentheses = dispatchReceiver != null;
            if (addParentheses) {
                $this$renderReceivers_u24lambda_u2d0.append("(");
            }
            $this$renderReceivers_u24lambda_u2d0.append(this.renderType(extensionReceiver)).append(".");
            if (addParentheses) {
                $this$renderReceivers_u24lambda_u2d0.append(")");
            }
        }
        String string2 = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    @NotNull
    protected final String renderLambda(@NotNull IrFunction irFunction2) {
        Intrinsics.checkNotNullParameter(irFunction2, "irFunction");
        IrAnnotationContainer irAnnotationContainer = irFunction2.getDispatchReceiverParameter();
        if (irAnnotationContainer == null || (irAnnotationContainer = irAnnotationContainer.getType()) == null) {
            IrValueParameter irValueParameter = irFunction2.getExtensionReceiverParameter();
            irAnnotationContainer = irValueParameter != null ? irValueParameter.getType() : null;
        }
        String receiver = irAnnotationContainer != null ? this.renderType((IrType)irAnnotationContainer) : null;
        String arguments2 = CollectionsKt.joinToString$default(irFunction2.getValueParameters(), null, "(", ")", 0, null, new Function1<IrValueParameter, CharSequence>(this){
            final /* synthetic */ ReflectionState this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull IrValueParameter it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return this.this$0.renderType(it.getType());
            }
        }, 25, null);
        String returnType2 = this.renderType(irFunction2.getReturnType());
        String it = arguments2 + " -> " + returnType2;
        boolean bl = false;
        return receiver != null ? receiver + '.' + it : it;
    }

    @NotNull
    protected final String renderFunction(@NotNull IrFunction irFunction2) {
        Intrinsics.checkNotNullParameter(irFunction2, "irFunction");
        IrClass irClass2 = IrUtilsKt.getParentClassOrNull(irFunction2);
        IrSimpleType dispatchReceiver = irClass2 != null ? IrUtilsKt.getDefaultType(irClass2) : null;
        IrValueParameter irValueParameter = irFunction2.getExtensionReceiverParameter();
        IrType extensionReceiver = irValueParameter != null ? irValueParameter.getType() : null;
        String receivers = irFunction2 instanceof IrConstructor ? "" : this.renderReceivers(dispatchReceiver, extensionReceiver);
        String arguments2 = CollectionsKt.joinToString$default(irFunction2.getValueParameters(), null, "(", ")", 0, null, new Function1<IrValueParameter, CharSequence>(this){
            final /* synthetic */ ReflectionState this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull IrValueParameter it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return this.this$0.renderType(it.getType());
            }
        }, 25, null);
        String returnType2 = this.renderType(irFunction2.getReturnType());
        return "fun " + receivers + irFunction2.getName() + arguments2 + ": " + returnType2;
    }

    @NotNull
    protected final String renderProperty(@NotNull IrProperty property2) {
        IrDeclarationBase irDeclarationBase;
        Intrinsics.checkNotNullParameter(property2, "property");
        String prefix = property2.isVar() ? "var" : "val";
        IrDeclarationBase irDeclarationBase2 = property2.getGetter();
        String receivers = this.renderReceivers(irDeclarationBase2 != null && (irDeclarationBase2 = ((IrFunction)irDeclarationBase2).getDispatchReceiverParameter()) != null ? ((IrValueDeclaration)irDeclarationBase2).getType() : null, (irDeclarationBase = property2.getGetter()) != null && (irDeclarationBase = ((IrFunction)irDeclarationBase).getExtensionReceiverParameter()) != null ? ((IrValueDeclaration)irDeclarationBase).getType() : null);
        IrSimpleFunction irSimpleFunction = property2.getGetter();
        Intrinsics.checkNotNull(irSimpleFunction);
        String returnType2 = this.renderType(irSimpleFunction.getReturnType());
        return prefix + ' ' + receivers + property2.getName() + ": " + returnType2;
    }

    @NotNull
    protected final String renderType(@NotNull IrType $this$renderType) {
        int index2;
        Intrinsics.checkNotNullParameter($this$renderType, "<this>");
        String renderedType2 = StringsKt.replace$default(RenderIrElementKt.render($this$renderType), "<root>.", "", false, 4, null);
        if (StringsKt.contains$default((CharSequence)renderedType2, "<get-", false, 2, null)) {
            int startIndex = StringsKt.indexOf$default((CharSequence)renderedType2, "<get-", 0, false, 6, null);
            int lastTriangle = StringsKt.indexOf$default((CharSequence)renderedType2, '>', startIndex, false, 4, null) + 1;
            String string2 = renderedType2;
            CharSequence charSequence2 = "get";
            renderedType2 = ((Object)StringsKt.replaceRange((CharSequence)string2, startIndex, lastTriangle, charSequence2)).toString();
        }
        while ((index2 = StringsKt.indexOf$default((CharSequence)renderedType2, " of ", 0, false, 6, null)) != -1) {
            int replaceUntilComma = StringsKt.indexOf$default((CharSequence)renderedType2, ',', index2, false, 4, null);
            int replaceUntilTriangle = StringsKt.indexOf$default((CharSequence)renderedType2, '>', index2, false, 4, null);
            int replaceUntil = replaceUntilComma == -1 && replaceUntilTriangle == -1 ? renderedType2.length() : (replaceUntilComma == -1 ? replaceUntilTriangle : (replaceUntilTriangle == -1 ? replaceUntilComma : Math.min(replaceUntilComma, replaceUntilTriangle)));
            String string3 = renderedType2;
            CharSequence charSequence3 = "";
            renderedType2 = ((Object)StringsKt.replaceRange((CharSequence)string3, index2, replaceUntil, charSequence3)).toString();
        }
        return renderedType2;
    }

    @Override
    @Nullable
    public State getField(@NotNull IrSymbol symbol2) {
        return State.DefaultImpls.getField(this, symbol2);
    }

    @Override
    public void setField(@NotNull IrSymbol symbol2, @NotNull State state) {
        State.DefaultImpls.setField(this, symbol2, state);
    }
}

