/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.declarations.comparators;

import java.util.Comparator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.comparators.FirMemberDeclarationComparator;
import org.jetbrains.kotlin.fir.declarations.comparators.FirTypeParameterRefComparator;
import org.jetbrains.kotlin.fir.declarations.comparators.FirValueParameterComparator;
import org.jetbrains.kotlin.fir.types.FirTypeRefComparator;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/fir/declarations/comparators/FirCallableDeclarationComparator;", "Ljava/util/Comparator;", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "Lkotlin/Comparator;", "()V", "compare", "", "a", "b", "tree"})
public final class FirCallableDeclarationComparator
implements Comparator<FirCallableDeclaration> {
    @NotNull
    public static final FirCallableDeclarationComparator INSTANCE = new FirCallableDeclarationComparator();

    private FirCallableDeclarationComparator() {
    }

    @Override
    public int compare(@NotNull FirCallableDeclaration a, @NotNull FirCallableDeclaration b) {
        int typeParameterSizeDiff;
        int returnTypeDiff;
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        int typeAndNameDiff = FirMemberDeclarationComparator.TypeAndNameComparator.INSTANCE.compare(a, b);
        if (typeAndNameDiff != 0) {
            return typeAndNameDiff;
        }
        if (a.getReceiverTypeRef() != null || b.getReceiverTypeRef() != null) {
            boolean bl;
            int bHasReceiverType;
            int aHasReceiverType = a.getReceiverTypeRef() != null ? 1 : 0;
            int receiverTypePresenceDiff = aHasReceiverType - (bHasReceiverType = b.getReceiverTypeRef() != null ? 1 : 0);
            if (receiverTypePresenceDiff != 0) {
                return receiverTypePresenceDiff;
            }
            boolean bl2 = bl = a.getReceiverTypeRef() != null && b.getReceiverTypeRef() != null;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
        }
        if ((returnTypeDiff = FirTypeRefComparator.INSTANCE.compare(a.getReturnTypeRef(), b.getReturnTypeRef())) != 0) {
            return returnTypeDiff;
        }
        if (a instanceof FirFunction) {
            if (!(b instanceof FirFunction)) {
                boolean bl = false;
                String string3 = "TypeAndNameComparator is inconsistent: " + FirRendererKt.render$default(a, null, 1, null) + " v.s. " + FirRendererKt.render$default(b, null, 1, null);
                throw new IllegalArgumentException(string3.toString());
            }
            int valueParameterSizeDiff = ((FirFunction)a).getValueParameters().size() - ((FirFunction)b).getValueParameters().size();
            if (valueParameterSizeDiff != 0) {
                return valueParameterSizeDiff;
            }
            for (Pair pair : CollectionsKt.zip((Iterable)((FirFunction)a).getValueParameters(), (Iterable)((FirFunction)b).getValueParameters())) {
                FirValueParameter bValueParameter;
                FirValueParameter aValueParameter = (FirValueParameter)pair.component1();
                int valueParameterDiff = FirValueParameterComparator.INSTANCE.compare(aValueParameter, bValueParameter = (FirValueParameter)pair.component2());
                if (valueParameterDiff == 0) continue;
                return valueParameterDiff;
            }
        }
        if ((typeParameterSizeDiff = a.getTypeParameters().size() - b.getTypeParameters().size()) != 0) {
            return typeParameterSizeDiff;
        }
        for (Pair pair : CollectionsKt.zip((Iterable)a.getTypeParameters(), (Iterable)b.getTypeParameters())) {
            FirTypeParameterRef bTypeParameter;
            FirTypeParameterRef aTypeParameter = (FirTypeParameterRef)pair.component1();
            int typeParameterDiff = FirTypeParameterRefComparator.INSTANCE.compare(aTypeParameter, bTypeParameter = (FirTypeParameterRef)pair.component2());
            if (typeParameterDiff == 0) continue;
            return typeParameterDiff;
        }
        String string4 = a.getSymbol().getCallableId().getPackageName().asString();
        String string5 = b.getSymbol().getCallableId().getPackageName().asString();
        Intrinsics.checkNotNullExpressionValue(string5, "b.symbol.callableId.packageName.asString()");
        return string4.compareTo(string5);
    }
}

