/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kapt3.stubs;

import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.sun.tools.javac.tree.JCTree;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.ObjectOutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.kapt3.KaptContextForStubGeneration;
import org.jetbrains.kotlin.kapt3.base.stubs.FileInfoKt;
import org.jetbrains.kotlin.kapt3.base.stubs.KotlinPosition;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.org.objectweb.asm.tree.ClassNode;
import org.jetbrains.org.objectweb.asm.tree.FieldNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0011\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0018\u0010\u0011\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\tH\u0002J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u000e\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010 \u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017J\u0016\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010$\u001a\u00020%R&\u0010\u0005\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\f0\u0006j\u0002`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/kapt3/stubs/KaptLineMappingCollector;", "", "kaptContext", "Lorg/jetbrains/kotlin/kapt3/KaptContextForStubGeneration;", "(Lorg/jetbrains/kotlin/kapt3/KaptContextForStubGeneration;)V", "filePaths", "", "Lcom/intellij/psi/PsiFile;", "Lkotlin/Pair;", "", "", "lineInfo", "Lorg/jetbrains/kotlin/kapt3/base/stubs/KotlinPosition;", "Lorg/jetbrains/kotlin/kapt3/base/stubs/LineInfoMap;", "signatureInfo", "getFilePathRelativePreferred", "file", "getPosition", "clazz", "Lorg/jetbrains/org/objectweb/asm/tree/ClassNode;", "field", "Lorg/jetbrains/org/objectweb/asm/tree/FieldNode;", "method", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "register", "", "asmNode", "fqName", "psiElement", "Lcom/intellij/psi/PsiElement;", "registerClass", "registerField", "registerMethod", "registerSignature", "declaration", "Lcom/sun/tools/javac/tree/JCTree$JCMethodDecl;", "serialize", "", "kotlin-annotation-processing"})
public final class KaptLineMappingCollector {
    @NotNull
    private final KaptContextForStubGeneration kaptContext;
    @NotNull
    private final Map<String, KotlinPosition> lineInfo;
    @NotNull
    private final Map<String, String> signatureInfo;
    @NotNull
    private final Map<PsiFile, Pair<String, Boolean>> filePaths;

    public KaptLineMappingCollector(@NotNull KaptContextForStubGeneration kaptContext) {
        Intrinsics.checkNotNullParameter((Object)kaptContext, (String)"kaptContext");
        this.kaptContext = kaptContext;
        this.lineInfo = new LinkedHashMap();
        this.signatureInfo = new LinkedHashMap();
        this.filePaths = new LinkedHashMap();
    }

    public final void registerClass(@NotNull ClassNode clazz) {
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        String string = clazz.name;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"clazz.name");
        this.register(clazz, string);
    }

    public final void registerMethod(@NotNull ClassNode clazz, @NotNull MethodNode method) {
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        this.register(method, clazz.name + '#' + method.name + method.desc);
    }

    public final void registerField(@NotNull ClassNode clazz, @NotNull FieldNode field) {
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        this.register(field, clazz.name + '#' + field.name);
    }

    public final void registerSignature(@NotNull JCTree.JCMethodDecl declaration, @NotNull MethodNode method) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        this.signatureInfo.put(FileInfoKt.getJavacSignature(declaration), method.name + method.desc);
    }

    @Nullable
    public final KotlinPosition getPosition(@NotNull ClassNode clazz) {
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        return this.lineInfo.get(clazz.name);
    }

    @Nullable
    public final KotlinPosition getPosition(@NotNull ClassNode clazz, @NotNull MethodNode method) {
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        return this.lineInfo.get(clazz.name + '#' + method.name + method.desc);
    }

    @Nullable
    public final KotlinPosition getPosition(@NotNull ClassNode clazz, @NotNull FieldNode field) {
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        return this.lineInfo.get(clazz.name + '#' + field.name);
    }

    private final void register(Object asmNode, String fqName) {
        JvmDeclarationOrigin jvmDeclarationOrigin = this.kaptContext.getOrigins().get(asmNode);
        if (jvmDeclarationOrigin == null || (jvmDeclarationOrigin = jvmDeclarationOrigin.getElement()) == null) {
            return;
        }
        JvmDeclarationOrigin psiElement = jvmDeclarationOrigin;
        this.register(fqName, (PsiElement)psiElement);
    }

    private final void register(String fqName, PsiElement psiElement) {
        VirtualFile containingVirtualFile = psiElement.getContainingFile().getVirtualFile();
        if (containingVirtualFile == null || FileDocumentManager.getInstance().getDocument(containingVirtualFile) == null) {
            return;
        }
        TextRange textRange = psiElement.getTextRange();
        if (textRange == null) {
            return;
        }
        TextRange textRange2 = textRange;
        PsiFile psiFile = psiElement.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"psiElement.containingFile");
        Pair<String, Boolean> pair = this.getFilePathRelativePreferred(psiFile);
        String path = (String)pair.component1();
        boolean isRelative = (Boolean)pair.component2();
        this.lineInfo.put(fqName, new KotlinPosition(path, isRelative, textRange2.getStartOffset()));
    }

    /*
     * Unable to fully structure code
     */
    private final Pair<String, Boolean> getFilePathRelativePreferred(PsiFile file) {
        block6: {
            block5: {
                $this$getOrPut$iv = this.filePaths;
                $i$f$getOrPut = false;
                value$iv = $this$getOrPut$iv.get(file);
                if (value$iv != null) break block5;
                $i$a$-getOrPut-KaptLineMappingCollector$getFilePathRelativePreferred$1 = false;
                v0 = file.getVirtualFile().getCanonicalPath();
                if (v0 == null) {
                    v0 = file.getVirtualFile().getPath();
                }
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"file.virtualFile.canonic\u2026 ?: file.virtualFile.path");
                absolutePath = v0;
                absoluteFile = new File(absolutePath);
                v1 = file.getProject().getBasePath();
                if (v1 != null) {
                    it = v1;
                    $i$a$-let-KaptLineMappingCollector$getFilePathRelativePreferred$1$baseFile$1 = false;
                    v2 = new File(it);
                } else {
                    v2 = baseFile = null;
                }
                if (!absoluteFile.exists() || baseFile == null || !baseFile.exists()) ** GOTO lbl-1000
                v3 = FilesKt.relativeToOrNull((File)absoluteFile, (File)baseFile);
                v4 = relativePath = v3 != null ? v3.getPath() : null;
                if (relativePath != null) {
                    v5 = new Pair((Object)relativePath, (Object)true);
                } else lbl-1000:
                // 2 sources

                {
                    v5 = new Pair((Object)absolutePath, (Object)false);
                }
                answer$iv = v5;
                $this$getOrPut$iv.put(file, (Pair<String, Boolean>)answer$iv);
                v6 = answer$iv;
                break block6;
            }
            v6 = value$iv;
        }
        return v6;
    }

    @NotNull
    public final byte[] serialize() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(os);
        oos.writeInt(1);
        oos.writeInt(this.lineInfo.size());
        for (Map.Entry<String, KotlinPosition> entry : this.lineInfo.entrySet()) {
            String fqName = entry.getKey();
            KotlinPosition kotlinPosition = entry.getValue();
            oos.writeUTF(fqName);
            oos.writeUTF(kotlinPosition.getPath());
            oos.writeBoolean(kotlinPosition.isRelativePath());
            oos.writeInt(kotlinPosition.getPos());
        }
        oos.writeInt(this.signatureInfo.size());
        for (Map.Entry<String, Object> entry : this.signatureInfo.entrySet()) {
            String javacSignature = entry.getKey();
            String methodDesc = (String)entry.getValue();
            oos.writeUTF(javacSignature);
            oos.writeUTF(methodDesc);
        }
        oos.flush();
        byte[] byArray = os.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"os.toByteArray()");
        return byArray;
    }
}

