/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirAnnotationHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.collectors.AbstractDiagnosticCollector;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionAnnotationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirBasicExpressionChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirExpressionAnnotationChecker
extends FirExpressionChecker<FirStatement> {
    @NotNull
    public static final FirExpressionAnnotationChecker INSTANCE = new FirExpressionAnnotationChecker();

    private FirExpressionAnnotationChecker() {
    }

    @Override
    public void check(@NotNull FirStatement expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Object object;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (expression2 instanceof FirDeclaration || !(expression2 instanceof FirExpression) || expression2 instanceof FirBlock && Intrinsics.areEqual((object = expression2.getSource()) == null ? null : ((FirSourceElement)object).getKind(), FirFakeSourceElementKind.DesugaredForLoop.INSTANCE)) {
            return;
        }
        for (FirAnnotationCall annotation2 : expression2.getAnnotations()) {
            boolean bl;
            CheckerContext it;
            List<String> list2;
            FirAnnotationContainer firAnnotationContainer;
            boolean $i$f$withSuppressedDiagnostics = false;
            FirAnnotationContainer firAnnotationContainer2 = firAnnotationContainer = (FirElement)annotation2 instanceof FirAnnotationContainer ? (FirAnnotationContainer)((FirElement)annotation2) : null;
            if (firAnnotationContainer == null) {
                list2 = null;
            } else {
                FirAnnotationContainer firAnnotationContainer3;
                FirAnnotationContainer it$iv = firAnnotationContainer3 = firAnnotationContainer;
                boolean bl2 = false;
                list2 = AbstractDiagnosticCollector.Companion.getDiagnosticsSuppressedForContainer(it$iv);
            }
            List<String> arguments$iv = list2;
            if (arguments$iv != null) {
                it = context2.addSuppressedDiagnostics((Collection<String>)arguments$iv, arguments$iv.contains("infos"), arguments$iv.contains("warnings"), arguments$iv.contains("errors"));
                bl = false;
                if (FirAnnotationHelpersKt.getAllowedAnnotationTargets(annotation2, context2.getSession()).contains((Object)KotlinTarget.EXPRESSION)) continue;
                DiagnosticReporterKt.reportOn$default(reporter, annotation2.getSource(), FirErrors.INSTANCE.getWRONG_ANNOTATION_TARGET(), (Object)"expression", context2, null, 16, null);
                continue;
            }
            it = context2;
            bl = false;
            if (FirAnnotationHelpersKt.getAllowedAnnotationTargets(annotation2, context2.getSession()).contains((Object)KotlinTarget.EXPRESSION)) continue;
            DiagnosticReporterKt.reportOn$default(reporter, annotation2.getSource(), FirErrors.INSTANCE.getWRONG_ANNOTATION_TARGET(), (Object)"expression", context2, null, 16, null);
        }
    }
}

