/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.annotation.AnnotationRetention;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirAnnotatedDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirArrayOfCall;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirGetClassCall;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirPhaseManagerKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007*\u00020\t\u001a\u0010\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004*\u00020\u000b\u001a\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004*\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a\u0014\u0010\u000f\u001a\u0004\u0018\u00010\f*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u001a\n\u0010\u0013\u001a\u00020\u0014*\u00020\u000b\u001a\u0012\u0010\u0013\u001a\u00020\u0014*\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a\f\u0010\u0015\u001a\u0004\u0018\u00010\f*\u00020\u0016\u001a\f\u0010\u0017\u001a\u0004\u0018\u00010\f*\u00020\u0016\u001a\u0012\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\u0007*\u00020\tH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"RETENTION_PARAMETER_NAME", "Lorg/jetbrains/kotlin/name/Name;", "TARGET_PARAMETER_NAME", "defaultAnnotationTargets", "", "Lorg/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "extractClassesFromArgument", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "getAllowedAnnotationTargets", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "getAnnotationByClassId", "Lorg/jetbrains/kotlin/fir/FirAnnotationContainer;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "getRetention", "Lkotlin/annotation/AnnotationRetention;", "getRetentionAnnotation", "Lorg/jetbrains/kotlin/fir/declarations/FirAnnotatedDeclaration;", "getTargetAnnotation", "unfoldArrayOrVararg", "checkers"})
public final class FirAnnotationHelpersKt {
    @NotNull
    private static final Name RETENTION_PARAMETER_NAME;
    @NotNull
    private static final Name TARGET_PARAMETER_NAME;
    @NotNull
    private static final Set<KotlinTarget> defaultAnnotationTargets;

    @NotNull
    public static final AnnotationRetention getRetention(@NotNull FirAnnotationCall $this$getRetention, @NotNull FirSession session2) {
        FirRegularClassSymbol firRegularClassSymbol;
        FirClassLikeSymbol<?> firClassLikeSymbol;
        ConeClassLikeType coneClassLikeType;
        Intrinsics.checkNotNullParameter($this$getRetention, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        Object object = FirTypeUtilsKt.getConeType($this$getRetention.getAnnotationTypeRef());
        ConeClassLikeType coneClassLikeType2 = coneClassLikeType = object instanceof ConeClassLikeType ? (ConeClassLikeType)object : null;
        if (coneClassLikeType == null) {
            firClassLikeSymbol = null;
        } else {
            object = coneClassLikeType.getLookupTag();
            firClassLikeSymbol = LookupTagUtilsKt.toSymbol((ConeClassLikeLookupTag)object, session2);
        }
        FirClassLikeSymbol<?> firClassLikeSymbol2 = firClassLikeSymbol;
        FirRegularClassSymbol firRegularClassSymbol2 = firRegularClassSymbol = firClassLikeSymbol2 instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firClassLikeSymbol2 : null;
        if (firRegularClassSymbol == null) {
            return AnnotationRetention.RUNTIME;
        }
        FirRegularClassSymbol annotationClassSymbol = firRegularClassSymbol;
        FirPhaseManagerKt.ensureResolved(annotationClassSymbol, FirResolvePhase.BODY_RESOLVE);
        FirRegularClass annotationClass = (FirRegularClass)annotationClassSymbol.getFir();
        return FirAnnotationHelpersKt.getRetention(annotationClass);
    }

    @NotNull
    public static final AnnotationRetention getRetention(@NotNull FirRegularClass $this$getRetention) {
        AnnotationRetention annotationRetention;
        Object object;
        block4: {
            FirResolvedNamedReference firResolvedNamedReference;
            FirQualifiedAccessExpression firQualifiedAccessExpression;
            Intrinsics.checkNotNullParameter($this$getRetention, "<this>");
            FirAnnotationCall firAnnotationCall = FirAnnotationHelpersKt.getRetentionAnnotation($this$getRetention);
            if (firAnnotationCall == null) {
                return AnnotationRetention.RUNTIME;
            }
            FirAnnotationCall retentionAnnotation = firAnnotationCall;
            object = FirAnnotationUtilsKt.findArgumentByName(retentionAnnotation, RETENTION_PARAMETER_NAME);
            FirQualifiedAccessExpression firQualifiedAccessExpression2 = firQualifiedAccessExpression = object instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)object : null;
            if (firQualifiedAccessExpression == null) {
                return AnnotationRetention.RUNTIME;
            }
            FirQualifiedAccessExpression retentionArgument = firQualifiedAccessExpression;
            Object object2 = retentionArgument.getCalleeReference();
            FirResolvedNamedReference firResolvedNamedReference2 = firResolvedNamedReference = object2 instanceof FirResolvedNamedReference ? (FirResolvedNamedReference)object2 : null;
            if (firResolvedNamedReference == null) {
                return AnnotationRetention.RUNTIME;
            }
            object2 = firResolvedNamedReference.getName();
            object = ((Name)object2).asString();
            Intrinsics.checkNotNullExpressionValue(object, "(retentionArgument.calle\u2026notationRetention.RUNTIME");
            Object retentionName = object;
            AnnotationRetention[] $this$firstOrNull$iv = AnnotationRetention.values();
            boolean $i$f$firstOrNull = false;
            for (AnnotationRetention element$iv : $this$firstOrNull$iv) {
                AnnotationRetention it = element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.name(), retentionName)) continue;
                annotationRetention = element$iv;
                break block4;
            }
            annotationRetention = null;
        }
        object = annotationRetention;
        return object == null ? AnnotationRetention.RUNTIME : object;
    }

    @NotNull
    public static final Set<KotlinTarget> getAllowedAnnotationTargets(@NotNull FirAnnotationCall $this$getAllowedAnnotationTargets, @NotNull FirSession session2) {
        FirClassLikeSymbol<?> firClassLikeSymbol;
        FirClassLikeSymbol<?> firClassLikeSymbol2;
        Object object;
        Intrinsics.checkNotNullParameter($this$getAllowedAnnotationTargets, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        if ($this$getAllowedAnnotationTargets.getAnnotationTypeRef() instanceof FirErrorTypeRef) {
            return ArraysKt.toSet(KotlinTarget.values());
        }
        ConeKotlinType coneKotlinType = FirTypeUtilsKt.getConeType($this$getAllowedAnnotationTargets.getAnnotationTypeRef());
        Object object2 = object = coneKotlinType instanceof ConeClassLikeType ? (ConeClassLikeType)coneKotlinType : null;
        if (object == null) {
            firClassLikeSymbol2 = null;
        } else {
            coneKotlinType = TypeExpansionUtilsKt.fullyExpandedType$default((ConeClassLikeType)object, session2, null, 2, null);
            ConeClassLikeLookupTag coneClassLikeLookupTag = ((ConeClassLikeType)coneKotlinType).getLookupTag();
            firClassLikeSymbol2 = firClassLikeSymbol = LookupTagUtilsKt.toSymbol(coneClassLikeLookupTag, session2);
        }
        if (firClassLikeSymbol == null) {
            return defaultAnnotationTargets;
        }
        FirClassLikeSymbol<?> annotationClassSymbol = firClassLikeSymbol;
        FirPhaseManagerKt.ensureResolved((FirBasedSymbol)annotationClassSymbol, FirResolvePhase.BODY_RESOLVE);
        object = annotationClassSymbol.getFir();
        FirRegularClass annotationClass = object instanceof FirRegularClass ? (FirRegularClass)object : null;
        object = annotationClass;
        return object == null ? defaultAnnotationTargets : FirAnnotationHelpersKt.getAllowedAnnotationTargets((FirRegularClass)object);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<KotlinTarget> getAllowedAnnotationTargets(@NotNull FirRegularClass $this$getAllowedAnnotationTargets) {
        void destination$iv;
        void $this$mapNotNullTo$iv;
        Intrinsics.checkNotNullParameter($this$getAllowedAnnotationTargets, "<this>");
        FirAnnotationCall firAnnotationCall = FirAnnotationHelpersKt.getTargetAnnotation($this$getAllowedAnnotationTargets);
        if (firAnnotationCall == null) {
            return defaultAnnotationTargets;
        }
        FirAnnotationCall targetAnnotation = firAnnotationCall;
        if (targetAnnotation.getArgumentList().getArguments().isEmpty()) {
            return SetsKt.emptySet();
        }
        Object object = FirAnnotationUtilsKt.findArgumentByName(targetAnnotation, TARGET_PARAMETER_NAME);
        Collection<FirExpression> collection = object == null ? null : FirAnnotationHelpersKt.unfoldArrayOrVararg((FirExpression)object);
        List<Object> arguments2 = collection == null ? CollectionsKt.emptyList() : collection;
        object = arguments2;
        collection = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            KotlinTarget kotlinTarget;
            KotlinTarget kotlinTarget2;
            block6: {
                FirResolvedNamedReference firResolvedNamedReference;
                FirQualifiedAccessExpression targetExpression;
                Object element$iv$iv;
                Object element$iv = element$iv$iv = iterator2.next();
                boolean bl = false;
                FirExpression argument2 = (FirExpression)element$iv;
                boolean bl2 = false;
                FirQualifiedAccessExpression firQualifiedAccessExpression = targetExpression = argument2 instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)argument2 : null;
                KotlinTarget[] kotlinTargetArray = firQualifiedAccessExpression == null ? null : firQualifiedAccessExpression.getCalleeReference();
                FirResolvedNamedReference firResolvedNamedReference2 = firResolvedNamedReference = kotlinTargetArray instanceof FirResolvedNamedReference ? (FirResolvedNamedReference)kotlinTargetArray : null;
                if (firResolvedNamedReference == null) {
                    kotlinTarget2 = null;
                } else {
                    kotlinTargetArray = firResolvedNamedReference.getName();
                    String string2 = kotlinTargetArray.asString();
                    Intrinsics.checkNotNullExpressionValue(string2, "(targetExpression?.calle\u2026 return@mapNotNullTo null");
                    String targetName = string2;
                    KotlinTarget[] $this$firstOrNull$iv = KotlinTarget.values();
                    boolean $i$f$firstOrNull = false;
                    for (KotlinTarget element$iv2 : $this$firstOrNull$iv) {
                        KotlinTarget target = element$iv2;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual(target.name(), targetName)) continue;
                        kotlinTarget2 = element$iv2;
                        break block6;
                    }
                    kotlinTarget2 = null;
                }
            }
            KotlinTarget kotlinTarget3 = kotlinTarget2;
            if (kotlinTarget3 == null) continue;
            KotlinTarget it$iv = kotlinTarget = kotlinTarget3;
            boolean bl = false;
            destination$iv.add(it$iv);
        }
        return (Set)destination$iv;
    }

    @Nullable
    public static final FirAnnotationCall getRetentionAnnotation(@NotNull FirAnnotatedDeclaration $this$getRetentionAnnotation) {
        Intrinsics.checkNotNullParameter($this$getRetentionAnnotation, "<this>");
        return FirAnnotationUtilsKt.getAnnotationByFqName($this$getRetentionAnnotation, StandardNames.FqNames.retention);
    }

    @Nullable
    public static final FirAnnotationCall getTargetAnnotation(@NotNull FirAnnotatedDeclaration $this$getTargetAnnotation) {
        Intrinsics.checkNotNullParameter($this$getTargetAnnotation, "<this>");
        return FirAnnotationUtilsKt.getAnnotationByFqName($this$getTargetAnnotation, StandardNames.FqNames.target);
    }

    @Nullable
    public static final FirAnnotationCall getAnnotationByClassId(@NotNull FirAnnotationContainer $this$getAnnotationByClassId, @NotNull ClassId classId) {
        Object v2;
        block3: {
            Iterable iterable;
            Intrinsics.checkNotNullParameter($this$getAnnotationByClassId, "<this>");
            Intrinsics.checkNotNullParameter(classId, "classId");
            Iterable iterable2 = iterable = (Iterable)$this$getAnnotationByClassId.getAnnotations();
            for (Object t : iterable2) {
                ClassId classId2;
                ConeClassLikeType coneClassLikeType;
                FirAnnotationCall it = (FirAnnotationCall)t;
                boolean bl = false;
                Object object = FirTypeUtilsKt.getConeType(it.getAnnotationTypeRef());
                ConeClassLikeType coneClassLikeType2 = coneClassLikeType = object instanceof ConeClassLikeType ? (ConeClassLikeType)object : null;
                if (coneClassLikeType == null) {
                    classId2 = null;
                } else {
                    object = coneClassLikeType.getLookupTag();
                    classId2 = ((ConeClassLikeLookupTag)object).getClassId();
                }
                if (!Intrinsics.areEqual(classId2, classId)) continue;
                v2 = t;
                break block3;
            }
            v2 = null;
        }
        return v2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<FirRegularClassSymbol> extractClassesFromArgument(@NotNull FirExpression $this$extractClassesFromArgument) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$extractClassesFromArgument, "<this>");
        Iterable $this$mapNotNull$iv = FirAnnotationHelpersKt.unfoldArrayOrVararg($this$extractClassesFromArgument);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            FirRegularClassSymbol firRegularClassSymbol;
            FirRegularClassSymbol firRegularClassSymbol2;
            FirRegularClassSymbol firRegularClassSymbol3;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            FirExpression it = (FirExpression)element$iv$iv;
            boolean bl2 = false;
            if (!(it instanceof FirGetClassCall)) {
                firRegularClassSymbol3 = null;
            } else {
                FirResolvedQualifier qualifier;
                Object object;
                FirExpression firExpression2 = ((FirGetClassCall)it).getArgument();
                Object object2 = object = firExpression2 instanceof FirResolvedQualifier ? (FirResolvedQualifier)firExpression2 : null;
                firRegularClassSymbol3 = object == null ? null : (firRegularClassSymbol2 = (object = (qualifier = object).getSymbol()) instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)object : null);
            }
            if (firRegularClassSymbol2 == null) continue;
            FirRegularClassSymbol it$iv$iv = firRegularClassSymbol = firRegularClassSymbol2;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final List<FirExpression> unfoldArrayOrVararg(FirExpression $this$unfoldArrayOrVararg) {
        List<FirExpression> list2;
        FirExpression firExpression2 = $this$unfoldArrayOrVararg;
        if (firExpression2 instanceof FirVarargArgumentsExpression) {
            list2 = ((FirVarargArgumentsExpression)$this$unfoldArrayOrVararg).getArguments();
        } else if (firExpression2 instanceof FirArrayOfCall) {
            FirCall $this$arguments$iv = (FirCall)((Object)$this$unfoldArrayOrVararg);
            boolean $i$f$getArguments = false;
            list2 = $this$arguments$iv.getArgumentList().getArguments();
        } else {
            return CollectionsKt.emptyList();
        }
        return list2;
    }

    static {
        Name name = Name.identifier("value");
        Intrinsics.checkNotNullExpressionValue(name, "identifier(\"value\")");
        RETENTION_PARAMETER_NAME = name;
        name = Name.identifier("allowedTargets");
        Intrinsics.checkNotNullExpressionValue(name, "identifier(\"allowedTargets\")");
        TARGET_PARAMETER_NAME = name;
        defaultAnnotationTargets = KotlinTarget.Companion.getDEFAULT_TARGET_SET();
    }
}

