/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.deprecation;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory3;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.metadata.deserialization.VersionRequirement;
import org.jetbrains.kotlin.resolve.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.deprecation.DeprecatedByAnnotation;
import org.jetbrains.kotlin.resolve.deprecation.DeprecatedByOverridden;
import org.jetbrains.kotlin.resolve.deprecation.DeprecatedByVersionRequirement;
import org.jetbrains.kotlin.resolve.deprecation.DeprecatedTypealiasByAnnotation;
import org.jetbrains.kotlin.resolve.deprecation.Deprecation;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationLevelValue;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u001a\u0018\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u001a\f\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u000b\u001a\f\u0010\u0010\u001a\u0004\u0018\u00010\u000f*\u00020\u000b\u001a\u0014\u0010\u0011\u001a\u0004\u0018\u00010\u0005*\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u000f\u00a8\u0006\u0013"}, d2={"computeLevelForDeprecatedSinceKotlin", "Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationLevelValue;", "annotation", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "apiVersion", "Lorg/jetbrains/kotlin/config/ApiVersion;", "createDeprecationDiagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "element", "Lcom/intellij/psi/PsiElement;", "deprecation", "Lorg/jetbrains/kotlin/resolve/deprecation/Deprecation;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "deprecatedByAnnotationReplaceWithExpression", "", "deprecatedByOverriddenMessage", "getSinceVersion", "name", "frontend"})
public final class DeprecationUtilKt {
    @Nullable
    public static final String deprecatedByOverriddenMessage(@NotNull Deprecation $this$deprecatedByOverriddenMessage) {
        Intrinsics.checkNotNullParameter($this$deprecatedByOverriddenMessage, "<this>");
        DeprecatedByOverridden deprecatedByOverridden = $this$deprecatedByOverriddenMessage instanceof DeprecatedByOverridden ? (DeprecatedByOverridden)$this$deprecatedByOverriddenMessage : null;
        return deprecatedByOverridden == null ? null : deprecatedByOverridden.additionalMessage$frontend();
    }

    @Nullable
    public static final String deprecatedByAnnotationReplaceWithExpression(@NotNull Deprecation $this$deprecatedByAnnotationReplaceWithExpression) {
        Intrinsics.checkNotNullParameter($this$deprecatedByAnnotationReplaceWithExpression, "<this>");
        DeprecatedByAnnotation deprecatedByAnnotation = $this$deprecatedByAnnotationReplaceWithExpression instanceof DeprecatedByAnnotation ? (DeprecatedByAnnotation)$this$deprecatedByAnnotationReplaceWithExpression : null;
        return deprecatedByAnnotation == null ? null : deprecatedByAnnotation.getReplaceWithValue$frontend();
    }

    @Nullable
    public static final ApiVersion getSinceVersion(@NotNull AnnotationDescriptor $this$getSinceVersion, @NotNull String name) {
        ApiVersion apiVersion;
        Intrinsics.checkNotNullParameter($this$getSinceVersion, "<this>");
        Intrinsics.checkNotNullParameter(name, "name");
        ConstantValue<?> constantValue = AnnotationUtilKt.argumentValue($this$getSinceVersion, name);
        if (constantValue == null) {
            apiVersion = null;
        } else {
            StringValue stringValue;
            ConstantValue<?> $this$safeAs$iv = constantValue;
            boolean $i$f$safeAs = false;
            ConstantValue<?> constantValue2 = $this$safeAs$iv;
            if (!(constantValue2 instanceof StringValue)) {
                constantValue2 = null;
            }
            if ((stringValue = (StringValue)constantValue2) == null) {
                apiVersion = null;
            } else {
                String string2;
                String string3;
                String string4;
                String p0 = string4 = (string3 = (String)stringValue.getValue());
                boolean bl = false;
                String string5 = string2 = !(((CharSequence)p0).length() == 0) ? string4 : null;
                if (string2 == null) {
                    apiVersion = null;
                } else {
                    string4 = string2;
                    ApiVersion.Companion companion = ApiVersion.Companion;
                    String p02 = string4;
                    boolean bl2 = false;
                    apiVersion = companion.parse(p02);
                }
            }
        }
        return apiVersion;
    }

    @Nullable
    public static final DeprecationLevelValue computeLevelForDeprecatedSinceKotlin(@NotNull AnnotationDescriptor annotation2, @NotNull ApiVersion apiVersion) {
        Intrinsics.checkNotNullParameter(annotation2, "annotation");
        Intrinsics.checkNotNullParameter(apiVersion, "apiVersion");
        ApiVersion hiddenSince = DeprecationUtilKt.getSinceVersion(annotation2, "hiddenSince");
        if (hiddenSince != null && apiVersion.compareTo(hiddenSince) >= 0) {
            return DeprecationLevelValue.HIDDEN;
        }
        ApiVersion errorSince = DeprecationUtilKt.getSinceVersion(annotation2, "errorSince");
        if (errorSince != null && apiVersion.compareTo(errorSince) >= 0) {
            return DeprecationLevelValue.ERROR;
        }
        ApiVersion warningSince = DeprecationUtilKt.getSinceVersion(annotation2, "warningSince");
        if (warningSince != null && apiVersion.compareTo(warningSince) >= 0) {
            return DeprecationLevelValue.WARNING;
        }
        return null;
    }

    @NotNull
    public static final Diagnostic createDeprecationDiagnostic(@NotNull PsiElement element, @NotNull Deprecation deprecation2, @NotNull LanguageVersionSettings languageVersionSettings) {
        Diagnostic diagnostic;
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(deprecation2, "deprecation");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        Object object = deprecation2.getTarget().getOriginal();
        Intrinsics.checkNotNullExpressionValue(object, "deprecation.target.original");
        DeclarationDescriptor targetOriginal = object;
        object = deprecation2;
        if (object instanceof DeprecatedByVersionRequirement) {
            DiagnosticFactory3<PsiElement, DeclarationDescriptor, VersionRequirement.Version, Pair<LanguageVersion, String>> diagnosticFactory3;
            DeprecationLevelValue deprecationLevelValue = deprecation2.getDeprecationLevel();
            int n = WhenMappings.$EnumSwitchMapping$0[deprecationLevelValue.ordinal()];
            switch (n) {
                case 1: {
                    diagnosticFactory3 = Errors.VERSION_REQUIREMENT_DEPRECATION;
                    break;
                }
                case 2: 
                case 3: {
                    diagnosticFactory3 = Errors.VERSION_REQUIREMENT_DEPRECATION_ERROR;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            DiagnosticFactory3<PsiElement, DeclarationDescriptor, VersionRequirement.Version, Pair<LanguageVersion, String>> factory2 = diagnosticFactory3;
            ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = factory2.on(element, targetOriginal, ((DeprecatedByVersionRequirement)deprecation2).getVersionRequirement().getVersion(), TuplesKt.to(languageVersionSettings.getLanguageVersion(), deprecation2.getMessage()));
            Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, "{\n            val factor\u2026e\n            )\n        }");
            diagnostic = parametrizedDiagnostic;
        } else if (object instanceof DeprecatedTypealiasByAnnotation) {
            DiagnosticFactory3<PsiElement, TypeAliasDescriptor, DeclarationDescriptor, String> diagnosticFactory3;
            Object object2 = deprecation2.getDeprecationLevel();
            int n = WhenMappings.$EnumSwitchMapping$0[object2.ordinal()];
            switch (n) {
                case 1: {
                    diagnosticFactory3 = Errors.TYPEALIAS_EXPANSION_DEPRECATION;
                    break;
                }
                case 2: 
                case 3: {
                    diagnosticFactory3 = Errors.TYPEALIAS_EXPANSION_DEPRECATION_ERROR;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            DiagnosticFactory3<PsiElement, TypeAliasDescriptor, DeclarationDescriptor, String> factory3 = diagnosticFactory3;
            object2 = ((DeprecatedTypealiasByAnnotation)deprecation2).getNested().getMessage();
            ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = factory3.on(element, ((DeprecatedTypealiasByAnnotation)deprecation2).getTypeAliasTarget().getOriginal(), ((DeprecatedTypealiasByAnnotation)deprecation2).getNested().getTarget().getOriginal(), (String)(object2 == null ? "" : object2));
            Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, "{\n            val factor\u2026.message ?: \"\")\n        }");
            diagnostic = parametrizedDiagnostic;
        } else {
            DiagnosticFactory2<PsiElement, DeclarationDescriptor, String> diagnosticFactory2;
            Object object3 = deprecation2.getDeprecationLevel();
            int n = WhenMappings.$EnumSwitchMapping$0[object3.ordinal()];
            switch (n) {
                case 1: {
                    diagnosticFactory2 = Errors.DEPRECATION;
                    break;
                }
                case 2: 
                case 3: {
                    diagnosticFactory2 = Errors.DEPRECATION_ERROR;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            DiagnosticFactory2<PsiElement, DeclarationDescriptor, String> factory4 = diagnosticFactory2;
            object3 = deprecation2.getMessage();
            ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = factory4.on(element, targetOriginal, (String)(object3 == null ? "" : object3));
            Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, "{\n            val factor\u2026.message ?: \"\")\n        }");
            diagnostic = parametrizedDiagnostic;
        }
        return diagnostic;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DeprecationLevelValue.values().length];
            nArray[DeprecationLevelValue.WARNING.ordinal()] = 1;
            nArray[DeprecationLevelValue.ERROR.ordinal()] = 2;
            nArray[DeprecationLevelValue.HIDDEN.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

