/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.declarations.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousInitializer;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.utils.ConstructorDelegationComparator;
import org.jetbrains.kotlin.fir.expressions.FirDelegatedConstructorCall;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccess;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousObjectSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000d\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,*\u00020.\"\u001b\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\"\u0015\u0010\u0006\u001a\u00020\u0007*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\"\u0015\u0010\u0006\u001a\u00020\u0007*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u000b\"\u001b\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0005\"\u001b\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0005\"\u0017\u0010\u0011\u001a\u0004\u0018\u00010\r*\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\"\u0017\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\"\u0016\u0010\u0019\u001a\u00020\u001a*\u00020\u001b8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001c\"\u0016\u0010\u001d\u001a\u00020\u001a*\u00020\u001b8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001c\"\u0016\u0010\u001e\u001a\u00020\u001a*\u00020\u001b8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001c\"\u0017\u0010\u001f\u001a\u0004\u0018\u00010\r*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b \u0010!\"\u0017\u0010\"\u001a\u0004\u0018\u00010#*\u00020$8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\"\u001b\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00150\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u0005\"\u001f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00150\u0001*\u0006\u0012\u0002\b\u00030)8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010*\u00a8\u0006/"}, d2={"anonymousInitializers", "", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousInitializer;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "getAnonymousInitializers", "(Lorg/jetbrains/kotlin/fir/declarations/FirClass;)Ljava/util/List;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "getClassId", "(Lorg/jetbrains/kotlin/fir/declarations/FirClass;)Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "(Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;)Lorg/jetbrains/kotlin/name/ClassId;", "constructors", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "getConstructors", "constructorsSortedByDelegation", "getConstructorsSortedByDelegation", "delegatedThisConstructor", "getDelegatedThisConstructor", "(Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;)Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "expandedConeType", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "getExpandedConeType", "(Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;)Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "isFromLibrary", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "(Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)Z", "isJava", "isSynthetic", "primaryConstructor", "getPrimaryConstructor", "(Lorg/jetbrains/kotlin/fir/declarations/FirClass;)Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "referredPropertySymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccess;", "getReferredPropertySymbol", "(Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccess;)Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "superConeTypes", "getSuperConeTypes", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;)Ljava/util/List;", "collectEnumEntries", "", "Lorg/jetbrains/kotlin/fir/declarations/FirEnumEntry;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "tree"})
public final class FirDeclarationUtilKt {
    @Nullable
    public static final ConeClassLikeType getExpandedConeType(@NotNull FirTypeAlias $this$expandedConeType) {
        Intrinsics.checkNotNullParameter($this$expandedConeType, "<this>");
        FirTypeRef $this$coneTypeSafe$iv = $this$expandedConeType.getExpandedTypeRef();
        boolean $i$f$coneTypeSafe = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType = firResolvedTypeRef == null ? null : firResolvedTypeRef.getType();
        if (!(coneKotlinType instanceof ConeClassLikeType)) {
            coneKotlinType = null;
        }
        return (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType));
    }

    @NotNull
    public static final ClassId getClassId(@NotNull FirClassLikeDeclaration $this$classId) {
        ClassId classId;
        Intrinsics.checkNotNullParameter($this$classId, "<this>");
        FirClassLikeDeclaration firClassLikeDeclaration = $this$classId;
        if (firClassLikeDeclaration instanceof FirClass) {
            classId = ((FirClass)$this$classId).getSymbol().getClassId();
        } else if (firClassLikeDeclaration instanceof FirTypeAlias) {
            classId = ((FirTypeAlias)$this$classId).getSymbol().getClassId();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return classId;
    }

    @NotNull
    public static final ClassId getClassId(@NotNull FirClass $this$classId) {
        Intrinsics.checkNotNullParameter($this$classId, "<this>");
        return $this$classId.getSymbol().getClassId();
    }

    @NotNull
    public static final List<ConeClassLikeType> getSuperConeTypes(@NotNull FirClassSymbol<?> $this$superConeTypes) {
        List<ConeClassLikeType> list2;
        Intrinsics.checkNotNullParameter($this$superConeTypes, "<this>");
        FirClassSymbol<?> firClassSymbol = $this$superConeTypes;
        if (firClassSymbol instanceof FirRegularClassSymbol) {
            list2 = FirDeclarationUtilKt.getSuperConeTypes((FirClass)((FirRegularClassSymbol)$this$superConeTypes).getFir());
        } else if (firClassSymbol instanceof FirAnonymousObjectSymbol) {
            list2 = FirDeclarationUtilKt.getSuperConeTypes((FirClass)((FirAnonymousObjectSymbol)$this$superConeTypes).getFir());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ConeClassLikeType> getSuperConeTypes(@NotNull FirClass $this$superConeTypes) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$superConeTypes, "<this>");
        Iterable $this$mapNotNull$iv = $this$superConeTypes.getSuperTypeRefs();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ConeClassLikeType coneClassLikeType;
            ConeClassLikeType coneClassLikeType2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            FirTypeRef it = (FirTypeRef)element$iv$iv;
            boolean bl2 = false;
            FirTypeRef $this$coneTypeSafe$iv = it;
            boolean $i$f$coneTypeSafe = false;
            FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
            ConeKotlinType coneKotlinType = firResolvedTypeRef == null ? null : firResolvedTypeRef.getType();
            if (!(coneKotlinType instanceof ConeClassLikeType)) {
                coneKotlinType = null;
            }
            if ((coneClassLikeType2 = (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType))) == null) continue;
            ConeClassLikeType it$iv$iv = coneClassLikeType = coneClassLikeType2;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<FirAnonymousInitializer> getAnonymousInitializers(@NotNull FirClass $this$anonymousInitializers) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$anonymousInitializers, "<this>");
        Iterable $this$filterIsInstance$iv = $this$anonymousInitializers.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof FirAnonymousInitializer)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<FirConstructor> getConstructors(@NotNull FirClass $this$constructors) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$constructors, "<this>");
        Iterable $this$filterIsInstance$iv = $this$constructors.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof FirConstructor)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final FirConstructor getDelegatedThisConstructor(@NotNull FirConstructor $this$delegatedThisConstructor) {
        FirConstructor firConstructor;
        Intrinsics.checkNotNullParameter($this$delegatedThisConstructor, "<this>");
        FirDelegatedConstructorCall firDelegatedConstructorCall = $this$delegatedThisConstructor.getDelegatedConstructor();
        if (firDelegatedConstructorCall == null) {
            firConstructor = null;
        } else {
            FirDelegatedConstructorCall firDelegatedConstructorCall2;
            FirDelegatedConstructorCall firDelegatedConstructorCall3;
            FirDelegatedConstructorCall it = firDelegatedConstructorCall3 = firDelegatedConstructorCall;
            boolean bl = false;
            FirDelegatedConstructorCall firDelegatedConstructorCall4 = firDelegatedConstructorCall2 = it.isThis() ? firDelegatedConstructorCall3 : null;
            if (firDelegatedConstructorCall2 == null) {
                firConstructor = null;
            } else {
                Object var8_8;
                Object v3;
                FirResolvedNamedReference firResolvedNamedReference;
                it = firDelegatedConstructorCall3 = firDelegatedConstructorCall2;
                boolean bl2 = false;
                Object object = it.getCalleeReference();
                FirResolvedNamedReference firResolvedNamedReference2 = firResolvedNamedReference = object instanceof FirResolvedNamedReference ? (FirResolvedNamedReference)object : null;
                if (firResolvedNamedReference == null) {
                    v3 = null;
                } else {
                    object = firResolvedNamedReference.getResolvedSymbol();
                    v3 = var8_8 = ((FirBasedSymbol)object).getFir();
                }
                firConstructor = var8_8 instanceof FirConstructor ? (FirConstructor)var8_8 : null;
            }
        }
        return firConstructor;
    }

    @NotNull
    public static final List<FirConstructor> getConstructorsSortedByDelegation(@NotNull FirClass $this$constructorsSortedByDelegation) {
        Intrinsics.checkNotNullParameter($this$constructorsSortedByDelegation, "<this>");
        return CollectionsKt.sortedWith((Iterable)FirDeclarationUtilKt.getConstructors($this$constructorsSortedByDelegation), ConstructorDelegationComparator.INSTANCE);
    }

    @Nullable
    public static final FirConstructor getPrimaryConstructor(@NotNull FirClass $this$primaryConstructor) {
        Object v0;
        block1: {
            Iterable iterable;
            Intrinsics.checkNotNullParameter($this$primaryConstructor, "<this>");
            Iterable iterable2 = iterable = (Iterable)FirDeclarationUtilKt.getConstructors($this$primaryConstructor);
            for (Object t : iterable2) {
                FirConstructor p0 = (FirConstructor)t;
                boolean bl = false;
                if (!p0.isPrimary()) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<FirEnumEntry> collectEnumEntries(@NotNull FirRegularClass $this$collectEnumEntries) {
        void $this$filterIsInstanceTo$iv$iv;
        boolean bl;
        Intrinsics.checkNotNullParameter($this$collectEnumEntries, "<this>");
        boolean bl2 = bl = $this$collectEnumEntries.getClassKind() == ClassKind.ENUM_CLASS;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        Iterable $this$filterIsInstance$iv = $this$collectEnumEntries.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof FirEnumEntry)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final FirPropertySymbol getReferredPropertySymbol(@NotNull FirQualifiedAccess $this$referredPropertySymbol) {
        Object object;
        Intrinsics.checkNotNullParameter($this$referredPropertySymbol, "<this>");
        FirReference firReference = $this$referredPropertySymbol.getCalleeReference();
        Object object2 = object = firReference instanceof FirResolvedNamedReference ? (FirResolvedNamedReference)firReference : null;
        if (object == null) {
            return null;
        }
        Object reference = object;
        return (object = ((FirResolvedNamedReference)reference).getResolvedSymbol()) instanceof FirPropertySymbol ? (FirPropertySymbol)object : null;
    }

    public static final boolean isJava(@NotNull FirDeclaration $this$isJava) {
        Intrinsics.checkNotNullParameter($this$isJava, "<this>");
        boolean $i$f$isJava = false;
        return Intrinsics.areEqual($this$isJava.getOrigin(), FirDeclarationOrigin.Java.INSTANCE);
    }

    public static final boolean isFromLibrary(@NotNull FirDeclaration $this$isFromLibrary) {
        Intrinsics.checkNotNullParameter($this$isFromLibrary, "<this>");
        boolean $i$f$isFromLibrary = false;
        return Intrinsics.areEqual($this$isFromLibrary.getOrigin(), FirDeclarationOrigin.Library.INSTANCE);
    }

    public static final boolean isSynthetic(@NotNull FirDeclaration $this$isSynthetic) {
        Intrinsics.checkNotNullParameter($this$isSynthetic, "<this>");
        boolean $i$f$isSynthetic = false;
        return Intrinsics.areEqual($this$isSynthetic.getOrigin(), FirDeclarationOrigin.Synthetic.INSTANCE);
    }
}

