/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirSpreadArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirSpreadOfNullableChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirFunctionCallChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirSpreadOfNullableChecker
extends FirExpressionChecker<FirFunctionCall> {
    @NotNull
    public static final FirSpreadOfNullableChecker INSTANCE = new FirSpreadOfNullableChecker();

    private FirSpreadOfNullableChecker() {
    }

    @Override
    public void check(@NotNull FirFunctionCall expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        for (FirExpression argument2 : expression2.getArgumentList().getArguments()) {
            if (argument2 instanceof FirVarargArgumentsExpression) {
                for (FirExpression subArgument : ((FirVarargArgumentsExpression)argument2).getArguments()) {
                    FirSpreadOfNullableChecker.check$checkAndReport(reporter, context2, subArgument, argument2.getSource());
                }
                continue;
            }
            FirSpreadOfNullableChecker.check$checkAndReport(reporter, context2, argument2, argument2.getSource());
        }
    }

    private static final void check$checkAndReport(DiagnosticReporter $reporter, CheckerContext $context, FirExpression argument2, FirSourceElement source) {
        FirTypeRef argumentTypeRef = argument2.getTypeRef();
        if (argument2 instanceof FirSpreadArgumentExpression && !(FirTypeUtilsKt.getConeType(argumentTypeRef) instanceof ConeFlexibleType) && FirTypeUtilsKt.getCanBeNull(argumentTypeRef)) {
            DiagnosticReporterKt.reportOn$default($reporter, source, FirErrors.INSTANCE.getSPREAD_OF_NULLABLE(), $context, null, 8, null);
        }
    }
}

