/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.ir2wasm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.WasmSymbols;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ClassInfoKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ClassMetadata;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.DeclarationGeneratorKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.LoopLabelType;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.TypeTransformerKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.VirtualMethodMetadata;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmFunctionCodegenContext;
import org.jetbrains.kotlin.backend.wasm.utils.AnnotationsKt;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.utils.IrResolveUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.InlineClassesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoidKt;
import org.jetbrains.kotlin.wasm.ir.WasmExpressionBuilder;
import org.jetbrains.kotlin.wasm.ir.WasmFunctionType;
import org.jetbrains.kotlin.wasm.ir.WasmImmediate;
import org.jetbrains.kotlin.wasm.ir.WasmImmediateKind;
import org.jetbrains.kotlin.wasm.ir.WasmLocal;
import org.jetbrains.kotlin.wasm.ir.WasmOp;
import org.jetbrains.kotlin.wasm.ir.WasmRefNullType;
import org.jetbrains.kotlin.wasm.ir.WasmSymbol;
import org.jetbrains.kotlin.wasm.ir.WasmSymbolIntWrapper;
import org.jetbrains.kotlin.wasm.ir.WasmType;
import org.jetbrains.kotlin.wasm.ir.WasmTypeDeclaration;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00d2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u000e\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u000e\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020 J\u0018\u0010!\u001a\u00020\"2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010#\u001a\u00020$H\u0002J\u0016\u0010%\u001a\u00020\"2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010#\u001a\u00020$J\u0010\u0010&\u001a\u00020\u00122\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020*H\u0016J\u001c\u0010+\u001a\u00020\u0012\"\u0004\b\u0000\u0010,2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H,0-H\u0016J\u0010\u0010.\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u000201H\u0016J\u0010\u00102\u001a\u00020\u00122\u0006\u0010'\u001a\u000203H\u0016J\u0010\u00104\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u000205H\u0016J\u0010\u00106\u001a\u00020\u00122\u0006\u00107\u001a\u000208H\u0016J\u0010\u00109\u001a\u00020\u00122\u0006\u0010:\u001a\u00020;H\u0016J\u0010\u0010<\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020=H\u0016J\u0010\u0010>\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020?H\u0016J\u0010\u0010@\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020AH\u0016J\u0010\u0010B\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020CH\u0016J\u0010\u0010D\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020EH\u0016J\u0010\u0010F\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020GH\u0016J\u0010\u0010H\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020IH\u0016J\u0010\u0010J\u001a\u00020\u00122\u0006\u00107\u001a\u00020KH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006L"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/BodyGenerator;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementVisitorVoid;", "context", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmFunctionCodegenContext;", "(Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmFunctionCodegenContext;)V", "backendContext", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "body", "Lorg/jetbrains/kotlin/wasm/ir/WasmExpressionBuilder;", "getBody", "()Lorg/jetbrains/kotlin/wasm/ir/WasmExpressionBuilder;", "getContext", "()Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmFunctionCodegenContext;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "wasmSymbols", "Lorg/jetbrains/kotlin/backend/wasm/WasmSymbols;", "generateCall", "", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "generateExpression", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "generateInstanceFieldAccess", "field", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "generateTypeRTT", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "statementToWasmInstruction", "statement", "Lorg/jetbrains/kotlin/ir/IrStatement;", "tryToGenerateIntrinsicCall", "", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "tryToGenerateWasmOpIntrinsicCall", "visitBreak", "jump", "Lorg/jetbrains/kotlin/ir/expressions/IrBreak;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitConst", "T", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "visitConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "visitContainerExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrContainerExpression;", "visitContinue", "Lorg/jetbrains/kotlin/ir/expressions/IrContinue;", "visitDelegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "visitDoWhileLoop", "loop", "Lorg/jetbrains/kotlin/ir/expressions/IrDoWhileLoop;", "visitElement", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "visitGetField", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "visitGetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "visitReturn", "Lorg/jetbrains/kotlin/ir/expressions/IrReturn;", "visitSetField", "Lorg/jetbrains/kotlin/ir/expressions/IrSetField;", "visitSetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrSetValue;", "visitTypeOperator", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "visitWhen", "Lorg/jetbrains/kotlin/ir/expressions/IrWhen;", "visitWhileLoop", "Lorg/jetbrains/kotlin/ir/expressions/IrWhileLoop;", "backend.wasm"})
public final class BodyGenerator
implements IrElementVisitorVoid {
    @NotNull
    private final WasmFunctionCodegenContext context;
    @NotNull
    private final WasmExpressionBuilder body;
    @NotNull
    private final WasmBackendContext backendContext;
    @NotNull
    private final WasmSymbols wasmSymbols;
    @NotNull
    private final IrBuiltIns irBuiltIns;

    public BodyGenerator(@NotNull WasmFunctionCodegenContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
        this.body = this.context.getBodyGen();
        this.backendContext = this.context.getBackendContext();
        this.wasmSymbols = this.backendContext.getWasmSymbols();
        this.irBuiltIns = this.backendContext.getIrBuiltIns();
    }

    @NotNull
    public final WasmFunctionCodegenContext getContext() {
        return this.context;
    }

    @NotNull
    public final WasmExpressionBuilder getBody() {
        return this.body;
    }

    @Override
    public void visitElement(@NotNull IrElement element) {
        Intrinsics.checkNotNullParameter(element, "element");
        throw new IllegalStateException(Intrinsics.stringPlus("Unexpected element of type ", Reflection.getOrCreateKotlinClass(element.getClass())).toString());
    }

    @Override
    public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
        boolean bl;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        boolean bl2 = bl = expression2.getOperator() == IrTypeOperator.REINTERPRET_CAST;
        if (!bl) {
            boolean bl3 = false;
            String string2 = "Other types of casts must be lowered";
            throw new IllegalArgumentException(string2.toString());
        }
        this.generateExpression(expression2.getArgument());
    }

    @Override
    public <T> void visitConst(@NotNull IrConst<T> expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrConstKind<T> kind = expression2.getKind();
        if (kind instanceof IrConstKind.Null) {
            DeclarationGeneratorKt.generateDefaultInitializerForType(this.context.transformType(expression2.getType()), this.body);
        } else if (kind instanceof IrConstKind.Boolean) {
            this.body.buildConstI32((Boolean)((IrConstKind.Boolean)kind).valueOf(expression2) != false ? 1 : 0);
        } else if (kind instanceof IrConstKind.Byte) {
            this.body.buildConstI32(((Number)((IrConstKind.Byte)kind).valueOf(expression2)).byteValue());
        } else if (kind instanceof IrConstKind.Short) {
            this.body.buildConstI32(((Number)((IrConstKind.Short)kind).valueOf(expression2)).shortValue());
        } else if (kind instanceof IrConstKind.Int) {
            this.body.buildConstI32(((Number)((IrConstKind.Int)kind).valueOf(expression2)).intValue());
        } else if (kind instanceof IrConstKind.Long) {
            this.body.buildConstI64(((Number)((IrConstKind.Long)kind).valueOf(expression2)).longValue());
        } else if (kind instanceof IrConstKind.Char) {
            this.body.buildConstI32(((Character)((IrConstKind.Char)kind).valueOf(expression2)).charValue());
        } else if (kind instanceof IrConstKind.Float) {
            this.body.buildConstF32(((Number)((IrConstKind.Float)kind).valueOf(expression2)).floatValue());
        } else if (kind instanceof IrConstKind.Double) {
            this.body.buildConstF64(((Number)((IrConstKind.Double)kind).valueOf(expression2)).doubleValue());
        } else if (kind instanceof IrConstKind.String) {
            this.body.buildConstI32Symbol(this.context.referenceStringLiteral((String)((IrConstKind.String)kind).valueOf(expression2)));
            this.body.buildConstI32(((String)((IrConstKind.String)kind).valueOf(expression2)).length());
            this.body.buildCall(this.context.referenceFunction(this.wasmSymbols.getStringGetLiteral()));
        } else {
            throw new IllegalStateException("Unknown constant kind".toString());
        }
    }

    @Override
    public void visitGetField(@NotNull IrGetField expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrField field2 = (IrField)expression2.getSymbol().getOwner();
        IrExpression receiver = expression2.getReceiver();
        if (receiver != null) {
            this.generateExpression(receiver);
            if (!this.backendContext.getInlineClassesUtils().isClassInlineLike(IrUtilsKt.getParentAsClass(field2))) {
                this.generateInstanceFieldAccess(field2);
            }
        } else {
            this.body.buildGetGlobal(this.context.referenceGlobal(field2.getSymbol()));
        }
    }

    private final void generateInstanceFieldAccess(IrField field2) {
        WasmImmediate[] wasmImmediateArray = field2.getType();
        WasmOp opcode = Intrinsics.areEqual(wasmImmediateArray, this.irBuiltIns.getCharType()) ? WasmOp.STRUCT_GET_U : (((Intrinsics.areEqual(wasmImmediateArray, this.irBuiltIns.getBooleanType()) ? true : Intrinsics.areEqual(wasmImmediateArray, this.irBuiltIns.getByteType())) ? true : Intrinsics.areEqual(wasmImmediateArray, this.irBuiltIns.getShortType())) ? WasmOp.STRUCT_GET_S : WasmOp.STRUCT_GET);
        wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.GcType(this.context.referenceGcType(IrUtilsKt.getParentAsClass(field2).getSymbol())), new WasmImmediate.StructFieldIdx(this.context.getStructFieldRef(field2))};
        this.body.buildInstr(opcode, wasmImmediateArray);
    }

    @Override
    public void visitSetField(@NotNull IrSetField expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrField field2 = (IrField)expression2.getSymbol().getOwner();
        IrExpression receiver = expression2.getReceiver();
        if (receiver != null) {
            this.generateExpression(receiver);
            this.generateExpression(expression2.getValue());
            this.body.buildStructSet(this.context.referenceGcType(IrUtilsKt.getParentAsClass(field2).getSymbol()), this.context.getStructFieldRef(field2));
        } else {
            this.generateExpression(expression2.getValue());
            this.body.buildSetGlobal(this.context.referenceGlobal(expression2.getSymbol()));
        }
    }

    @Override
    public void visitGetValue(@NotNull IrGetValue expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        this.body.buildGetLocal(this.context.referenceLocal(expression2.getSymbol()));
    }

    @Override
    public void visitSetValue(@NotNull IrSetValue expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        this.generateExpression(expression2.getValue());
        this.body.buildSetLocal(this.context.referenceLocal(expression2.getSymbol()));
    }

    @Override
    public void visitCall(@NotNull IrCall expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        this.generateCall(expression2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitConstructorCall(@NotNull IrConstructorCall expression2) {
        boolean bl;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrClass klass = IrUtilsKt.getParentAsClass((IrDeclaration)expression2.getSymbol().getOwner());
        boolean bl2 = bl = !this.backendContext.getInlineClassesUtils().isClassInlineLike(klass);
        if (!bl) {
            boolean $i$a$-require-BodyGenerator$visitConstructorCall$522 = false;
            String $i$a$-require-BodyGenerator$visitConstructorCall$522 = "All inline class constructor calls must be lowered to static function calls";
            throw new IllegalArgumentException($i$a$-require-BodyGenerator$visitConstructorCall$522.toString());
        }
        WasmSymbol<WasmTypeDeclaration> wasmGcType = this.context.referenceGcType(klass.getSymbol());
        if (AnnotationsKt.getWasmArrayAnnotation(klass) != null) {
            boolean $i$a$-require-BodyGenerator$visitConstructorCall$522;
            boolean bl3 = $i$a$-require-BodyGenerator$visitConstructorCall$522 = expression2.getValueArgumentsCount() == 1;
            if (!$i$a$-require-BodyGenerator$visitConstructorCall$522) {
                boolean $i$a$-require-BodyGenerator$visitConstructorCall$42 = false;
                String $i$a$-require-BodyGenerator$visitConstructorCall$42 = "@WasmArrayOf constructs must have exactly one argument";
                throw new IllegalArgumentException($i$a$-require-BodyGenerator$visitConstructorCall$42.toString());
            }
            IrExpression irExpression = expression2.getValueArgument(0);
            Intrinsics.checkNotNull(irExpression);
            this.generateExpression(irExpression);
            this.body.buildRttCanon(wasmGcType);
            WasmImmediate[] $i$a$-require-BodyGenerator$visitConstructorCall$522 = new WasmImmediate[]{new WasmImmediate.GcType(wasmGcType)};
            this.body.buildInstr(WasmOp.ARRAY_NEW_DEFAULT_WITH_RTT, $i$a$-require-BodyGenerator$visitConstructorCall$522);
            return;
        }
        WasmSymbol<Integer> wasmClassId = this.context.referenceClassId(klass.getSymbol());
        List<IrField> irFields = ClassInfoKt.allFields(klass, this.backendContext.getIrBuiltIns());
        Iterable $this$forEachIndexed$iv = irFields;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void field2;
            int n = index$iv;
            index$iv = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrField irField = (IrField)item$iv;
            int index2 = n;
            boolean bl4 = false;
            if (index2 == 0) {
                this.getBody().buildConstI32Symbol(wasmClassId);
                continue;
            }
            DeclarationGeneratorKt.generateDefaultInitializerForType(this.getContext().transformType(field2.getType()), this.getBody());
        }
        this.body.buildGetGlobal(this.context.referenceClassRTT(klass.getSymbol()));
        this.body.buildStructNew(wasmGcType);
        this.generateCall(expression2);
    }

    @Override
    public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrClass klass = IrUtilsKt.getParentAsClass(this.context.getIrFunction());
        if (IrTypePredicatesKt.isAny(IrUtilsKt.getDefaultType(klass))) {
            return;
        }
        this.body.buildGetLocal(this.context.referenceLocal(0));
        this.generateCall(expression2);
    }

    /*
     * WARNING - void declaration
     */
    private final void generateCall(IrFunctionAccessExpression call2) {
        WasmType resT;
        boolean isSuperCall;
        IrExpression it;
        IrExpression klass2;
        if (Intrinsics.areEqual(call2.getSymbol(), this.wasmSymbols.getBoxIntrinsic())) {
            IrType irType = call2.getTypeArgument(0);
            Intrinsics.checkNotNull(irType);
            IrType toType22 = irType;
            IrClass irClass2 = TypeTransformerKt.getErasedUpperBound(toType22);
            Intrinsics.checkNotNull(irClass2);
            IrClass klass2 = irClass2;
            WasmSymbol<WasmTypeDeclaration> structTypeName = this.context.referenceGcType(klass2.getSymbol());
            WasmSymbol<Integer> klassId = this.context.referenceClassId(klass2.getSymbol());
            this.body.buildConstI32Symbol(klassId);
            IrExpression irExpression = call2.getValueArgument(0);
            Intrinsics.checkNotNull(irExpression);
            this.generateExpression(irExpression);
            this.body.buildGetGlobal(this.context.referenceClassRTT(klass2.getSymbol()));
            this.body.buildStructNew(structTypeName);
            return;
        }
        IrExpression toType22 = call2.getDispatchReceiver();
        if (toType22 != null) {
            it = klass2 = toType22;
            boolean bl = false;
            this.generateExpression(it);
        }
        toType22 = call2.getExtensionReceiver();
        if (toType22 != null) {
            it = klass2 = toType22;
            boolean bl = false;
            this.generateExpression(it);
        }
        int toType22 = 0;
        int klass2 = call2.getValueArgumentsCount();
        while (toType22 < klass2) {
            int i = toType22++;
            IrExpression irExpression = call2.getValueArgument(i);
            Intrinsics.checkNotNull(irExpression);
            this.generateExpression(irExpression);
        }
        IrFunction function2 = IrResolveUtilsKt.getRealOverrideTarget(((IrFunctionSymbol)call2.getSymbol()).getOwner());
        if (this.tryToGenerateIntrinsicCall(call2, function2)) {
            return;
        }
        boolean bl = isSuperCall = call2 instanceof IrCall && ((IrCall)call2).getSuperQualifierSymbol() != null;
        if (function2 instanceof IrSimpleFunction && org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isOverridable((IrSimpleFunction)function2) && !isSuperCall) {
            IrClass klass3 = IrUtilsKt.getParentAsClass(function2);
            if (!IrUtilsKt.isInterface(klass3)) {
                void $this$mapTo$iv$iv;
                ClassMetadata classMetadata = this.context.getClassMetadata(klass3.getSymbol());
                Iterable $this$map$iv = classMetadata.getVirtualMethods();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    VirtualMethodMetadata virtualMethodMetadata = (VirtualMethodMetadata)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    IrSimpleFunction irSimpleFunction = it2.getFunction();
                    collection.add(irSimpleFunction);
                }
                int vfSlot = ((List)destination$iv$iv).indexOf(function2);
                IrExpression irExpression = call2.getDispatchReceiver();
                Intrinsics.checkNotNull(irExpression);
                this.generateExpression(irExpression);
                this.body.buildConstI32(vfSlot);
                this.body.buildCall(this.context.referenceFunction(this.wasmSymbols.getGetVirtualMethodId()));
                WasmExpressionBuilder.buildCallIndirect$default(this.body, this.context.referenceFunctionType(((IrSimpleFunction)function2).getSymbol()), null, 2, null);
            } else {
                IrExpression irExpression = call2.getDispatchReceiver();
                Intrinsics.checkNotNull(irExpression);
                this.generateExpression(irExpression);
                this.body.buildConstI32Symbol(this.context.referenceInterfaceId(klass3.getSymbol()));
                this.body.buildCall(this.context.referenceFunction(this.wasmSymbols.getGetInterfaceImplId()));
                WasmExpressionBuilder wasmExpressionBuilder = this.body;
                WasmSymbolIntWrapper wasmSymbolIntWrapper = new WasmSymbolIntWrapper(this.context.referenceInterfaceTable(((IrSimpleFunction)function2).getSymbol()));
                WasmSymbol<WasmFunctionType> wasmSymbol = this.context.referenceFunctionType(((IrSimpleFunction)function2).getSymbol());
                wasmExpressionBuilder.buildCallIndirect(wasmSymbol, wasmSymbolIntWrapper);
            }
        } else {
            this.body.buildCall(this.context.referenceFunction(function2.getSymbol()));
        }
        if ((AnnotationsKt.getWasmImportAnnotation(function2) != null || AnnotationsKt.getJsFunAnnotation(function2) != null) && (resT = this.context.transformResultType(function2.getReturnType())) instanceof WasmRefNullType) {
            this.generateTypeRTT(function2.getReturnType());
            this.body.buildRefCast();
        }
    }

    private final void generateTypeRTT(IrType type2) {
        IrClass irClass2 = TypeTransformerKt.getErasedUpperBound(type2);
        IrClassSymbol rtClass = irClass2 == null ? this.context.getBackendContext().getIrBuiltIns().getAnyClass() : irClass2.getSymbol();
        this.body.buildGetGlobal(this.context.referenceClassRTT(rtClass));
    }

    private final boolean tryToGenerateIntrinsicCall(IrFunctionAccessExpression call2, IrFunction function2) {
        if (this.tryToGenerateWasmOpIntrinsicCall(call2, function2)) {
            return true;
        }
        IrFunctionSymbol irFunctionSymbol = function2.getSymbol();
        if (Intrinsics.areEqual(irFunctionSymbol, this.wasmSymbols.getWasmClassId())) {
            boolean bl;
            IrType irType = call2.getTypeArgument(0);
            Intrinsics.checkNotNull(irType);
            IrClass irClass2 = IrTypesKt.getClass(irType);
            if (irClass2 == null) {
                throw new IllegalStateException("No class given for wasmClassId intrinsic".toString());
            }
            IrClass klass = irClass2;
            boolean bl2 = bl = !IrUtilsKt.isInterface(klass);
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            this.body.buildConstI32Symbol(this.context.referenceClassId(klass.getSymbol()));
        } else if (Intrinsics.areEqual(irFunctionSymbol, this.wasmSymbols.getWasmInterfaceId())) {
            IrType irType = call2.getTypeArgument(0);
            Intrinsics.checkNotNull(irType);
            IrClass irClass3 = IrTypesKt.getClass(irType);
            if (irClass3 == null) {
                throw new IllegalStateException("No interface given for wasmInterfaceId intrinsic".toString());
            }
            IrClass irInterface = irClass3;
            boolean bl = IrUtilsKt.isInterface(irInterface);
            if (_Assertions.ENABLED && !bl) {
                String string3 = "Assertion failed";
                throw new AssertionError((Object)string3);
            }
            this.body.buildConstI32Symbol(this.context.referenceInterfaceId(irInterface.getSymbol()));
        } else if (Intrinsics.areEqual(irFunctionSymbol, this.wasmSymbols.getWasmRefCast())) {
            IrType irType = call2.getTypeArgument(0);
            Intrinsics.checkNotNull(irType);
            IrType toType = irType;
            this.generateTypeRTT(toType);
            this.body.buildRefCast();
        } else if (Intrinsics.areEqual(irFunctionSymbol, this.wasmSymbols.getUnboxIntrinsic())) {
            IrType irType = call2.getTypeArgument(0);
            Intrinsics.checkNotNull(irType);
            IrType fromType = irType;
            if (IrTypePredicatesKt.isNothing(fromType)) {
                this.body.buildUnreachable();
                return true;
            }
            if (IrTypePredicatesKt.isNothing(IrTypesKt.makeNotNull(fromType))) {
                this.body.buildUnreachable();
                return true;
            }
            IrType irType2 = call2.getTypeArgument(1);
            Intrinsics.checkNotNull(irType2);
            IrType toType = irType2;
            IrClass irClass4 = this.backendContext.getInlineClassesUtils().getInlinedClass(toType);
            Intrinsics.checkNotNull(irClass4);
            IrClass klass = irClass4;
            IrField field2 = InlineClassesKt.getInlineClassBackingField(klass);
            this.generateTypeRTT(toType);
            this.body.buildRefCast();
            this.generateInstanceFieldAccess(field2);
        } else if (Intrinsics.areEqual(irFunctionSymbol, this.wasmSymbols.getUnsafeGetScratchRawMemory())) {
            this.body.buildDrop();
            this.body.buildConstI32Symbol(this.context.getScratchMemAddr());
        } else {
            return false;
        }
        return true;
    }

    @Override
    public void visitContainerExpression(@NotNull IrContainerExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        List<IrStatement> statements2 = expression2.getStatements();
        if (statements2.isEmpty()) {
            return;
        }
        Iterable $this$forEach$iv = CollectionsKt.dropLast(statements2, 1);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrStatement it = (IrStatement)element$iv;
            boolean bl = false;
            this.statementToWasmInstruction(it);
        }
        if (!Intrinsics.areEqual(expression2.getType(), this.irBuiltIns.getUnitType())) {
            this.generateExpression((IrExpression)CollectionsKt.last(statements2));
        } else {
            this.statementToWasmInstruction(CollectionsKt.last(statements2));
        }
    }

    @Override
    public void visitBreak(@NotNull IrBreak jump) {
        Intrinsics.checkNotNullParameter(jump, "jump");
        this.body.buildBr(this.context.referenceLoopLevel(jump.getLoop(), LoopLabelType.BREAK));
    }

    @Override
    public void visitContinue(@NotNull IrContinue jump) {
        Intrinsics.checkNotNullParameter(jump, "jump");
        this.body.buildBr(this.context.referenceLoopLevel(jump.getLoop(), LoopLabelType.CONTINUE));
    }

    @Override
    public void visitReturn(@NotNull IrReturn expression2) {
        IrType irReturnType;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        this.generateExpression(expression2.getValue());
        if (Intrinsics.areEqual(expression2.getValue().getType(), this.irBuiltIns.getUnitType()) && !Intrinsics.areEqual(org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.returnType(expression2.getReturnTargetSymbol().getOwner(), this.backendContext), this.irBuiltIns.getUnitType()) && !Intrinsics.areEqual(irReturnType = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.returnType(expression2.getReturnTargetSymbol().getOwner(), this.backendContext), this.irBuiltIns.getUnitType())) {
            DeclarationGeneratorKt.generateDefaultInitializerForType(this.context.transformType(irReturnType), this.body);
        }
        if (DeclarationGeneratorKt.isExported(this.context.getIrFunction(), this.context.getBackendContext()) && Intrinsics.areEqual(IrTypesKt.getClass(expression2.getValue().getType()), IrTypesKt.getClass(this.irBuiltIns.getStringType()))) {
            this.body.buildCall(this.context.referenceFunction(this.wasmSymbols.getExportString()));
        }
        this.body.buildInstr(WasmOp.RETURN, new WasmImmediate[0]);
    }

    @Override
    public void visitWhen(@NotNull IrWhen expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        if (Intrinsics.areEqual(expression2.getType(), this.irBuiltIns.getUnitType())) {
            int ifCount = 0;
            for (IrBranch branch : expression2.getBranches()) {
                if (!org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isElseBranch(branch)) {
                    this.generateExpression(branch.getCondition());
                    this.body.buildIf(null, null);
                    this.statementToWasmInstruction(branch.getResult());
                    this.body.buildElse();
                    int n = ifCount;
                    ifCount = n + 1;
                    continue;
                }
                this.statementToWasmInstruction(branch.getResult());
                break;
            }
            int n = 0;
            while (n < ifCount) {
                int n2;
                int it = n2 = n++;
                boolean bl = false;
                this.getBody().buildEnd();
            }
            return;
        }
        WasmType resultType = this.context.transformBlockResultType(expression2.getType());
        int ifCount = 0;
        for (IrBranch branch : expression2.getBranches()) {
            if (!org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isElseBranch(branch)) {
                this.generateExpression(branch.getCondition());
                this.body.buildIf(null, resultType);
                this.generateExpression(branch.getResult());
                if (Intrinsics.areEqual(expression2.getType(), this.irBuiltIns.getNothingType())) {
                    this.body.buildUnreachable();
                }
                this.body.buildElse();
                int bl = ifCount;
                ifCount = bl + 1;
                continue;
            }
            this.generateExpression(branch.getResult());
            if (!Intrinsics.areEqual(expression2.getType(), this.irBuiltIns.getNothingType())) break;
            this.body.buildUnreachable();
            break;
        }
        int n = 0;
        while (n < ifCount) {
            int n3;
            int it = n3 = n++;
            boolean bl = false;
            this.getBody().buildEnd();
        }
    }

    @Override
    public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2) {
        Intrinsics.checkNotNullParameter(loop2, "loop");
        String label = loop2.getLabel();
        WasmExpressionBuilder.buildLoop$default(this.body, label, null, 2, null);
        int wasmLoop = this.body.getNumberOfNestedBlocks();
        WasmExpressionBuilder.buildBlock$default(this.body, Intrinsics.stringPlus("BREAK_", label), null, 2, null);
        int wasmBreakBlock = this.body.getNumberOfNestedBlocks();
        WasmExpressionBuilder.buildBlock$default(this.body, Intrinsics.stringPlus("CONTINUE_", label), null, 2, null);
        int wasmContinueBlock = this.body.getNumberOfNestedBlocks();
        this.context.defineLoopLevel(loop2, LoopLabelType.BREAK, wasmBreakBlock);
        this.context.defineLoopLevel(loop2, LoopLabelType.CONTINUE, wasmContinueBlock);
        IrExpression irExpression = loop2.getBody();
        if (irExpression != null) {
            IrExpression irExpression2;
            IrExpression it = irExpression2 = irExpression;
            boolean bl = false;
            this.statementToWasmInstruction(it);
        }
        this.body.buildEnd();
        this.generateExpression(loop2.getCondition());
        this.body.buildBrIf(wasmLoop);
        this.body.buildEnd();
        this.body.buildEnd();
    }

    @Override
    public void visitWhileLoop(@NotNull IrWhileLoop loop2) {
        Intrinsics.checkNotNullParameter(loop2, "loop");
        String label = loop2.getLabel();
        WasmExpressionBuilder.buildLoop$default(this.body, label, null, 2, null);
        int wasmLoop = this.body.getNumberOfNestedBlocks();
        WasmExpressionBuilder.buildBlock$default(this.body, Intrinsics.stringPlus("BREAK_", label), null, 2, null);
        int wasmBreakBlock = this.body.getNumberOfNestedBlocks();
        this.context.defineLoopLevel(loop2, LoopLabelType.BREAK, wasmBreakBlock);
        this.context.defineLoopLevel(loop2, LoopLabelType.CONTINUE, wasmLoop);
        this.generateExpression(loop2.getCondition());
        this.body.buildInstr(WasmOp.I32_EQZ, new WasmImmediate[0]);
        this.body.buildBrIf(wasmBreakBlock);
        IrExpression irExpression = loop2.getBody();
        if (irExpression != null) {
            IrExpression irExpression2;
            IrExpression it = irExpression2 = irExpression;
            boolean bl = false;
            this.statementToWasmInstruction(it);
        }
        this.body.buildBr(wasmLoop);
        this.body.buildEnd();
        this.body.buildEnd();
    }

    public final void generateExpression(@NotNull IrExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrElementVisitorVoidKt.acceptVoid(expression2, this);
        if (Intrinsics.areEqual(expression2.getType(), this.irBuiltIns.getNothingType())) {
            this.body.buildUnreachable();
        }
    }

    public final void statementToWasmInstruction(@NotNull IrStatement statement2) {
        Intrinsics.checkNotNullParameter(statement2, "statement");
        if (statement2 instanceof IrVariable) {
            this.context.defineLocal(((IrVariable)statement2).getSymbol());
            IrExpression irExpression = ((IrVariable)statement2).getInitializer();
            if (irExpression == null) {
                return;
            }
            IrExpression init2 = irExpression;
            this.generateExpression(init2);
            WasmLocal varName = this.context.referenceLocal(((IrVariable)statement2).getSymbol());
            this.body.buildSetLocal(varName);
            return;
        }
        this.generateExpression((IrExpression)statement2);
        if (!Intrinsics.areEqual(((IrExpression)statement2).getType(), this.irBuiltIns.getUnitType()) && !Intrinsics.areEqual(((IrExpression)statement2).getType(), this.irBuiltIns.getNothingType())) {
            this.body.buildInstr(WasmOp.DROP, new WasmImmediate[0]);
        }
    }

    public final boolean tryToGenerateWasmOpIntrinsicCall(@NotNull IrFunctionAccessExpression call2, @NotNull IrFunction function2) {
        Intrinsics.checkNotNullParameter(call2, "call");
        Intrinsics.checkNotNullParameter(function2, "function");
        if (AnnotationsKt.hasWasmNoOpCastAnnotation(function2)) {
            return true;
        }
        String opString = AnnotationsKt.getWasmOpAnnotation(function2);
        if (opString != null) {
            WasmOp op = WasmOp.valueOf(opString);
            boolean $i$f$emptyArray = false;
            WasmImmediate[] immediates = new WasmImmediate[]{};
            int n = op.getImmediates().size();
            switch (n) {
                case 0: {
                    WasmOp wasmOp = op;
                    int n2 = WhenMappings.$EnumSwitchMapping$0[wasmOp.ordinal()];
                    if (n2 != 1) break;
                    IrType irType = call2.getTypeArgument(0);
                    Intrinsics.checkNotNull(irType);
                    IrType toIrType2 = irType;
                    this.generateTypeRTT(toIrType2);
                    break;
                }
                case 1: {
                    WasmImmediate wasmImmediate;
                    WasmImmediate[] wasmImmediateArray = new WasmImmediate[1];
                    WasmImmediateKind imm = op.getImmediates().get(0);
                    int n3 = WhenMappings.$EnumSwitchMapping$1[imm.ordinal()];
                    switch (n3) {
                        case 1: {
                            wasmImmediate = new WasmImmediate.MemArg(0, 0, null);
                            break;
                        }
                        case 2: {
                            IrValueParameter irValueParameter = function2.getDispatchReceiverParameter();
                            Intrinsics.checkNotNull(irValueParameter);
                            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(irValueParameter.getType());
                            Intrinsics.checkNotNull(irClassSymbol);
                            wasmImmediate = new WasmImmediate.GcType(this.context.referenceGcType(irClassSymbol));
                            break;
                        }
                        default: {
                            throw new IllegalStateException(("Immediate " + (Object)((Object)imm) + " is unsupported").toString());
                        }
                    }
                    wasmImmediateArray[0] = wasmImmediate;
                    immediates = wasmImmediateArray;
                    break;
                }
                default: {
                    throw new IllegalStateException(("Op " + opString + " is unsupported").toString());
                }
            }
            this.body.buildInstr(op, Arrays.copyOf(immediates, immediates.length));
            return true;
        }
        return false;
    }

    @Override
    public <T> void visitConst(@NotNull IrConst<T> expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2, data);
    }

    @Override
    public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration2);
    }

    @Override
    public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration2, data);
    }

    @Override
    public void visitBlock(@NotNull IrBlock expression2) {
        IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2);
    }

    @Override
    public void visitBlock(@NotNull IrBlock expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2, data);
    }

    @Override
    public void visitBlockBody(@NotNull IrBlockBody body2) {
        IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2);
    }

    @Override
    public void visitBlockBody(@NotNull IrBlockBody body2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2, data);
    }

    @Override
    public void visitBody(@NotNull IrBody body2) {
        IrElementVisitorVoid.DefaultImpls.visitBody(this, body2);
    }

    @Override
    public void visitBody(@NotNull IrBody body2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBody(this, body2, data);
    }

    @Override
    public void visitBranch(@NotNull IrBranch branch) {
        IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch);
    }

    @Override
    public void visitBranch(@NotNull IrBranch branch, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch, data);
    }

    @Override
    public void visitBreak(@NotNull IrBreak jump, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump, data);
    }

    @Override
    public void visitBreakContinue(@NotNull IrBreakContinue jump) {
        IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump);
    }

    @Override
    public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump, data);
    }

    @Override
    public void visitCall(@NotNull IrCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2, data);
    }

    @Override
    public void visitCallableReference(@NotNull IrCallableReference<?> expression2) {
        IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2);
    }

    @Override
    public void visitCallableReference(@NotNull IrCallableReference<?> expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2, data);
    }

    @Override
    public void visitCatch(@NotNull IrCatch aCatch) {
        IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch);
    }

    @Override
    public void visitCatch(@NotNull IrCatch aCatch, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch, data);
    }

    @Override
    public void visitClass(@NotNull IrClass declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration2);
    }

    @Override
    public void visitClass(@NotNull IrClass declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration2, data);
    }

    @Override
    public void visitClassReference(@NotNull IrClassReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2);
    }

    @Override
    public void visitClassReference(@NotNull IrClassReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2, data);
    }

    @Override
    public void visitComposite(@NotNull IrComposite expression2) {
        IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2);
    }

    @Override
    public void visitComposite(@NotNull IrComposite expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2, data);
    }

    @Override
    public void visitConstructor(@NotNull IrConstructor declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration2);
    }

    @Override
    public void visitConstructor(@NotNull IrConstructor declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration2, data);
    }

    @Override
    public void visitConstructorCall(@NotNull IrConstructorCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2, data);
    }

    @Override
    public void visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2, data);
    }

    @Override
    public void visitContinue(@NotNull IrContinue jump, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump, data);
    }

    @Override
    public void visitDeclaration(@NotNull IrDeclarationBase declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration2);
    }

    @Override
    public void visitDeclaration(@NotNull IrDeclarationBase declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration2, data);
    }

    @Override
    public void visitDeclarationReference(@NotNull IrDeclarationReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2);
    }

    @Override
    public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2, data);
    }

    @Override
    public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data);
    }

    @Override
    public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2, data);
    }

    @Override
    public void visitDynamicExpression(@NotNull IrDynamicExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2);
    }

    @Override
    public void visitDynamicExpression(@NotNull IrDynamicExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2, data);
    }

    @Override
    public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2);
    }

    @Override
    public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2, data);
    }

    @Override
    public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2);
    }

    @Override
    public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data);
    }

    @Override
    public void visitElement(@NotNull IrElement element, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitElement(this, element, data);
    }

    @Override
    public void visitElseBranch(@NotNull IrElseBranch branch) {
        IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch);
    }

    @Override
    public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch, data);
    }

    @Override
    public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
        IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2);
    }

    @Override
    public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
    }

    @Override
    public void visitEnumEntry(@NotNull IrEnumEntry declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration2);
    }

    @Override
    public void visitEnumEntry(@NotNull IrEnumEntry declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration2, data);
    }

    @Override
    public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2);
    }

    @Override
    public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2, data);
    }

    @Override
    public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration2);
    }

    @Override
    public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration2, data);
    }

    @Override
    public void visitErrorExpression(@NotNull IrErrorExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2);
    }

    @Override
    public void visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2, data);
    }

    @Override
    public void visitExpression(@NotNull IrExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2);
    }

    @Override
    public void visitExpression(@NotNull IrExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2, data);
    }

    @Override
    public void visitExpressionBody(@NotNull IrExpressionBody body2) {
        IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2);
    }

    @Override
    public void visitExpressionBody(@NotNull IrExpressionBody body2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2, data);
    }

    @Override
    public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration2);
    }

    @Override
    public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration2, data);
    }

    @Override
    public void visitField(@NotNull IrField declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitField(this, declaration2);
    }

    @Override
    public void visitField(@NotNull IrField declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitField(this, declaration2, data);
    }

    @Override
    public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2);
    }

    @Override
    public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2, data);
    }

    @Override
    public void visitFile(@NotNull IrFile declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration2);
    }

    @Override
    public void visitFile(@NotNull IrFile declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration2, data);
    }

    @Override
    public void visitFunction(@NotNull IrFunction declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration2);
    }

    @Override
    public void visitFunction(@NotNull IrFunction declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration2, data);
    }

    @Override
    public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2);
    }

    @Override
    public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2, data);
    }

    @Override
    public void visitFunctionExpression(@NotNull IrFunctionExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2);
    }

    @Override
    public void visitFunctionExpression(@NotNull IrFunctionExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2, data);
    }

    @Override
    public void visitFunctionReference(@NotNull IrFunctionReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2);
    }

    @Override
    public void visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2, data);
    }

    @Override
    public void visitGetClass(@NotNull IrGetClass expression2) {
        IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2);
    }

    @Override
    public void visitGetClass(@NotNull IrGetClass expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2, data);
    }

    @Override
    public void visitGetEnumValue(@NotNull IrGetEnumValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2);
    }

    @Override
    public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2, data);
    }

    @Override
    public void visitGetField(@NotNull IrGetField expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2, data);
    }

    @Override
    public void visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2);
    }

    @Override
    public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2, data);
    }

    @Override
    public void visitGetValue(@NotNull IrGetValue expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2, data);
    }

    @Override
    public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2) {
        IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2);
    }

    @Override
    public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2, data);
    }

    @Override
    public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration2);
    }

    @Override
    public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration2, data);
    }

    @Override
    public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2);
    }

    @Override
    public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
    }

    @Override
    public void visitLoop(@NotNull IrLoop loop2) {
        IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2);
    }

    @Override
    public void visitLoop(@NotNull IrLoop loop2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2, data);
    }

    @Override
    public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2) {
        IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2);
    }

    @Override
    public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2, data);
    }

    @Override
    public void visitModuleFragment(@NotNull IrModuleFragment declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration2);
    }

    @Override
    public void visitModuleFragment(@NotNull IrModuleFragment declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration2, data);
    }

    @Override
    public void visitPackageFragment(@NotNull IrPackageFragment declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration2);
    }

    @Override
    public void visitPackageFragment(@NotNull IrPackageFragment declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration2, data);
    }

    @Override
    public void visitProperty(@NotNull IrProperty declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration2);
    }

    @Override
    public void visitProperty(@NotNull IrProperty declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration2, data);
    }

    @Override
    public void visitPropertyReference(@NotNull IrPropertyReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2);
    }

    @Override
    public void visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2, data);
    }

    @Override
    public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2);
    }

    @Override
    public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2, data);
    }

    @Override
    public void visitReturn(@NotNull IrReturn expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2, data);
    }

    @Override
    public void visitScript(@NotNull IrScript declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration2);
    }

    @Override
    public void visitScript(@NotNull IrScript declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration2, data);
    }

    @Override
    public void visitSetField(@NotNull IrSetField expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2, data);
    }

    @Override
    public void visitSetValue(@NotNull IrSetValue expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2, data);
    }

    @Override
    public void visitSimpleFunction(@NotNull IrSimpleFunction declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration2);
    }

    @Override
    public void visitSimpleFunction(@NotNull IrSimpleFunction declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration2, data);
    }

    @Override
    public void visitSingletonReference(@NotNull IrGetSingletonValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2);
    }

    @Override
    public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2, data);
    }

    @Override
    public void visitSpreadElement(@NotNull IrSpreadElement spread) {
        IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread);
    }

    @Override
    public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread, data);
    }

    @Override
    public void visitStringConcatenation(@NotNull IrStringConcatenation expression2) {
        IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2);
    }

    @Override
    public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2, data);
    }

    @Override
    public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2);
    }

    @Override
    public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2, data);
    }

    @Override
    public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2) {
        IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2);
    }

    @Override
    public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2, data);
    }

    @Override
    public void visitSyntheticBody(@NotNull IrSyntheticBody body2) {
        IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2);
    }

    @Override
    public void visitSyntheticBody(@NotNull IrSyntheticBody body2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2, data);
    }

    @Override
    public void visitThrow(@NotNull IrThrow expression2) {
        IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2);
    }

    @Override
    public void visitThrow(@NotNull IrThrow expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2, data);
    }

    @Override
    public void visitTry(@NotNull IrTry aTry) {
        IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry);
    }

    @Override
    public void visitTry(@NotNull IrTry aTry, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry, data);
    }

    @Override
    public void visitTypeAlias(@NotNull IrTypeAlias declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration2);
    }

    @Override
    public void visitTypeAlias(@NotNull IrTypeAlias declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration2, data);
    }

    @Override
    public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2, data);
    }

    @Override
    public void visitTypeParameter(@NotNull IrTypeParameter declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration2);
    }

    @Override
    public void visitTypeParameter(@NotNull IrTypeParameter declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration2, data);
    }

    @Override
    public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2, data);
    }

    @Override
    public void visitValueParameter(@NotNull IrValueParameter declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration2);
    }

    @Override
    public void visitValueParameter(@NotNull IrValueParameter declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration2, data);
    }

    @Override
    public void visitVararg(@NotNull IrVararg expression2) {
        IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2);
    }

    @Override
    public void visitVararg(@NotNull IrVararg expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2, data);
    }

    @Override
    public void visitVariable(@NotNull IrVariable declaration2) {
        IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration2);
    }

    @Override
    public void visitVariable(@NotNull IrVariable declaration2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration2, data);
    }

    @Override
    public void visitVariableAccess(@NotNull IrValueAccessExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitVariableAccess(this, expression2);
    }

    @Override
    public void visitWhen(@NotNull IrWhen expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2, data);
    }

    @Override
    public void visitWhileLoop(@NotNull IrWhileLoop loop2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2, data);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[WasmOp.values().length];
            nArray[WasmOp.REF_TEST.ordinal()] = 1;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[WasmImmediateKind.values().length];
            nArray[WasmImmediateKind.MEM_ARG.ordinal()] = 1;
            nArray[WasmImmediateKind.STRUCT_TYPE_IDX.ordinal()] = 2;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

