/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.phaser.NamedCompilerPhase;
import org.jetbrains.kotlin.backend.common.phaser.PhaseBuildersKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.codegen.IrCodegenUtilsKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.backend.jvm.lower.InheritedDefaultMethodsOnClassesLoweringKt;
import org.jetbrains.kotlin.config.JvmDefaultMode;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.deserialization.PlatformDependentDeclarationFilterKt;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u0011*\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u001a\f\u0010\u0015\u001a\u00020\u000f*\u00020\u0011H\u0002\u001a \u0010\u0016\u001a\u00020\u000f*\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0011H\u0000\" \u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\" \u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0005\" \u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0005\" \u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0005\" \u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0005\u00a8\u0006\u0018"}, d2={"inheritedDefaultMethodsOnClassesPhase", "Lorg/jetbrains/kotlin/backend/common/phaser/NamedCompilerPhase;", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "getInheritedDefaultMethodsOnClassesPhase", "()Lorg/jetbrains/kotlin/backend/common/phaser/NamedCompilerPhase;", "interfaceDefaultCallsPhase", "getInterfaceDefaultCallsPhase", "interfaceObjectCallsPhase", "getInterfaceObjectCallsPhase", "interfaceSuperCallsPhase", "getInterfaceSuperCallsPhase", "replaceDefaultImplsOverriddenSymbolsPhase", "getReplaceDefaultImplsOverriddenSymbolsPhase", "isDefaultImplsBridge", "", "f", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "findInterfaceImplementation", "jvmDefaultMode", "Lorg/jetbrains/kotlin/config/JvmDefaultMode;", "isCloneableClone", "isDefinitelyNotDefaultImplsMethod", "implementation", "backend.jvm.lower"})
public final class InheritedDefaultMethodsOnClassesLoweringKt {
    @NotNull
    private static final NamedCompilerPhase<JvmBackendContext, IrFile> inheritedDefaultMethodsOnClassesPhase = PhaseBuildersKt.makeIrFilePhase$default(inheritedDefaultMethodsOnClassesPhase.1.INSTANCE, "InheritedDefaultMethodsOnClasses", "Add bridge-implementations in classes that inherit default implementations from interfaces", null, null, null, null, null, 248, null);
    @NotNull
    private static final NamedCompilerPhase<JvmBackendContext, IrFile> replaceDefaultImplsOverriddenSymbolsPhase = PhaseBuildersKt.makeIrFilePhase$default(replaceDefaultImplsOverriddenSymbolsPhase.1.INSTANCE, "ReplaceDefaultImplsOverriddenSymbols", "Replace overridden symbols for methods inherited from interfaces to classes", null, null, null, null, null, 248, null);
    @NotNull
    private static final NamedCompilerPhase<JvmBackendContext, IrFile> interfaceSuperCallsPhase = PhaseBuildersKt.makeIrFilePhase$default(interfaceSuperCallsPhase.1.INSTANCE, "InterfaceSuperCalls", "Redirect super interface calls to DefaultImpls", null, null, null, null, null, 248, null);
    @NotNull
    private static final NamedCompilerPhase<JvmBackendContext, IrFile> interfaceDefaultCallsPhase = PhaseBuildersKt.makeIrFilePhase$default(interfaceDefaultCallsPhase.1.INSTANCE, "InterfaceDefaultCalls", "Redirect interface calls with default arguments to DefaultImpls (except method compiled to JVM defaults)", null, null, null, null, null, 248, null);
    @NotNull
    private static final NamedCompilerPhase<JvmBackendContext, IrFile> interfaceObjectCallsPhase = PhaseBuildersKt.makeIrFilePhase$default(interfaceObjectCallsPhase.1.INSTANCE, "InterfaceObjectCalls", "Resolve calls to Object methods on interface types to virtual methods", null, null, null, null, null, 248, null);

    @NotNull
    public static final NamedCompilerPhase<JvmBackendContext, IrFile> getInheritedDefaultMethodsOnClassesPhase() {
        return inheritedDefaultMethodsOnClassesPhase;
    }

    @NotNull
    public static final NamedCompilerPhase<JvmBackendContext, IrFile> getReplaceDefaultImplsOverriddenSymbolsPhase() {
        return replaceDefaultImplsOverriddenSymbolsPhase;
    }

    @NotNull
    public static final NamedCompilerPhase<JvmBackendContext, IrFile> getInterfaceSuperCallsPhase() {
        return interfaceSuperCallsPhase;
    }

    @NotNull
    public static final NamedCompilerPhase<JvmBackendContext, IrFile> getInterfaceDefaultCallsPhase() {
        return interfaceDefaultCallsPhase;
    }

    public static final boolean isDefinitelyNotDefaultImplsMethod(@NotNull IrSimpleFunction $this$isDefinitelyNotDefaultImplsMethod, @NotNull JvmDefaultMode jvmDefaultMode2, @Nullable IrSimpleFunction implementation2) {
        Intrinsics.checkNotNullParameter($this$isDefinitelyNotDefaultImplsMethod, "<this>");
        Intrinsics.checkNotNullParameter((Object)jvmDefaultMode2, "jvmDefaultMode");
        return implementation2 == null || Intrinsics.areEqual(implementation2.getOrigin(), IrDeclarationOrigin.IR_EXTERNAL_JAVA_DECLARATION_STUB.INSTANCE) || JvmIrUtilsKt.isCompiledToJvmDefault(implementation2, jvmDefaultMode2) || Intrinsics.areEqual($this$isDefinitelyNotDefaultImplsMethod.getOrigin(), IrDeclarationOrigin.FUNCTION_FOR_DEFAULT_PARAMETER.INSTANCE) || IrUtilsKt.hasAnnotation((IrAnnotationContainer)$this$isDefinitelyNotDefaultImplsMethod, PlatformDependentDeclarationFilterKt.getPLATFORM_DEPENDENT_ANNOTATION_FQ_NAME()) || InheritedDefaultMethodsOnClassesLoweringKt.isCloneableClone($this$isDefinitelyNotDefaultImplsMethod);
    }

    public static /* synthetic */ boolean isDefinitelyNotDefaultImplsMethod$default(IrSimpleFunction irSimpleFunction, JvmDefaultMode jvmDefaultMode2, IrSimpleFunction irSimpleFunction2, int n, Object object) {
        if ((n & 2) != 0) {
            irSimpleFunction2 = (IrSimpleFunction)IrFakeOverrideUtilsKt.resolveFakeOverride$default(irSimpleFunction, false, null, 3, null);
        }
        return InheritedDefaultMethodsOnClassesLoweringKt.isDefinitelyNotDefaultImplsMethod(irSimpleFunction, jvmDefaultMode2, irSimpleFunction2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isCloneableClone(IrSimpleFunction $this$isCloneableClone) {
        FqName fqName2;
        IrClass irClass2;
        if (!Intrinsics.areEqual($this$isCloneableClone.getName().asString(), "clone")) return false;
        IrDeclarationParent $this$safeAs$iv = $this$isCloneableClone.getParent();
        boolean $i$f$safeAs = false;
        IrDeclarationParent irDeclarationParent = $this$safeAs$iv;
        if (!(irDeclarationParent instanceof IrClass)) {
            irDeclarationParent = null;
        }
        if (!Intrinsics.areEqual((irClass2 = (IrClass)irDeclarationParent) == null ? null : ((fqName2 = IrUtilsKt.getFqNameWhenAvailable(irClass2)) == null ? null : fqName2.asString()), "kotlin.Cloneable")) return false;
        if (!$this$isCloneableClone.getValueParameters().isEmpty()) return false;
        return true;
    }

    @NotNull
    public static final NamedCompilerPhase<JvmBackendContext, IrFile> getInterfaceObjectCallsPhase() {
        return interfaceObjectCallsPhase;
    }

    @Nullable
    public static final IrSimpleFunction findInterfaceImplementation(@NotNull IrSimpleFunction $this$findInterfaceImplementation, @NotNull JvmDefaultMode jvmDefaultMode2) {
        boolean bl;
        IrSimpleFunction implementation2;
        block8: {
            Intrinsics.checkNotNullParameter($this$findInterfaceImplementation, "<this>");
            Intrinsics.checkNotNullParameter((Object)jvmDefaultMode2, "jvmDefaultMode");
            if (!$this$findInterfaceImplementation.isFakeOverride()) {
                return null;
            }
            IrDeclarationParent parent2 = $this$findInterfaceImplementation.getParent();
            if (parent2 instanceof IrClass && (IrCodegenUtilsKt.isJvmInterface((IrClass)parent2) || IrUtilsKt.isFromJava((IrDeclaration)((Object)parent2)))) {
                return null;
            }
            IrSimpleFunction irSimpleFunction = (IrSimpleFunction)IrFakeOverrideUtilsKt.resolveFakeOverride$default($this$findInterfaceImplementation, false, findInterfaceImplementation.implementation.1.INSTANCE, 1, null);
            if (irSimpleFunction == null) {
                return null;
            }
            implementation2 = irSimpleFunction;
            Iterable $this$any$iv = $this$findInterfaceImplementation.getOverriddenSymbols();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IrSimpleFunctionSymbol it = (IrSimpleFunctionSymbol)element$iv;
                    boolean bl2 = false;
                    boolean bl3 = !IrUtilsKt.isInterface(IrUtilsKt.getParentAsClass((IrDeclaration)it.getOwner())) && ((IrSimpleFunction)it.getOwner()).getModality() != Modality.ABSTRACT && Intrinsics.areEqual(IrFakeOverrideUtilsKt.resolveFakeOverride$default((IrOverridableDeclaration)it.getOwner(), false, findInterfaceImplementation.1.1.INSTANCE, 1, null), implementation2);
                    if (!bl3) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        if (bl) {
            return null;
        }
        if (!IrUtilsKt.hasInterfaceParent(implementation2) || DescriptorVisibilities.isPrivate(implementation2.getVisibility()) || InheritedDefaultMethodsOnClassesLoweringKt.isDefinitelyNotDefaultImplsMethod$default(implementation2, jvmDefaultMode2, null, 2, null) || org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isMethodOfAny(implementation2)) {
            return null;
        }
        return implementation2;
    }

    private static final boolean isDefaultImplsBridge(IrSimpleFunction f) {
        return Intrinsics.areEqual(f.getOrigin(), JvmLoweredDeclarationOrigin.SUPER_INTERFACE_METHOD_BRIDGE.INSTANCE);
    }

    public static final /* synthetic */ boolean access$isDefaultImplsBridge(IrSimpleFunction f) {
        return InheritedDefaultMethodsOnClassesLoweringKt.isDefaultImplsBridge(f);
    }
}

