/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.ir.IrUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.Closure;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrTypeParametersContainer;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeAbbreviation;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitor;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0002\u001d\u001eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\tH\u0002J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0004\u001a\u00020\u000bJ\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u000e\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0004\u001a\u00020\u000eJ\u0010\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\tH\u0002R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\u00020\t*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0018\u0010\n\u001a\u00020\t*\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000fR\u001a\u0010\u0010\u001a\u0004\u0018\u00010\t*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u0004\u0018\u00010\t*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator;", "", "irElement", "Lorg/jetbrains/kotlin/ir/IrElement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "(Lorg/jetbrains/kotlin/ir/IrElement;Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)V", "closureBuilders", "", "Lorg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator$ClosureBuilder;", "closureBuilder", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getClosureBuilder", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)Lorg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator$ClosureBuilder;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Lorg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator$ClosureBuilder;", "closureBuilderOrNull", "getClosureBuilderOrNull", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)Lorg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator$ClosureBuilder;", "parentClosureBuilder", "getParentClosureBuilder", "collectPotentiallyCapturedTypeParameters", "", "getClassClosure", "Lorg/jetbrains/kotlin/backend/common/lower/Closure;", "getClosure", "getFunctionClosure", "includeInParent", "builder", "ClosureBuilder", "ClosureCollectorVisitor", "ir.backend.common"})
public final class ClosureAnnotator {
    @NotNull
    private final Map<IrDeclaration, ClosureBuilder> closureBuilders;

    public ClosureAnnotator(@NotNull IrElement irElement, @NotNull IrDeclaration declaration2) {
        Intrinsics.checkNotNullParameter(irElement, "irElement");
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        this.closureBuilders = new LinkedHashMap();
        ClosureBuilder closureBuilder = this.getClosureBuilderOrNull(declaration2);
        irElement.accept(new ClosureCollectorVisitor(), closureBuilder == null ? this.getParentClosureBuilder(declaration2) : closureBuilder);
    }

    @NotNull
    public final Closure getFunctionClosure(@NotNull IrFunction declaration2) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        return this.getClosure(declaration2);
    }

    @NotNull
    public final Closure getClassClosure(@NotNull IrClass declaration2) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        return this.getClosure(declaration2);
    }

    private final Closure getClosure(IrDeclaration declaration2) {
        Map<IrDeclaration, ClosureBuilder> map = this.closureBuilders;
        ClosureBuilder closureBuilder = map.get(declaration2);
        if (closureBuilder == null) {
            boolean bl = false;
            throw new AssertionError((Object)("No closure builder for passed declaration " + IrUtilsKt.ir2string(declaration2) + '.'));
        }
        return closureBuilder.buildClosure();
    }

    private final void includeInParent(ClosureBuilder builder2) {
        ClosureBuilder parentBuilder = this.getParentClosureBuilder(builder2.getOwner());
        if (parentBuilder != null && !(parentBuilder.getOwner() instanceof IrFunction)) {
            parentBuilder.include(builder2);
        }
    }

    private final ClosureBuilder getClosureBuilder(IrClass $this$closureBuilder) {
        ClosureBuilder closureBuilder;
        Map<IrDeclaration, ClosureBuilder> $this$getOrPut$iv = this.closureBuilders;
        boolean $i$f$getOrPut = false;
        ClosureBuilder value$iv = $this$getOrPut$iv.get($this$closureBuilder);
        if (value$iv == null) {
            Object v0;
            ClosureBuilder closureBuilder2;
            block6: {
                boolean bl = false;
                closureBuilder2 = new ClosureBuilder($this$closureBuilder);
                this.collectPotentiallyCapturedTypeParameters(closureBuilder2);
                closureBuilder2.declareVariable($this$closureBuilder.getThisReceiver());
                if ($this$closureBuilder.isInner()) {
                    closureBuilder2.declareVariable(((IrClass)$this$closureBuilder.getParent()).getThisReceiver());
                    this.includeInParent(closureBuilder2);
                }
                Iterable $this$firstOrNull$iv = $this$closureBuilder.getDeclarations();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    IrDeclaration it = (IrDeclaration)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof IrConstructor && ((IrConstructor)it).isPrimary())) continue;
                    v0 = element$iv;
                    break block6;
                }
                v0 = null;
            }
            IrDeclaration irDeclaration2 = v0;
            if (irDeclaration2 != null) {
                IrDeclaration irDeclaration3;
                IrDeclaration it = irDeclaration3 = irDeclaration2;
                boolean bl = false;
                IrConstructor constructor2 = (IrConstructor)it;
                Iterable $this$forEach$iv = constructor2.getValueParameters();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    IrValueParameter v = (IrValueParameter)element$iv;
                    boolean bl3 = false;
                    closureBuilder2.declareVariable(v);
                }
            }
            ClosureBuilder answer$iv = closureBuilder2;
            $this$getOrPut$iv.put($this$closureBuilder, answer$iv);
            closureBuilder = answer$iv;
        } else {
            closureBuilder = value$iv;
        }
        return closureBuilder;
    }

    private final ClosureBuilder getClosureBuilder(IrFunction $this$closureBuilder) {
        ClosureBuilder closureBuilder;
        Map<IrDeclaration, ClosureBuilder> $this$getOrPut$iv = this.closureBuilders;
        boolean $i$f$getOrPut = false;
        ClosureBuilder value$iv = $this$getOrPut$iv.get($this$closureBuilder);
        if (value$iv == null) {
            boolean bl = false;
            ClosureBuilder closureBuilder2 = new ClosureBuilder($this$closureBuilder);
            this.collectPotentiallyCapturedTypeParameters(closureBuilder2);
            Iterable $this$forEach$iv = $this$closureBuilder.getValueParameters();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IrValueParameter it = (IrValueParameter)element$iv;
                boolean bl2 = false;
                closureBuilder2.declareVariable(it);
            }
            closureBuilder2.declareVariable($this$closureBuilder.getDispatchReceiverParameter());
            closureBuilder2.declareVariable($this$closureBuilder.getExtensionReceiverParameter());
            closureBuilder2.seeType($this$closureBuilder.getReturnType());
            if ($this$closureBuilder instanceof IrConstructor) {
                IrClass constructedClass = (IrClass)$this$closureBuilder.getParent();
                closureBuilder2.declareVariable(constructedClass.getThisReceiver());
                ClosureBuilder classBuilder2 = this.getClosureBuilder(constructedClass);
                closureBuilder2.include(classBuilder2);
            }
            ClosureBuilder answer$iv = closureBuilder2;
            $this$getOrPut$iv.put($this$closureBuilder, answer$iv);
            closureBuilder = answer$iv;
        } else {
            closureBuilder = value$iv;
        }
        return closureBuilder;
    }

    private final void collectPotentiallyCapturedTypeParameters(ClosureBuilder closureBuilder) {
        ClosureBuilder current = this.getParentClosureBuilder(closureBuilder.getOwner());
        while (current != null) {
            IrDeclaration container = current.getOwner();
            if (container instanceof IrTypeParametersContainer) {
                for (IrTypeParameter typeParameter : ((IrTypeParametersContainer)container).getTypeParameters()) {
                    closureBuilder.addPotentiallyCapturedTypeParameter(typeParameter);
                }
            }
            current = this.getParentClosureBuilder(container);
        }
    }

    private final ClosureBuilder getParentClosureBuilder(IrDeclaration $this$parentClosureBuilder) {
        IrDeclarationParent p = $this$parentClosureBuilder.getParent();
        return p instanceof IrClass ? this.getClosureBuilder((IrClass)p) : (p instanceof IrFunction ? this.getClosureBuilder((IrFunction)p) : (p instanceof IrDeclaration ? this.getParentClosureBuilder((IrDeclaration)((Object)p)) : null));
    }

    private final ClosureBuilder getClosureBuilderOrNull(IrDeclaration $this$closureBuilderOrNull) {
        IrDeclaration irDeclaration2 = $this$closureBuilderOrNull;
        return irDeclaration2 instanceof IrClass ? this.getClosureBuilder((IrClass)$this$closureBuilderOrNull) : (irDeclaration2 instanceof IrFunction ? this.getClosureBuilder((IrFunction)$this$closureBuilderOrNull) : null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0007J\u0006\u0010\u0015\u001a\u00020\u000bJ\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00000\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00132\b\u0010\u0019\u001a\u0004\u0018\u00010\rJ\u000e\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u0000J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0007J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\rJ\u000e\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\tJ\b\u0010$\u001a\u00020\u001dH\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator$ClosureBuilder;", "", "owner", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)V", "capturedTypeParameters", "", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParameter;", "capturedValues", "Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;", "closure", "Lorg/jetbrains/kotlin/backend/common/lower/Closure;", "declaredValues", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "includes", "getOwner", "()Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "potentiallyCapturedTypeParameters", "addPotentiallyCapturedTypeParameter", "", "param", "buildClosure", "collectConnectedClosures", "", "declareVariable", "valueDeclaration", "include", "includingBuilder", "isExternal", "", "typeParameter", "seeType", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "seeVariable", "value", "updateFromIncluded", "ir.backend.common"})
    private static final class ClosureBuilder {
        @NotNull
        private final IrDeclaration owner;
        @NotNull
        private final Set<IrValueSymbol> capturedValues;
        @NotNull
        private final Set<IrValueDeclaration> declaredValues;
        @NotNull
        private final Set<ClosureBuilder> includes;
        @NotNull
        private final Set<IrTypeParameter> potentiallyCapturedTypeParameters;
        @NotNull
        private final Set<IrTypeParameter> capturedTypeParameters;
        @Nullable
        private Closure closure;

        public ClosureBuilder(@NotNull IrDeclaration owner) {
            Intrinsics.checkNotNullParameter(owner, "owner");
            this.owner = owner;
            this.capturedValues = new LinkedHashSet();
            this.declaredValues = new LinkedHashSet();
            this.includes = new LinkedHashSet();
            this.potentiallyCapturedTypeParameters = new LinkedHashSet();
            this.capturedTypeParameters = new LinkedHashSet();
        }

        @NotNull
        public final IrDeclaration getOwner() {
            return this.owner;
        }

        @NotNull
        public final Closure buildClosure() {
            boolean changes;
            Closure closure = this.closure;
            if (closure != null) {
                Closure closure2;
                Closure it = closure2 = closure;
                boolean bl = false;
                return it;
            }
            List<ClosureBuilder> work = this.collectConnectedClosures();
            do {
                changes = false;
                for (ClosureBuilder c : work) {
                    if (!c.updateFromIncluded()) continue;
                    changes = true;
                }
            } while (changes);
            for (ClosureBuilder c : work) {
                c.closure = new Closure(CollectionsKt.toList((Iterable)c.capturedValues), CollectionsKt.toList((Iterable)c.capturedTypeParameters));
            }
            Closure closure3 = this.closure;
            if (closure3 == null) {
                throw new AssertionError((Object)Intrinsics.stringPlus("Closure should have been built for ", RenderIrElementKt.render(this.owner)));
            }
            return closure3;
        }

        private final List<ClosureBuilder> collectConnectedClosures() {
            LinkedHashSet<ClosureBuilder> connected = new LinkedHashSet<ClosureBuilder>();
            connected.add(this);
            ClosureBuilder.collectConnectedClosures$collectRec(connected, this);
            return CollectionsKt.asReversed(CollectionsKt.toList((Iterable)connected));
        }

        private final boolean updateFromIncluded() {
            if (this.closure != null) {
                throw new AssertionError((Object)Intrinsics.stringPlus("Closure has already been built for ", RenderIrElementKt.render(this.owner)));
            }
            int capturedValuesBefore = this.capturedValues.size();
            int capturedTypeParametersBefore = this.capturedTypeParameters.size();
            for (ClosureBuilder subClosure : this.includes) {
                Object it;
                Iterable $this$filterTo$iv;
                Iterable iterable = subClosure.capturedValues;
                Collection destination$iv = this.capturedValues;
                boolean $i$f$filterTo = false;
                for (Object element$iv : $this$filterTo$iv) {
                    it = (IrValueSymbol)element$iv;
                    boolean bl = false;
                    if (!this.isExternal(it.getOwner())) continue;
                    destination$iv.add(element$iv);
                }
                $this$filterTo$iv = subClosure.capturedTypeParameters;
                destination$iv = this.capturedTypeParameters;
                $i$f$filterTo = false;
                for (Object element$iv : $this$filterTo$iv) {
                    it = (IrTypeParameter)element$iv;
                    boolean bl = false;
                    if (!this.isExternal((IrTypeParameter)it)) continue;
                    destination$iv.add(element$iv);
                }
            }
            return this.capturedValues.size() != capturedValuesBefore || this.capturedTypeParameters.size() != capturedTypeParametersBefore;
        }

        public final void include(@NotNull ClosureBuilder includingBuilder) {
            Intrinsics.checkNotNullParameter(includingBuilder, "includingBuilder");
            this.includes.add(includingBuilder);
        }

        public final void declareVariable(@Nullable IrValueDeclaration valueDeclaration) {
            if (valueDeclaration != null) {
                this.declaredValues.add(valueDeclaration);
                this.seeType(valueDeclaration.getType());
            }
        }

        public final void seeVariable(@NotNull IrValueSymbol value2) {
            Intrinsics.checkNotNullParameter(value2, "value");
            if (this.isExternal(value2.getOwner())) {
                this.capturedValues.add(value2);
            }
        }

        public final boolean isExternal(@NotNull IrValueDeclaration valueDeclaration) {
            Intrinsics.checkNotNullParameter(valueDeclaration, "valueDeclaration");
            return !this.declaredValues.contains(valueDeclaration);
        }

        public final boolean isExternal(@NotNull IrTypeParameter typeParameter) {
            Intrinsics.checkNotNullParameter(typeParameter, "typeParameter");
            return this.potentiallyCapturedTypeParameters.contains(typeParameter);
        }

        public final void addPotentiallyCapturedTypeParameter(@NotNull IrTypeParameter param) {
            Intrinsics.checkNotNullParameter(param, "param");
            this.potentiallyCapturedTypeParameters.add(param);
        }

        public final void seeType(@NotNull IrType type2) {
            Object object;
            boolean $i$f$forEach;
            Iterable $this$forEach$iv;
            Intrinsics.checkNotNullParameter(type2, "type");
            if (!(type2 instanceof IrSimpleType)) {
                return;
            }
            IrClassifierSymbol classifier2 = ((IrSimpleType)type2).getClassifier();
            if (classifier2 instanceof IrTypeParameterSymbol && this.isExternal((IrTypeParameter)((IrTypeParameterSymbol)classifier2).getOwner()) && this.capturedTypeParameters.add((IrTypeParameter)((IrTypeParameterSymbol)classifier2).getOwner())) {
                $this$forEach$iv = ((IrTypeParameter)((IrTypeParameterSymbol)classifier2).getOwner()).getSuperTypes();
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    IrType p0 = (IrType)element$iv;
                    boolean bl = false;
                    this.seeType(p0);
                }
            }
            $this$forEach$iv = ((IrSimpleType)type2).getArguments();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IrTypeProjection irTypeProjection;
                IrTypeArgument it = (IrTypeArgument)element$iv;
                boolean bl = false;
                IrTypeProjection irTypeProjection2 = irTypeProjection = it instanceof IrTypeProjection ? (IrTypeProjection)it : null;
                if (irTypeProjection == null) continue;
                IrType irType = irTypeProjection.getType();
                object = irType;
                IrType p0 = object;
                boolean bl2 = false;
                this.seeType(p0);
            }
            IrTypeAbbreviation irTypeAbbreviation = ((IrSimpleType)type2).getAbbreviation();
            if (irTypeAbbreviation != null) {
                List<IrTypeArgument> list2 = irTypeAbbreviation.getArguments();
                Iterable $this$forEach$iv2 = list2;
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    IrType irType;
                    IrType irType2;
                    IrTypeArgument it = (IrTypeArgument)element$iv;
                    boolean bl = false;
                    Object object2 = object = it instanceof IrTypeProjection ? (IrTypeProjection)it : null;
                    if (object == null) continue;
                    IrType p0 = irType2 = (irType = object.getType());
                    boolean bl3 = false;
                    this.seeType(p0);
                }
            }
        }

        private static final void collectConnectedClosures$collectRec(LinkedHashSet<ClosureBuilder> connected, ClosureBuilder current) {
            for (ClosureBuilder included : current.includes) {
                if (included.closure != null || !connected.add(included)) continue;
                ClosureBuilder.collectConnectedClosures$collectRec(connected, included);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0002J\u001a\u0010\t\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00132\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00152\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00172\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00192\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u001b2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u001d2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u001f2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010 \u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020!2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator$ClosureCollectorVisitor;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementVisitor;", "", "Lorg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator$ClosureBuilder;", "(Lorg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator;)V", "processMemberAccess", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "parentClosure", "visitClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "data", "visitElement", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "visitExpression", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "visitFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "visitFunctionAccess", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "visitFunctionExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionExpression;", "visitFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "visitPropertyReference", "Lorg/jetbrains/kotlin/ir/expressions/IrPropertyReference;", "visitTypeParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParameter;", "visitValueAccess", "Lorg/jetbrains/kotlin/ir/expressions/IrValueAccessExpression;", "visitVariable", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "ir.backend.common"})
    private final class ClosureCollectorVisitor
    implements IrElementVisitor<Unit, ClosureBuilder> {
        public ClosureCollectorVisitor() {
            Intrinsics.checkNotNullParameter(ClosureAnnotator.this, "this$0");
        }

        @Override
        public void visitElement(@NotNull IrElement element, @Nullable ClosureBuilder data) {
            Intrinsics.checkNotNullParameter(element, "element");
            element.acceptChildren(this, data);
        }

        @Override
        public void visitClass(@NotNull IrClass declaration2, @Nullable ClosureBuilder data) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            declaration2.acceptChildren(this, ClosureAnnotator.this.getClosureBuilder(declaration2));
        }

        @Override
        public void visitFunction(@NotNull IrFunction declaration2, @Nullable ClosureBuilder data) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            ClosureBuilder closureBuilder = ClosureAnnotator.this.getClosureBuilder(declaration2);
            declaration2.acceptChildren(this, closureBuilder);
            ClosureAnnotator.this.includeInParent(closureBuilder);
        }

        @Override
        public void visitTypeParameter(@NotNull IrTypeParameter declaration2, @Nullable ClosureBuilder data) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            for (IrType superType2 : declaration2.getSuperTypes()) {
                ClosureBuilder closureBuilder = data;
                if (closureBuilder == null) continue;
                closureBuilder.seeType(superType2);
            }
        }

        @Override
        public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable ClosureBuilder data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            ClosureBuilder closureBuilder = data;
            if (closureBuilder != null) {
                closureBuilder.seeVariable(expression2.getSymbol());
            }
            IrElementVisitor.DefaultImpls.visitValueAccess(this, expression2, data);
        }

        @Override
        public void visitVariable(@NotNull IrVariable declaration2, @Nullable ClosureBuilder data) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            ClosureBuilder closureBuilder = data;
            if (closureBuilder != null) {
                closureBuilder.declareVariable(declaration2);
            }
            IrElementVisitor.DefaultImpls.visitVariable(this, declaration2, data);
        }

        @Override
        public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable ClosureBuilder data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitor.DefaultImpls.visitFunctionAccess(this, expression2, data);
            this.processMemberAccess(((IrFunctionSymbol)expression2.getSymbol()).getOwner(), data);
        }

        @Override
        public void visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable ClosureBuilder data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitor.DefaultImpls.visitFunctionReference(this, expression2, data);
            this.processMemberAccess(((IrFunctionSymbol)expression2.getSymbol()).getOwner(), data);
        }

        @Override
        public void visitFunctionExpression(@NotNull IrFunctionExpression expression2, @Nullable ClosureBuilder data) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitor.DefaultImpls.visitFunctionExpression(this, expression2, data);
            this.processMemberAccess(expression2.getFunction(), data);
        }

        @Override
        public void visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable ClosureBuilder data) {
            IrSimpleFunctionSymbol it;
            IrSimpleFunctionSymbol irSimpleFunctionSymbol;
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitor.DefaultImpls.visitPropertyReference(this, expression2, data);
            IrSimpleFunctionSymbol irSimpleFunctionSymbol2 = expression2.getGetter();
            if (irSimpleFunctionSymbol2 != null) {
                it = irSimpleFunctionSymbol = irSimpleFunctionSymbol2;
                boolean bl = false;
                this.processMemberAccess((IrDeclaration)it.getOwner(), data);
            }
            irSimpleFunctionSymbol2 = expression2.getSetter();
            if (irSimpleFunctionSymbol2 != null) {
                it = irSimpleFunctionSymbol = irSimpleFunctionSymbol2;
                boolean bl = false;
                this.processMemberAccess((IrDeclaration)it.getOwner(), data);
            }
        }

        @Override
        public void visitExpression(@NotNull IrExpression expression2, @Nullable ClosureBuilder data) {
            ClosureBuilder typeParameterContainerScopeBuilder;
            ClosureBuilder closureBuilder;
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementVisitor.DefaultImpls.visitExpression(this, expression2, data);
            ClosureBuilder closureBuilder2 = data;
            if (closureBuilder2 == null) {
                closureBuilder = null;
            } else {
                IrConstructor irConstructor2;
                ClosureBuilder closureBuilder3 = closureBuilder2;
                ClosureAnnotator closureAnnotator = ClosureAnnotator.this;
                ClosureBuilder it = closureBuilder3;
                boolean bl = false;
                IrDeclaration irDeclaration2 = it.getOwner();
                IrConstructor irConstructor3 = irConstructor2 = irDeclaration2 instanceof IrConstructor ? (IrConstructor)irDeclaration2 : null;
                closureBuilder = irConstructor2 == null ? it : closureAnnotator.getClosureBuilder(irConstructor2);
            }
            closureBuilder2 = typeParameterContainerScopeBuilder = closureBuilder;
            if (closureBuilder2 != null) {
                closureBuilder2.seeType(expression2.getType());
            }
        }

        private final void processMemberAccess(IrDeclaration declaration2, ClosureBuilder parentClosure) {
            if (AdditionalIrUtilsKt.isLocal(declaration2)) {
                if (declaration2 instanceof IrSimpleFunction && !Intrinsics.areEqual(((IrSimpleFunction)declaration2).getVisibility(), DescriptorVisibilities.LOCAL)) {
                    return;
                }
                ClosureBuilder builder2 = ClosureAnnotator.this.getClosureBuilderOrNull(declaration2);
                ClosureBuilder closureBuilder = builder2;
                if (closureBuilder != null) {
                    ClosureBuilder closureBuilder2;
                    ClosureBuilder it = closureBuilder2 = closureBuilder;
                    boolean bl = false;
                    ClosureBuilder closureBuilder3 = parentClosure;
                    if (closureBuilder3 != null) {
                        closureBuilder3.include(builder2);
                    }
                }
            }
        }

        @Override
        public <T> void visitConst(@NotNull IrConst<T> expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitConst(this, expression2, data);
        }

        @Override
        public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitAnonymousInitializer(this, declaration2, data);
        }

        @Override
        public void visitBlock(@NotNull IrBlock expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitBlock(this, expression2, data);
        }

        @Override
        public void visitBlockBody(@NotNull IrBlockBody body2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitBlockBody(this, body2, data);
        }

        @Override
        public void visitBody(@NotNull IrBody body2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitBody(this, body2, data);
        }

        @Override
        public void visitBranch(@NotNull IrBranch branch, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitBranch(this, branch, data);
        }

        @Override
        public void visitBreak(@NotNull IrBreak jump, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitBreak(this, jump, data);
        }

        @Override
        public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitBreakContinue(this, jump, data);
        }

        @Override
        public void visitCall(@NotNull IrCall expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitCall(this, expression2, data);
        }

        @Override
        public void visitCallableReference(@NotNull IrCallableReference<?> expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitCallableReference(this, expression2, data);
        }

        @Override
        public void visitCatch(@NotNull IrCatch aCatch, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitCatch(this, aCatch, data);
        }

        @Override
        public void visitClassReference(@NotNull IrClassReference expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitClassReference(this, expression2, data);
        }

        @Override
        public void visitComposite(@NotNull IrComposite expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitComposite(this, expression2, data);
        }

        @Override
        public void visitConstructor(@NotNull IrConstructor declaration2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitConstructor(this, declaration2, data);
        }

        @Override
        public void visitConstructorCall(@NotNull IrConstructorCall expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitConstructorCall(this, expression2, data);
        }

        @Override
        public void visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitContainerExpression(this, expression2, data);
        }

        @Override
        public void visitContinue(@NotNull IrContinue jump, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitContinue(this, jump, data);
        }

        @Override
        public void visitDeclaration(@NotNull IrDeclarationBase declaration2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitDeclaration(this, declaration2, data);
        }

        @Override
        public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitDeclarationReference(this, expression2, data);
        }

        @Override
        public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data);
        }

        @Override
        public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitDoWhileLoop(this, loop2, data);
        }

        @Override
        public void visitDynamicExpression(@NotNull IrDynamicExpression expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitDynamicExpression(this, expression2, data);
        }

        @Override
        public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitDynamicMemberExpression(this, expression2, data);
        }

        @Override
        public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data);
        }

        @Override
        public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitElseBranch(this, branch, data);
        }

        @Override
        public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
        }

        @Override
        public void visitEnumEntry(@NotNull IrEnumEntry declaration2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitEnumEntry(this, declaration2, data);
        }

        @Override
        public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitErrorCallExpression(this, expression2, data);
        }

        @Override
        public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitErrorDeclaration(this, declaration2, data);
        }

        @Override
        public void visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitErrorExpression(this, expression2, data);
        }

        @Override
        public void visitExpressionBody(@NotNull IrExpressionBody body2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitExpressionBody(this, body2, data);
        }

        @Override
        public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitExternalPackageFragment(this, declaration2, data);
        }

        @Override
        public void visitField(@NotNull IrField declaration2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitField(this, declaration2, data);
        }

        @Override
        public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitFieldAccess(this, expression2, data);
        }

        @Override
        public void visitFile(@NotNull IrFile declaration2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitFile(this, declaration2, data);
        }

        @Override
        public void visitGetClass(@NotNull IrGetClass expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitGetClass(this, expression2, data);
        }

        @Override
        public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitGetEnumValue(this, expression2, data);
        }

        @Override
        public void visitGetField(@NotNull IrGetField expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitGetField(this, expression2, data);
        }

        @Override
        public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitGetObjectValue(this, expression2, data);
        }

        @Override
        public void visitGetValue(@NotNull IrGetValue expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitGetValue(this, expression2, data);
        }

        @Override
        public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitInstanceInitializerCall(this, expression2, data);
        }

        @Override
        public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitLocalDelegatedProperty(this, declaration2, data);
        }

        @Override
        public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
        }

        @Override
        public void visitLoop(@NotNull IrLoop loop2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitLoop(this, loop2, data);
        }

        @Override
        public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitMemberAccess(this, expression2, data);
        }

        @Override
        public void visitModuleFragment(@NotNull IrModuleFragment declaration2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitModuleFragment(this, declaration2, data);
        }

        @Override
        public void visitPackageFragment(@NotNull IrPackageFragment declaration2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitPackageFragment(this, declaration2, data);
        }

        @Override
        public void visitProperty(@NotNull IrProperty declaration2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitProperty(this, declaration2, data);
        }

        @Override
        public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitRawFunctionReference(this, expression2, data);
        }

        @Override
        public void visitReturn(@NotNull IrReturn expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitReturn(this, expression2, data);
        }

        @Override
        public void visitScript(@NotNull IrScript declaration2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitScript(this, declaration2, data);
        }

        @Override
        public void visitSetField(@NotNull IrSetField expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitSetField(this, expression2, data);
        }

        @Override
        public void visitSetValue(@NotNull IrSetValue expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitSetValue(this, expression2, data);
        }

        @Override
        public void visitSimpleFunction(@NotNull IrSimpleFunction declaration2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitSimpleFunction(this, declaration2, data);
        }

        @Override
        public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitSingletonReference(this, expression2, data);
        }

        @Override
        public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitSpreadElement(this, spread, data);
        }

        @Override
        public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitStringConcatenation(this, expression2, data);
        }

        @Override
        public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitSuspendableExpression(this, expression2, data);
        }

        @Override
        public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitSuspensionPoint(this, expression2, data);
        }

        @Override
        public void visitSyntheticBody(@NotNull IrSyntheticBody body2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitSyntheticBody(this, body2, data);
        }

        @Override
        public void visitThrow(@NotNull IrThrow expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitThrow(this, expression2, data);
        }

        @Override
        public void visitTry(@NotNull IrTry aTry, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitTry(this, aTry, data);
        }

        @Override
        public void visitTypeAlias(@NotNull IrTypeAlias declaration2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitTypeAlias(this, declaration2, data);
        }

        @Override
        public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitTypeOperator(this, expression2, data);
        }

        @Override
        public void visitValueParameter(@NotNull IrValueParameter declaration2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitValueParameter(this, declaration2, data);
        }

        @Override
        public void visitVararg(@NotNull IrVararg expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitVararg(this, expression2, data);
        }

        @Override
        public void visitWhen(@NotNull IrWhen expression2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitWhen(this, expression2, data);
        }

        @Override
        public void visitWhileLoop(@NotNull IrWhileLoop loop2, @Nullable ClosureBuilder data) {
            IrElementVisitor.DefaultImpls.visitWhileLoop(this, loop2, data);
        }
    }
}

