/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.collectors.AbstractDiagnosticCollector;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.symbols.AbstractFirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.CompilerConeAttributesKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirSupertypesChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirSupertypesChecker
extends FirDeclarationChecker<FirClass<?>> {
    @NotNull
    public static final FirSupertypesChecker INSTANCE = new FirSupertypesChecker();

    private FirSupertypesChecker() {
    }

    @Override
    public void check(@NotNull FirClass<?> declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        boolean isInterface = declaration2.getClassKind() == ClassKind.INTERFACE;
        boolean nullableSupertypeReported = false;
        boolean extensionFunctionSupertypeReported = false;
        boolean interfaceWithSuperclassReported = false;
        interfaceWithSuperclassReported = !isInterface;
        boolean finalSupertypeReported = false;
        boolean singletonInSupertypeReported = false;
        boolean classAppeared = false;
        boolean bl = false;
        HashSet<FirRegularClassSymbol> superClassSymbols = new HashSet<FirRegularClassSymbol>();
        for (FirTypeRef superTypeRef : declaration2.getSuperTypeRefs()) {
            boolean bl2;
            CheckerContext it;
            List<String> arguments$iv;
            boolean bl3;
            FirAnnotationContainer it$iv;
            boolean bl4;
            boolean bl5;
            FirAnnotationContainer firAnnotationContainer;
            FirAnnotationContainer firAnnotationContainer2;
            boolean $i$f$withSuppressedDiagnostics;
            FirAnnotationCall annotation2;
            Object isObject2;
            boolean $i$f$getModality;
            FirRegularClass $this$modality$iv;
            ConeClassLikeLookupTag superTypeFir;
            ConeClassLikeLookupTag lookupTag;
            FirClassLikeSymbol<?> firClassLikeSymbol;
            boolean $i$f$safeAs;
            ConeKotlinType $this$safeAs$iv;
            ConeKotlinType coneType;
            boolean bl6;
            CheckerContext it2;
            List<String> list2;
            FirAnnotationContainer firAnnotationContainer3;
            boolean $i$f$withSuppressedDiagnostics2 = false;
            FirAnnotationContainer firAnnotationContainer4 = firAnnotationContainer3 = (FirElement)superTypeRef instanceof FirAnnotationContainer ? (FirAnnotationContainer)((FirElement)superTypeRef) : null;
            if (firAnnotationContainer3 == null) {
                list2 = null;
            } else {
                FirAnnotationContainer firAnnotationContainer5 = firAnnotationContainer3;
                boolean bl7 = false;
                boolean bl8 = false;
                FirAnnotationContainer it$iv2 = firAnnotationContainer5;
                boolean bl9 = false;
                list2 = AbstractDiagnosticCollector.Companion.getDiagnosticsSuppressedForContainer(it$iv2);
            }
            List<String> arguments$iv2 = list2;
            if (arguments$iv2 != null) {
                ConeClassLikeLookupTag coneClassLikeLookupTag;
                it2 = context2.addSuppressedDiagnostics((Collection<String>)arguments$iv2, arguments$iv2.contains("infos"), arguments$iv2.contains("warnings"), arguments$iv2.contains("errors"));
                bl6 = false;
                coneType = FirTypeUtilsKt.getConeType(superTypeRef);
                if (!nullableSupertypeReported && coneType.getNullability() == ConeNullability.NULLABLE) {
                    DiagnosticReporterKt.reportOn$default(reporter, superTypeRef.getSource(), FirErrors.INSTANCE.getNULLABLE_SUPERTYPE(), context2, null, 8, null);
                    nullableSupertypeReported = true;
                }
                if (!extensionFunctionSupertypeReported && CompilerConeAttributesKt.isExtensionFunctionType(coneType)) {
                    DiagnosticReporterKt.reportOn$default(reporter, superTypeRef.getSource(), FirErrors.INSTANCE.getSUPERTYPE_IS_EXTENSION_FUNCTION_TYPE(), context2, null, 8, null);
                    extensionFunctionSupertypeReported = true;
                }
                $this$safeAs$iv = coneType;
                $i$f$safeAs = false;
                ConeKotlinType coneKotlinType = $this$safeAs$iv;
                if (!(coneKotlinType instanceof ConeClassLikeType)) {
                    coneKotlinType = null;
                }
                if ((coneClassLikeLookupTag = (firClassLikeSymbol = (ConeClassLikeType)coneKotlinType) == null ? null : ((ConeClassLikeType)((Object)firClassLikeSymbol)).getLookupTag()) == null) continue;
                lookupTag = coneClassLikeLookupTag;
                firClassLikeSymbol = LookupTagUtilsKt.toSymbol(lookupTag, context2.getSession());
                ConeClassLikeLookupTag coneClassLikeLookupTag2 = superTypeFir = firClassLikeSymbol == null ? null : (FirClassLikeDeclaration)firClassLikeSymbol.getFir();
                if (superTypeFir instanceof FirRegularClass) {
                    boolean isObject2;
                    if (!superClassSymbols.add(((FirRegularClass)((Object)superTypeFir)).getSymbol())) {
                        DiagnosticReporterKt.reportOn$default(reporter, superTypeRef.getSource(), FirErrors.INSTANCE.getSUPERTYPE_APPEARS_TWICE(), context2, null, 8, null);
                    }
                    if (((FirRegularClass)((Object)superTypeFir)).getClassKind() != ClassKind.INTERFACE) {
                        if (classAppeared) {
                            DiagnosticReporterKt.reportOn$default(reporter, superTypeRef.getSource(), FirErrors.INSTANCE.getMANY_CLASSES_IN_SUPERTYPE_LIST(), context2, null, 8, null);
                        } else {
                            classAppeared = true;
                        }
                        if (!interfaceWithSuperclassReported) {
                            DiagnosticReporterKt.reportOn$default(reporter, superTypeRef.getSource(), FirErrors.INSTANCE.getINTERFACE_WITH_SUPERCLASS(), context2, null, 8, null);
                            interfaceWithSuperclassReported = true;
                        }
                    }
                    boolean bl10 = isObject2 = ((FirRegularClass)((Object)superTypeFir)).getClassKind() == ClassKind.OBJECT;
                    if (!finalSupertypeReported && !isObject2) {
                        $this$modality$iv = (FirRegularClass)((Object)superTypeFir);
                        $i$f$getModality = false;
                        if ($this$modality$iv.getStatus().getModality() == Modality.FINAL) {
                            DiagnosticReporterKt.reportOn$default(reporter, superTypeRef.getSource(), FirErrors.INSTANCE.getFINAL_SUPERTYPE(), context2, null, 8, null);
                            finalSupertypeReported = true;
                        }
                    }
                    if (!singletonInSupertypeReported && isObject2) {
                        DiagnosticReporterKt.reportOn$default(reporter, superTypeRef.getSource(), FirErrors.INSTANCE.getSINGLETON_IN_SUPERTYPE(), context2, null, 8, null);
                        singletonInSupertypeReported = true;
                    }
                }
                isObject2 = superTypeRef.getAnnotations().iterator();
                while (isObject2.hasNext()) {
                    List<String> list3;
                    annotation2 = isObject2.next();
                    $i$f$withSuppressedDiagnostics = false;
                    FirAnnotationContainer firAnnotationContainer6 = firAnnotationContainer2 = (FirElement)annotation2 instanceof FirAnnotationContainer ? (FirAnnotationContainer)((FirElement)annotation2) : null;
                    if (firAnnotationContainer2 == null) {
                        list3 = null;
                    } else {
                        firAnnotationContainer = firAnnotationContainer2;
                        bl5 = false;
                        bl4 = false;
                        it$iv = firAnnotationContainer;
                        bl3 = false;
                        list3 = AbstractDiagnosticCollector.Companion.getDiagnosticsSuppressedForContainer(it$iv);
                    }
                    arguments$iv = list3;
                    if (arguments$iv != null) {
                        it = context2.addSuppressedDiagnostics((Collection<String>)arguments$iv, arguments$iv.contains("infos"), arguments$iv.contains("warnings"), arguments$iv.contains("errors"));
                        bl2 = false;
                        if (annotation2.getUseSiteTarget() == null) continue;
                        DiagnosticReporterKt.reportOn$default(reporter, annotation2.getSource(), FirErrors.INSTANCE.getANNOTATION_ON_SUPERCLASS(), context2, null, 8, null);
                        continue;
                    }
                    it = context2;
                    bl2 = false;
                    if (annotation2.getUseSiteTarget() == null) continue;
                    DiagnosticReporterKt.reportOn$default(reporter, annotation2.getSource(), FirErrors.INSTANCE.getANNOTATION_ON_SUPERCLASS(), context2, null, 8, null);
                }
                continue;
            }
            it2 = context2;
            bl6 = false;
            coneType = FirTypeUtilsKt.getConeType(superTypeRef);
            if (!nullableSupertypeReported && coneType.getNullability() == ConeNullability.NULLABLE) {
                DiagnosticReporterKt.reportOn$default(reporter, superTypeRef.getSource(), FirErrors.INSTANCE.getNULLABLE_SUPERTYPE(), context2, null, 8, null);
                nullableSupertypeReported = true;
            }
            if (!extensionFunctionSupertypeReported && CompilerConeAttributesKt.isExtensionFunctionType(coneType)) {
                DiagnosticReporterKt.reportOn$default(reporter, superTypeRef.getSource(), FirErrors.INSTANCE.getSUPERTYPE_IS_EXTENSION_FUNCTION_TYPE(), context2, null, 8, null);
                extensionFunctionSupertypeReported = true;
            }
            $this$safeAs$iv = coneType;
            $i$f$safeAs = false;
            ConeKotlinType coneKotlinType = $this$safeAs$iv;
            if (!(coneKotlinType instanceof ConeClassLikeType)) {
                coneKotlinType = null;
            }
            if ((superTypeFir = (isObject2 = (ConeClassLikeType)coneKotlinType) == null ? null : ((ConeClassLikeType)isObject2).getLookupTag()) == null) continue;
            lookupTag = superTypeFir;
            isObject2 = LookupTagUtilsKt.toSymbol(lookupTag, context2.getSession());
            ConeClassLikeLookupTag coneClassLikeLookupTag = superTypeFir = isObject2 == null ? null : (FirClassLikeDeclaration)((AbstractFirBasedSymbol)isObject2).getFir();
            if (superTypeFir instanceof FirRegularClass) {
                if (!superClassSymbols.add(((FirRegularClass)((Object)superTypeFir)).getSymbol())) {
                    DiagnosticReporterKt.reportOn$default(reporter, superTypeRef.getSource(), FirErrors.INSTANCE.getSUPERTYPE_APPEARS_TWICE(), context2, null, 8, null);
                }
                if (((FirRegularClass)((Object)superTypeFir)).getClassKind() != ClassKind.INTERFACE) {
                    if (classAppeared) {
                        DiagnosticReporterKt.reportOn$default(reporter, superTypeRef.getSource(), FirErrors.INSTANCE.getMANY_CLASSES_IN_SUPERTYPE_LIST(), context2, null, 8, null);
                    } else {
                        classAppeared = true;
                    }
                    if (!interfaceWithSuperclassReported) {
                        DiagnosticReporterKt.reportOn$default(reporter, superTypeRef.getSource(), FirErrors.INSTANCE.getINTERFACE_WITH_SUPERCLASS(), context2, null, 8, null);
                        interfaceWithSuperclassReported = true;
                    }
                }
                boolean bl11 = isObject = ((FirRegularClass)((Object)superTypeFir)).getClassKind() == ClassKind.OBJECT;
                if (!finalSupertypeReported && !isObject) {
                    $this$modality$iv = (FirRegularClass)((Object)superTypeFir);
                    $i$f$getModality = false;
                    if ($this$modality$iv.getStatus().getModality() == Modality.FINAL) {
                        DiagnosticReporterKt.reportOn$default(reporter, superTypeRef.getSource(), FirErrors.INSTANCE.getFINAL_SUPERTYPE(), context2, null, 8, null);
                        finalSupertypeReported = true;
                    }
                }
                if (!singletonInSupertypeReported && isObject) {
                    DiagnosticReporterKt.reportOn$default(reporter, superTypeRef.getSource(), FirErrors.INSTANCE.getSINGLETON_IN_SUPERTYPE(), context2, null, 8, null);
                    singletonInSupertypeReported = true;
                }
            }
            firClassLikeSymbol = superTypeRef.getAnnotations().iterator();
            while (firClassLikeSymbol.hasNext()) {
                List<String> list4;
                annotation2 = (FirAnnotationCall)firClassLikeSymbol.next();
                $i$f$withSuppressedDiagnostics = false;
                FirAnnotationContainer firAnnotationContainer7 = firAnnotationContainer2 = (FirElement)annotation2 instanceof FirAnnotationContainer ? (FirAnnotationContainer)((FirElement)annotation2) : null;
                if (firAnnotationContainer2 == null) {
                    list4 = null;
                } else {
                    firAnnotationContainer = firAnnotationContainer2;
                    bl5 = false;
                    bl4 = false;
                    it$iv = firAnnotationContainer;
                    bl3 = false;
                    list4 = AbstractDiagnosticCollector.Companion.getDiagnosticsSuppressedForContainer(it$iv);
                }
                arguments$iv = list4;
                if (arguments$iv != null) {
                    it = context2.addSuppressedDiagnostics((Collection<String>)arguments$iv, arguments$iv.contains("infos"), arguments$iv.contains("warnings"), arguments$iv.contains("errors"));
                    bl2 = false;
                    if (annotation2.getUseSiteTarget() == null) continue;
                    DiagnosticReporterKt.reportOn$default(reporter, annotation2.getSource(), FirErrors.INSTANCE.getANNOTATION_ON_SUPERCLASS(), context2, null, 8, null);
                    continue;
                }
                it = context2;
                bl2 = false;
                if (annotation2.getUseSiteTarget() == null) continue;
                DiagnosticReporterKt.reportOn$default(reporter, annotation2.getSource(), FirErrors.INSTANCE.getANNOTATION_ON_SUPERCLASS(), context2, null, 8, null);
            }
        }
    }
}

