/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirRenderer;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.SessionUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnosticFactory3;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirCallableMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.transformers.PhaseUtilsKt;
import org.jetbrains.kotlin.fir.symbols.AbstractFirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J$\u0010\u000e\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J0\u0010\u0010\u001a\u00020\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\f\u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00142\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u001a2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u001e\u0010\u001b\u001a\u0004\u0018\u00010\u0002*\u00020\u001c2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExposedVisibilityDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirMemberDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "checkFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "checkMemberReceiver", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "memberDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableMemberDeclaration;", "checkParameterBounds", "checkProperty", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "checkSupertypes", "checkTypeAlias", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "findVisibilityExposure", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "base", "Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;", "checkers"})
public final class FirExposedVisibilityDeclarationChecker
extends FirDeclarationChecker<FirMemberDeclaration> {
    @NotNull
    public static final FirExposedVisibilityDeclarationChecker INSTANCE = new FirExposedVisibilityDeclarationChecker();

    private FirExposedVisibilityDeclarationChecker() {
    }

    @Override
    public void check(@NotNull FirMemberDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        FirMemberDeclaration firMemberDeclaration = declaration2;
        if (firMemberDeclaration instanceof FirTypeAlias) {
            this.checkTypeAlias((FirTypeAlias)declaration2, reporter, context2);
        } else if (firMemberDeclaration instanceof FirProperty) {
            this.checkProperty((FirProperty)declaration2, reporter, context2);
        } else if (firMemberDeclaration instanceof FirFunction) {
            this.checkFunction((FirFunction)((Object)declaration2), reporter, context2);
        } else if (firMemberDeclaration instanceof FirRegularClass) {
            this.checkClass((FirRegularClass)declaration2, reporter, context2);
        }
    }

    private final void checkClass(FirRegularClass declaration2, DiagnosticReporter reporter, CheckerContext context2) {
        this.checkSupertypes(declaration2, reporter, context2);
        this.checkParameterBounds(declaration2, reporter, context2);
    }

    private final void checkSupertypes(FirRegularClass declaration2, DiagnosticReporter reporter, CheckerContext context2) {
        EffectiveVisibility effectiveVisibility;
        FirMemberDeclaration $this$effectiveVisibility$iv = declaration2;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        Object object = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        EffectiveVisibility effectiveVisibility2 = effectiveVisibility = object == null ? null : object.getEffectiveVisibility();
        if (effectiveVisibility == null) {
            object = "Effective visibility for " + FirRendererKt.render($this$effectiveVisibility$iv, FirRenderer.RenderMode.Companion.getNoBodies()) + " must be resolved";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }
        EffectiveVisibility classVisibility = effectiveVisibility;
        if (Intrinsics.areEqual(classVisibility, EffectiveVisibility.Local.INSTANCE)) {
            return;
        }
        List<FirTypeRef> supertypes2 = declaration2.getSuperTypeRefs();
        boolean isInterface = declaration2.getClassKind() == ClassKind.INTERFACE;
        for (FirTypeRef supertypeRef : supertypes2) {
            EffectiveVisibility effectiveVisibility3;
            FirMemberDeclaration restricting;
            FirPureAbstractElement clazz;
            boolean superIsInterface;
            ConeClassLikeType supertype2;
            ConeClassLikeType coneClassLikeType;
            FirPureAbstractElement $this$coneTypeSafe$iv = supertypeRef;
            boolean $i$f$coneTypeSafe = false;
            boolean bl = false;
            Object object2 = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
            ConeKotlinType coneKotlinType = object2 == null ? null : ((FirResolvedTypeRef)object2).getType();
            if (!(coneKotlinType instanceof ConeClassLikeType)) {
                coneKotlinType = null;
            }
            if ((coneClassLikeType = (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType))) == null || ($this$coneTypeSafe$iv = FirHelpersKt.toRegularClass(supertype2 = coneClassLikeType, context2.getSession())) == null || (superIsInterface = ((FirRegularClass)(clazz = $this$coneTypeSafe$iv)).getClassKind() == ClassKind.INTERFACE) != isInterface || (restricting = this.findVisibilityExposure(supertype2, context2, classVisibility)) == null) continue;
            object2 = supertypeRef.getSource();
            Object object3 = object2 == null ? declaration2.getSource() : object2;
            FirMemberDeclaration $this$effectiveVisibility$iv2 = restricting;
            boolean $i$f$getEffectiveVisibility2 = false;
            FirDeclarationStatus firDeclarationStatus2 = $this$effectiveVisibility$iv2.getStatus();
            Object object4 = firDeclarationStatus2 instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus2 : null;
            EffectiveVisibility effectiveVisibility4 = effectiveVisibility3 = object4 == null ? null : object4.getEffectiveVisibility();
            if (effectiveVisibility3 == null) {
                object4 = "Effective visibility for " + FirRendererKt.render($this$effectiveVisibility$iv2, FirRenderer.RenderMode.Companion.getNoBodies()) + " must be resolved";
                boolean bl2 = false;
                throw (Throwable)new IllegalStateException(object4.toString());
            }
            DiagnosticReporterKt.reportOn$default(reporter, (FirSourceElement)object3, isInterface ? FirErrors.INSTANCE.getEXPOSED_SUPER_INTERFACE() : FirErrors.INSTANCE.getEXPOSED_SUPER_CLASS(), classVisibility, restricting, effectiveVisibility3, context2, null, 64, null);
        }
    }

    private final void checkParameterBounds(FirRegularClass declaration2, DiagnosticReporter reporter, CheckerContext context2) {
        EffectiveVisibility effectiveVisibility;
        FirMemberDeclaration $this$effectiveVisibility$iv = declaration2;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        Object object = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        EffectiveVisibility effectiveVisibility2 = effectiveVisibility = object == null ? null : object.getEffectiveVisibility();
        if (effectiveVisibility == null) {
            object = "Effective visibility for " + FirRendererKt.render($this$effectiveVisibility$iv, FirRenderer.RenderMode.Companion.getNoBodies()) + " must be resolved";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }
        EffectiveVisibility classVisibility = effectiveVisibility;
        if (Intrinsics.areEqual(classVisibility, EffectiveVisibility.Local.INSTANCE)) {
            return;
        }
        for (FirTypeParameterRef parameter : declaration2.getTypeParameters()) {
            for (FirTypeRef bound : ((FirTypeParameter)parameter.getSymbol().getFir()).getBounds()) {
                EffectiveVisibility effectiveVisibility3;
                FirMemberDeclaration restricting = this.findVisibilityExposure(FirTypeUtilsKt.getConeType(bound), context2, classVisibility);
                if (restricting == null) continue;
                FirMemberDeclaration $this$effectiveVisibility$iv2 = restricting;
                boolean $i$f$getEffectiveVisibility2 = false;
                FirDeclarationStatus firDeclarationStatus2 = $this$effectiveVisibility$iv2.getStatus();
                Object object2 = firDeclarationStatus2 instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus2 : null;
                EffectiveVisibility effectiveVisibility4 = effectiveVisibility3 = object2 == null ? null : object2.getEffectiveVisibility();
                if (effectiveVisibility3 == null) {
                    object2 = "Effective visibility for " + FirRendererKt.render($this$effectiveVisibility$iv2, FirRenderer.RenderMode.Companion.getNoBodies()) + " must be resolved";
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(object2.toString());
                }
                DiagnosticReporterKt.reportOn$default(reporter, bound.getSource(), FirErrors.INSTANCE.getEXPOSED_TYPE_PARAMETER_BOUND(), classVisibility, restricting, effectiveVisibility3, context2, null, 64, null);
            }
        }
    }

    private final void checkTypeAlias(FirTypeAlias declaration2, DiagnosticReporter reporter, CheckerContext context2) {
        FirMemberDeclaration restricting;
        Object object;
        ConeClassLikeType expandedType2 = FirDeclarationUtilKt.getExpandedConeType(declaration2);
        FirMemberDeclaration $this$effectiveVisibility$iv = declaration2;
        boolean $i$f$getEffectiveVisibility22 = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        Object object2 = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        Object object3 = object = object2 == null ? null : object2.getEffectiveVisibility();
        if (object == null) {
            object2 = "Effective visibility for " + FirRendererKt.render($this$effectiveVisibility$iv, FirRenderer.RenderMode.Companion.getNoBodies()) + " must be resolved";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(object2.toString());
        }
        Object typeAliasVisibility = object;
        if (Intrinsics.areEqual(typeAliasVisibility, EffectiveVisibility.Local.INSTANCE)) {
            return;
        }
        ConeClassLikeType $i$f$getEffectiveVisibility22 = expandedType2;
        FirMemberDeclaration firMemberDeclaration = restricting = $i$f$getEffectiveVisibility22 == null ? null : this.findVisibilityExposure($i$f$getEffectiveVisibility22, context2, (EffectiveVisibility)typeAliasVisibility);
        if (restricting != null) {
            EffectiveVisibility effectiveVisibility;
            FirMemberDeclaration $this$effectiveVisibility$iv2 = restricting;
            boolean $i$f$getEffectiveVisibility = false;
            object2 = $this$effectiveVisibility$iv2.getStatus();
            object = object2 instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)object2 : null;
            EffectiveVisibility effectiveVisibility2 = effectiveVisibility = object == null ? null : object.getEffectiveVisibility();
            if (effectiveVisibility == null) {
                object = "Effective visibility for " + FirRendererKt.render($this$effectiveVisibility$iv2, FirRenderer.RenderMode.Companion.getNoBodies()) + " must be resolved";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(object.toString());
            }
            DiagnosticReporterKt.reportOn$default(reporter, declaration2.getSource(), FirErrors.INSTANCE.getEXPOSED_TYPEALIAS_EXPANDED_TYPE(), typeAliasVisibility, restricting, effectiveVisibility, context2, null, 64, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkFunction(FirFunction<?> declaration2, DiagnosticReporter reporter, CheckerContext context2) {
        Object object;
        FirMemberDeclaration $this$effectiveVisibility$iv = (FirMemberDeclaration)((Object)declaration2);
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        Object object2 = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        Object object3 = object = object2 == null ? null : object2.getEffectiveVisibility();
        if (object == null) {
            object2 = "Effective visibility for " + FirRendererKt.render($this$effectiveVisibility$iv, FirRenderer.RenderMode.Companion.getNoBodies()) + " must be resolved";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(object2.toString());
        }
        Object functionVisibility = object;
        if (Intrinsics.areEqual(functionVisibility, EffectiveVisibility.Local.INSTANCE)) {
            return;
        }
        if (!(declaration2 instanceof FirConstructor)) {
            FirMemberDeclaration restricting;
            FirTypeRef $this$coneTypeSafe$iv = declaration2.getReturnTypeRef();
            boolean $i$f$coneTypeSafe = false;
            boolean bl = false;
            object = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
            ConeKotlinType coneKotlinType = object == null ? null : ((FirResolvedTypeRef)object).getType();
            if (!(coneKotlinType instanceof ConeKotlinType)) {
                coneKotlinType = null;
            }
            FirMemberDeclaration firMemberDeclaration = restricting = ($i$f$getEffectiveVisibility = coneKotlinType) == null ? null : this.findVisibilityExposure($i$f$getEffectiveVisibility, context2, (EffectiveVisibility)functionVisibility);
            if (restricting != null) {
                EffectiveVisibility effectiveVisibility;
                FirMemberDeclaration $this$effectiveVisibility$iv2 = restricting;
                boolean $i$f$getEffectiveVisibility2 = false;
                object2 = $this$effectiveVisibility$iv2.getStatus();
                object = object2 instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)object2 : null;
                EffectiveVisibility effectiveVisibility2 = effectiveVisibility = object == null ? null : object.getEffectiveVisibility();
                if (effectiveVisibility == null) {
                    object = "Effective visibility for " + FirRendererKt.render($this$effectiveVisibility$iv2, FirRenderer.RenderMode.Companion.getNoBodies()) + " must be resolved";
                    boolean bl2 = false;
                    throw (Throwable)new IllegalStateException(object.toString());
                }
                DiagnosticReporterKt.reportOn$default(reporter, declaration2.getSource(), FirErrors.INSTANCE.getEXPOSED_FUNCTION_RETURN_TYPE(), functionVisibility, restricting, effectiveVisibility, context2, null, 64, null);
            }
        }
        Iterable $this$forEachIndexed$iv = declaration2.getValueParameters();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            EffectiveVisibility effectiveVisibility;
            ConeKotlinType coneKotlinType;
            FirMemberDeclaration restricting;
            void valueParameter2;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            FirValueParameter firValueParameter = (FirValueParameter)item$iv;
            int i = n;
            boolean bl3 = false;
            if (i >= declaration2.getValueParameters().size()) continue;
            FirTypeRef $this$coneTypeSafe$iv = valueParameter2.getReturnTypeRef();
            boolean $i$f$coneTypeSafe = false;
            boolean bl4 = false;
            Object object4 = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
            ConeKotlinType coneKotlinType2 = object4 == null ? null : ((FirResolvedTypeRef)object4).getType();
            if (!(coneKotlinType2 instanceof ConeKotlinType)) {
                coneKotlinType2 = null;
            }
            if ((restricting = (coneKotlinType = coneKotlinType2) == null ? null : INSTANCE.findVisibilityExposure(coneKotlinType, context2, (EffectiveVisibility)functionVisibility)) == null) continue;
            FirMemberDeclaration $this$effectiveVisibility$iv3 = restricting;
            boolean $i$f$getEffectiveVisibility3 = false;
            FirDeclarationStatus firDeclarationStatus2 = $this$effectiveVisibility$iv3.getStatus();
            object4 = firDeclarationStatus2 instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus2 : null;
            EffectiveVisibility effectiveVisibility3 = effectiveVisibility = object4 == null ? null : object4.getEffectiveVisibility();
            if (effectiveVisibility == null) {
                object4 = "Effective visibility for " + FirRendererKt.render($this$effectiveVisibility$iv3, FirRenderer.RenderMode.Companion.getNoBodies()) + " must be resolved";
                boolean bl5 = false;
                throw (Throwable)new IllegalStateException(object4.toString());
            }
            DiagnosticReporterKt.reportOn$default(reporter, valueParameter2.getSource(), FirErrors.INSTANCE.getEXPOSED_PARAMETER_TYPE(), functionVisibility, restricting, effectiveVisibility, context2, null, 64, null);
        }
        this.checkMemberReceiver(declaration2.getReceiverTypeRef(), declaration2 instanceof FirCallableMemberDeclaration ? (FirCallableMemberDeclaration)((Object)declaration2) : null, reporter, context2);
    }

    private final void checkProperty(FirProperty declaration2, DiagnosticReporter reporter, CheckerContext context2) {
        FirMemberDeclaration restricting;
        EffectiveVisibility effectiveVisibility;
        if (declaration2.isLocal()) {
            return;
        }
        FirMemberDeclaration $this$effectiveVisibility$iv = declaration2;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        Object object = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        EffectiveVisibility effectiveVisibility2 = effectiveVisibility = object == null ? null : object.getEffectiveVisibility();
        if (effectiveVisibility == null) {
            object = "Effective visibility for " + FirRendererKt.render($this$effectiveVisibility$iv, FirRenderer.RenderMode.Companion.getNoBodies()) + " must be resolved";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }
        EffectiveVisibility propertyVisibility = effectiveVisibility;
        if (Intrinsics.areEqual(propertyVisibility, EffectiveVisibility.Local.INSTANCE)) {
            return;
        }
        FirTypeRef $this$coneTypeSafe$iv = declaration2.getReturnTypeRef();
        boolean $i$f$coneTypeSafe = false;
        boolean bl = false;
        FirElement firElement = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType = firElement == null ? null : firElement.getType();
        if (!(coneKotlinType instanceof ConeKotlinType)) {
            coneKotlinType = null;
        }
        FirMemberDeclaration firMemberDeclaration = restricting = ($i$f$getEffectiveVisibility = coneKotlinType) == null ? null : this.findVisibilityExposure($i$f$getEffectiveVisibility, context2, propertyVisibility);
        if (restricting != null) {
            EffectiveVisibility effectiveVisibility3;
            FirDiagnosticFactory3<EffectiveVisibility, FirMemberDeclaration, EffectiveVisibility> diagnostic = Intrinsics.areEqual(FirDeclarationUtilKt.getFromPrimaryConstructor(declaration2), true) ? FirErrors.INSTANCE.getEXPOSED_PROPERTY_TYPE_IN_CONSTRUCTOR() : FirErrors.INSTANCE.getEXPOSED_PROPERTY_TYPE();
            FirMemberDeclaration $this$effectiveVisibility$iv2 = restricting;
            boolean $i$f$getEffectiveVisibility2 = false;
            firElement = $this$effectiveVisibility$iv2.getStatus();
            Object object2 = firElement instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firElement : null;
            EffectiveVisibility effectiveVisibility4 = effectiveVisibility3 = object2 == null ? null : object2.getEffectiveVisibility();
            if (effectiveVisibility3 == null) {
                object2 = "Effective visibility for " + FirRendererKt.render($this$effectiveVisibility$iv2, FirRenderer.RenderMode.Companion.getNoBodies()) + " must be resolved";
                boolean bl2 = false;
                throw (Throwable)new IllegalStateException(object2.toString());
            }
            DiagnosticReporterKt.reportOn$default(reporter, declaration2.getSource(), diagnostic, propertyVisibility, restricting, effectiveVisibility3, context2, null, 64, null);
        }
        this.checkMemberReceiver(declaration2.getReceiverTypeRef(), declaration2, reporter, context2);
    }

    private final void checkMemberReceiver(FirTypeRef typeRef, FirCallableMemberDeclaration<?> memberDeclaration, DiagnosticReporter reporter, CheckerContext context2) {
        Object object;
        if (typeRef == null || memberDeclaration == null) {
            return;
        }
        ConeKotlinType receiverParameterType = FirTypeUtilsKt.getConeType(typeRef);
        FirMemberDeclaration $this$effectiveVisibility$iv = memberDeclaration;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        Object object2 = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        Object object3 = object = object2 == null ? null : object2.getEffectiveVisibility();
        if (object == null) {
            object2 = "Effective visibility for " + FirRendererKt.render($this$effectiveVisibility$iv, FirRenderer.RenderMode.Companion.getNoBodies()) + " must be resolved";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(object2.toString());
        }
        Object memberVisibility = object;
        if (Intrinsics.areEqual(memberVisibility, EffectiveVisibility.Local.INSTANCE)) {
            return;
        }
        FirMemberDeclaration restricting = this.findVisibilityExposure(receiverParameterType, context2, (EffectiveVisibility)memberVisibility);
        if (restricting != null) {
            EffectiveVisibility effectiveVisibility;
            FirMemberDeclaration $this$effectiveVisibility$iv2 = restricting;
            boolean $i$f$getEffectiveVisibility2 = false;
            object2 = $this$effectiveVisibility$iv2.getStatus();
            object = object2 instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)object2 : null;
            EffectiveVisibility effectiveVisibility2 = effectiveVisibility = object == null ? null : object.getEffectiveVisibility();
            if (effectiveVisibility == null) {
                object = "Effective visibility for " + FirRendererKt.render($this$effectiveVisibility$iv2, FirRenderer.RenderMode.Companion.getNoBodies()) + " must be resolved";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(object.toString());
            }
            DiagnosticReporterKt.reportOn$default(reporter, typeRef.getSource(), FirErrors.INSTANCE.getEXPOSED_RECEIVER_TYPE(), memberVisibility, restricting, effectiveVisibility, context2, null, 64, null);
        }
    }

    private final FirMemberDeclaration findVisibilityExposure(ConeKotlinType $this$findVisibilityExposure, CheckerContext context2, EffectiveVisibility base) {
        Object firSymbol;
        Object object;
        ConeClassLikeType coneClassLikeType;
        ConeClassLikeType coneClassLikeType2 = coneClassLikeType = $this$findVisibilityExposure instanceof ConeClassLikeType ? (ConeClassLikeType)$this$findVisibilityExposure : null;
        if (coneClassLikeType == null) {
            return null;
        }
        ConeClassLikeType type2 = coneClassLikeType;
        Object object2 = LookupTagUtilsKt.toSymbol(TypeExpansionUtilsKt.fullyExpandedType$default(type2, context2.getSession(), null, 2, null).getLookupTag(), context2.getSession());
        if (object2 == null) {
            object = null;
        } else {
            FirClassLikeSymbol<?> firClassLikeSymbol = object2;
            boolean bl = false;
            boolean bl2 = false;
            firSymbol = firClassLikeSymbol;
            boolean bl3 = false;
            PhaseUtilsKt.ensureResolved((AbstractFirBasedSymbol)firSymbol, FirResolvePhase.Companion.getDECLARATIONS(), context2.getSession());
            object = (FirClassLikeDeclaration)((AbstractFirBasedSymbol)firSymbol).getFir();
        }
        ConeTypeProjection[] coneTypeProjectionArray = object;
        if (coneTypeProjectionArray == null) {
            return null;
        }
        ConeTypeProjection[] fir = coneTypeProjectionArray;
        if (fir instanceof FirMemberDeclaration) {
            FirMemberDeclaration $this$effectiveVisibility$iv = (FirMemberDeclaration)fir;
            boolean $i$f$getEffectiveVisibility = false;
            FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
            Object object3 = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
            Object object4 = firSymbol = object3 == null ? null : object3.getEffectiveVisibility();
            if (firSymbol == null) {
                object3 = "Effective visibility for " + FirRendererKt.render($this$effectiveVisibility$iv, FirRenderer.RenderMode.Companion.getNoBodies()) + " must be resolved";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(object3.toString());
            }
            Object effectiveVisibility = firSymbol;
            object2 = ((EffectiveVisibility)effectiveVisibility).relation(base, SessionUtilsKt.getTypeContext(context2.getSession()));
            int n = WhenMappings.$EnumSwitchMapping$0[((Enum)object2).ordinal()];
            switch (n) {
                case 1: 
                case 2: {
                    return (FirMemberDeclaration)fir;
                }
            }
        }
        coneTypeProjectionArray = type2.getTypeArguments();
        int n = 0;
        int n2 = coneTypeProjectionArray.length;
        while (n < n2) {
            FirMemberDeclaration firMemberDeclaration;
            ConeClassLikeType coneClassLikeType3;
            ConeTypeProjection it = coneTypeProjectionArray[n];
            ++n;
            ConeTypeProjection $this$safeAs$iv = it;
            boolean $i$f$safeAs = false;
            ConeTypeProjection coneTypeProjection = $this$safeAs$iv;
            if (!(coneTypeProjection instanceof ConeClassLikeType)) {
                coneTypeProjection = null;
            }
            if ((coneClassLikeType3 = (ConeClassLikeType)coneTypeProjection) == null || (firMemberDeclaration = this.findVisibilityExposure(coneClassLikeType3, context2, base)) == null) continue;
            FirMemberDeclaration firMemberDeclaration2 = firMemberDeclaration;
            boolean bl = false;
            boolean bl4 = false;
            FirMemberDeclaration it2 = firMemberDeclaration2;
            boolean bl5 = false;
            return it2;
        }
        return null;
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EffectiveVisibility.Permissiveness.values().length];
            nArray[EffectiveVisibility.Permissiveness.LESS.ordinal()] = 1;
            nArray[EffectiveVisibility.Permissiveness.UNKNOWN.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

