/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.editor.impl.IntervalTreeImpl;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.editor.impl.RedBlackTree;
import com.intellij.openapi.util.Getter;
import com.intellij.util.DocumentEventUtil;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RangeMarkerTree<T extends RangeMarkerEx>
extends IntervalTreeImpl<T>
implements PrioritizedDocumentListener {
    RangeMarkerTree(@NotNull Document document) {
        if (document == null) {
            RangeMarkerTree.$$$reportNull$$$0(0);
        }
        document.addDocumentListener(this);
    }

    RangeMarkerTree() {
    }

    @Override
    public int getPriority() {
        return 40;
    }

    @Override
    protected int compareEqualStartIntervals(@NotNull IntervalTreeImpl.IntervalNode<T> i1, @NotNull IntervalTreeImpl.IntervalNode<T> i2) {
        boolean stickyR2;
        boolean greedyR2;
        int o2Length;
        boolean greedyL2;
        if (i1 == null) {
            RangeMarkerTree.$$$reportNull$$$0(1);
        }
        if (i2 == null) {
            RangeMarkerTree.$$$reportNull$$$0(2);
        }
        RMNode o1 = (RMNode)i1;
        RMNode o2 = (RMNode)i2;
        boolean greedyL1 = o1.isGreedyToLeft();
        if (greedyL1 != (greedyL2 = o2.isGreedyToLeft())) {
            return greedyL1 ? -1 : 1;
        }
        int o1Length = o1.intervalEnd() - o1.intervalStart();
        int d = o1Length - (o2Length = o2.intervalEnd() - o2.intervalStart());
        if (d != 0) {
            return d;
        }
        boolean greedyR1 = o1.isGreedyToRight();
        if (greedyR1 != (greedyR2 = o2.isGreedyToRight())) {
            return greedyR1 ? -1 : 1;
        }
        boolean stickyR1 = o1.isStickingToRight();
        if (stickyR1 != (stickyR2 = o2.isStickingToRight())) {
            return stickyR1 ? -1 : 1;
        }
        return 0;
    }

    @Override
    protected RMNode<T> lookupNode(@NotNull T key) {
        if (key == null) {
            RangeMarkerTree.$$$reportNull$$$0(8);
        }
        return ((RangeMarkerImpl)key).myNode;
    }

    @Override
    protected void setNode(@NotNull T key, IntervalTreeImpl.IntervalNode<T> intervalNode) {
        if (key == null) {
            RangeMarkerTree.$$$reportNull$$$0(9);
        }
        ((RangeMarkerImpl)key).myNode = (RMNode)intervalNode;
    }

    @Override
    public void documentChanged(@NotNull DocumentEvent e) {
        if (e == null) {
            RangeMarkerTree.$$$reportNull$$$0(10);
        }
        try {
            this.l.writeLock().lock();
            if (this.size() != 0) {
                this.updateMarkersOnChange(e);
                if (DocumentEventUtil.isMoveInsertion(e)) {
                    this.reTargetMarkersOnChange(e);
                }
                IntervalTreeImpl.IntervalNode root2 = this.getRoot();
                assert (root2 == null || root2.maxEnd + root2.delta <= e.getDocument().getTextLength()) : "Root: " + root2 + "; root.maxEnd=" + root2.maxEnd + "; root.delta=" + root2.delta + "; e.getDocument().getTextLength()=" + e.getDocument().getTextLength() + "; event: " + e;
            }
        }
        finally {
            this.l.writeLock().unlock();
        }
    }

    private void updateMarkersOnChange(@NotNull DocumentEvent e) {
        if (e == null) {
            RangeMarkerTree.$$$reportNull$$$0(11);
        }
        this.checkMax(true);
        this.incModCount();
        SmartList<IntervalTreeImpl.IntervalNode<T>> affected = new SmartList<IntervalTreeImpl.IntervalNode<T>>();
        int start = e.getOffset();
        int oldLength = e.getOldLength();
        int newLength = e.getNewLength();
        this.collectAffectedMarkersAndShiftSubtrees(this.getRoot(), start, start + oldLength, newLength - oldLength, affected);
        this.checkMax(false);
        if (!affected.isEmpty()) {
            this.updateAffectedNodes(e, 0, affected);
        }
    }

    private void updateAffectedNodes(@NotNull DocumentEvent e, int reTargetShift, @NotNull List<IntervalTreeImpl.IntervalNode<T>> affected) {
        if (e == null) {
            RangeMarkerTree.$$$reportNull$$$0(12);
        }
        if (affected == null) {
            RangeMarkerTree.$$$reportNull$$$0(13);
        }
        for (int i = affected.size() - 1; i >= 0; --i) {
            IntervalTreeImpl.IntervalNode<T> node = affected.get(i);
            int startOffset = node.intervalStart();
            int endOffset = node.intervalEnd();
            this.removeNode(node);
            this.checkMax(false);
            node.setParent(null);
            node.setLeft(null);
            node.setRight(null);
            node.setValid(true);
            if (reTargetShift == 0) {
                node.clearDelta();
                assert (node.intervalStart() == startOffset);
                assert (node.intervalEnd() == endOffset);
                continue;
            }
            node.changeDelta(reTargetShift);
            this.pushDelta(node);
        }
        this.checkMax(true);
        for (IntervalTreeImpl.IntervalNode<T> node : affected) {
            RangeMarkerImpl marker = RangeMarkerTree.getNodeMarker(node);
            if (marker == null) continue;
            if (reTargetShift == 0) {
                marker.documentChanged(e);
            } else {
                marker.onReTarget(e);
            }
            if (marker.isValid()) {
                this.findOrInsertWithIntervals(node);
                continue;
            }
            node.setValid(false);
            ((RMNode)node).onRemoved();
        }
        this.checkMax(true);
    }

    @Nullable
    private static <T extends RangeMarkerEx> RangeMarkerImpl getNodeMarker(@NotNull IntervalTreeImpl.IntervalNode<T> node) {
        if (node == null) {
            RangeMarkerTree.$$$reportNull$$$0(14);
        }
        List keys = node.intervals;
        for (int i = keys.size() - 1; i >= 0; --i) {
            Getter key = keys.get(i);
            RangeMarkerImpl marker = (RangeMarkerImpl)key.get();
            if (marker == null) continue;
            if (marker.isValid()) {
                return marker;
            }
            node.removeIntervalInternal(i);
        }
        return null;
    }

    private void findOrInsertWithIntervals(IntervalTreeImpl.IntervalNode<T> node) {
        IntervalTreeImpl.IntervalNode<T> insertedNode = this.findOrInsert(node);
        if (insertedNode != node) {
            insertedNode.addIntervalsFrom(node);
        }
    }

    boolean collectAffectedMarkersAndShiftSubtrees(@Nullable IntervalTreeImpl.IntervalNode<T> root2, int start, int end, int lengthDelta, @NotNull List<? super IntervalTreeImpl.IntervalNode<T>> affected) {
        if (affected == null) {
            RangeMarkerTree.$$$reportNull$$$0(15);
        }
        if (root2 == null) {
            return true;
        }
        boolean norm = this.pushDelta(root2);
        int maxEnd = root2.maxEnd;
        assert (root2.isValid());
        boolean hasAliveKeys = root2.hasAliveKey(false);
        if (!hasAliveKeys) {
            affected.add(root2);
        }
        if (start <= maxEnd) {
            if (end < root2.intervalStart()) {
                int newD = root2.changeDelta(lengthDelta);
                norm &= newD == 0;
                RedBlackTree.Node left = root2.getLeft();
                if (left != null) {
                    int newL = ((IntervalTreeImpl.IntervalNode)left).changeDelta(-lengthDelta);
                    norm &= newL == 0;
                }
                norm &= this.pushDelta(root2);
                norm &= this.collectAffectedMarkersAndShiftSubtrees((IntervalTreeImpl.IntervalNode<T>)left, start, end, lengthDelta, (List<? super IntervalTreeImpl.IntervalNode<T>>)affected);
                this.correctMax(root2, 0);
            } else {
                if (start <= root2.intervalEnd()) {
                    if (hasAliveKeys) {
                        affected.add(root2);
                    }
                    root2.setValid(false);
                }
                norm &= this.collectAffectedMarkersAndShiftSubtrees((IntervalTreeImpl.IntervalNode<T>)root2.getLeft(), start, end, lengthDelta, (List<? super IntervalTreeImpl.IntervalNode<T>>)affected);
                norm &= this.collectAffectedMarkersAndShiftSubtrees((IntervalTreeImpl.IntervalNode<T>)root2.getRight(), start, end, lengthDelta, (List<? super IntervalTreeImpl.IntervalNode<T>>)affected);
                this.correctMax(root2, 0);
            }
        }
        return norm;
    }

    private void reTargetMarkersOnChange(@NotNull DocumentEvent e) {
        if (e == null) {
            RangeMarkerTree.$$$reportNull$$$0(16);
        }
        this.checkMax(true);
        SmartList<IntervalTreeImpl.IntervalNode<T>> affected = new SmartList<IntervalTreeImpl.IntervalNode<T>>();
        int moveStart = e.getMoveOffset();
        int moveEnd = moveStart + e.getNewLength();
        this.collectNodesToRetarget(this.getRoot(), moveStart, moveEnd, affected);
        if (!affected.isEmpty()) {
            this.updateAffectedNodes(e, e.getOffset() - e.getMoveOffset(), affected);
        }
    }

    private void collectNodesToRetarget(@Nullable IntervalTreeImpl.IntervalNode<T> root2, int start, int end, @NotNull List<? super IntervalTreeImpl.IntervalNode<T>> affected) {
        if (affected == null) {
            RangeMarkerTree.$$$reportNull$$$0(17);
        }
        if (root2 == null) {
            return;
        }
        this.pushDelta(root2);
        int maxEnd = root2.maxEnd;
        assert (root2.isValid());
        if (start > maxEnd) {
            return;
        }
        this.collectNodesToRetarget((IntervalTreeImpl.IntervalNode<T>)root2.getLeft(), start, end, (List<? super IntervalTreeImpl.IntervalNode<T>>)affected);
        if (start <= root2.intervalStart() && root2.intervalEnd() <= end) {
            affected.add(root2);
        }
        if (end < root2.intervalStart()) {
            return;
        }
        this.collectNodesToRetarget((IntervalTreeImpl.IntervalNode<T>)root2.getRight(), start, end, (List<? super IntervalTreeImpl.IntervalNode<T>>)affected);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "i1";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "i2";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interval";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/RangeMarkerTree";
                break;
            }
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "affected";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/RangeMarkerTree";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "addInterval";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "compareEqualStartIntervals";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "dispose";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addInterval";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "errMsg";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createNewNode";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lookupNode";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setNode";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "documentChanged";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateMarkersOnChange";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "updateAffectedNodes";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getNodeMarker";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "collectAffectedMarkersAndShiftSubtrees";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "reTargetMarkersOnChange";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "collectNodesToRetarget";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    static class RMNode<T extends RangeMarkerEx>
    extends IntervalTreeImpl.IntervalNode<T> {
        boolean isGreedyToLeft() {
            return this.isFlagSet((byte)8);
        }

        boolean isGreedyToRight() {
            return this.isFlagSet((byte)16);
        }

        boolean isStickingToRight() {
            return this.isFlagSet((byte)32);
        }

        void onRemoved() {
        }

        @Override
        public String toString() {
            return (this.isGreedyToLeft() ? "[" : "(") + this.intervalStart() + "," + this.intervalEnd() + (this.isGreedyToRight() ? "]" : ")");
        }
    }
}

