/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.BuiltInsPackageFragment;
import org.jetbrains.kotlin.config.JvmAnalysisFlags;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassOrPackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.checkers.ClassifierUsageChecker;
import org.jetbrains.kotlin.resolve.checkers.ClassifierUsageCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001c\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/MissingBuiltInDeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "diagnosticFor", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "ClassifierUsage", "frontend.java"})
public final class MissingBuiltInDeclarationChecker
implements CallChecker {
    @NotNull
    public static final MissingBuiltInDeclarationChecker INSTANCE = new MissingBuiltInDeclarationChecker();

    private MissingBuiltInDeclarationChecker() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Diagnostic error;
        Diagnostic diagnostic;
        Object object;
        boolean bl;
        Object object2;
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context2, "context");
        if (context2.getLanguageVersionSettings().getFlag(JvmAnalysisFlags.getSuppressMissingBuiltinsError()).booleanValue()) {
            return;
        }
        Object descriptor2 = resolvedCall2.getResultingDescriptor();
        Diagnostic diagnostic2 = this.diagnosticFor((DeclarationDescriptor)descriptor2, reportOn);
        if (diagnostic2 == null) {
            ClassifierDescriptor classifierDescriptor;
            MissingBuiltInDeclarationChecker missingBuiltInDeclarationChecker = this;
            object2 = descriptor2.getReturnType();
            if (object2 == null) {
                classifierDescriptor = null;
            } else {
                void p0;
                Object object3 = object2;
                bl = false;
                boolean bl2 = false;
                KotlinType kotlinType = object3;
                MissingBuiltInDeclarationChecker missingBuiltInDeclarationChecker2 = missingBuiltInDeclarationChecker;
                boolean bl3 = false;
                boolean bl4 = CallCheckerKt.isComputingDeferredType(this, (KotlinType)p0);
                missingBuiltInDeclarationChecker = missingBuiltInDeclarationChecker2;
                Object object4 = object = !bl4 ? object3 : null;
                classifierDescriptor = object == null ? null : ((object3 = ((KotlinType)object).getConstructor()) == null ? null : object3.getDeclarationDescriptor());
            }
            diagnostic = missingBuiltInDeclarationChecker.diagnosticFor(classifierDescriptor, reportOn);
        } else {
            diagnostic = diagnostic2;
        }
        diagnostic2 = error = diagnostic;
        if (diagnostic2 != null) {
            object2 = diagnostic2;
            object = context2.getTrace();
            boolean bl5 = false;
            bl = false;
            Object p0 = object2;
            boolean bl6 = false;
            object.report((Diagnostic)p0);
        }
    }

    private final Diagnostic diagnosticFor(DeclarationDescriptor descriptor2, PsiElement reportOn) {
        if (descriptor2 == null) {
            return null;
        }
        ClassOrPackageFragmentDescriptor containingClassOrPackage = DescriptorUtils.getParentOfType(descriptor2, ClassOrPackageFragmentDescriptor.class);
        if (containingClassOrPackage instanceof ClassDescriptor) {
            BuiltInsPackageFragment builtInsPackageFragment;
            PackageFragmentDescriptor containingPackage = DescriptorUtils.getParentOfType(descriptor2, PackageFragmentDescriptor.class);
            BuiltInsPackageFragment builtInsPackageFragment2 = builtInsPackageFragment = containingPackage instanceof BuiltInsPackageFragment ? (BuiltInsPackageFragment)containingPackage : null;
            if (builtInsPackageFragment == null ? false : builtInsPackageFragment.isFallback()) {
                return Errors.MISSING_BUILT_IN_DECLARATION.on(reportOn, DescriptorUtilsKt.getFqNameSafe(containingClassOrPackage));
            }
        } else if (containingClassOrPackage instanceof BuiltInsPackageFragment && ((BuiltInsPackageFragment)containingClassOrPackage).isFallback()) {
            return Errors.MISSING_BUILT_IN_DECLARATION.on(reportOn, DescriptorUtilsKt.getFqNameSafe(descriptor2));
        }
        return null;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/MissingBuiltInDeclarationChecker$ClassifierUsage;", "Lorg/jetbrains/kotlin/resolve/checkers/ClassifierUsageChecker;", "()V", "check", "", "targetDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "element", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/ClassifierUsageCheckerContext;", "frontend.java"})
    public static final class ClassifierUsage
    implements ClassifierUsageChecker {
        @NotNull
        public static final ClassifierUsage INSTANCE = new ClassifierUsage();

        private ClassifierUsage() {
        }

        @Override
        public void check(@NotNull ClassifierDescriptor targetDescriptor, @NotNull PsiElement element, @NotNull ClassifierUsageCheckerContext context2) {
            Intrinsics.checkNotNullParameter(targetDescriptor, "targetDescriptor");
            Intrinsics.checkNotNullParameter(element, "element");
            Intrinsics.checkNotNullParameter(context2, "context");
            if (context2.getLanguageVersionSettings().getFlag(JvmAnalysisFlags.getSuppressMissingBuiltinsError()).booleanValue()) {
                return;
            }
            Diagnostic diagnostic = INSTANCE.diagnosticFor(targetDescriptor, element);
            if (diagnostic != null) {
                Diagnostic diagnostic2 = diagnostic;
                BindingTrace bindingTrace = context2.getTrace();
                boolean bl = false;
                boolean bl2 = false;
                Diagnostic p0 = diagnostic2;
                boolean bl3 = false;
                bindingTrace.report(p0);
            }
        }
    }
}

