/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.DefaultNamesKt;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.FirSourceElementKind;
import org.jetbrains.kotlin.fir.FirSymbolOwner;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirCallableMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirIntersectionCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirIntersectionOverrideFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirIntersectionOverridePropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u0006*\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0018\u0010\n\u001a\u00020\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0018\u0010\f\u001a\u00020\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\tR\u0018\u0010\u000e\u001a\u00020\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\t\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirNotImplementedOverrideChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "()V", "matchesDataClassSyntheticMemberSignatures", "", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "getMatchesDataClassSyntheticMemberSignatures", "(Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;)Z", "matchesEqualsSignature", "getMatchesEqualsSignature", "matchesHashCodeSignature", "getMatchesHashCodeSignature", "matchesToStringSignature", "getMatchesToStringSignature", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "isFromInterfaceOrEnum", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "checkers"})
public final class FirNotImplementedOverrideChecker
extends FirDeclarationChecker<FirClass<?>> {
    @NotNull
    public static final FirNotImplementedOverrideChecker INSTANCE = new FirNotImplementedOverrideChecker();

    private FirNotImplementedOverrideChecker() {
    }

    @Override
    public void check(@NotNull FirClass<?> declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Object invisible;
        Object notImplemented;
        Object $this$baseForIntersectionOverride$iv$iv$iv$iv;
        Iterator iterator2;
        ClassKind classKind;
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        FirSourceElement firSourceElement = declaration2.getSource();
        if (firSourceElement == null) {
            return;
        }
        FirSourceElement source = firSourceElement;
        FirSourceElementKind sourceKind = source.getKind();
        if (sourceKind instanceof FirFakeSourceElementKind && !Intrinsics.areEqual(sourceKind, FirFakeSourceElementKind.EnumInitializer.INSTANCE)) {
            return;
        }
        Modality modality = FirHelpersKt.modality(declaration2);
        if (modality == Modality.ABSTRACT || modality == Modality.SEALED) {
            return;
        }
        if (declaration2 instanceof FirRegularClass) {
            FirMemberDeclaration $this$isExpect$iv = (FirMemberDeclaration)((Object)declaration2);
            boolean $i$f$isExpect = false;
            if ($this$isExpect$iv.getStatus().isExpect()) {
                return;
            }
        }
        if ((classKind = declaration2.getClassKind()) == ClassKind.ANNOTATION_CLASS || classKind == ClassKind.ENUM_CLASS) {
            return;
        }
        FirTypeScope classScope = FirHelpersKt.unsubstitutedScope(declaration2, context2);
        boolean bl = false;
        List notImplementedSymbols = new ArrayList();
        boolean bl2 = false;
        List notImplementedIntersectionSymbols = new ArrayList();
        boolean bl3 = false;
        List invisibleSymbols = new ArrayList();
        Object object = declaration2.getSymbol().getClassId().getPackageFqName();
        Intrinsics.checkNotNullExpressionValue(object, "declaration.symbol.classId.packageFqName");
        FqName classPackage = object;
        for (Name name : classScope.getCallableNames()) {
            classScope.processFunctionsByName(name, (Function1<? super FirNamedFunctionSymbol, Unit>)new Function1<FirNamedFunctionSymbol, Unit>(context2, declaration2, notImplementedIntersectionSymbols, invisibleSymbols, notImplementedSymbols, classPackage){
                final /* synthetic */ CheckerContext $context;
                final /* synthetic */ FirClass<?> $declaration;
                final /* synthetic */ List<FirCallableSymbol<?>> $notImplementedIntersectionSymbols;
                final /* synthetic */ List<FirCallableSymbol<?>> $invisibleSymbols;
                final /* synthetic */ List<FirCallableSymbol<?>> $notImplementedSymbols;
                final /* synthetic */ FqName $classPackage;
                {
                    this.$context = $context;
                    this.$declaration = $declaration;
                    this.$notImplementedIntersectionSymbols = $notImplementedIntersectionSymbols;
                    this.$invisibleSymbols = $invisibleSymbols;
                    this.$notImplementedSymbols = $notImplementedSymbols;
                    this.$classPackage = $classPackage;
                    super(1);
                }

                public final void invoke(@NotNull FirNamedFunctionSymbol namedFunctionSymbol) {
                    boolean bl;
                    Collection collection;
                    Intrinsics.checkNotNullParameter(namedFunctionSymbol, "namedFunctionSymbol");
                    FirSimpleFunction simpleFunction = (FirSimpleFunction)namedFunctionSymbol.getFir();
                    if (namedFunctionSymbol instanceof FirIntersectionOverrideFunctionSymbol) {
                        int n;
                        Iterable $this$count$iv = ((FirIntersectionOverrideFunctionSymbol)namedFunctionSymbol).getIntersections();
                        boolean $i$f$count2 = false;
                        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                            n = 0;
                        } else {
                            int count$iv = 0;
                            for (T element$iv : $this$count$iv) {
                                FirCallableSymbol it = (FirCallableSymbol)element$iv;
                                boolean bl2 = false;
                                FirMemberDeclaration $this$modality$iv = (FirCallableMemberDeclaration)it.getFir();
                                boolean $i$f$getModality = false;
                                if (!($this$modality$iv.getStatus().getModality() != Modality.ABSTRACT)) continue;
                                int n2 = ++count$iv;
                                boolean bl3 = false;
                                if (n2 >= 0) continue;
                                CollectionsKt.throwCountOverflow();
                            }
                            n = count$iv;
                        }
                        if (n > 1 && FirHelpersKt.getContainingClass(simpleFunction, this.$context) == this.$declaration) {
                            $this$count$iv = this.$notImplementedIntersectionSymbols;
                            FirNamedFunctionSymbol $i$f$count2 = namedFunctionSymbol;
                            boolean bl4 = false;
                            $this$count$iv.add($i$f$count2);
                            return;
                        }
                    }
                    if (!FirNotImplementedOverrideChecker.access$check$shouldBeImplemented(simpleFunction, this.$context, this.$declaration)) {
                        return;
                    }
                    if (this.$declaration instanceof FirRegularClass) {
                        FirRegularClass $this$isData$iv = (FirRegularClass)this.$declaration;
                        boolean $i$f$isData = false;
                        if ($this$isData$iv.getStatus().isData() && FirNotImplementedOverrideChecker.access$getMatchesDataClassSyntheticMemberSignatures(FirNotImplementedOverrideChecker.INSTANCE, simpleFunction)) {
                            return;
                        }
                    }
                    FirMemberDeclaration $this$isSuspend$iv = simpleFunction;
                    boolean $i$f$isSuspend = false;
                    if ($this$isSuspend$iv.getStatus().isSuspend()) {
                        return;
                    }
                    if (FirNotImplementedOverrideChecker.access$check$isInvisible(simpleFunction, this.$classPackage, this.$declaration)) {
                        collection = this.$invisibleSymbols;
                        bl = false;
                        collection.add(namedFunctionSymbol);
                    } else {
                        collection = this.$notImplementedSymbols;
                        bl = false;
                        collection.add(namedFunctionSymbol);
                    }
                }
            });
            classScope.processPropertiesByName(name, new Function1<FirVariableSymbol<?>, Unit>(context2, declaration2, notImplementedIntersectionSymbols, invisibleSymbols, notImplementedSymbols, classPackage){
                final /* synthetic */ CheckerContext $context;
                final /* synthetic */ FirClass<?> $declaration;
                final /* synthetic */ List<FirCallableSymbol<?>> $notImplementedIntersectionSymbols;
                final /* synthetic */ List<FirCallableSymbol<?>> $invisibleSymbols;
                final /* synthetic */ List<FirCallableSymbol<?>> $notImplementedSymbols;
                final /* synthetic */ FqName $classPackage;
                {
                    this.$context = $context;
                    this.$declaration = $declaration;
                    this.$notImplementedIntersectionSymbols = $notImplementedIntersectionSymbols;
                    this.$invisibleSymbols = $invisibleSymbols;
                    this.$notImplementedSymbols = $notImplementedSymbols;
                    this.$classPackage = $classPackage;
                    super(1);
                }

                public final void invoke(@NotNull FirVariableSymbol<?> propertySymbol) {
                    Object object;
                    Intrinsics.checkNotNullParameter(propertySymbol, "propertySymbol");
                    E e = propertySymbol.getFir();
                    Object object2 = object = e instanceof FirProperty ? (FirProperty)e : null;
                    if (object == null) {
                        return;
                    }
                    FirProperty property2 = object;
                    if (propertySymbol instanceof FirIntersectionOverridePropertySymbol) {
                        int n;
                        Iterable $this$count$iv = ((FirIntersectionOverridePropertySymbol)propertySymbol).getIntersections();
                        boolean $i$f$count = false;
                        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                            n = 0;
                        } else {
                            int count$iv = 0;
                            for (T element$iv : $this$count$iv) {
                                FirCallableSymbol it = (FirCallableSymbol)element$iv;
                                boolean bl = false;
                                FirMemberDeclaration $this$modality$iv = (FirCallableMemberDeclaration)it.getFir();
                                boolean $i$f$getModality = false;
                                if (!($this$modality$iv.getStatus().getModality() != Modality.ABSTRACT)) continue;
                                int n2 = ++count$iv;
                                boolean bl2 = false;
                                if (n2 >= 0) continue;
                                CollectionsKt.throwCountOverflow();
                            }
                            n = count$iv;
                        }
                        if (n > 1 && FirHelpersKt.getContainingClass(property2, this.$context) == this.$declaration) {
                            object = this.$notImplementedIntersectionSymbols;
                            FirVariableSymbol<?> firVariableSymbol = propertySymbol;
                            boolean bl = false;
                            object.add(firVariableSymbol);
                            return;
                        }
                    }
                    if (!FirNotImplementedOverrideChecker.access$check$shouldBeImplemented(property2, this.$context, this.$declaration)) {
                        return;
                    }
                    if (FirNotImplementedOverrideChecker.access$check$isInvisible(property2, this.$classPackage, this.$declaration)) {
                        object = this.$invisibleSymbols;
                        boolean bl = false;
                        object.add(propertySymbol);
                    } else {
                        object = this.$notImplementedSymbols;
                        boolean bl = false;
                        object.add(propertySymbol);
                    }
                }
            });
        }
        object = notImplementedSymbols;
        boolean name = false;
        if (!object.isEmpty()) {
            FirCallableSymbol $this$unwrapFakeOverrides$iv = (FirCallableSymbol)CollectionsKt.first(notImplementedSymbols);
            boolean $i$f$unwrapFakeOverrides = false;
            FirCallableDeclaration $this$unwrapFakeOverrides$iv$iv = (FirCallableDeclaration)$this$unwrapFakeOverrides$iv.getFir();
            boolean $i$f$unwrapFakeOverrides2 = false;
            FirCallableDeclaration current$iv$iv = $this$unwrapFakeOverrides$iv$iv;
            while (true) {
                FirCallableDeclaration next$iv$iv;
                FirCallableDeclaration firCallableDeclaration;
                FirCallableDeclaration firCallableDeclaration2;
                FirCallableDeclaration $this$originalIfFakeOverride$iv$iv$iv = current$iv$iv;
                boolean $i$f$originalIfFakeOverride = false;
                FirCallableDeclaration $this$originalForSubstitutionOverride$iv$iv$iv$iv = $this$originalIfFakeOverride$iv$iv$iv;
                boolean $i$f$getOriginalForSubstitutionOverride = false;
                Iterator iterator3 = iterator2 = ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv$iv$iv) ? ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv$iv$iv) : null;
                if (iterator2 == null) {
                    $this$baseForIntersectionOverride$iv$iv$iv$iv = $this$originalIfFakeOverride$iv$iv$iv;
                    boolean $i$f$getBaseForIntersectionOverride = false;
                    firCallableDeclaration2 = ClassMembersKt.isIntersectionOverride($this$baseForIntersectionOverride$iv$iv$iv$iv) ? ClassMembersKt.getOriginalForIntersectionOverrideAttr($this$baseForIntersectionOverride$iv$iv$iv$iv) : null;
                } else {
                    firCallableDeclaration2 = firCallableDeclaration = iterator2;
                }
                if (firCallableDeclaration == null) break;
                current$iv$iv = next$iv$iv = firCallableDeclaration;
            }
            FirCallableSymbol firCallableSymbol = current$iv$iv.getSymbol();
            if (firCallableSymbol == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol<*>");
            }
            notImplemented = (FirCallableDeclaration)firCallableSymbol.getFir();
            if (this.isFromInterfaceOrEnum((FirCallableDeclaration<?>)notImplemented, context2)) {
                DiagnosticReporterKt.reportOn(reporter, source, FirErrors.INSTANCE.getABSTRACT_MEMBER_NOT_IMPLEMENTED(), declaration2, notImplemented, context2);
            } else {
                DiagnosticReporterKt.reportOn(reporter, source, FirErrors.INSTANCE.getABSTRACT_CLASS_MEMBER_NOT_IMPLEMENTED(), declaration2, notImplemented, context2);
            }
        }
        notImplemented = invisibleSymbols;
        boolean $this$unwrapFakeOverrides$iv = false;
        if (!notImplemented.isEmpty()) {
            invisible = (FirCallableDeclaration)((FirCallableSymbol)CollectionsKt.first(invisibleSymbols)).getFir();
            if (FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession()).supportsFeature(LanguageFeature.ProhibitInvisibleAbstractMethodsInSuperclasses)) {
                DiagnosticReporterKt.reportOn(reporter, source, FirErrors.INSTANCE.getINVISIBLE_ABSTRACT_MEMBER_FROM_SUPER(), declaration2, invisible, context2);
            } else {
                DiagnosticReporterKt.reportOn(reporter, source, FirErrors.INSTANCE.getINVISIBLE_ABSTRACT_MEMBER_FROM_SUPER_WARNING(), declaration2, invisible, context2);
            }
        }
        invisible = notImplementedIntersectionSymbols;
        $this$unwrapFakeOverrides$iv = false;
        if (!invisible.isEmpty()) {
            boolean overridingFinalByDelegationReported = false;
            boolean manyMemberNotImplementedReported = false;
            boolean delegatedHidesSupertypeReported = false;
            for (FirCallableSymbol notImplementedIntersectionSymbol : notImplementedIntersectionSymbols) {
                boolean bl4;
                FirCallableDeclaration notImplementedIntersection;
                block33: {
                    Object v3;
                    FirCallableSymbol<Object> it;
                    Object object2;
                    Collection<FirCallableSymbol<?>> intersections;
                    block30: {
                        notImplementedIntersection = (FirCallableDeclaration)notImplementedIntersectionSymbol.getFir();
                        intersections = ((FirIntersectionCallableSymbol)((Object)notImplementedIntersectionSymbol)).getIntersections();
                        $this$baseForIntersectionOverride$iv$iv$iv$iv = intersections;
                        boolean $i$f$getBaseForIntersectionOverride = false;
                        iterator2 = $this$baseForIntersectionOverride$iv$iv$iv$iv;
                        boolean bl5 = false;
                        Iterator next$iv$iv = iterator2.iterator();
                        while (next$iv$iv.hasNext()) {
                            object2 = next$iv$iv.next();
                            it = (FirCallableSymbol)object2;
                            boolean bl6 = false;
                            FirCallableMemberDeclaration fir = (FirCallableMemberDeclaration)it.getFir();
                            if (!Intrinsics.areEqual(fir.getOrigin(), FirDeclarationOrigin.Delegated.INSTANCE)) continue;
                            v3 = object2;
                            break block30;
                        }
                        v3 = null;
                    }
                    FirCallableSymbol delegatedIntersected = v3;
                    if (delegatedIntersected != null) {
                        Object v5;
                        block32: {
                            FirCallableSymbol<Object> firCallableSymbol;
                            block31: {
                                Iterable $i$f$getBaseForIntersectionOverride = intersections;
                                boolean bl7 = false;
                                Iterable iterable = $i$f$getBaseForIntersectionOverride;
                                boolean next$iv$iv = false;
                                object2 = iterable.iterator();
                                while (object2.hasNext()) {
                                    FirCallableSymbol<Object> it2 = it = object2.next();
                                    boolean bl8 = false;
                                    FirMemberDeclaration $this$modality$iv = (FirCallableMemberDeclaration)it2.getFir();
                                    boolean $i$f$getModality = false;
                                    if (!($this$modality$iv.getStatus().getModality() == Modality.FINAL)) continue;
                                    firCallableSymbol = it;
                                    break block31;
                                }
                                firCallableSymbol = null;
                            }
                            FirCallableSymbol finalIntersected = firCallableSymbol;
                            if (finalIntersected != null) {
                                if (overridingFinalByDelegationReported) continue;
                                DiagnosticReporterKt.reportOn(reporter, source, FirErrors.INSTANCE.getOVERRIDING_FINAL_MEMBER_BY_DELEGATION(), delegatedIntersected.getFir(), finalIntersected.getFir(), context2);
                                overridingFinalByDelegationReported = true;
                                continue;
                            }
                            Iterable $this$firstOrNull$iv = intersections;
                            boolean $i$f$firstOrNull = false;
                            for (Object element$iv : $this$firstOrNull$iv) {
                                it = (FirCallableSymbol)element$iv;
                                boolean bl9 = false;
                                if (!(!Intrinsics.areEqual(((FirCallableMemberDeclaration)it.getFir()).getOrigin(), FirDeclarationOrigin.Delegated.INSTANCE))) continue;
                                v5 = element$iv;
                                break block32;
                            }
                            v5 = null;
                        }
                        FirCallableSymbol notDelegatedIntersected = v5;
                        if (notDelegatedIntersected != null) {
                            if (delegatedHidesSupertypeReported) continue;
                            DiagnosticReporterKt.reportOn(reporter, source, FirErrors.INSTANCE.getDELEGATED_MEMBER_HIDES_SUPERTYPE_OVERRIDE(), delegatedIntersected.getFir(), notDelegatedIntersected.getFir(), context2);
                            delegatedHidesSupertypeReported = true;
                            continue;
                        }
                    }
                    if (manyMemberNotImplementedReported) continue;
                    Iterable $this$any$iv = intersections;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl4 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            FirClassLikeSymbol<?> firClassLikeSymbol;
                            FirCallableSymbol it3 = (FirCallableSymbol)element$iv;
                            boolean bl10 = false;
                            ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClass(it3);
                            FirClassLikeDeclaration firClassLikeDeclaration = coneClassLikeLookupTag == null ? null : ((firClassLikeSymbol = LookupTagUtilsKt.toSymbol(coneClassLikeLookupTag, context2.getSession())) == null ? null : (FirClassLikeDeclaration)firClassLikeSymbol.getFir());
                            FirRegularClass firRegularClass = firClassLikeDeclaration instanceof FirRegularClass ? (FirRegularClass)firClassLikeDeclaration : null;
                            if (!((firRegularClass == null ? null : firRegularClass.getClassKind()) == ClassKind.CLASS)) continue;
                            bl4 = true;
                            break block33;
                        }
                        bl4 = false;
                    }
                }
                if (bl4) {
                    DiagnosticReporterKt.reportOn(reporter, source, FirErrors.INSTANCE.getMANY_IMPL_MEMBER_NOT_IMPLEMENTED(), declaration2, notImplementedIntersection, context2);
                } else {
                    DiagnosticReporterKt.reportOn(reporter, source, FirErrors.INSTANCE.getMANY_INTERFACES_MEMBER_NOT_IMPLEMENTED(), declaration2, notImplementedIntersection, context2);
                }
                manyMemberNotImplementedReported = true;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private final boolean isFromInterfaceOrEnum(FirCallableDeclaration<?> $this$isFromInterfaceOrEnum, CheckerContext context) {
        block3: {
            block2: {
                var4_3 = FirHelpersKt.getContainingClass((FirSymbolOwner)$this$isFromInterfaceOrEnum, context);
                v0 = var3_4 = var4_3 instanceof FirRegularClass != false ? (FirRegularClass)var4_3 : null;
                if (var3_4 != null) break block2;
                v1 = null;
                break block3;
            }
            var4_3 = var3_4;
            var5_5 = false;
            var6_6 = false;
            it = var4_3;
            $i$a$-let-FirNotImplementedOverrideChecker$isFromInterfaceOrEnum$1 = false;
            $this$isInterface$iv = it;
            $i$f$isInterface = false;
            if ($this$isInterface$iv.getClassKind() == ClassKind.INTERFACE) ** GOTO lbl-1000
            $this$isEnumClass$iv = it;
            $i$f$isEnumClass = false;
            if ($this$isEnumClass$iv.getClassKind() == ClassKind.ENUM_CLASS) lbl-1000:
            // 2 sources

            {
                v2 = true;
            } else {
                v2 = false;
            }
            v1 = v2;
        }
        return Intrinsics.areEqual(v1, true);
    }

    private final boolean getMatchesDataClassSyntheticMemberSignatures(FirSimpleFunction $this$matchesDataClassSyntheticMemberSignatures) {
        return Intrinsics.areEqual($this$matchesDataClassSyntheticMemberSignatures.getName(), OperatorNameConventions.EQUALS) && this.getMatchesEqualsSignature($this$matchesDataClassSyntheticMemberSignatures) || Intrinsics.areEqual($this$matchesDataClassSyntheticMemberSignatures.getName(), DefaultNamesKt.getHASHCODE_NAME()) && this.getMatchesHashCodeSignature($this$matchesDataClassSyntheticMemberSignatures) || Intrinsics.areEqual($this$matchesDataClassSyntheticMemberSignatures.getName(), OperatorNameConventions.TO_STRING) && this.getMatchesToStringSignature($this$matchesDataClassSyntheticMemberSignatures);
    }

    private final boolean getMatchesEqualsSignature(FirSimpleFunction $this$matchesEqualsSignature) {
        return $this$matchesEqualsSignature.getValueParameters().size() == 1 && ConeTypeUtilsKt.isNullableAny(FirTypeUtilsKt.getConeType($this$matchesEqualsSignature.getValueParameters().get(0).getReturnTypeRef()));
    }

    private final boolean getMatchesHashCodeSignature(FirSimpleFunction $this$matchesHashCodeSignature) {
        return $this$matchesHashCodeSignature.getValueParameters().isEmpty();
    }

    private final boolean getMatchesToStringSignature(FirSimpleFunction $this$matchesToStringSignature) {
        return $this$matchesToStringSignature.getValueParameters().isEmpty();
    }

    private static final boolean check$isInvisible(FirCallableMemberDeclaration<?> $this$check_u24isInvisible, FqName classPackage, FirClass<?> $declaration) {
        boolean $i$f$getVisibility;
        FirMemberDeclaration $this$visibility$iv;
        block3: {
            block2: {
                $this$visibility$iv = $this$check_u24isInvisible;
                $i$f$getVisibility = false;
                if (Intrinsics.areEqual($this$visibility$iv.getStatus().getVisibility(), Visibilities.Private.INSTANCE)) break block2;
                $this$visibility$iv = $this$check_u24isInvisible;
                $i$f$getVisibility = false;
                if ($this$visibility$iv.getStatus().getVisibility().visibleFromPackage(classPackage, $this$check_u24isInvisible.getSymbol().getCallableId().getPackageName())) break block3;
            }
            return true;
        }
        $this$visibility$iv = $this$check_u24isInvisible;
        $i$f$getVisibility = false;
        return Intrinsics.areEqual($this$visibility$iv.getStatus().getVisibility(), Visibilities.Internal.INSTANCE) && $this$check_u24isInvisible.getDeclarationSiteSession() != $declaration.getDeclarationSiteSession();
    }

    private static final boolean check$shouldBeImplemented(FirCallableMemberDeclaration<?> $this$check_u24shouldBeImplemented, CheckerContext $context, FirClass<?> $declaration) {
        FirMemberDeclaration $this$isAbstract$iv = $this$check_u24shouldBeImplemented;
        boolean $i$f$isAbstract = false;
        if (!($this$isAbstract$iv.getStatus().getModality() == Modality.ABSTRACT)) {
            return false;
        }
        FirClassLikeDeclaration<?> containingClass = FirHelpersKt.getContainingClass((FirSymbolOwner)$this$check_u24shouldBeImplemented, $context);
        if (containingClass == $declaration && Intrinsics.areEqual($this$check_u24shouldBeImplemented.getOrigin(), FirDeclarationOrigin.Source.INSTANCE)) {
            return false;
        }
        if (containingClass instanceof FirRegularClass) {
            FirMemberDeclaration $this$isExpect$iv = (FirMemberDeclaration)((Object)containingClass);
            boolean $i$f$isExpect = false;
            if ($this$isExpect$iv.getStatus().isExpect()) {
                return false;
            }
        }
        return true;
    }

    public static final /* synthetic */ boolean access$check$shouldBeImplemented(FirCallableMemberDeclaration $receiver, CheckerContext $context, FirClass $declaration) {
        return FirNotImplementedOverrideChecker.check$shouldBeImplemented($receiver, $context, $declaration);
    }

    public static final /* synthetic */ boolean access$getMatchesDataClassSyntheticMemberSignatures(FirNotImplementedOverrideChecker $this, FirSimpleFunction $receiver) {
        return $this.getMatchesDataClassSyntheticMemberSignatures($receiver);
    }

    public static final /* synthetic */ boolean access$check$isInvisible(FirCallableMemberDeclaration $receiver, FqName classPackage, FirClass $declaration) {
        return FirNotImplementedOverrideChecker.check$isInvisible($receiver, classPackage, $declaration);
    }
}

