/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.ivy.plugins.lock;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.kotlin.org.apache.ivy.plugins.lock.AbstractLockStrategy;
import org.jetbrains.kotlin.org.apache.ivy.plugins.lock.DeleteOnExitHook;
import org.jetbrains.kotlin.org.apache.ivy.util.Message;

public abstract class FileBasedLockStrategy
extends AbstractLockStrategy {
    private FileLocker locker;
    private long timeout = 120000L;
    private static final ConcurrentMap<File, ConcurrentMap<Thread, Integer>> currentLockHolders = new ConcurrentHashMap<File, ConcurrentMap<Thread, Integer>>();

    protected FileBasedLockStrategy(FileLocker locker, boolean debugLocking) {
        super(debugLocking);
        this.locker = locker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean acquireLock(File file) throws InterruptedException {
        Thread currentThread = Thread.currentThread();
        if (this.isDebugLocking()) {
            FileBasedLockStrategy.debugLocking("acquiring lock on " + file);
        }
        long start = System.currentTimeMillis();
        do {
            ConcurrentMap<File, ConcurrentMap<Thread, Integer>> concurrentMap = currentLockHolders;
            synchronized (concurrentMap) {
                if (this.isDebugLocking()) {
                    FileBasedLockStrategy.debugLocking("entered synchronized area (locking)");
                }
                int lockCount = this.hasLock(file, currentThread);
                if (this.isDebugLocking()) {
                    FileBasedLockStrategy.debugLocking("current status for " + file + " is " + lockCount + " held locks: " + this.getCurrentLockHolderNames(file));
                }
                if (lockCount < 0) {
                    if (this.isDebugLocking()) {
                        FileBasedLockStrategy.debugLocking("waiting for another thread to release the lock: " + this.getCurrentLockHolderNames(file));
                    }
                } else {
                    if (lockCount > 0) {
                        int holdLocks = this.incrementLock(file, currentThread);
                        if (this.isDebugLocking()) {
                            FileBasedLockStrategy.debugLocking("reentrant lock acquired on " + file + " in " + (System.currentTimeMillis() - start) + "ms - hold locks = " + holdLocks);
                        }
                        return true;
                    }
                    if (this.locker.tryLock(file)) {
                        if (this.isDebugLocking()) {
                            FileBasedLockStrategy.debugLocking("lock acquired on " + file + " in " + (System.currentTimeMillis() - start) + "ms");
                        }
                        this.incrementLock(file, currentThread);
                        return true;
                    }
                }
            }
            if (this.isDebugLocking()) {
                FileBasedLockStrategy.debugLocking("failed to acquire lock; sleeping for retry...");
            }
            Thread.sleep(100L);
        } while (System.currentTimeMillis() - start < this.timeout);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseLock(File file) {
        Thread currentThread = Thread.currentThread();
        if (this.isDebugLocking()) {
            FileBasedLockStrategy.debugLocking("releasing lock on " + file);
        }
        ConcurrentMap<File, ConcurrentMap<Thread, Integer>> concurrentMap = currentLockHolders;
        synchronized (concurrentMap) {
            int holdLocks;
            if (this.isDebugLocking()) {
                FileBasedLockStrategy.debugLocking("entered synchronized area (unlocking)");
            }
            if ((holdLocks = this.decrementLock(file, currentThread)) == 0) {
                this.locker.unlock(file);
                if (this.isDebugLocking()) {
                    FileBasedLockStrategy.debugLocking("lock released on " + file);
                }
            } else if (this.isDebugLocking()) {
                FileBasedLockStrategy.debugLocking("reentrant lock released on " + file + " - hold locks = " + holdLocks);
            }
        }
    }

    private static void debugLocking(String msg) {
        Message.info(Thread.currentThread() + " " + System.currentTimeMillis() + " " + msg);
    }

    private int hasLock(File file, Thread forThread) {
        int counter;
        ConcurrentMap locksPerThread = (ConcurrentMap)currentLockHolders.get(file);
        if (locksPerThread == null) {
            return 0;
        }
        if (locksPerThread.isEmpty()) {
            return 0;
        }
        Integer counterObj = (Integer)locksPerThread.get(forThread);
        int n = counter = counterObj == null ? 0 : counterObj;
        if (counter > 0) {
            return counter;
        }
        return -1;
    }

    private int incrementLock(File file, Thread forThread) {
        Integer c;
        ConcurrentHashMap<Thread, Integer> locksPerThread = (ConcurrentHashMap<Thread, Integer>)currentLockHolders.get(file);
        if (locksPerThread == null) {
            locksPerThread = new ConcurrentHashMap<Thread, Integer>();
            currentLockHolders.put(file, locksPerThread);
        }
        int holdLocks = (c = (Integer)locksPerThread.get(forThread)) == null ? 1 : c + 1;
        locksPerThread.put(forThread, holdLocks);
        return holdLocks;
    }

    private int decrementLock(File file, Thread forThread) {
        int oldHeldLocks;
        ConcurrentMap locksPerThread = (ConcurrentMap)currentLockHolders.get(file);
        if (locksPerThread == null) {
            throw new RuntimeException("Calling decrementLock on a thread which holds no locks");
        }
        Integer c = (Integer)locksPerThread.get(forThread);
        int n = oldHeldLocks = c == null ? 0 : c;
        if (oldHeldLocks <= 0) {
            throw new RuntimeException("Calling decrementLock on a thread which holds no locks");
        }
        int newHeldLocks = oldHeldLocks - 1;
        if (newHeldLocks > 0) {
            locksPerThread.put(forThread, newHeldLocks);
        } else {
            locksPerThread.remove(forThread);
        }
        return newHeldLocks;
    }

    protected String getCurrentLockHolderNames(File file) {
        StringBuilder sb = new StringBuilder();
        ConcurrentMap m = (ConcurrentMap)currentLockHolders.get(file);
        if (m == null) {
            return "(NULL)";
        }
        for (Thread t : m.keySet()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(t.toString());
        }
        return sb.toString();
    }

    public static class NIOFileLocker
    implements FileLocker {
        private ConcurrentMap<File, LockData> locks = new ConcurrentHashMap<File, LockData>();
        private boolean debugLocking;

        public NIOFileLocker(boolean debugLocking) {
            this.debugLocking = debugLocking;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean tryLock(File file) {
            block7: {
                try {
                    if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) break block7;
                    RandomAccessFile raf = new RandomAccessFile(file, "rw");
                    FileLock l = raf.getChannel().tryLock();
                    if (l != null) {
                        NIOFileLocker nIOFileLocker = this;
                        synchronized (nIOFileLocker) {
                            this.locks.put(file, new LockData(raf, l));
                        }
                        return true;
                    }
                    if (this.debugLocking) {
                        FileBasedLockStrategy.debugLocking("failed to acquire lock on " + file);
                    }
                }
                catch (IOException e) {
                    Message.verbose("file lock failed due to an exception: " + e.getMessage() + " (" + file + ")");
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unlock(File file) {
            NIOFileLocker nIOFileLocker = this;
            synchronized (nIOFileLocker) {
                LockData data = (LockData)this.locks.get(file);
                if (data == null) {
                    throw new IllegalArgumentException("file not previously locked: " + file);
                }
                try {
                    this.locks.remove(file);
                    data.l.release();
                    data.raf.close();
                }
                catch (IOException e) {
                    Message.error("problem while releasing lock on " + file + ": " + e.getMessage());
                }
            }
        }

        private static class LockData {
            private RandomAccessFile raf;
            private FileLock l;

            LockData(RandomAccessFile raf, FileLock l) {
                this.raf = raf;
                this.l = l;
            }
        }
    }

    public static class CreateFileLocker
    implements FileLocker {
        private boolean debugLocking;

        public CreateFileLocker(boolean debugLocking) {
            this.debugLocking = debugLocking;
        }

        @Override
        public boolean tryLock(File file) {
            try {
                if (file.getParentFile().exists() || file.getParentFile().mkdirs()) {
                    if (file.createNewFile()) {
                        DeleteOnExitHook.add(file);
                        return true;
                    }
                    if (this.debugLocking) {
                        FileBasedLockStrategy.debugLocking("file creation failed " + file);
                    }
                }
            }
            catch (IOException e) {
                Message.verbose("file creation failed due to an exception: " + e.getMessage() + " (" + file + ")");
            }
            return false;
        }

        @Override
        public void unlock(File file) {
            file.delete();
            DeleteOnExitHook.remove(file);
        }
    }

    public static interface FileLocker {
        public boolean tryLock(File var1);

        public void unlock(File var1);
    }
}

