/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.longs;

import it.unimi.dsi.fastutil.Arrays;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.longs.LongComparator;
import java.io.Serializable;

public final class LongArrays {
    public static final long[] EMPTY_ARRAY = new long[0];
    public static final long[] DEFAULT_EMPTY_ARRAY = new long[0];
    protected static final Segment POISON_PILL = new Segment(-1, -1, -1);
    public static final Hash.Strategy<long[]> HASH_STRATEGY = new ArrayHashStrategy();

    public static void ensureOffsetLength(long[] a, int offset2, int length) {
        Arrays.ensureOffsetLength(a.length, offset2, length);
    }

    public static void swap(long[] x, int a, int b) {
        long t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    public static void swap(long[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            LongArrays.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static int med3(long[] x, int a, int b, int c, LongComparator comp) {
        int ab = comp.compare(x[a], x[b]);
        int ac = comp.compare(x[a], x[c]);
        int bc = comp.compare(x[b], x[c]);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private static void selectionSort(long[] a, int from, int to, LongComparator comp) {
        for (int i = from; i < to - 1; ++i) {
            int m = i;
            for (int j = i + 1; j < to; ++j) {
                if (comp.compare(a[j], a[m]) >= 0) continue;
                m = j;
            }
            if (m == i) continue;
            long u = a[i];
            a[i] = a[m];
            a[m] = u;
        }
    }

    private static void insertionSort(long[] a, int from, int to, LongComparator comp) {
        int i = from;
        while (++i < to) {
            long t = a[i];
            int j = i;
            long u = a[j - 1];
            while (comp.compare(t, u) < 0) {
                a[j] = u;
                if (from == j - 1) {
                    --j;
                    break;
                }
                u = a[--j - 1];
            }
            a[j] = t;
        }
    }

    public static void quickSort(long[] x, int from, int to, LongComparator comp) {
        int c;
        int a;
        int len = to - from;
        if (len < 16) {
            LongArrays.selectionSort(x, from, to, comp);
            return;
        }
        int m = from + len / 2;
        int l = from;
        int n = to - 1;
        if (len > 128) {
            int s = len / 8;
            l = LongArrays.med3(x, l, l + s, l + 2 * s, comp);
            m = LongArrays.med3(x, m - s, m, m + s, comp);
            n = LongArrays.med3(x, n - 2 * s, n - s, n, comp);
        }
        m = LongArrays.med3(x, l, m, n, comp);
        long v = x[m];
        int b = a = from;
        int d = c = to - 1;
        while (true) {
            int comparison;
            if (b <= c && (comparison = comp.compare(x[b], v)) <= 0) {
                if (comparison == 0) {
                    LongArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = comp.compare(x[c], v)) >= 0) {
                if (comparison == 0) {
                    LongArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            LongArrays.swap(x, b++, c--);
        }
        int s = Math.min(a - from, b - a);
        LongArrays.swap(x, from, b - s, s);
        s = Math.min(d - c, to - d - 1);
        LongArrays.swap(x, b, to - s, s);
        s = b - a;
        if (s > 1) {
            LongArrays.quickSort(x, from, from + s, comp);
        }
        if ((s = d - c) > 1) {
            LongArrays.quickSort(x, to - s, to, comp);
        }
    }

    private static int med3(long[] x, int a, int b, int c) {
        int ab = Long.compare(x[a], x[b]);
        int ac = Long.compare(x[a], x[c]);
        int bc = Long.compare(x[b], x[c]);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private static void selectionSort(long[] a, int from, int to) {
        for (int i = from; i < to - 1; ++i) {
            int m = i;
            for (int j = i + 1; j < to; ++j) {
                if (a[j] >= a[m]) continue;
                m = j;
            }
            if (m == i) continue;
            long u = a[i];
            a[i] = a[m];
            a[m] = u;
        }
    }

    public static void quickSort(long[] x, int from, int to) {
        int c;
        int a;
        int len = to - from;
        if (len < 16) {
            LongArrays.selectionSort(x, from, to);
            return;
        }
        int m = from + len / 2;
        int l = from;
        int n = to - 1;
        if (len > 128) {
            int s = len / 8;
            l = LongArrays.med3(x, l, l + s, l + 2 * s);
            m = LongArrays.med3(x, m - s, m, m + s);
            n = LongArrays.med3(x, n - 2 * s, n - s, n);
        }
        m = LongArrays.med3(x, l, m, n);
        long v = x[m];
        int b = a = from;
        int d = c = to - 1;
        while (true) {
            int comparison;
            if (b <= c && (comparison = Long.compare(x[b], v)) <= 0) {
                if (comparison == 0) {
                    LongArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = Long.compare(x[c], v)) >= 0) {
                if (comparison == 0) {
                    LongArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            LongArrays.swap(x, b++, c--);
        }
        int s = Math.min(a - from, b - a);
        LongArrays.swap(x, from, b - s, s);
        s = Math.min(d - c, to - d - 1);
        LongArrays.swap(x, b, to - s, s);
        s = b - a;
        if (s > 1) {
            LongArrays.quickSort(x, from, from + s);
        }
        if ((s = d - c) > 1) {
            LongArrays.quickSort(x, to - s, to);
        }
    }

    public static void unstableSort(long[] a, int from, int to) {
        if (to - from >= 4000) {
            LongArrays.radixSort(a, from, to);
        } else {
            LongArrays.quickSort(a, from, to);
        }
    }

    public static void unstableSort(long[] a) {
        LongArrays.unstableSort(a, 0, a.length);
    }

    public static void unstableSort(long[] a, int from, int to, LongComparator comp) {
        LongArrays.quickSort(a, from, to, comp);
    }

    public static void unstableSort(long[] a, LongComparator comp) {
        LongArrays.unstableSort(a, 0, a.length, comp);
    }

    public static void mergeSort(long[] a, int from, int to, LongComparator comp, long[] supp) {
        int len = to - from;
        if (len < 16) {
            LongArrays.insertionSort(a, from, to, comp);
            return;
        }
        int mid = from + to >>> 1;
        LongArrays.mergeSort(supp, from, mid, comp, a);
        LongArrays.mergeSort(supp, mid, to, comp, a);
        if (comp.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from, a, from, len);
            return;
        }
        int p = from;
        int q = mid;
        for (int i = from; i < to; ++i) {
            a[i] = q >= to || p < mid && comp.compare(supp[p], supp[q]) <= 0 ? supp[p++] : supp[q++];
        }
    }

    public static void mergeSort(long[] a, int from, int to, LongComparator comp) {
        LongArrays.mergeSort(a, from, to, comp, (long[])a.clone());
    }

    public static void stableSort(long[] a, int from, int to, LongComparator comp) {
        LongArrays.mergeSort(a, from, to, comp);
    }

    public static void stableSort(long[] a, LongComparator comp) {
        LongArrays.stableSort(a, 0, a.length, comp);
    }

    public static void radixSort(long[] a, int from, int to) {
        if (to - from < 1024) {
            LongArrays.quickSort(a, from, to);
            return;
        }
        int maxLevel = 7;
        int stackSize = 1786;
        int stackPos = 0;
        int[] offsetStack = new int[1786];
        int[] lengthStack = new int[1786];
        int[] levelStack = new int[1786];
        offsetStack[stackPos] = from;
        lengthStack[stackPos] = to - from;
        levelStack[stackPos++] = 0;
        int[] count = new int[256];
        int[] pos = new int[256];
        while (stackPos > 0) {
            int first = offsetStack[--stackPos];
            int length = lengthStack[stackPos];
            int level = levelStack[stackPos];
            int signMask = level % 8 == 0 ? 128 : 0;
            int shift = (7 - level % 8) * 8;
            int i = first + length;
            while (i-- != first) {
                int n = (int)(a[i] >>> shift & 0xFFL ^ (long)signMask);
                count[n] = count[n] + 1;
            }
            int lastUsed = -1;
            int p = first;
            for (int i2 = 0; i2 < 256; ++i2) {
                if (count[i2] != 0) {
                    lastUsed = i2;
                }
                pos[i2] = p += count[i2];
            }
            int end = first + length - count[lastUsed];
            int c = -1;
            for (int i3 = first; i3 <= end; i3 += count[c]) {
                long t = a[i3];
                c = (int)(t >>> shift & 0xFFL ^ (long)signMask);
                if (i3 < end) {
                    while (true) {
                        int n = c;
                        int n2 = pos[n] - 1;
                        pos[n] = n2;
                        int d = n2;
                        if (n2 <= i3) break;
                        long z = t;
                        t = a[d];
                        a[d] = z;
                        c = (int)(t >>> shift & 0xFFL ^ (long)signMask);
                    }
                    a[i3] = t;
                }
                if (level < 7 && count[c] > 1) {
                    if (count[c] < 1024) {
                        LongArrays.quickSort(a, i3, i3 + count[c]);
                    } else {
                        offsetStack[stackPos] = i3;
                        lengthStack[stackPos] = count[c];
                        levelStack[stackPos++] = level + 1;
                    }
                }
                count[c] = 0;
            }
        }
    }

    protected static final class Segment {
        protected final int offset;
        protected final int length;
        protected final int level;

        protected Segment(int offset2, int length, int level) {
            this.offset = offset2;
            this.length = length;
            this.level = level;
        }

        public String toString() {
            return "Segment [offset=" + this.offset + ", length=" + this.length + ", level=" + this.level + "]";
        }
    }

    private static final class ArrayHashStrategy
    implements Hash.Strategy<long[]>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;

        private ArrayHashStrategy() {
        }

        @Override
        public int hashCode(long[] o) {
            return java.util.Arrays.hashCode(o);
        }

        @Override
        public boolean equals(long[] a, long[] b) {
            return java.util.Arrays.equals(a, b);
        }
    }
}

