/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.SystemInfo;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SystemProperties {
    private static String ourTestUserName;

    private SystemProperties() {
    }

    @NotNull
    public static String getUserHome() {
        String string2 = System.getProperty("user.home");
        if (string2 == null) {
            SystemProperties.$$$reportNull$$$0(0);
        }
        return string2;
    }

    public static String getUserName() {
        return ourTestUserName != null ? ourTestUserName : System.getProperty("user.name");
    }

    public static void setTestUserName(@Nullable String name) {
        ourTestUserName = name;
    }

    public static String getLineSeparator() {
        return System.getProperty("line.separator");
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public static String getOsName() {
        return SystemInfo.OS_NAME;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public static String getJavaVersion() {
        return SystemInfo.JAVA_VERSION;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public static String getJavaVmVendor() {
        return SystemInfo.JAVA_VENDOR;
    }

    public static String getJavaHome() {
        return System.getProperty("java.home");
    }

    public static int getIntProperty(@NotNull String key, int defaultValue2) {
        String value2;
        if (key == null) {
            SystemProperties.$$$reportNull$$$0(1);
        }
        if ((value2 = System.getProperty(key)) != null) {
            try {
                return Integer.parseInt(value2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue2;
    }

    public static float getFloatProperty(@NotNull String key, float defaultValue2) {
        String value2;
        if (key == null) {
            SystemProperties.$$$reportNull$$$0(2);
        }
        if ((value2 = System.getProperty(key)) != null) {
            try {
                return Float.parseFloat(value2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue2;
    }

    public static boolean getBooleanProperty(@NotNull String key, boolean defaultValue2) {
        String value2;
        if (key == null) {
            SystemProperties.$$$reportNull$$$0(3);
        }
        return (value2 = System.getProperty(key)) == null ? defaultValue2 : Boolean.parseBoolean(value2);
    }

    public static boolean is(String key) {
        return SystemProperties.getBooleanProperty(key, false);
    }

    public static boolean has(String key) {
        return System.getProperty(key) != null;
    }

    public static boolean isTrueSmoothScrollingEnabled() {
        return SystemProperties.getBooleanProperty("idea.true.smooth.scrolling", false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/SystemProperties";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserHome";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/SystemProperties";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getIntProperty";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFloatProperty";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getBooleanProperty";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

