/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirCallableMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.impl.FirDeclarationStatusImpl;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.resolve.transformers.FirStatusResolveTransformer;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\f\u0010\u0006\u001a\u00020\u0007*\u00020\bH\u0002\u001a\u001a\u0010\t\u001a\u00020\u0001*\u00020\b2\f\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0003H\u0002\u001a(\u0010\u000b\u001a\u00020\f*\u00020\b2\u0006\u0010\r\u001a\u00020\f2\f\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u0007\u001a\u001a\u0010\u000f\u001a\u00020\u0010*\u00020\b2\f\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0003H\u0002\u001a'\u0010\u0011\u001a\u0002H\u0002\"\u000e\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u0003*\u0002H\u00022\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014\"0\u0010\u0000\u001a\u0004\u0018\u00010\u0001\"\u000e\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u0003*\b\u0012\u0004\u0012\u0002H\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0015"}, d2={"modality", "Lorg/jetbrains/kotlin/descriptors/Modality;", "F", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "getModality", "(Lorg/jetbrains/kotlin/fir/declarations/FirClass;)Lorg/jetbrains/kotlin/descriptors/Modality;", "hasOwnBodyOrAccessorBody", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "resolveModality", "containingClass", "resolveStatus", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclarationStatus;", "status", "isLocal", "resolveVisibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "runStatusResolveForLocalClass", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "(Lorg/jetbrains/kotlin/fir/declarations/FirClass;Lorg/jetbrains/kotlin/fir/FirSession;)Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "resolve"})
public final class FirStatusResolveTransformerKt {
    @NotNull
    public static final <F extends FirClass<F>> F runStatusResolveForLocalClass(@NotNull F $this$runStatusResolveForLocalClass, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$runStatusResolveForLocalClass, "$this$runStatusResolveForLocalClass");
        Intrinsics.checkNotNullParameter(session2, "session");
        FirStatusResolveTransformer transformer2 = new FirStatusResolveTransformer(session2);
        return (F)((FirClass)$this$runStatusResolveForLocalClass.transform(transformer2, null).getSingle());
    }

    private static final <F extends FirClass<F>> Modality getModality(FirClass<F> $this$modality) {
        Modality modality;
        FirClass<F> firClass = $this$modality;
        if (firClass instanceof FirRegularClass) {
            modality = ((FirRegularClass)$this$modality).getStatus().getModality();
        } else if (firClass instanceof FirAnonymousObject) {
            modality = Modality.FINAL;
        } else {
            String string2 = "Unknown kind of class: " + Reflection.getOrCreateKotlinClass($this$modality.getClass());
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return modality;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public static final FirDeclarationStatus resolveStatus(@NotNull FirDeclaration $this$resolveStatus, @NotNull FirDeclarationStatus status, @Nullable FirClass<?> containingClass, boolean isLocal) {
        block5: {
            block7: {
                block6: {
                    Intrinsics.checkNotNullParameter($this$resolveStatus, "$this$resolveStatus");
                    Intrinsics.checkNotNullParameter(status, "status");
                    if (!Intrinsics.areEqual(status.getVisibility(), Visibilities.Unknown.INSTANCE) && status.getModality() != null && status.getModality() != Modality.OPEN) break block5;
                    var5_4 = status.getVisibility();
                    v0 = Intrinsics.areEqual(var5_4, Visibilities.Unknown.INSTANCE) ? (isLocal ? (Visibility)Visibilities.Local.INSTANCE : ($this$resolveStatus instanceof FirConstructor && containingClass instanceof FirAnonymousObject ? (Visibility)Visibilities.Private.INSTANCE : FirStatusResolveTransformerKt.resolveVisibility($this$resolveStatus, containingClass))) : (visibility = status.getVisibility());
                    v1 = status.getModality();
                    if (v1 == null) break block6;
                    var6_6 = v1;
                    var7_7 = false;
                    var8_8 = false;
                    it = var6_6;
                    $i$a$-let-FirStatusResolveTransformerKt$resolveStatus$modality$1 = false;
                    if (it != Modality.OPEN) ** GOTO lbl-1000
                    v2 = containingClass;
                    if ((v2 != null ? v2.getClassKind() : null) == ClassKind.INTERFACE && !FirStatusResolveTransformerKt.hasOwnBodyOrAccessorBody($this$resolveStatus)) {
                        v3 = Modality.ABSTRACT;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v3 = it;
                    }
                    v1 = v3;
                    if (v3 != null) break block7;
                }
                v1 = FirStatusResolveTransformerKt.resolveModality($this$resolveStatus, containingClass);
            }
            modality = v1;
            return ((FirDeclarationStatusImpl)status).resolved(visibility, modality);
        }
        return status;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean hasOwnBodyOrAccessorBody(FirDeclaration $this$hasOwnBodyOrAccessorBody) {
        FirDeclaration firDeclaration = $this$hasOwnBodyOrAccessorBody;
        if (firDeclaration instanceof FirSimpleFunction) {
            if (((FirSimpleFunction)$this$hasOwnBodyOrAccessorBody).getBody() == null) return false;
            return true;
        }
        if (!(firDeclaration instanceof FirProperty)) return true;
        if (((FirProperty)$this$hasOwnBodyOrAccessorBody).getInitializer() != null) return true;
        FirPropertyAccessor firPropertyAccessor = ((FirProperty)$this$hasOwnBodyOrAccessorBody).getGetter();
        if ((firPropertyAccessor != null ? firPropertyAccessor.getBody() : null) != null) return true;
        FirPropertyAccessor firPropertyAccessor2 = ((FirProperty)$this$hasOwnBodyOrAccessorBody).getSetter();
        if (firPropertyAccessor2 == null) return false;
        FirBlock firBlock = firPropertyAccessor2.getBody();
        if (firBlock == null) return false;
        return true;
    }

    private static final Visibility resolveVisibility(FirDeclaration $this$resolveVisibility, FirClass<?> containingClass) {
        if ($this$resolveVisibility instanceof FirConstructor && containingClass != null && (containingClass.getClassKind() == ClassKind.ENUM_CLASS || containingClass.getClassKind() == ClassKind.ENUM_ENTRY || FirStatusResolveTransformerKt.getModality(containingClass) == Modality.SEALED)) {
            return Visibilities.Private.INSTANCE;
        }
        return Visibilities.Public.INSTANCE;
    }

    private static final Modality resolveModality(FirDeclaration $this$resolveModality, FirClass<?> containingClass) {
        Modality modality;
        FirDeclaration firDeclaration = $this$resolveModality;
        if (firDeclaration instanceof FirRegularClass) {
            modality = ((FirRegularClass)$this$resolveModality).getClassKind() == ClassKind.INTERFACE ? Modality.ABSTRACT : Modality.FINAL;
        } else if (firDeclaration instanceof FirCallableMemberDeclaration) {
            if (containingClass == null) {
                modality = Modality.FINAL;
            } else if (containingClass.getClassKind() == ClassKind.INTERFACE) {
                FirMemberDeclaration $this$visibility$iv = (FirMemberDeclaration)$this$resolveModality;
                boolean $i$f$getVisibility = false;
                modality = Intrinsics.areEqual($this$visibility$iv.getStatus().getVisibility(), Visibilities.Private.INSTANCE) ? Modality.FINAL : (!FirStatusResolveTransformerKt.hasOwnBodyOrAccessorBody($this$resolveModality) ? Modality.ABSTRACT : Modality.OPEN);
            } else {
                FirMemberDeclaration $this$isOverride$iv = (FirMemberDeclaration)$this$resolveModality;
                boolean $i$f$isOverride = false;
                modality = $this$isOverride$iv.getStatus().isOverride() && FirStatusResolveTransformerKt.getModality(containingClass) != Modality.FINAL ? Modality.OPEN : Modality.FINAL;
            }
        } else {
            modality = Modality.FINAL;
        }
        return modality;
    }
}

