/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.backend.common.output.OutputFileCollection;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.ClassBuilderFactory;
import org.jetbrains.kotlin.codegen.ClassFileUtilsKt;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.MultifileClassCodegen;
import org.jetbrains.kotlin.codegen.PackageCodegen;
import org.jetbrains.kotlin.codegen.PackagePartRegistry;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.JvmAnalysisFlags;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.load.kotlin.ModuleMappingUtilKt;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.jvm.JvmModuleProtoBuf;
import org.jetbrains.kotlin.metadata.jvm.deserialization.ModuleMapping;
import org.jetbrains.kotlin.metadata.jvm.deserialization.ModuleMappingKt;
import org.jetbrains.kotlin.metadata.jvm.deserialization.PackageParts;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.kotlin.serialization.StringTableImpl;
import org.jetbrains.kotlin.serialization.deserialization.DeserializationConfiguration;
import org.jetbrains.org.objectweb.asm.Type;

public class ClassFileFactory
implements OutputFileCollection {
    private final GenerationState state;
    private final ClassBuilderFactory builderFactory;
    private final Map<String, OutAndSourceFileList> generators;
    private boolean isDone;
    private final Set<File> sourceFiles;
    private final PackagePartRegistry packagePartRegistry;

    public ClassFileFactory(@NotNull GenerationState state, @NotNull ClassBuilderFactory builderFactory) {
        if (state == null) {
            ClassFileFactory.$$$reportNull$$$0(0);
        }
        if (builderFactory == null) {
            ClassFileFactory.$$$reportNull$$$0(1);
        }
        this.generators = new LinkedHashMap<String, OutAndSourceFileList>();
        this.isDone = false;
        this.sourceFiles = new HashSet<File>();
        this.packagePartRegistry = new PackagePartRegistry();
        this.state = state;
        this.builderFactory = builderFactory;
    }

    public GenerationState getGenerationState() {
        return this.state;
    }

    @NotNull
    public PackagePartRegistry getPackagePartRegistry() {
        PackagePartRegistry packagePartRegistry = this.packagePartRegistry;
        if (packagePartRegistry == null) {
            ClassFileFactory.$$$reportNull$$$0(2);
        }
        return packagePartRegistry;
    }

    @NotNull
    public ClassBuilder newVisitor(@NotNull JvmDeclarationOrigin origin, @NotNull Type asmType, @NotNull PsiFile sourceFile) {
        if (origin == null) {
            ClassFileFactory.$$$reportNull$$$0(3);
        }
        if (asmType == null) {
            ClassFileFactory.$$$reportNull$$$0(4);
        }
        if (sourceFile == null) {
            ClassFileFactory.$$$reportNull$$$0(5);
        }
        ClassBuilder classBuilder2 = this.newVisitor(origin, asmType, (Collection<? extends PsiFile>)Collections.singletonList(sourceFile));
        if (classBuilder2 == null) {
            ClassFileFactory.$$$reportNull$$$0(6);
        }
        return classBuilder2;
    }

    @NotNull
    public ClassBuilder newVisitor(@NotNull JvmDeclarationOrigin origin, @NotNull Type asmType, @NotNull Collection<? extends PsiFile> sourceFiles2) {
        if (origin == null) {
            ClassFileFactory.$$$reportNull$$$0(7);
        }
        if (asmType == null) {
            ClassFileFactory.$$$reportNull$$$0(8);
        }
        if (sourceFiles2 == null) {
            ClassFileFactory.$$$reportNull$$$0(9);
        }
        ClassBuilder answer = this.builderFactory.newClassBuilder(origin);
        this.generators.put(asmType.getInternalName() + ".class", new ClassBuilderAndSourceFileList(answer, ClassFileFactory.toIoFilesIgnoringNonPhysical(sourceFiles2)));
        ClassBuilder classBuilder2 = answer;
        if (classBuilder2 == null) {
            ClassFileFactory.$$$reportNull$$$0(10);
        }
        return classBuilder2;
    }

    @NotNull
    public ClassBuilder newVisitor(@NotNull JvmDeclarationOrigin origin, @NotNull Type asmType, @NotNull List<File> sourceFiles2) {
        if (origin == null) {
            ClassFileFactory.$$$reportNull$$$0(11);
        }
        if (asmType == null) {
            ClassFileFactory.$$$reportNull$$$0(12);
        }
        if (sourceFiles2 == null) {
            ClassFileFactory.$$$reportNull$$$0(13);
        }
        ClassBuilder answer = this.builderFactory.newClassBuilder(origin);
        this.generators.put(asmType.getInternalName() + ".class", new ClassBuilderAndSourceFileList(answer, sourceFiles2));
        ClassBuilder classBuilder2 = answer;
        if (classBuilder2 == null) {
            ClassFileFactory.$$$reportNull$$$0(14);
        }
        return classBuilder2;
    }

    public void done() {
        if (!this.isDone) {
            this.isDone = true;
            this.writeModuleMappings();
        }
    }

    public void releaseGeneratedOutput() {
        this.generators.clear();
    }

    private void writeModuleMappings() {
        JvmModuleProtoBuf.Module.Builder builder = JvmModuleProtoBuf.Module.newBuilder();
        String outputFilePath = JvmCodegenUtil.getMappingFileName(this.state.getModuleName());
        for (PackageParts part : ClassFileUtilsKt.addCompiledPartsAndSort(this.packagePartRegistry.getParts().values(), this.state)) {
            part.addTo(builder);
        }
        List<String> experimental = this.state.getLanguageVersionSettings().getFlag(AnalysisFlags.getExperimental());
        if (!experimental.isEmpty()) {
            ClassFileFactory.writeExperimentalMarkers(this.state.getModule(), builder, experimental);
        }
        final JvmModuleProtoBuf.Module moduleProto = builder.build();
        this.generators.put(outputFilePath, new OutAndSourceFileList(CollectionsKt.toList(this.sourceFiles)){

            @Override
            public byte[] asBytes(ClassBuilderFactory factory2) {
                int flags = 0;
                if (ClassFileFactory.this.state.getLanguageVersionSettings().getFlag(JvmAnalysisFlags.getStrictMetadataVersionSemantics()).booleanValue()) {
                    flags |= 1;
                }
                return ModuleMappingKt.serializeToByteArray(moduleProto, ClassFileFactory.this.state.getMetadataVersion(), flags);
            }

            @Override
            public String asText(ClassBuilderFactory factory2) {
                return new String(this.asBytes(factory2), StandardCharsets.UTF_8);
            }
        });
    }

    private static void writeExperimentalMarkers(@NotNull ModuleDescriptor module2, @NotNull JvmModuleProtoBuf.Module.Builder builder, @NotNull List<String> experimental) {
        if (module2 == null) {
            ClassFileFactory.$$$reportNull$$$0(15);
        }
        if (builder == null) {
            ClassFileFactory.$$$reportNull$$$0(16);
        }
        if (experimental == null) {
            ClassFileFactory.$$$reportNull$$$0(17);
        }
        StringTableImpl stringTable = new StringTableImpl();
        for (String fqName2 : experimental) {
            ClassDescriptor descriptor2 = DescriptorUtilKt.resolveClassByFqName(module2, new FqName(fqName2), NoLookupLocation.FOR_ALREADY_TRACKED);
            if (descriptor2 == null) continue;
            ProtoBuf.Annotation.Builder annotation2 = ProtoBuf.Annotation.newBuilder();
            ClassId classId = DescriptorUtilsKt.getClassId((ClassifierDescriptor)descriptor2);
            if (classId == null) continue;
            annotation2.setId(stringTable.getQualifiedClassNameIndex(classId.asString(), false));
            builder.addAnnotation(annotation2);
        }
        Pair<ProtoBuf.StringTable, ProtoBuf.QualifiedNameTable> tables = stringTable.buildProto();
        builder.setStringTable(tables.getFirst());
        builder.setQualifiedNameTable(tables.getSecond());
    }

    @Override
    @NotNull
    public List<OutputFile> asList() {
        this.done();
        List<OutputFile> list2 = this.getCurrentOutput();
        if (list2 == null) {
            ClassFileFactory.$$$reportNull$$$0(18);
        }
        return list2;
    }

    @NotNull
    public List<OutputFile> getCurrentOutput() {
        List<OutputFile> list2 = CollectionsKt.map(this.generators.keySet(), x$0 -> new OutputClassFile((String)x$0));
        if (list2 == null) {
            ClassFileFactory.$$$reportNull$$$0(19);
        }
        return list2;
    }

    @Override
    @Nullable
    public OutputFile get(@NotNull String relativePath) {
        if (relativePath == null) {
            ClassFileFactory.$$$reportNull$$$0(20);
        }
        return this.generators.containsKey(relativePath) ? new OutputClassFile(relativePath) : null;
    }

    @NotNull
    public String createText() {
        String string2 = this.createText(null);
        if (string2 == null) {
            ClassFileFactory.$$$reportNull$$$0(21);
        }
        return string2;
    }

    @NotNull
    public String createText(@Nullable String ignorePrefixPath) {
        StringBuilder answer = new StringBuilder();
        block8: for (OutputFile file2 : this.asList()) {
            if (ignorePrefixPath != null && file2.getRelativePath().startsWith(ignorePrefixPath)) continue;
            File relativePath = new File(file2.getRelativePath());
            answer.append("@").append(relativePath).append('\n');
            switch (FilesKt.getExtension(relativePath)) {
                case "class": {
                    answer.append(file2.asText());
                    break;
                }
                case "kotlin_module": {
                    ModuleMapping mapping2 = ModuleMappingUtilKt.loadModuleMapping(ModuleMapping.Companion, file2.asByteArray(), relativePath.getPath(), DeserializationConfiguration.Default.INSTANCE, version -> {
                        throw new IllegalStateException("Version of the generated module cannot be incompatible: " + version);
                    });
                    for (Map.Entry<String, PackageParts> entry : mapping2.getPackageFqName2Parts().entrySet()) {
                        FqName packageFqName = new FqName(entry.getKey());
                        PackageParts packageParts = entry.getValue();
                        answer.append("<package ").append(packageFqName).append(": ").append(packageParts.getParts()).append(">\n");
                    }
                    continue block8;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown OutputFile: " + file2);
                }
            }
        }
        String string2 = answer.toString();
        if (string2 == null) {
            ClassFileFactory.$$$reportNull$$$0(22);
        }
        return string2;
    }

    @NotNull
    public Map<String, String> createTextForEachFile() {
        LinkedHashMap<String, String> answer = new LinkedHashMap<String, String>();
        for (OutputFile file2 : this.asList()) {
            answer.put(file2.getRelativePath(), file2.asText());
        }
        LinkedHashMap<String, String> linkedHashMap = answer;
        if (linkedHashMap == null) {
            ClassFileFactory.$$$reportNull$$$0(23);
        }
        return linkedHashMap;
    }

    @NotNull
    public PackageCodegen forPackage(@NotNull FqName fqName2, @NotNull Collection<KtFile> files2) {
        if (fqName2 == null) {
            ClassFileFactory.$$$reportNull$$$0(24);
        }
        if (files2 == null) {
            ClassFileFactory.$$$reportNull$$$0(25);
        }
        assert (!this.isDone) : "Already done!";
        this.registerSourceFiles(files2);
        PackageCodegen packageCodegen = this.state.getCodegenFactory().createPackageCodegen(this.state, files2, fqName2);
        if (packageCodegen == null) {
            ClassFileFactory.$$$reportNull$$$0(26);
        }
        return packageCodegen;
    }

    @NotNull
    public MultifileClassCodegen forMultifileClass(@NotNull FqName facadeFqName, @NotNull Collection<KtFile> files2) {
        if (facadeFqName == null) {
            ClassFileFactory.$$$reportNull$$$0(27);
        }
        if (files2 == null) {
            ClassFileFactory.$$$reportNull$$$0(28);
        }
        assert (!this.isDone) : "Already done!";
        this.registerSourceFiles(files2);
        MultifileClassCodegen multifileClassCodegen = this.state.getCodegenFactory().createMultifileClassCodegen(this.state, files2, facadeFqName);
        if (multifileClassCodegen == null) {
            ClassFileFactory.$$$reportNull$$$0(29);
        }
        return multifileClassCodegen;
    }

    private void registerSourceFiles(Collection<KtFile> files2) {
        this.sourceFiles.addAll(ClassFileFactory.toIoFilesIgnoringNonPhysical(files2));
    }

    @NotNull
    private static List<File> toIoFilesIgnoringNonPhysical(@NotNull Collection<? extends PsiFile> psiFiles) {
        if (psiFiles == null) {
            ClassFileFactory.$$$reportNull$$$0(30);
        }
        ArrayList<File> result2 = new ArrayList<File>(psiFiles.size());
        for (PsiFile psiFile : psiFiles) {
            VirtualFile virtualFile2 = psiFile.getVirtualFile();
            if (virtualFile2 == null) continue;
            result2.add(new File(virtualFile2.getPath()));
        }
        ArrayList<File> arrayList = result2;
        if (arrayList == null) {
            ClassFileFactory.$$$reportNull$$$0(31);
        }
        return arrayList;
    }

    public void removeClasses(Set<String> classNamesToRemove) {
        for (String classInternalName : classNamesToRemove) {
            this.generators.remove(classInternalName + ".class");
        }
    }

    public List<KtFile> getInputFiles() {
        return this.state.getFiles();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 14: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 29: 
            case 31: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 14: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 29: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builderFactory";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 14: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/ClassFileFactory";
                break;
            }
            case 3: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "origin";
                break;
            }
            case 4: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "asmType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFile";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFiles";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "experimental";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqName";
                break;
            }
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facadeFqName";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/ClassFileFactory";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackagePartRegistry";
                break;
            }
            case 6: 
            case 10: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "newVisitor";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "asList";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentOutput";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createText";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createTextForEachFile";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "forPackage";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "forMultifileClass";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "toIoFilesIgnoringNonPhysical";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 14: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 29: 
            case 31: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "newVisitor";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "writeExperimentalMarkers";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "forPackage";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "forMultifileClass";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "toIoFilesIgnoringNonPhysical";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 14: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 29: 
            case 31: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class OutAndSourceFileList {
        protected final List<File> sourceFiles;

        private OutAndSourceFileList(List<File> sourceFiles2) {
            this.sourceFiles = sourceFiles2;
        }

        public abstract byte[] asBytes(ClassBuilderFactory var1);

        public abstract String asText(ClassBuilderFactory var1);
    }

    private static final class ClassBuilderAndSourceFileList
    extends OutAndSourceFileList {
        private final ClassBuilder classBuilder;

        private ClassBuilderAndSourceFileList(ClassBuilder classBuilder2, List<File> sourceFiles2) {
            super(sourceFiles2);
            this.classBuilder = classBuilder2;
        }

        @Override
        public byte[] asBytes(ClassBuilderFactory factory2) {
            return factory2.asBytes(this.classBuilder);
        }

        @Override
        public String asText(ClassBuilderFactory factory2) {
            return factory2.asText(this.classBuilder);
        }
    }

    private class OutputClassFile
    implements OutputFile {
        private final String relativeClassFilePath;

        public OutputClassFile(String relativeClassFilePath) {
            this.relativeClassFilePath = relativeClassFilePath;
        }

        @Override
        @NotNull
        public String getRelativePath() {
            String string2 = this.relativeClassFilePath;
            if (string2 == null) {
                OutputClassFile.$$$reportNull$$$0(0);
            }
            return string2;
        }

        @Override
        @NotNull
        public List<File> getSourceFiles() {
            OutAndSourceFileList pair = (OutAndSourceFileList)ClassFileFactory.this.generators.get(this.relativeClassFilePath);
            if (pair == null) {
                throw new IllegalStateException("No record for binary file " + this.relativeClassFilePath);
            }
            List<File> list2 = pair.sourceFiles;
            if (list2 == null) {
                OutputClassFile.$$$reportNull$$$0(1);
            }
            return list2;
        }

        @Override
        @NotNull
        public byte[] asByteArray() {
            byte[] byArray;
            try {
                byArray = ((OutAndSourceFileList)ClassFileFactory.this.generators.get(this.relativeClassFilePath)).asBytes(ClassFileFactory.this.builderFactory);
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Error generating class file " + this.toString() + ": " + e.getMessage(), e);
            }
            if (byArray == null) {
                OutputClassFile.$$$reportNull$$$0(2);
            }
            return byArray;
        }

        @Override
        @NotNull
        public String asText() {
            String string2;
            try {
                string2 = ((OutAndSourceFileList)ClassFileFactory.this.generators.get(this.relativeClassFilePath)).asText(ClassFileFactory.this.builderFactory);
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Error generating class file " + this.toString() + ": " + e.getMessage(), e);
            }
            if (string2 == null) {
                OutputClassFile.$$$reportNull$$$0(3);
            }
            return string2;
        }

        @NotNull
        public String toString() {
            String string2 = this.getRelativePath() + " (compiled from " + this.getSourceFiles() + ")";
            if (string2 == null) {
                OutputClassFile.$$$reportNull$$$0(4);
            }
            return string2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "org/jetbrains/kotlin/codegen/ClassFileFactory$OutputClassFile";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRelativePath";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSourceFiles";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "asByteArray";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "asText";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

