/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.lazy;

import com.intellij.openapi.diagnostic.Logger;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.lazy.LazyEntity;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;

public class ForceResolveUtil {
    private static final Logger LOG = Logger.getInstance(ForceResolveUtil.class);

    private ForceResolveUtil() {
    }

    public static <T> T forceResolveAllContents(@NotNull T descriptor2) {
        if (descriptor2 == null) {
            ForceResolveUtil.$$$reportNull$$$0(0);
        }
        ForceResolveUtil.doForceResolveAllContents(descriptor2);
        return descriptor2;
    }

    public static void forceResolveAllContents(@NotNull MemberScope scope) {
        if (scope == null) {
            ForceResolveUtil.$$$reportNull$$$0(1);
        }
        ForceResolveUtil.forceResolveAllContents(DescriptorUtils.getAllDescriptors(scope));
    }

    public static void forceResolveAllContents(@NotNull Iterable<? extends DeclarationDescriptor> descriptors) {
        if (descriptors == null) {
            ForceResolveUtil.$$$reportNull$$$0(2);
        }
        for (DeclarationDescriptor declarationDescriptor : descriptors) {
            ForceResolveUtil.forceResolveAllContents(declarationDescriptor);
        }
    }

    public static void forceResolveAllContents(@NotNull Collection<KotlinType> types2) {
        if (types2 == null) {
            ForceResolveUtil.$$$reportNull$$$0(3);
        }
        for (KotlinType type2 : types2) {
            ForceResolveUtil.forceResolveAllContents(type2);
        }
    }

    public static void forceResolveAllContents(@NotNull TypeConstructor typeConstructor2) {
        if (typeConstructor2 == null) {
            ForceResolveUtil.$$$reportNull$$$0(4);
        }
        ForceResolveUtil.doForceResolveAllContents(typeConstructor2);
    }

    public static void forceResolveAllContents(@NotNull Annotations annotations2) {
        if (annotations2 == null) {
            ForceResolveUtil.$$$reportNull$$$0(5);
        }
        ForceResolveUtil.doForceResolveAllContents(annotations2);
        for (AnnotationDescriptor annotation2 : annotations2) {
            ForceResolveUtil.doForceResolveAllContents(annotation2);
        }
    }

    private static void doForceResolveAllContents(Object object) {
        if (object instanceof LazyEntity) {
            LazyEntity lazyEntity = (LazyEntity)object;
            lazyEntity.forceResolveAllContents();
        } else if (object instanceof ValueParameterDescriptorImpl.WithDestructuringDeclaration) {
            ((ValueParameterDescriptorImpl.WithDestructuringDeclaration)object).getDestructuringVariables();
        } else if (object instanceof CallableDescriptor) {
            CallableDescriptor callableDescriptor = (CallableDescriptor)object;
            ReceiverParameterDescriptor parameter = callableDescriptor.getExtensionReceiverParameter();
            if (parameter != null) {
                ForceResolveUtil.forceResolveAllContents(parameter.getType());
            }
            for (ValueParameterDescriptor parameterDescriptor : callableDescriptor.getValueParameters()) {
                ForceResolveUtil.forceResolveAllContents(parameterDescriptor);
            }
            for (TypeParameterDescriptor typeParameterDescriptor : callableDescriptor.getTypeParameters()) {
                ForceResolveUtil.forceResolveAllContents(typeParameterDescriptor.getUpperBounds());
            }
            ForceResolveUtil.forceResolveAllContents(callableDescriptor.getReturnType());
            ForceResolveUtil.forceResolveAllContents(callableDescriptor.getAnnotations());
        } else if (object instanceof TypeAliasDescriptor) {
            TypeAliasDescriptor typeAliasDescriptor = (TypeAliasDescriptor)object;
            ForceResolveUtil.forceResolveAllContents(typeAliasDescriptor.getUnderlyingType());
        }
    }

    @Nullable
    public static KotlinType forceResolveAllContents(@Nullable KotlinType type2) {
        if (type2 == null) {
            return null;
        }
        ForceResolveUtil.forceResolveAllContents(type2.getAnnotations());
        if (FlexibleTypesKt.isFlexible(type2)) {
            ForceResolveUtil.forceResolveAllContents(FlexibleTypesKt.asFlexibleType(type2).getLowerBound());
            ForceResolveUtil.forceResolveAllContents(FlexibleTypesKt.asFlexibleType(type2).getUpperBound());
        } else {
            ForceResolveUtil.forceResolveAllContents(type2.getConstructor());
            for (TypeProjection projection : type2.getArguments()) {
                if (projection.isStarProjection()) continue;
                ForceResolveUtil.forceResolveAllContents(projection.getType());
            }
        }
        return type2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "descriptor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "scope";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "descriptors";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "types";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "typeConstructor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "annotations";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/kotlin/resolve/lazy/ForceResolveUtil";
        objectArray[2] = "forceResolveAllContents";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

