/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.jvm.JavaToKotlinClassMap;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.jvm.checkers.BadInheritedJavaSignaturesCheckerKt;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/BadInheritedJavaSignaturesChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend.java"})
public final class BadInheritedJavaSignaturesChecker
implements DeclarationChecker {
    public static final BadInheritedJavaSignaturesChecker INSTANCE;

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        DeclarationDescriptor badSignatureOverriddenDescriptor;
        block7: {
            DeclarationDescriptor declarationDescriptor;
            Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            Intrinsics.checkParameterIsNotNull(context2, "context");
            if (!(descriptor2 instanceof ClassDescriptor)) {
                return;
            }
            Iterable $this$firstNotNullResult$iv = ResolutionScope.DefaultImpls.getContributedDescriptors$default(((ClassDescriptor)descriptor2).getUnsubstitutedMemberScope(), null, null, 3, null);
            boolean $i$f$firstNotNullResult = false;
            for (Object element$iv : $this$firstNotNullResult$iv) {
                DeclarationDescriptor p1 = (DeclarationDescriptor)element$iv;
                boolean bl = false;
                DeclarationDescriptor result$iv = BadInheritedJavaSignaturesCheckerKt.access$findFirstBadJavaSignatureOverridden(p1);
                if (result$iv == null) continue;
                declarationDescriptor = result$iv;
                break block7;
            }
            declarationDescriptor = badSignatureOverriddenDescriptor = null;
        }
        if (badSignatureOverriddenDescriptor != null) {
            PsiElement psiElement;
            PsiElement psiElement2;
            KtDeclaration $i$f$firstNotNullResult = declaration2;
            if ($i$f$firstNotNullResult instanceof KtClass) {
                psiElement2 = ((KtClass)declaration2).getNameIdentifier();
                if (psiElement2 == null) {
                    psiElement2 = ((KtClass)declaration2).getClassOrInterfaceKeyword();
                }
            } else {
                psiElement2 = psiElement = $i$f$firstNotNullResult instanceof KtObjectDeclaration ? ((KtObjectDeclaration)declaration2).getObjectKeyword() : null;
            }
            if (psiElement2 == null) {
                psiElement = declaration2;
            }
            Intrinsics.checkExpressionValueIsNotNull(psiElement, "when (declaration) {\n   \u2026         } ?: declaration");
            PsiElement reportOn = psiElement;
            String renderedDescriptor = DescriptorRenderer.COMPACT_WITH_SHORT_TYPES.render(badSignatureOverriddenDescriptor);
            context2.getTrace().report(Errors.UNSUPPORTED.on(reportOn, "Inheritance of a Java member referencing '" + JavaToKotlinClassMap.INSTANCE.getFUNCTION_N_FQ_NAME() + "': " + renderedDescriptor));
        }
    }

    private BadInheritedJavaSignaturesChecker() {
    }

    static {
        BadInheritedJavaSignaturesChecker badInheritedJavaSignaturesChecker;
        INSTANCE = badInheritedJavaSignaturesChecker = new BadInheritedJavaSignaturesChecker();
    }
}

