/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.callUtil;

import com.intellij.extapi.psi.ASTDelegatePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.KotlinLookupLocation;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtInstanceExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.kotlin.resolve.calls.CallTransformer;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMapping;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatch;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatchStatus;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentUnmapped;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tower.NewResolvedCallImpl;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\u0098\u0001\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001a\u0010\n\u001a\u00020\u0001\"\b\b\u0000\u0010\u000b*\u00020\f*\b\u0012\u0004\u0012\u0002H\u000b0\r\u001a\n\u0010\u000e\u001a\u00020\u000f*\u00020\u0010\u001a\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012*\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0012H\u0002\u001a\u0014\u0010\u0014\u001a\u0004\u0018\u00010\u0010*\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u0012\u0010\u0017\u001a\u00020\u0010*\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u000e\u0010\u0018\u001a\u0004\u0018\u00010\u0019*\u0004\u0018\u00010\u0002\u001a\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u0019*\u0006\u0012\u0002\b\u00030\r\u001a\u001a\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0\r*\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0016\u001a&\u0010\u001d\u001a\u0004\u0018\u00010\u001e\"\b\b\u0000\u0010\u000b*\u00020\f*\b\u0012\u0004\u0012\u0002H\u000b0\r2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0013\u001a\u001e\u0010 \u001a\u0004\u0018\u00010\u0010*\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010!\u001a\u00020\u0001\u001a(\u0010\"\u001a\f\u0012\u0006\b\u0001\u0012\u00020\f\u0018\u00010\r*\u0004\u0018\u00010\u00022\u0006\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010!\u001a\u00020\u0001\u001a\u001a\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020$0\r*\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u0010\u0010%\u001a\u0004\u0018\u00010\u0019*\u0006\u0012\u0002\b\u00030\r\u001a\u001e\u0010&\u001a\f\u0012\u0006\b\u0001\u0012\u00020\f\u0018\u00010\r*\u0004\u0018\u00010\u00102\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u001e\u0010&\u001a\f\u0012\u0006\b\u0001\u0012\u00020\f\u0018\u00010\r*\u0004\u0018\u00010\u00022\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u001a\u0010'\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\r*\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u001a\u0010'\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\r*\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u0014\u0010(\u001a\u0004\u0018\u00010)*\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u0014\u0010*\u001a\u0004\u0018\u00010\u0013*\u00020\u00102\u0006\u0010+\u001a\u00020\u0019\u001a\n\u0010,\u001a\u00020\u0002*\u00020\u0010\u001a\u0010\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012*\u00020\u0010\u001a\u0010\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012*\u00020.\u001a\u001a\u0010/\u001a\n\u0012\u0006\b\u0001\u0012\u0002000\r*\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0016\u001a\"\u00101\u001a\u00020\u0001\"\b\b\u0000\u0010\u000b*\u00020\f*\b\u0012\u0004\u0012\u0002H\u000b0\r2\u0006\u00102\u001a\u00020\u001e\u001a\u001a\u00103\u001a\u00020\u0001\"\b\b\u0000\u0010\u000b*\u00020\f*\b\u0012\u0004\u0012\u0002H\u000b0\r\u001a\u001a\u00104\u001a\u00020\u0001\"\b\b\u0000\u0010\u000b*\u00020\f*\b\u0012\u0004\u0012\u0002H\u000b0\r\u001a(\u00105\u001a\u00020\u0001\"\u000e\b\u0000\u00106*\b\u0012\u0004\u0012\u0002H607*\u00020\u00102\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H607\u001a\n\u00108\u001a\u00020\u0001*\u00020\u0010\u001a\n\u00109\u001a\u00020\u0001*\u00020\u0010\u001a\u001a\u0010:\u001a\u00020\u0001\"\b\b\u0000\u0010\u000b*\u00020\f*\b\u0012\u0004\u0012\u0002H\u000b0\r\u001a+\u0010;\u001a\u00020<*\u00020=2\b\u0010+\u001a\u0004\u0018\u00010\u00192\u0012\u0010>\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020@0?H\u0086\b\u001a\u001a\u0010A\u001a\u00020\u0001\"\b\b\u0000\u0010\u000b*\u00020\f*\b\u0012\u0004\u0012\u0002H\u000b0\r\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0015\u0010\u0004\u001a\u00020\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0006\"\u0015\u0010\u0007\u001a\u00020\u0001*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\t\u00a8\u0006B"}, d2={"isFakeElement", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "(Lorg/jetbrains/kotlin/psi/KtElement;)Z", "isFakePsiElement", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)Z", "isTrailingLambdaOnNewLIne", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "(Lorg/jetbrains/kotlin/psi/KtLambdaExpression;)Z", "allArgumentsMapped", "D", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "createLookupLocation", "Lorg/jetbrains/kotlin/incremental/KotlinLookupLocation;", "Lorg/jetbrains/kotlin/psi/Call;", "filterArgsInParentheses", "", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "getCall", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "getCallWithAssert", "getCalleeExpressionIfAny", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getFirstArgumentExpression", "getFunctionResolvedCallWithAssert", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "getParameterForArgument", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "valueArgument", "getParentCall", "strict", "getParentResolvedCall", "getPropertyResolvedCallWithAssert", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "getReceiverExpression", "getResolvedCall", "getResolvedCallWithAssert", "getType", "Lorg/jetbrains/kotlin/types/KotlinType;", "getValueArgumentForExpression", "expression", "getValueArgumentListOrElement", "getValueArgumentsInParentheses", "Lorg/jetbrains/kotlin/psi/KtCallElement;", "getVariableResolvedCallWithAssert", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "hasTypeMismatchErrorOnParameter", "parameter", "hasUnmappedArguments", "hasUnmappedParameters", "hasUnresolvedArguments", "C", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "isCallableReference", "isSafeCall", "noErrorsInValueArguments", "reportTrailingLambdaErrorOr", "", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "originalDiagnostic", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "usesDefaultArguments", "frontend"})
public final class CallUtilKt {
    public static final <D extends CallableDescriptor> boolean noErrorsInValueArguments(@NotNull ResolvedCall<D> $this$noErrorsInValueArguments) {
        boolean bl;
        block4: {
            Intrinsics.checkParameterIsNotNull($this$noErrorsInValueArguments, "$this$noErrorsInValueArguments");
            Call call2 = $this$noErrorsInValueArguments.getCall();
            Intrinsics.checkExpressionValueIsNotNull(call2, "call");
            List<? extends ValueArgument> list2 = call2.getValueArguments();
            Intrinsics.checkExpressionValueIsNotNull(list2, "call.valueArguments");
            Iterable $this$all$iv = list2;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    ValueArgument argument = (ValueArgument)element$iv;
                    boolean bl2 = false;
                    ValueArgument valueArgument = argument;
                    if (valueArgument == null) {
                        Intrinsics.throwNpe();
                    }
                    if (!$this$noErrorsInValueArguments.getArgumentMapping(valueArgument).isError()) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    public static final <D extends CallableDescriptor> boolean hasUnmappedArguments(@NotNull ResolvedCall<D> $this$hasUnmappedArguments) {
        boolean bl;
        block4: {
            Intrinsics.checkParameterIsNotNull($this$hasUnmappedArguments, "$this$hasUnmappedArguments");
            Call call2 = $this$hasUnmappedArguments.getCall();
            Intrinsics.checkExpressionValueIsNotNull(call2, "call");
            List<? extends ValueArgument> list2 = call2.getValueArguments();
            Intrinsics.checkExpressionValueIsNotNull(list2, "call.valueArguments");
            Iterable $this$any$iv = list2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ValueArgument argument = (ValueArgument)element$iv;
                    boolean bl2 = false;
                    ValueArgument valueArgument = argument;
                    if (valueArgument == null) {
                        Intrinsics.throwNpe();
                    }
                    if (!Intrinsics.areEqual($this$hasUnmappedArguments.getArgumentMapping(valueArgument), ArgumentUnmapped.INSTANCE)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final <D extends CallableDescriptor> boolean hasUnmappedParameters(@NotNull ResolvedCall<D> $this$hasUnmappedParameters) {
        Intrinsics.checkParameterIsNotNull($this$hasUnmappedParameters, "$this$hasUnmappedParameters");
        Map<ValueParameterDescriptor, ResolvedValueArgument> map2 = $this$hasUnmappedParameters.getValueArguments();
        Intrinsics.checkExpressionValueIsNotNull(map2, "valueArguments");
        Map<ValueParameterDescriptor, ResolvedValueArgument> parameterToArgumentMap = map2;
        Set<ValueParameterDescriptor> set = parameterToArgumentMap.keySet();
        D d = $this$hasUnmappedParameters.getResultingDescriptor();
        Intrinsics.checkExpressionValueIsNotNull(d, "resultingDescriptor");
        List<ValueParameterDescriptor> list2 = d.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, "resultingDescriptor.valueParameters");
        return !set.containsAll((Collection)list2);
    }

    public static final <D extends CallableDescriptor> boolean allArgumentsMapped(@NotNull ResolvedCall<D> $this$allArgumentsMapped) {
        boolean bl;
        block3: {
            Intrinsics.checkParameterIsNotNull($this$allArgumentsMapped, "$this$allArgumentsMapped");
            Call call2 = $this$allArgumentsMapped.getCall();
            Intrinsics.checkExpressionValueIsNotNull(call2, "call");
            List<? extends ValueArgument> list2 = call2.getValueArguments();
            Intrinsics.checkExpressionValueIsNotNull(list2, "call.valueArguments");
            Iterable $this$all$iv = list2;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    ValueArgument argument = (ValueArgument)element$iv;
                    boolean bl2 = false;
                    if ($this$allArgumentsMapped.getArgumentMapping(argument) instanceof ArgumentMatch) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public static final <D extends CallableDescriptor> boolean hasTypeMismatchErrorOnParameter(@NotNull ResolvedCall<D> $this$hasTypeMismatchErrorOnParameter, @NotNull ValueParameterDescriptor parameter) {
        boolean bl;
        block4: {
            Intrinsics.checkParameterIsNotNull($this$hasTypeMismatchErrorOnParameter, "$this$hasTypeMismatchErrorOnParameter");
            Intrinsics.checkParameterIsNotNull(parameter, "parameter");
            ResolvedValueArgument resolvedValueArgument = $this$hasTypeMismatchErrorOnParameter.getValueArguments().get(parameter);
            if (resolvedValueArgument == null) {
                return true;
            }
            List<ValueArgument> list2 = resolvedValueArgument.getArguments();
            Intrinsics.checkExpressionValueIsNotNull(list2, "resolvedValueArgument.arguments");
            Iterable $this$any$iv = list2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ArgumentMapping argumentMapping;
                    ValueArgument argument = (ValueArgument)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkExpressionValueIsNotNull($this$hasTypeMismatchErrorOnParameter.getArgumentMapping(argument), "getArgumentMapping(argument)");
                    boolean bl3 = argumentMapping instanceof ArgumentMatch && ((ArgumentMatch)argumentMapping).getStatus() == ArgumentMatchStatus.TYPE_MISMATCH;
                    if (!bl3) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Nullable
    public static final <D extends CallableDescriptor> ValueParameterDescriptor getParameterForArgument(@NotNull ResolvedCall<D> $this$getParameterForArgument, @Nullable ValueArgument valueArgument) {
        ArgumentMapping argumentMapping;
        ArgumentMapping argumentMapping2;
        Intrinsics.checkParameterIsNotNull($this$getParameterForArgument, "$this$getParameterForArgument");
        ValueArgument valueArgument2 = valueArgument;
        if (valueArgument2 != null) {
            ValueArgument valueArgument3 = valueArgument2;
            boolean bl = false;
            boolean bl2 = false;
            ValueArgument it = valueArgument3;
            boolean bl3 = false;
            argumentMapping2 = $this$getParameterForArgument.getArgumentMapping(it);
        } else {
            argumentMapping2 = argumentMapping = null;
        }
        if (!(argumentMapping2 instanceof ArgumentMatch)) {
            argumentMapping = null;
        }
        ArgumentMatch argumentMatch = (ArgumentMatch)argumentMapping;
        return argumentMatch != null ? argumentMatch.getValueParameter() : null;
    }

    public static final <D extends CallableDescriptor> boolean usesDefaultArguments(@NotNull ResolvedCall<D> $this$usesDefaultArguments) {
        boolean bl;
        block5: {
            Intrinsics.checkParameterIsNotNull($this$usesDefaultArguments, "$this$usesDefaultArguments");
            List<ResolvedValueArgument> list2 = $this$usesDefaultArguments.getValueArgumentsByIndex();
            if (list2 != null) {
                Iterable $this$any$iv = list2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ResolvedValueArgument it = (ResolvedValueArgument)element$iv;
                        boolean bl2 = false;
                        if (!(it instanceof DefaultValueArgument)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final <C extends ResolutionContext<C>> boolean hasUnresolvedArguments(@NotNull Call $this$hasUnresolvedArguments, @NotNull ResolutionContext<C> context2) {
        boolean bl;
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull($this$hasUnresolvedArguments, "$this$hasUnresolvedArguments");
        Intrinsics.checkParameterIsNotNull(context2, "context");
        List<? extends ValueArgument> list2 = $this$hasUnresolvedArguments.getValueArguments();
        Intrinsics.checkExpressionValueIsNotNull(list2, "valueArguments");
        Iterable $this$map$iv = list2;
        boolean $i$f$map = false;
        Object object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ValueArgument valueArgument = (ValueArgument)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            KtExpression ktExpression = it.getArgumentExpression();
            collection.add(ktExpression);
        }
        List arguments2 = (List)destination$iv$iv;
        Iterable $this$any$iv = arguments2;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        object = $this$any$iv.iterator();
        do {
            if (!object.hasNext()) return false;
            Object element$iv = object.next();
            KtExpression argument = (KtExpression)element$iv;
            boolean bl3 = false;
            if (argument == null || ArgumentTypeResolver.isFunctionLiteralOrCallableReference(argument, context2)) {
                bl = false;
                continue;
            }
            KtElement ktElement = argument;
            BindingTrace bindingTrace = context2.trace;
            Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
            BindingContext bindingContext = bindingTrace.getBindingContext();
            Intrinsics.checkExpressionValueIsNotNull(bindingContext, "context.trace.bindingContext");
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, bindingContext);
            if (resolvedCall2 instanceof MutableResolvedCall) {
                if (!((MutableResolvedCall)resolvedCall2).hasInferredReturnType()) {
                    bl = false;
                    continue;
                }
            } else if (resolvedCall2 instanceof NewResolvedCallImpl) {
                KotlinType kotlinType2 = ((NewResolvedCallImpl)resolvedCall2).getResultingDescriptor().getReturnType();
                if (kotlinType2 != null) {
                    if (KotlinTypeKt.isError(kotlinType2)) {
                        bl = false;
                        continue;
                    }
                }
            }
            BindingTrace bindingTrace2 = context2.trace;
            Intrinsics.checkExpressionValueIsNotNull(bindingTrace2, "context.trace");
            KotlinType expressionType = bindingTrace2.getBindingContext().getType(argument);
            if (expressionType == null) return true;
            if (KotlinTypeKt.isError(expressionType)) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    @NotNull
    public static final List<ValueArgument> getValueArgumentsInParentheses(@NotNull Call $this$getValueArgumentsInParentheses) {
        Intrinsics.checkParameterIsNotNull($this$getValueArgumentsInParentheses, "$this$getValueArgumentsInParentheses");
        List<? extends ValueArgument> list2 = $this$getValueArgumentsInParentheses.getValueArguments();
        Intrinsics.checkExpressionValueIsNotNull(list2, "valueArguments");
        return CallUtilKt.filterArgsInParentheses(list2);
    }

    @NotNull
    public static final List<ValueArgument> getValueArgumentsInParentheses(@NotNull KtCallElement $this$getValueArgumentsInParentheses) {
        Intrinsics.checkParameterIsNotNull($this$getValueArgumentsInParentheses, "$this$getValueArgumentsInParentheses");
        List<? extends ValueArgument> list2 = $this$getValueArgumentsInParentheses.getValueArguments();
        Intrinsics.checkExpressionValueIsNotNull(list2, "valueArguments");
        return CallUtilKt.filterArgsInParentheses(list2);
    }

    @NotNull
    public static final KtElement getValueArgumentListOrElement(@NotNull Call $this$getValueArgumentListOrElement) {
        KtElement ktElement;
        Intrinsics.checkParameterIsNotNull($this$getValueArgumentListOrElement, "$this$getValueArgumentListOrElement");
        if ($this$getValueArgumentListOrElement instanceof CallTransformer.CallForImplicitInvoke) {
            Call call2 = ((CallTransformer.CallForImplicitInvoke)$this$getValueArgumentListOrElement).getOuterCall();
            Intrinsics.checkExpressionValueIsNotNull(call2, "outerCall");
            ktElement = CallUtilKt.getValueArgumentListOrElement(call2);
        } else {
            KtValueArgumentList ktValueArgumentList = $this$getValueArgumentListOrElement.getValueArgumentList();
            ktElement = ktValueArgumentList != null ? (KtElement)ktValueArgumentList : (KtElement)$this$getValueArgumentListOrElement.getCalleeExpression();
            if (ktElement == null) {
                KtElement ktElement2 = $this$getValueArgumentListOrElement.getCallElement();
                ktElement = ktElement2;
                Intrinsics.checkExpressionValueIsNotNull(ktElement2, "callElement");
            }
        }
        return ktElement;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<ValueArgument> filterArgsInParentheses(@NotNull List<? extends ValueArgument> $this$filterArgsInParentheses) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = $this$filterArgsInParentheses;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ValueArgument it = (ValueArgument)element$iv$iv;
            boolean bl = false;
            if (!(!(it instanceof KtLambdaArgument))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final ValueArgument getValueArgumentForExpression(@NotNull Call $this$getValueArgumentForExpression, @NotNull KtExpression expression2) {
        Object v2;
        block1: {
            Intrinsics.checkParameterIsNotNull($this$getValueArgumentForExpression, "$this$getValueArgumentForExpression");
            Intrinsics.checkParameterIsNotNull(expression2, "expression");
            getValueArgumentForExpression.1 $fun$deparenthesizeStructurally$1 = getValueArgumentForExpression.1.INSTANCE;
            Function1<KtElement, Boolean> $fun$isParenthesizedExpression$2 = new Function1<KtElement, Boolean>(expression2){
                final /* synthetic */ KtExpression $expression;

                public final boolean invoke(@NotNull KtElement $this$isParenthesizedExpression) {
                    boolean bl;
                    block1: {
                        Intrinsics.checkParameterIsNotNull($this$isParenthesizedExpression, "$this$isParenthesizedExpression");
                        Sequence<KtElement> $this$any$iv = SequencesKt.generateSequence($this$isParenthesizedExpression, (Function1)getValueArgumentForExpression.1.INSTANCE);
                        boolean $i$f$any = false;
                        Iterator<KtElement> iterator2 = $this$any$iv.iterator();
                        while (iterator2.hasNext()) {
                            KtElement element$iv;
                            KtElement it = element$iv = iterator2.next();
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual(it, this.$expression)) continue;
                            bl = true;
                            break block1;
                        }
                        bl = false;
                    }
                    return bl;
                }
                {
                    this.$expression = ktExpression;
                    super(1);
                }
            };
            List<? extends ValueArgument> list2 = $this$getValueArgumentForExpression.getValueArguments();
            Intrinsics.checkExpressionValueIsNotNull(list2, "valueArguments");
            Iterable $this$firstOrNull$iv = list2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ValueArgument it = (ValueArgument)element$iv;
                boolean bl = false;
                Object object = it;
                if (!(object != null && (object = object.getArgumentExpression()) != null ? $fun$isParenthesizedExpression$2.invoke((KtElement)object) : false)) continue;
                v2 = element$iv;
                break block1;
            }
            v2 = null;
        }
        return v2;
    }

    @Nullable
    public static final KtExpression getCalleeExpressionIfAny(@Nullable KtElement $this$getCalleeExpressionIfAny) {
        KtElement element = $this$getCalleeExpressionIfAny instanceof KtExpression ? (KtElement)KtPsiUtil.deparenthesize((KtExpression)$this$getCalleeExpressionIfAny) : $this$getCalleeExpressionIfAny;
        KtElement ktElement = element;
        return ktElement instanceof KtSimpleNameExpression ? (KtExpression)element : (ktElement instanceof KtCallElement ? ((KtCallElement)element).getCalleeExpression() : (ktElement instanceof KtQualifiedExpression ? CallUtilKt.getCalleeExpressionIfAny(((KtQualifiedExpression)element).getSelectorExpression()) : (ktElement instanceof KtOperationExpression ? (KtExpression)((KtOperationExpression)element).getOperationReference() : null)));
    }

    @Nullable
    public static final Call getCall(@NotNull KtElement $this$getCall, @NotNull BindingContext context2) {
        KtExpression reference;
        KtExpression ktExpression;
        KtProperty subjectVariable;
        KtElement element;
        Intrinsics.checkParameterIsNotNull($this$getCall, "$this$getCall");
        Intrinsics.checkParameterIsNotNull(context2, "context");
        KtElement ktElement = element = $this$getCall instanceof KtExpression ? (KtElement)KtPsiUtil.deparenthesize((KtExpression)$this$getCall) : $this$getCall;
        if (element == null) {
            return null;
        }
        if (element instanceof KtCallElement && ((KtCallElement)element).getCalleeExpression() == null) {
            return null;
        }
        if (element instanceof KtWhenExpression && (subjectVariable = ((KtWhenExpression)element).getSubjectVariable()) != null) {
            return CallUtilKt.getCall(subjectVariable, context2);
        }
        PsiElement parent2 = element.getParent();
        PsiElement psiElement = parent2;
        if (psiElement instanceof KtInstanceExpressionWithLabel) {
            ktExpression = (KtExpression)parent2;
        } else if (psiElement instanceof KtUserType) {
            PsiElement psiElement2 = ((KtUserType)parent2).getParent();
            Intrinsics.checkExpressionValueIsNotNull(psiElement2, "parent.parent");
            PsiElement psiElement3 = psiElement2.getParent();
            if (!(psiElement3 instanceof KtConstructorCalleeExpression)) {
                psiElement3 = null;
            }
            ktExpression = (KtConstructorCalleeExpression)psiElement3;
        } else {
            ktExpression = reference = CallUtilKt.getCalleeExpressionIfAny(element);
        }
        if (reference != null) {
            return (Call)context2.get(BindingContext.CALL, reference);
        }
        return (Call)context2.get(BindingContext.CALL, element);
    }

    @Nullable
    public static final Call getParentCall(@NotNull KtElement $this$getParentCall, @NotNull BindingContext context2, boolean strict) {
        KtElement parent2;
        Intrinsics.checkParameterIsNotNull($this$getParentCall, "$this$getParentCall");
        Intrinsics.checkParameterIsNotNull(context2, "context");
        Class[] callExpressionTypes = new Class[]{KtSimpleNameExpression.class, KtCallElement.class, KtBinaryExpression.class, KtUnaryExpression.class, KtArrayAccessExpression.class};
        KtElement ktElement = parent2 = strict ? (KtElement)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentCall, Arrays.copyOf(callExpressionTypes, callExpressionTypes.length)) : (KtElement)PsiTreeUtil.getNonStrictParentOfType($this$getParentCall, Arrays.copyOf(callExpressionTypes, callExpressionTypes.length));
        return ktElement != null ? CallUtilKt.getCall(ktElement, context2) : null;
    }

    public static /* synthetic */ Call getParentCall$default(KtElement ktElement, BindingContext bindingContext, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return CallUtilKt.getParentCall(ktElement, bindingContext, bl);
    }

    @Nullable
    public static final ResolvedCall<? extends CallableDescriptor> getResolvedCall(@Nullable Call $this$getResolvedCall, @NotNull BindingContext context2) {
        Intrinsics.checkParameterIsNotNull(context2, "context");
        return (ResolvedCall)context2.get(BindingContext.RESOLVED_CALL, $this$getResolvedCall);
    }

    @Nullable
    public static final ResolvedCall<? extends CallableDescriptor> getResolvedCall(@Nullable KtElement $this$getResolvedCall, @NotNull BindingContext context2) {
        Intrinsics.checkParameterIsNotNull(context2, "context");
        Object object = $this$getResolvedCall;
        return object != null && (object = CallUtilKt.getCall((KtElement)object, context2)) != null ? CallUtilKt.getResolvedCall((Call)object, context2) : null;
    }

    @Nullable
    public static final ResolvedCall<? extends CallableDescriptor> getParentResolvedCall(@Nullable KtElement $this$getParentResolvedCall, @NotNull BindingContext context2, boolean strict) {
        Intrinsics.checkParameterIsNotNull(context2, "context");
        Object object = $this$getParentResolvedCall;
        return object != null && (object = CallUtilKt.getParentCall((KtElement)object, context2, strict)) != null ? CallUtilKt.getResolvedCall((Call)object, context2) : null;
    }

    public static /* synthetic */ ResolvedCall getParentResolvedCall$default(KtElement ktElement, BindingContext bindingContext, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return CallUtilKt.getParentResolvedCall(ktElement, bindingContext, bl);
    }

    @NotNull
    public static final Call getCallWithAssert(@NotNull KtElement $this$getCallWithAssert, @NotNull BindingContext context2) {
        Intrinsics.checkParameterIsNotNull($this$getCallWithAssert, "$this$getCallWithAssert");
        Intrinsics.checkParameterIsNotNull(context2, "context");
        Call $this$sure$iv = CallUtilKt.getCall($this$getCallWithAssert, context2);
        boolean $i$f$sure = false;
        Call call2 = $this$sure$iv;
        if (call2 == null) {
            String string2;
            boolean bl = false;
            String string3 = string2 = "No call for " + PsiUtilsKt.getTextWithLocation($this$getCallWithAssert);
            throw (Throwable)((Object)new AssertionError((Object)string3));
        }
        return call2;
    }

    @NotNull
    public static final ResolvedCall<? extends CallableDescriptor> getResolvedCallWithAssert(@NotNull KtElement $this$getResolvedCallWithAssert, @NotNull BindingContext context2) {
        Intrinsics.checkParameterIsNotNull($this$getResolvedCallWithAssert, "$this$getResolvedCallWithAssert");
        Intrinsics.checkParameterIsNotNull(context2, "context");
        ResolvedCall<? extends CallableDescriptor> $this$sure$iv = CallUtilKt.getResolvedCall($this$getResolvedCallWithAssert, context2);
        boolean $i$f$sure = false;
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = $this$sure$iv;
        if (resolvedCall2 == null) {
            String string2;
            boolean bl = false;
            String string3 = string2 = "No resolved call for " + PsiUtilsKt.getTextWithLocation($this$getResolvedCallWithAssert);
            throw (Throwable)((Object)new AssertionError((Object)string3));
        }
        return resolvedCall2;
    }

    @NotNull
    public static final ResolvedCall<? extends CallableDescriptor> getResolvedCallWithAssert(@NotNull Call $this$getResolvedCallWithAssert, @NotNull BindingContext context2) {
        Intrinsics.checkParameterIsNotNull($this$getResolvedCallWithAssert, "$this$getResolvedCallWithAssert");
        Intrinsics.checkParameterIsNotNull(context2, "context");
        ResolvedCall<? extends CallableDescriptor> $this$sure$iv = CallUtilKt.getResolvedCall($this$getResolvedCallWithAssert, context2);
        boolean $i$f$sure = false;
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = $this$sure$iv;
        if (resolvedCall2 == null) {
            String string2;
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder().append("No resolved call for ");
            KtElement ktElement = $this$getResolvedCallWithAssert.getCallElement();
            Intrinsics.checkExpressionValueIsNotNull(ktElement, "this.callElement");
            String string3 = string2 = stringBuilder.append(PsiUtilsKt.getTextWithLocation(ktElement)).toString();
            throw (Throwable)((Object)new AssertionError((Object)string3));
        }
        return resolvedCall2;
    }

    @NotNull
    public static final ResolvedCall<? extends FunctionDescriptor> getFunctionResolvedCallWithAssert(@NotNull KtExpression $this$getFunctionResolvedCallWithAssert, @NotNull BindingContext context2) {
        Intrinsics.checkParameterIsNotNull($this$getFunctionResolvedCallWithAssert, "$this$getFunctionResolvedCallWithAssert");
        Intrinsics.checkParameterIsNotNull(context2, "context");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCallWithAssert($this$getFunctionResolvedCallWithAssert, context2);
        boolean bl = resolvedCall2.getResultingDescriptor() instanceof FunctionDescriptor;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "ResolvedCall for this expression must be ResolvedCall<? extends FunctionDescriptor>: " + PsiUtilsKt.getTextWithLocation($this$getFunctionResolvedCallWithAssert);
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        if (resolvedCall3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.calls.model.ResolvedCall<out org.jetbrains.kotlin.descriptors.FunctionDescriptor>");
        }
        return resolvedCall3;
    }

    @NotNull
    public static final ResolvedCall<? extends PropertyDescriptor> getPropertyResolvedCallWithAssert(@NotNull KtExpression $this$getPropertyResolvedCallWithAssert, @NotNull BindingContext context2) {
        Intrinsics.checkParameterIsNotNull($this$getPropertyResolvedCallWithAssert, "$this$getPropertyResolvedCallWithAssert");
        Intrinsics.checkParameterIsNotNull(context2, "context");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCallWithAssert($this$getPropertyResolvedCallWithAssert, context2);
        boolean bl = resolvedCall2.getResultingDescriptor() instanceof PropertyDescriptor;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "ResolvedCall for this expression must be ResolvedCall<? extends PropertyDescriptor>: " + PsiUtilsKt.getTextWithLocation($this$getPropertyResolvedCallWithAssert);
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        if (resolvedCall3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.calls.model.ResolvedCall<out org.jetbrains.kotlin.descriptors.PropertyDescriptor>");
        }
        return resolvedCall3;
    }

    @NotNull
    public static final ResolvedCall<? extends VariableDescriptor> getVariableResolvedCallWithAssert(@NotNull KtExpression $this$getVariableResolvedCallWithAssert, @NotNull BindingContext context2) {
        Intrinsics.checkParameterIsNotNull($this$getVariableResolvedCallWithAssert, "$this$getVariableResolvedCallWithAssert");
        Intrinsics.checkParameterIsNotNull(context2, "context");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCallWithAssert($this$getVariableResolvedCallWithAssert, context2);
        boolean bl = resolvedCall2.getResultingDescriptor() instanceof VariableDescriptor;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "ResolvedCall for this expression must be ResolvedCall<? extends PropertyDescriptor>: " + PsiUtilsKt.getTextWithLocation($this$getVariableResolvedCallWithAssert);
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        if (resolvedCall3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.calls.model.ResolvedCall<out org.jetbrains.kotlin.descriptors.VariableDescriptor>");
        }
        return resolvedCall3;
    }

    @Nullable
    public static final KotlinType getType(@NotNull KtExpression $this$getType, @NotNull BindingContext context2) {
        Intrinsics.checkParameterIsNotNull($this$getType, "$this$getType");
        Intrinsics.checkParameterIsNotNull(context2, "context");
        KotlinType type2 = context2.getType($this$getType);
        if (type2 != null) {
            return type2;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall($this$getType, context2);
        if (resolvedCall2 instanceof VariableAsFunctionResolvedCall) {
            VariableDescriptor variableDescriptor = ((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getVariableCall().getResultingDescriptor();
            Intrinsics.checkExpressionValueIsNotNull(variableDescriptor, "resolvedCall.variableCall.resultingDescriptor");
            return variableDescriptor.getType();
        }
        return null;
    }

    public static final boolean isFakeElement(@NotNull KtElement $this$isFakeElement) {
        Intrinsics.checkParameterIsNotNull($this$isFakeElement, "$this$isFakeElement");
        PsiFile file2 = $this$isFakeElement.getContainingFile();
        return file2 instanceof KtFile && KtPsiFactoryKt.getDoNotAnalyze((KtFile)file2) != null;
    }

    public static final boolean isFakePsiElement(@NotNull PsiElement $this$isFakePsiElement) {
        Intrinsics.checkParameterIsNotNull($this$isFakePsiElement, "$this$isFakePsiElement");
        return $this$isFakePsiElement instanceof KtElement && CallUtilKt.isFakeElement((KtElement)$this$isFakePsiElement);
    }

    public static final boolean isSafeCall(@NotNull Call $this$isSafeCall) {
        Intrinsics.checkParameterIsNotNull($this$isSafeCall, "$this$isSafeCall");
        if ($this$isSafeCall instanceof CallTransformer.CallForImplicitInvoke) {
            Call call2 = ((CallTransformer.CallForImplicitInvoke)$this$isSafeCall).getOuterCall();
            Intrinsics.checkExpressionValueIsNotNull(call2, "outerCall");
            if (call2.isSemanticallyEquivalentToSafeCall()) {
                return true;
            }
        }
        return $this$isSafeCall.isSemanticallyEquivalentToSafeCall();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isCallableReference(@NotNull Call $this$isCallableReference) {
        Intrinsics.checkParameterIsNotNull($this$isCallableReference, "$this$isCallableReference");
        KtElement ktElement = $this$isCallableReference.getCallElement();
        Intrinsics.checkExpressionValueIsNotNull(ktElement, "callElement");
        KtElement callElement = ktElement;
        if (!(callElement instanceof KtNameReferenceExpression)) return false;
        PsiElement psiElement = ((KtNameReferenceExpression)callElement).getParent();
        if (!(psiElement instanceof KtCallableReferenceExpression)) {
            psiElement = null;
        }
        KtCallableReferenceExpression ktCallableReferenceExpression = (KtCallableReferenceExpression)psiElement;
        if (!Intrinsics.areEqual(ktCallableReferenceExpression != null ? ktCallableReferenceExpression.getCallableReference() : null, callElement)) return false;
        return true;
    }

    @NotNull
    public static final KotlinLookupLocation createLookupLocation(@NotNull Call $this$createLookupLocation) {
        Intrinsics.checkParameterIsNotNull($this$createLookupLocation, "$this$createLookupLocation");
        KtExpression calleeExpression = $this$createLookupLocation.getCalleeExpression();
        KtElement ktElement = calleeExpression != null && !CallUtilKt.isFakeElement(calleeExpression) ? (KtElement)calleeExpression : $this$createLookupLocation.getCallElement();
        Intrinsics.checkExpressionValueIsNotNull(ktElement, "if (calleeExpression != \u2026\n        else callElement");
        KtElement element = ktElement;
        return new KotlinLookupLocation(element);
    }

    @Nullable
    public static final KtExpression getFirstArgumentExpression(@NotNull ResolvedCall<?> $this$getFirstArgumentExpression) {
        KtExpression ktExpression;
        Intrinsics.checkParameterIsNotNull($this$getFirstArgumentExpression, "$this$getFirstArgumentExpression");
        List<ResolvedValueArgument> list2 = $this$getFirstArgumentExpression.getValueArgumentsByIndex();
        if (list2 != null) {
            List<ResolvedValueArgument> list3 = list2;
            boolean bl = false;
            boolean bl2 = false;
            List<ResolvedValueArgument> $this$run = list3;
            boolean bl3 = false;
            ResolvedValueArgument resolvedValueArgument = $this$run.get(0);
            Intrinsics.checkExpressionValueIsNotNull(resolvedValueArgument, "get(0)");
            ktExpression = resolvedValueArgument.getArguments().get(0).getArgumentExpression();
        } else {
            ktExpression = null;
        }
        return ktExpression;
    }

    @Nullable
    public static final KtExpression getReceiverExpression(@NotNull ResolvedCall<?> $this$getReceiverExpression) {
        Object object;
        Intrinsics.checkParameterIsNotNull($this$getReceiverExpression, "$this$getReceiverExpression");
        ReceiverValue $this$safeAs$iv = $this$getReceiverExpression.getExtensionReceiver();
        boolean $i$f$safeAs = false;
        ReceiverValue receiverValue = $this$safeAs$iv;
        if (!(receiverValue instanceof ExpressionReceiver)) {
            receiverValue = null;
        }
        if ((object = (ExpressionReceiver)receiverValue) == null || (object = object.getExpression()) == null) {
            $this$safeAs$iv = $this$getReceiverExpression.getDispatchReceiver();
            $i$f$safeAs = false;
            ReceiverValue receiverValue2 = $this$safeAs$iv;
            if (!(receiverValue2 instanceof ExpressionReceiver)) {
                receiverValue2 = null;
            }
            ExpressionReceiver expressionReceiver = (ExpressionReceiver)receiverValue2;
            object = expressionReceiver != null ? expressionReceiver.getExpression() : null;
        }
        return object;
    }

    public static final boolean isTrailingLambdaOnNewLIne(@NotNull KtLambdaExpression $this$isTrailingLambdaOnNewLIne) {
        Intrinsics.checkParameterIsNotNull($this$isTrailingLambdaOnNewLIne, "$this$isTrailingLambdaOnNewLIne");
        PsiElement psiElement = $this$isTrailingLambdaOnNewLIne.getParent();
        if (psiElement != null) {
            PsiElement $this$safeAs$iv = psiElement;
            boolean $i$f$safeAs = false;
            PsiElement psiElement2 = $this$safeAs$iv;
            if (!(psiElement2 instanceof KtLambdaArgument)) {
                psiElement2 = null;
            }
            if ((psiElement = (KtLambdaArgument)psiElement2) != null) {
                PsiElement psiElement3 = psiElement;
                boolean bl = false;
                boolean bl2 = false;
                PsiElement lambdaArgument = psiElement3;
                boolean bl3 = false;
                for (PsiElement prevSibling = ((ASTDelegatePsiElement)lambdaArgument).getPrevSibling(); prevSibling != null && !(prevSibling instanceof KtElement); prevSibling = prevSibling.getPrevSibling()) {
                    if (!(prevSibling instanceof PsiWhiteSpace) || !prevSibling.textContains('\n')) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static final void reportTrailingLambdaErrorOr(@NotNull BindingTrace $this$reportTrailingLambdaErrorOr, @Nullable KtExpression expression2, @NotNull Function1<? super KtExpression, ? extends Diagnostic> originalDiagnostic) {
        block2: {
            int $i$f$reportTrailingLambdaErrorOr = 0;
            Intrinsics.checkParameterIsNotNull($this$reportTrailingLambdaErrorOr, "$this$reportTrailingLambdaErrorOr");
            Intrinsics.checkParameterIsNotNull(originalDiagnostic, "originalDiagnostic");
            KtExpression ktExpression = expression2;
            if (ktExpression == null) break block2;
            KtExpression ktExpression2 = ktExpression;
            boolean bl = false;
            boolean bl2 = false;
            KtExpression expr = ktExpression2;
            boolean bl3 = false;
            if (expr instanceof KtLambdaExpression && CallUtilKt.isTrailingLambdaOnNewLIne((KtLambdaExpression)expr)) {
                $this$reportTrailingLambdaErrorOr.report(Errors.UNEXPECTED_TRAILING_LAMBDA_ON_A_NEW_LINE.on((KtLambdaExpression)expr));
            } else {
                $this$reportTrailingLambdaErrorOr.report(originalDiagnostic.invoke(expr));
            }
        }
    }
}

