/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.AttributeList;
import org.jdom.Content;
import org.jdom.ContentList;
import org.jdom.DocType;
import org.jdom.IllegalAddException;
import org.jdom.IllegalNameException;
import org.jdom.Namespace;
import org.jdom.Parent;
import org.jdom.Text;
import org.jdom.Verifier;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;

public class Element
extends Content
implements Parent {
    protected String name;
    protected Namespace namespace;
    transient List<Namespace> additionalNamespaces = null;
    transient AttributeList attributes = null;
    transient ContentList content = new ContentList(this);

    protected Element() {
        super(Content.CType.Element);
    }

    public Element(String name, Namespace namespace) {
        super(Content.CType.Element);
        this.setName(name);
        this.setNamespace(namespace);
    }

    public Element(String name) {
        this(name, null);
    }

    public String getName() {
        return this.name;
    }

    public Element setName(String name) {
        String reason = Verifier.checkElementName(name);
        if (reason != null) {
            throw new IllegalNameException(name, "element", reason);
        }
        this.name = name;
        return this;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public Element setNamespace(Namespace namespace) {
        String reason;
        if (namespace == null) {
            namespace = Namespace.NO_NAMESPACE;
        }
        if (this.additionalNamespaces != null && (reason = Verifier.checkNamespaceCollision(namespace, this.getAdditionalNamespaces())) != null) {
            throw new IllegalAddException(this, namespace, reason);
        }
        if (this.hasAttributes()) {
            for (Attribute a : this.getAttributes()) {
                String reason2 = Verifier.checkNamespaceCollision(namespace, a);
                if (reason2 == null) continue;
                throw new IllegalAddException(this, namespace, reason2);
            }
        }
        this.namespace = namespace;
        return this;
    }

    public String getNamespaceURI() {
        return this.namespace.getURI();
    }

    public String getQualifiedName() {
        if ("".equals(this.namespace.getPrefix())) {
            return this.getName();
        }
        return this.namespace.getPrefix() + ':' + this.name;
    }

    public void addNamespaceDeclaration(Namespace additionalNamespace) {
        if (this.additionalNamespaces == null) {
            this.additionalNamespaces = new ArrayList<Namespace>(5);
        }
        for (Namespace ns : this.additionalNamespaces) {
            if (ns != additionalNamespace) continue;
            return;
        }
        String reason = Verifier.checkNamespaceCollision(additionalNamespace, this);
        if (reason != null) {
            throw new IllegalAddException(this, additionalNamespace, reason);
        }
        this.additionalNamespaces.add(additionalNamespace);
    }

    public List<Namespace> getAdditionalNamespaces() {
        if (this.additionalNamespaces == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.additionalNamespaces);
    }

    @Override
    public String getValue() {
        StringBuilder buffer = new StringBuilder();
        for (Content child : this.getContent()) {
            if (!(child instanceof Element) && !(child instanceof Text)) continue;
            buffer.append(child.getValue());
        }
        return buffer.toString();
    }

    public String getText() {
        if (this.content.size() == 0) {
            return "";
        }
        if (this.content.size() == 1) {
            Content obj = this.content.get(0);
            if (obj instanceof Text) {
                return ((Text)obj).getText();
            }
            return "";
        }
        StringBuilder textContent = new StringBuilder();
        boolean hasText = false;
        for (int i = 0; i < this.content.size(); ++i) {
            Content obj = this.content.get(i);
            if (!(obj instanceof Text)) continue;
            textContent.append(((Text)obj).getText());
            hasText = true;
        }
        if (!hasText) {
            return "";
        }
        return textContent.toString();
    }

    public String getTextTrim() {
        return this.getText().trim();
    }

    public List<Content> getContent() {
        return this.content;
    }

    public <E extends Content> List<E> getContent(Filter<E> filter2) {
        return this.content.getView(filter2);
    }

    public Parent setContent(int index2, Collection<? extends Content> newContent) {
        this.content.remove(index2);
        this.content.addAll(index2, newContent);
        return this;
    }

    public Element addContent(Content child) {
        this.content.add(child);
        return this;
    }

    public Element addContent(Element child) {
        this.content.add(child);
        return this;
    }

    public Element addContent(Collection<? extends Content> newContent) {
        this.content.addAll(newContent);
        return this;
    }

    @Override
    public boolean removeContent(Content child) {
        return this.content.remove(child);
    }

    public boolean isAncestor(Element element) {
        Parent p = element.getParent();
        while (p instanceof Element) {
            if (p == this) {
                return true;
            }
            p = p.getParent();
        }
        return false;
    }

    public boolean hasAttributes() {
        return this.attributes != null && !this.attributes.isEmpty();
    }

    public boolean hasAdditionalNamespaces() {
        return this.additionalNamespaces != null && !this.additionalNamespaces.isEmpty();
    }

    AttributeList getAttributeList() {
        if (this.attributes == null) {
            this.attributes = new AttributeList(this);
        }
        return this.attributes;
    }

    public List<Attribute> getAttributes() {
        return this.getAttributeList();
    }

    public Attribute getAttribute(String attname) {
        return this.getAttribute(attname, Namespace.NO_NAMESPACE);
    }

    public Attribute getAttribute(String attname, Namespace ns) {
        if (this.attributes == null) {
            return null;
        }
        return this.getAttributeList().get(attname, ns);
    }

    public String getAttributeValue(String attname) {
        if (this.attributes == null) {
            return null;
        }
        return this.getAttributeValue(attname, Namespace.NO_NAMESPACE);
    }

    public String getAttributeValue(String attname, String def) {
        if (this.attributes == null) {
            return def;
        }
        return this.getAttributeValue(attname, Namespace.NO_NAMESPACE, def);
    }

    public String getAttributeValue(String attname, Namespace ns) {
        if (this.attributes == null) {
            return null;
        }
        return this.getAttributeValue(attname, ns, null);
    }

    public String getAttributeValue(String attname, Namespace ns, String def) {
        if (this.attributes == null) {
            return def;
        }
        Attribute attribute = this.getAttributeList().get(attname, ns);
        if (attribute == null) {
            return def;
        }
        return attribute.getValue();
    }

    public Element setAttribute(Attribute attribute) {
        this.getAttributeList().add(attribute);
        return this;
    }

    public boolean removeAttribute(String attname) {
        return this.removeAttribute(attname, Namespace.NO_NAMESPACE);
    }

    public boolean removeAttribute(String attname, Namespace ns) {
        if (this.attributes == null) {
            return false;
        }
        return this.getAttributeList().remove(attname, ns);
    }

    public String toString() {
        StringBuilder stringForm = new StringBuilder(64).append("[Element: <").append(this.getQualifiedName());
        String nsuri = this.getNamespaceURI();
        if (!"".equals(nsuri)) {
            stringForm.append(" [Namespace: ").append(nsuri).append("]");
        }
        stringForm.append("/>]");
        return stringForm.toString();
    }

    @Override
    public Element clone() {
        int i;
        Element element = (Element)super.clone();
        element.content = new ContentList(element);
        AttributeList attributeList = element.attributes = this.attributes == null ? null : new AttributeList(element);
        if (this.attributes != null) {
            for (i = 0; i < this.attributes.size(); ++i) {
                Attribute attribute = this.attributes.get(i);
                element.attributes.add(attribute.clone());
            }
        }
        if (this.additionalNamespaces != null) {
            element.additionalNamespaces = new ArrayList<Namespace>(this.additionalNamespaces);
        }
        for (i = 0; i < this.content.size(); ++i) {
            Content c = this.content.get(i);
            element.content.add(c.clone());
        }
        return element;
    }

    public List<Element> getChildren() {
        return this.content.getView(new ElementFilter());
    }

    public List<Element> getChildren(String cname) {
        return this.getChildren(cname, Namespace.NO_NAMESPACE);
    }

    public List<Element> getChildren(String cname, Namespace ns) {
        return this.content.getView(new ElementFilter(cname, ns));
    }

    public Element getChild(String cname, Namespace ns) {
        List<Element> elements = this.content.getView(new ElementFilter(cname, ns));
        Iterator<Element> iter = elements.iterator();
        if (iter.hasNext()) {
            return iter.next();
        }
        return null;
    }

    public Element getChild(String cname) {
        return this.getChild(cname, Namespace.NO_NAMESPACE);
    }

    @Override
    public Element detach() {
        return (Element)super.detach();
    }

    @Override
    public void canContainContent(Content child, int index2, boolean replace2) throws IllegalAddException {
        if (child instanceof DocType) {
            throw new IllegalAddException("A DocType is not allowed except at the document level");
        }
    }
}

