/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.resolve.calls.CallInfo;
import org.jetbrains.kotlin.fir.resolve.calls.CandidateCollector;
import org.jetbrains.kotlin.fir.resolve.calls.ImplicitDispatchReceiverValue;
import org.jetbrains.kotlin.fir.resolve.calls.ImplicitReceiverValue;
import org.jetbrains.kotlin.fir.resolve.calls.InferenceComponents;
import org.jetbrains.kotlin.fir.resolve.calls.MemberScopeTowerLevel;
import org.jetbrains.kotlin.fir.resolve.calls.ScopeTowerLevel;
import org.jetbrains.kotlin.fir.resolve.calls.TowerDataConsumer;
import org.jetbrains.kotlin.fir.resolve.calls.TowerDataKind;
import org.jetbrains.kotlin.fir.resolve.calls.TowerScopeLevel;
import org.jetbrains.kotlin.fir.resolve.transformers.ReturnTypeCalculator;
import org.jetbrains.kotlin.fir.scopes.FirScope;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001dH\u0002J\u001c\u0010%\u001a\u00020#2\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020!0\u0010R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\"\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/CallResolver;", "", "typeCalculator", "Lorg/jetbrains/kotlin/fir/resolve/transformers/ReturnTypeCalculator;", "components", "Lorg/jetbrains/kotlin/fir/resolve/calls/InferenceComponents;", "(Lorg/jetbrains/kotlin/fir/resolve/transformers/ReturnTypeCalculator;Lorg/jetbrains/kotlin/fir/resolve/calls/InferenceComponents;)V", "callInfo", "Lorg/jetbrains/kotlin/fir/resolve/calls/CallInfo;", "getCallInfo", "()Lorg/jetbrains/kotlin/fir/resolve/calls/CallInfo;", "setCallInfo", "(Lorg/jetbrains/kotlin/fir/resolve/calls/CallInfo;)V", "getComponents", "()Lorg/jetbrains/kotlin/fir/resolve/calls/InferenceComponents;", "scopes", "", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "getScopes", "()Ljava/util/List;", "setScopes", "(Ljava/util/List;)V", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "getTypeCalculator", "()Lorg/jetbrains/kotlin/fir/resolve/transformers/ReturnTypeCalculator;", "processImplicitReceiver", "", "towerDataConsumer", "Lorg/jetbrains/kotlin/fir/resolve/calls/TowerDataConsumer;", "implicitReceiverValue", "Lorg/jetbrains/kotlin/fir/resolve/calls/ImplicitReceiverValue;", "collector", "Lorg/jetbrains/kotlin/fir/resolve/calls/CandidateCollector;", "oldGroup", "runTowerResolver", "implicitReceiverValues", "resolve"})
public final class CallResolver {
    @Nullable
    private CallInfo callInfo;
    @Nullable
    private List<? extends FirScope> scopes;
    @NotNull
    private final ReturnTypeCalculator typeCalculator;
    @NotNull
    private final InferenceComponents components;

    @Nullable
    public final CallInfo getCallInfo() {
        return this.callInfo;
    }

    public final void setCallInfo(@Nullable CallInfo callInfo) {
        this.callInfo = callInfo;
    }

    @Nullable
    public final List<FirScope> getScopes() {
        return this.scopes;
    }

    public final void setScopes(@Nullable List<? extends FirScope> list2) {
        this.scopes = list2;
    }

    @NotNull
    public final FirSession getSession() {
        return this.components.getSession();
    }

    private final int processImplicitReceiver(TowerDataConsumer towerDataConsumer, ImplicitReceiverValue implicitReceiverValue, CandidateCollector collector2, int oldGroup) {
        int group = oldGroup;
        towerDataConsumer.consume(TowerDataKind.TOWER_LEVEL, new MemberScopeTowerLevel(this.getSession(), implicitReceiverValue, null, 4, null), collector2, group++);
        towerDataConsumer.consume(TowerDataKind.TOWER_LEVEL, new MemberScopeTowerLevel(this.getSession(), implicitReceiverValue, implicitReceiverValue), collector2, group++);
        return group;
    }

    @NotNull
    public final CandidateCollector runTowerResolver(@NotNull TowerDataConsumer towerDataConsumer, @NotNull List<? extends ImplicitReceiverValue> implicitReceiverValues) {
        Intrinsics.checkParameterIsNotNull(towerDataConsumer, "towerDataConsumer");
        Intrinsics.checkParameterIsNotNull(implicitReceiverValues, "implicitReceiverValues");
        CallInfo callInfo = this.callInfo;
        if (callInfo == null) {
            Intrinsics.throwNpe();
        }
        CandidateCollector collector2 = new CandidateCollector(callInfo, this.components);
        int group = 0;
        towerDataConsumer.consume(TowerDataKind.EMPTY, TowerScopeLevel.Empty.INSTANCE, collector2, group++);
        List<? extends FirScope> list2 = this.scopes;
        if (list2 == null) {
            Intrinsics.throwNpe();
        }
        for (FirScope firScope : list2) {
            towerDataConsumer.consume(TowerDataKind.TOWER_LEVEL, new ScopeTowerLevel(this.getSession(), firScope), collector2, group++);
        }
        boolean bl = false;
        for (ImplicitReceiverValue implicitReceiverValue : implicitReceiverValues) {
            if (implicitReceiverValue instanceof ImplicitDispatchReceiverValue) {
                boolean bl2;
                if (bl2) continue;
                if (!((FirRegularClass)((ImplicitDispatchReceiverValue)implicitReceiverValue).getBoundSymbol().getFir()).isInner()) {
                    bl2 = true;
                }
            }
            this.processImplicitReceiver(towerDataConsumer, implicitReceiverValue, collector2, group);
        }
        return collector2;
    }

    @NotNull
    public final ReturnTypeCalculator getTypeCalculator() {
        return this.typeCalculator;
    }

    @NotNull
    public final InferenceComponents getComponents() {
        return this.components;
    }

    public CallResolver(@NotNull ReturnTypeCalculator typeCalculator2, @NotNull InferenceComponents components) {
        Intrinsics.checkParameterIsNotNull(typeCalculator2, "typeCalculator");
        Intrinsics.checkParameterIsNotNull(components, "components");
        this.typeCalculator = typeCalculator2;
        this.components = components;
    }
}

