/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.FunctionLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.CoroutineIntrinsicLambdaOrigin;
import org.jetbrains.kotlin.backend.common.lower.SharedVariablesLowering;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrReturnableBlock;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetVariable;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.symbols.IrVariableSymbol;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitor;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/SharedVariablesLowering;", "Lorg/jetbrains/kotlin/backend/common/FunctionLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/BackendContext;", "(Lorg/jetbrains/kotlin/backend/common/BackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/BackendContext;", "lower", "", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "SharedVariablesTransformer", "ir.backend.common"})
public final class SharedVariablesLowering
implements FunctionLoweringPass {
    @NotNull
    private final BackendContext context;

    @Override
    public void lower(@NotNull IrFunction irFunction) {
        Intrinsics.checkParameterIsNotNull(irFunction, "irFunction");
        new SharedVariablesTransformer(irFunction).lowerSharedVariables();
    }

    @NotNull
    public final BackendContext getContext() {
        return this.context;
    }

    public SharedVariablesLowering(@NotNull BackendContext context) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        this.context = context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkParameterIsNotNull(irFile, "irFile");
        FunctionLoweringPass.DefaultImpls.lower(this, irFile);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\n\u001a\u00020\u000bH\u0002J\u0006\u0010\f\u001a\u00020\u000bJ\b\u0010\r\u001a\u00020\u000bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/SharedVariablesLowering$SharedVariablesTransformer;", "", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "(Lorg/jetbrains/kotlin/backend/common/lower/SharedVariablesLowering;Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)V", "getIrFunction", "()Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "sharedVariables", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "collectSharedVariables", "", "lowerSharedVariables", "rewriteSharedVariables", "ir.backend.common"})
    private final class SharedVariablesTransformer {
        private final HashSet<IrVariable> sharedVariables;
        @NotNull
        private final IrFunction irFunction;

        public final void lowerSharedVariables() {
            this.collectSharedVariables();
            if (this.sharedVariables.isEmpty()) {
                return;
            }
            this.rewriteSharedVariables();
        }

        private final void collectSharedVariables() {
            this.irFunction.accept((IrElementVisitor)new IrElementVisitor<Unit, IrDeclarationParent>(this){
                @NotNull
                private final Set<IrVariable> relevantVars;
                final /* synthetic */ SharedVariablesTransformer this$0;

                @NotNull
                public final Set<IrVariable> getRelevantVars() {
                    return this.relevantVars;
                }

                public void visitElement(@NotNull IrElement element, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(element, "element");
                    element.acceptChildren(this, data);
                }

                public void visitDeclaration(@NotNull IrDeclaration declaration2, @Nullable IrDeclarationParent data) {
                    IrDeclarationParent irDeclarationParent;
                    Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
                    IrDeclaration irDeclaration = declaration2;
                    if (!(irDeclaration instanceof IrDeclarationParent)) {
                        irDeclaration = null;
                    }
                    if ((irDeclarationParent = (IrDeclarationParent)((Object)irDeclaration)) == null) {
                        irDeclarationParent = data;
                    }
                    IrElementVisitor.DefaultImpls.visitDeclaration(this, declaration2, irDeclarationParent);
                }

                public void visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitContainerExpression(this, expression2, expression2 instanceof IrReturnableBlock && Intrinsics.areEqual(expression2.getOrigin(), CoroutineIntrinsicLambdaOrigin.INSTANCE) ? null : data);
                }

                public void visitVariable(@NotNull IrVariable declaration2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
                    declaration2.acceptChildren(this, data);
                    if (declaration2.isVar()) {
                        this.relevantVars.add(declaration2);
                    }
                }

                public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    expression2.acceptChildren(this, data);
                    IrValueDeclaration value = expression2.getSymbol().getOwner();
                    if (CollectionsKt.contains((Iterable)this.relevantVars, value)) {
                        IrValueDeclaration irValueDeclaration = value;
                        if (irValueDeclaration == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrVariable");
                        }
                        if (Intrinsics.areEqual(((IrVariable)irValueDeclaration).getParent(), data) ^ true) {
                            SharedVariablesTransformer.access$getSharedVariables$p(this.this$0).add(value);
                        }
                    }
                }
                {
                    Set set;
                    this.this$0 = $outer;
                    collectSharedVariables.1 var3_2 = this;
                    boolean bl = false;
                    var3_2.relevantVars = set = (Set)new LinkedHashSet<E>();
                }

                public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
                    IrElementVisitor.DefaultImpls.visitAnonymousInitializer(this, declaration2, data);
                }

                public void visitBlock(@NotNull IrBlock expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitBlock(this, expression2, data);
                }

                public void visitBlockBody(@NotNull IrBlockBody body, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(body, "body");
                    IrElementVisitor.DefaultImpls.visitBlockBody(this, body, data);
                }

                public void visitBody(@NotNull IrBody body, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(body, "body");
                    IrElementVisitor.DefaultImpls.visitBody(this, body, data);
                }

                public void visitBranch(@NotNull IrBranch branch, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(branch, "branch");
                    IrElementVisitor.DefaultImpls.visitBranch(this, branch, data);
                }

                public void visitBreak(@NotNull IrBreak jump, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(jump, "jump");
                    IrElementVisitor.DefaultImpls.visitBreak(this, jump, data);
                }

                public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(jump, "jump");
                    IrElementVisitor.DefaultImpls.visitBreakContinue(this, jump, data);
                }

                public void visitCall(@NotNull IrCall expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitCall(this, expression2, data);
                }

                public void visitCallableReference(@NotNull IrCallableReference expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitCallableReference(this, expression2, data);
                }

                public void visitCatch(@NotNull IrCatch aCatch, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(aCatch, "aCatch");
                    IrElementVisitor.DefaultImpls.visitCatch(this, aCatch, data);
                }

                public void visitClass(@NotNull IrClass declaration2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
                    IrElementVisitor.DefaultImpls.visitClass(this, declaration2, data);
                }

                public void visitClassReference(@NotNull IrClassReference expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitClassReference(this, expression2, data);
                }

                public void visitComposite(@NotNull IrComposite expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitComposite(this, expression2, data);
                }

                public <T> void visitConst(@NotNull IrConst<T> expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitConst(this, expression2, data);
                }

                public void visitConstructor(@NotNull IrConstructor declaration2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
                    IrElementVisitor.DefaultImpls.visitConstructor(this, declaration2, data);
                }

                public void visitConstructorCall(@NotNull IrConstructorCall expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitConstructorCall(this, expression2, data);
                }

                public void visitContinue(@NotNull IrContinue jump, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(jump, "jump");
                    IrElementVisitor.DefaultImpls.visitContinue(this, jump, data);
                }

                public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitDeclarationReference(this, expression2, data);
                }

                public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data);
                }

                public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(loop2, "loop");
                    IrElementVisitor.DefaultImpls.visitDoWhileLoop(this, loop2, data);
                }

                public void visitDynamicExpression(@NotNull IrDynamicExpression expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitDynamicExpression(this, expression2, data);
                }

                public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitDynamicMemberExpression(this, expression2, data);
                }

                public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data);
                }

                public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(branch, "branch");
                    IrElementVisitor.DefaultImpls.visitElseBranch(this, branch, data);
                }

                public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
                }

                public void visitEnumEntry(@NotNull IrEnumEntry declaration2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
                    IrElementVisitor.DefaultImpls.visitEnumEntry(this, declaration2, data);
                }

                public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitErrorCallExpression(this, expression2, data);
                }

                public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
                    IrElementVisitor.DefaultImpls.visitErrorDeclaration(this, declaration2, data);
                }

                public void visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitErrorExpression(this, expression2, data);
                }

                public void visitExpression(@NotNull IrExpression expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitExpression(this, expression2, data);
                }

                public void visitExpressionBody(@NotNull IrExpressionBody body, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(body, "body");
                    IrElementVisitor.DefaultImpls.visitExpressionBody(this, body, data);
                }

                public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
                    IrElementVisitor.DefaultImpls.visitExternalPackageFragment(this, declaration2, data);
                }

                public void visitField(@NotNull IrField declaration2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
                    IrElementVisitor.DefaultImpls.visitField(this, declaration2, data);
                }

                public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitFieldAccess(this, expression2, data);
                }

                public void visitFile(@NotNull IrFile declaration2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
                    IrElementVisitor.DefaultImpls.visitFile(this, declaration2, data);
                }

                public void visitFunction(@NotNull IrFunction declaration2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
                    IrElementVisitor.DefaultImpls.visitFunction(this, declaration2, data);
                }

                public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitFunctionAccess(this, expression2, data);
                }

                public void visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitFunctionReference(this, expression2, data);
                }

                public void visitGetClass(@NotNull IrGetClass expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitGetClass(this, expression2, data);
                }

                public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitGetEnumValue(this, expression2, data);
                }

                public void visitGetField(@NotNull IrGetField expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitGetField(this, expression2, data);
                }

                public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitGetObjectValue(this, expression2, data);
                }

                public void visitGetValue(@NotNull IrGetValue expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitGetValue(this, expression2, data);
                }

                public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitInstanceInitializerCall(this, expression2, data);
                }

                public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
                    IrElementVisitor.DefaultImpls.visitLocalDelegatedProperty(this, declaration2, data);
                }

                public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
                }

                public void visitLoop(@NotNull IrLoop loop2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(loop2, "loop");
                    IrElementVisitor.DefaultImpls.visitLoop(this, loop2, data);
                }

                public void visitMemberAccess(@NotNull IrMemberAccessExpression expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitMemberAccess(this, expression2, data);
                }

                public void visitModuleFragment(@NotNull IrModuleFragment declaration2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
                    IrElementVisitor.DefaultImpls.visitModuleFragment(this, declaration2, data);
                }

                public void visitPackageFragment(@NotNull IrPackageFragment declaration2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
                    IrElementVisitor.DefaultImpls.visitPackageFragment(this, declaration2, data);
                }

                public void visitProperty(@NotNull IrProperty declaration2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
                    IrElementVisitor.DefaultImpls.visitProperty(this, declaration2, data);
                }

                public void visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitPropertyReference(this, expression2, data);
                }

                public void visitReturn(@NotNull IrReturn expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitReturn(this, expression2, data);
                }

                public void visitSetField(@NotNull IrSetField expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitSetField(this, expression2, data);
                }

                public void visitSetVariable(@NotNull IrSetVariable expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitSetVariable(this, expression2, data);
                }

                public void visitSimpleFunction(@NotNull IrSimpleFunction declaration2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
                    IrElementVisitor.DefaultImpls.visitSimpleFunction(this, declaration2, data);
                }

                public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitSingletonReference(this, expression2, data);
                }

                public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(spread, "spread");
                    IrElementVisitor.DefaultImpls.visitSpreadElement(this, spread, data);
                }

                public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitStringConcatenation(this, expression2, data);
                }

                public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitSuspendableExpression(this, expression2, data);
                }

                public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitSuspensionPoint(this, expression2, data);
                }

                public void visitSyntheticBody(@NotNull IrSyntheticBody body, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(body, "body");
                    IrElementVisitor.DefaultImpls.visitSyntheticBody(this, body, data);
                }

                public void visitThrow(@NotNull IrThrow expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitThrow(this, expression2, data);
                }

                public void visitTry(@NotNull IrTry aTry, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(aTry, "aTry");
                    IrElementVisitor.DefaultImpls.visitTry(this, aTry, data);
                }

                public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitTypeOperator(this, expression2, data);
                }

                public void visitTypeParameter(@NotNull IrTypeParameter declaration2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
                    IrElementVisitor.DefaultImpls.visitTypeParameter(this, declaration2, data);
                }

                public void visitValueParameter(@NotNull IrValueParameter declaration2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
                    IrElementVisitor.DefaultImpls.visitValueParameter(this, declaration2, data);
                }

                public void visitVararg(@NotNull IrVararg expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitVararg(this, expression2, data);
                }

                public void visitWhen(@NotNull IrWhen expression2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitor.DefaultImpls.visitWhen(this, expression2, data);
                }

                public void visitWhileLoop(@NotNull IrWhileLoop loop2, @Nullable IrDeclarationParent data) {
                    Intrinsics.checkParameterIsNotNull(loop2, "loop");
                    IrElementVisitor.DefaultImpls.visitWhileLoop(this, loop2, data);
                }
            }, this.irFunction);
        }

        private final void rewriteSharedVariables() {
            HashMap transformedSymbols = new HashMap();
            IrElementTransformerVoidKt.transformChildrenVoid(this.irFunction, new IrElementTransformerVoid(this, transformedSymbols){
                final /* synthetic */ SharedVariablesTransformer this$0;
                final /* synthetic */ HashMap $transformedSymbols;

                @NotNull
                public IrStatement visitVariable(@NotNull IrVariable declaration2) {
                    Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
                    IrElementTransformerVoidKt.transformChildrenVoid(declaration2, this);
                    if (!SharedVariablesTransformer.access$getSharedVariables$p(this.this$0).contains(declaration2)) {
                        return declaration2;
                    }
                    IrVariable newDeclaration = this.this$0.SharedVariablesLowering.this.getContext().getSharedVariablesManager().declareSharedVariable(declaration2);
                    newDeclaration.setParent(declaration2.getParent());
                    ((Map)this.$transformedSymbols).put(declaration2.getSymbol(), newDeclaration.getSymbol());
                    return this.this$0.SharedVariablesLowering.this.getContext().getSharedVariablesManager().defineSharedValue(declaration2, newDeclaration);
                }
                {
                    this.this$0 = $outer;
                    this.$transformedSymbols = $captured_local_variable$1;
                }
            });
            IrElementTransformerVoidKt.transformChildrenVoid(this.irFunction, new IrElementTransformerVoid(this, transformedSymbols){
                final /* synthetic */ SharedVariablesTransformer this$0;
                final /* synthetic */ HashMap $transformedSymbols;

                @NotNull
                public IrExpression visitGetValue(@NotNull IrGetValue expression2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                    IrVariableSymbol irVariableSymbol = this.getTransformedSymbol(expression2.getSymbol());
                    if (irVariableSymbol == null) {
                        return expression2;
                    }
                    IrVariableSymbol newDeclaration = irVariableSymbol;
                    return this.this$0.SharedVariablesLowering.this.getContext().getSharedVariablesManager().getSharedValue(newDeclaration, expression2);
                }

                @NotNull
                public IrExpression visitSetVariable(@NotNull IrSetVariable expression2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                    IrVariableSymbol irVariableSymbol = this.getTransformedSymbol(expression2.getSymbol());
                    if (irVariableSymbol == null) {
                        return expression2;
                    }
                    IrVariableSymbol newDeclaration = irVariableSymbol;
                    return this.this$0.SharedVariablesLowering.this.getContext().getSharedVariablesManager().setSharedValue(newDeclaration, expression2);
                }

                private final IrVariableSymbol getTransformedSymbol(IrValueSymbol oldSymbol) {
                    Map map2 = this.$transformedSymbols;
                    boolean bl = false;
                    V v = map2.get(oldSymbol);
                    if (v == null) {
                        boolean bl2 = false;
                        boolean bl3 = !CollectionsKt.contains(SharedVariablesTransformer.access$getSharedVariables$p(this.this$0), oldSymbol.getOwner());
                        boolean bl4 = false;
                        if (_Assertions.ENABLED && !bl3) {
                            boolean bl5 = false;
                            String string = "Shared variable is not transformed: " + DumpIrTreeKt.dump(oldSymbol.getOwner());
                            throw (Throwable)((Object)new AssertionError((Object)string));
                        }
                        v = null;
                    }
                    return (IrVariableSymbol)v;
                }
                {
                    this.this$0 = $outer;
                    this.$transformedSymbols = $captured_local_variable$1;
                }
            });
        }

        @NotNull
        public final IrFunction getIrFunction() {
            return this.irFunction;
        }

        public SharedVariablesTransformer(@NotNull IrFunction irFunction) {
            Intrinsics.checkParameterIsNotNull(irFunction, "irFunction");
            this.irFunction = irFunction;
            this.sharedVariables = new HashSet();
        }

        public static final /* synthetic */ HashSet access$getSharedVariables$p(SharedVariablesTransformer $this) {
            return $this.sharedVariables;
        }
    }
}

