/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.ant;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.ant.IvyCacheTask;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.report.ArtifactDownloadReport;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.tools.ant.BuildException;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.tools.ant.DirectoryScanner;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.tools.ant.Project;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.tools.ant.types.FileSet;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.tools.ant.types.PatternSet;

public class IvyCacheFileset
extends IvyCacheTask {
    private String setid;

    public String getSetid() {
        return this.setid;
    }

    public void setSetid(String id) {
        this.setid = id;
    }

    @Override
    public void setUseOrigin(boolean useOrigin) {
        if (useOrigin) {
            throw new UnsupportedOperationException("the cachefileset task does not support the useOrigin mode, since filesets require to have only one root directory. Please use the the cachepath task instead");
        }
    }

    @Override
    public void doExecute() throws BuildException {
        this.prepareAndCheck();
        if (this.setid == null) {
            throw new BuildException("setid is required in ivy cachefileset");
        }
        try {
            FileSet fileset;
            List<ArtifactDownloadReport> paths = this.getArtifactReports();
            File base = null;
            for (ArtifactDownloadReport a : paths) {
                if (a.getLocalFile() == null) continue;
                base = this.getBaseDir(base, a.getLocalFile());
            }
            if (base == null) {
                fileset = new EmptyFileSet();
            } else {
                fileset = new FileSet();
                fileset.setDir(base);
                for (ArtifactDownloadReport a : paths) {
                    if (a.getLocalFile() == null) continue;
                    PatternSet.NameEntry ne = fileset.createInclude();
                    ne.setName(this.getPath(base, a.getLocalFile()));
                }
            }
            fileset.setProject(this.getProject());
            this.getProject().addReference(this.setid, (Object)fileset);
        }
        catch (Exception ex) {
            throw new BuildException("impossible to build ivy cache fileset: " + ex, (Throwable)ex);
        }
    }

    private String getPath(File base, File file) {
        String absoluteBasePath = base.getAbsolutePath();
        int beginIndex = absoluteBasePath.length();
        if (!absoluteBasePath.endsWith(File.separator)) {
            ++beginIndex;
        }
        return file.getAbsolutePath().substring(beginIndex);
    }

    File getBaseDir(File base, File file) {
        File next;
        if (base == null) {
            return file.getParentFile().getAbsoluteFile();
        }
        Iterator bases = this.getParents(base).iterator();
        Iterator fileParents = this.getParents(file.getAbsoluteFile()).iterator();
        File result = null;
        while (bases.hasNext() && fileParents.hasNext() && (next = (File)bases.next()).equals(fileParents.next())) {
            result = next;
        }
        return result;
    }

    private LinkedList getParents(File file) {
        LinkedList<File> r = new LinkedList<File>();
        while (file != null) {
            r.addFirst(file);
            file = file.getParentFile();
        }
        return r;
    }

    private static class EmptyDirectoryScanner
    extends DirectoryScanner {
        private EmptyDirectoryScanner() {
        }

        public String[] getIncludedFiles() {
            return new String[0];
        }
    }

    private static class EmptyIterator
    implements Iterator {
        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException("EmptyFileSet Iterator");
        }

        @Override
        public void remove() {
            throw new IllegalStateException("EmptyFileSet Iterator");
        }
    }

    private static class EmptyFileSet
    extends FileSet {
        private DirectoryScanner ds = new EmptyDirectoryScanner();

        private EmptyFileSet() {
        }

        public Iterator iterator() {
            return new EmptyIterator();
        }

        public Object clone() {
            return new EmptyFileSet();
        }

        public int size() {
            return 0;
        }

        public DirectoryScanner getDirectoryScanner(Project project) {
            return this.ds;
        }
    }
}

