/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.descriptors.WrappedPropertyDescriptor;
import org.jetbrains.kotlin.backend.common.descriptors.WrappedVariableDescriptor;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.jvm.lower.MoveCompanionObjectFieldsLowering;
import org.jetbrains.kotlin.backend.jvm.lower.MoveCompanionObjectFieldsLoweringKt;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.declarations.impl.IrAnonymousInitializerImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrFieldImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrVariableImpl;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetFieldImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrAnonymousInitializerSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.impl.IrFieldSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.impl.IrVariableSymbolImpl;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J$\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000b2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J$\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000b2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000bH\u0002J6\u0010\u001b\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\f\u0010\u001e\u001a\u00020\u001f*\u00020\u000bH\u0002J\u001c\u0010 \u001a\u00020!*\u00020!2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/MoveCompanionObjectFieldsLowering;", "Lorg/jetbrains/kotlin/backend/common/ClassLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "createStaticBackingField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "oldField", "propertyParent", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "fieldParent", "handleClass", "", "irClass", "fieldReplacementMap", "", "Lorg/jetbrains/kotlin/ir/symbols/IrFieldSymbol;", "handleObject", "irObject", "lower", "moveAnonymousInitializerToStaticParent", "Lorg/jetbrains/kotlin/ir/declarations/IrAnonymousInitializer;", "oldInitializer", "oldParent", "newParent", "movePropertyFieldToStaticParent", "irProperty", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "allFieldsAreJvmField", "", "transferToNewParent", "Lorg/jetbrains/kotlin/ir/expressions/IrBlockBody;", "backend"})
public final class MoveCompanionObjectFieldsLowering
implements ClassLoweringPass {
    @NotNull
    private final CommonBackendContext context;

    @Override
    public void lower(@NotNull IrClass irClass) {
        Intrinsics.checkParameterIsNotNull(irClass, "irClass");
        Map fieldReplacementMap = new LinkedHashMap();
        if (IrUtilsKt.isObject(irClass) && !irClass.isCompanion() && Intrinsics.areEqual(irClass.getVisibility(), Visibilities.LOCAL) ^ true) {
            this.handleObject(irClass, fieldReplacementMap);
        } else {
            this.handleClass(irClass, fieldReplacementMap);
        }
        MoveCompanionObjectFieldsLoweringKt.access$replaceFieldReferences(irClass, fieldReplacementMap);
    }

    private final void handleObject(IrClass irObject, Map<IrFieldSymbol, IrFieldSymbol> fieldReplacementMap) {
        irObject.getDeclarations().replaceAll(new UnaryOperator<E>(this, irObject, fieldReplacementMap){
            final /* synthetic */ MoveCompanionObjectFieldsLowering this$0;
            final /* synthetic */ IrClass $irObject;
            final /* synthetic */ Map $fieldReplacementMap;

            @NotNull
            public final IrDeclaration apply(@NotNull IrDeclaration it) {
                IrDeclaration irDeclaration;
                Intrinsics.checkParameterIsNotNull(it, "it");
                IrDeclaration irDeclaration2 = it;
                if (irDeclaration2 instanceof IrProperty) {
                    MoveCompanionObjectFieldsLowering.access$movePropertyFieldToStaticParent(this.this$0, (IrProperty)it, this.$irObject, this.$irObject, this.$fieldReplacementMap);
                    irDeclaration = it;
                } else {
                    irDeclaration = irDeclaration2 instanceof IrAnonymousInitializer ? (IrDeclaration)MoveCompanionObjectFieldsLowering.access$moveAnonymousInitializerToStaticParent(this.this$0, (IrAnonymousInitializer)it, this.$irObject, this.$irObject) : it;
                }
                return irDeclaration;
            }
            {
                this.this$0 = moveCompanionObjectFieldsLowering;
                this.$irObject = irClass;
                this.$fieldReplacementMap = map2;
            }
        });
    }

    private final void handleClass(IrClass irClass, Map<IrFieldSymbol, IrFieldSymbol> fieldReplacementMap) {
        Object v0;
        block5: {
            Iterable iterable = irClass.getDeclarations();
            Iterable iterable2 = iterable;
            Iterator iterator2 = iterable2.iterator();
            while (iterator2.hasNext()) {
                Object t = iterator2.next();
                IrDeclaration it = (IrDeclaration)t;
                if (!(it instanceof IrClass && ((IrClass)it).isCompanion())) continue;
                v0 = t;
                break block5;
            }
            v0 = null;
        }
        IrClass irClass2 = v0;
        if (irClass2 == null) {
            return;
        }
        IrClass companion = irClass2;
        if ((IrUtilsKt.isInterface(irClass) || IrUtilsKt.isAnnotationClass(irClass)) && !this.allFieldsAreJvmField(companion)) {
            return;
        }
        Iterable $receiver$iv = companion.getDeclarations();
        for (Object element$iv : $receiver$iv) {
            IrDeclaration it = (IrDeclaration)element$iv;
            IrDeclaration irDeclaration = it;
            if (irDeclaration instanceof IrProperty) {
                IrField newField = this.movePropertyFieldToStaticParent((IrProperty)it, companion, irClass, fieldReplacementMap);
                if (newField == null) continue;
                irClass.getDeclarations().add(newField);
                continue;
            }
            if (!(irDeclaration instanceof IrAnonymousInitializer)) continue;
            IrAnonymousInitializer newInitializer = this.moveAnonymousInitializerToStaticParent((IrAnonymousInitializer)it, companion, irClass);
            irClass.getDeclarations().add(newInitializer);
        }
        CollectionsKt.removeAll(companion.getDeclarations(), (Function1)handleClass.2.INSTANCE);
    }

    private final boolean allFieldsAreJvmField(@NotNull IrClass $receiver) {
        boolean bl;
        block5: {
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv = $receiver.getDeclarations();
            Iterable iterable = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                if (!(element$iv$iv instanceof IrProperty)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList();
            Iterable $receiver$iv$iv$iv = $receiver$iv$iv;
            for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                IrField irField;
                Object element$iv$iv = element$iv$iv$iv;
                IrProperty it = (IrProperty)element$iv$iv;
                if (it.getBackingField() == null) continue;
                IrField it$iv$iv = irField;
                destination$iv$iv.add(it$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $receiver$iv) {
                    IrField it = (IrField)element$iv;
                    IrAnnotationContainer irAnnotationContainer = it;
                    FqName fqName2 = JvmAbi.JVM_FIELD_ANNOTATION_FQ_NAME;
                    Intrinsics.checkExpressionValueIsNotNull(fqName2, "JVM_FIELD_ANNOTATION_FQ_NAME");
                    if (IrUtilsKt.hasAnnotation(irAnnotationContainer, fqName2)) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final IrField movePropertyFieldToStaticParent(IrProperty irProperty, IrClass propertyParent, IrClass fieldParent, Map<IrFieldSymbol, IrFieldSymbol> fieldReplacementMap) {
        if (Intrinsics.areEqual(irProperty.getOrigin(), IrDeclarationOrigin.FAKE_OVERRIDE.INSTANCE)) {
            return null;
        }
        IrField irField = irProperty.getBackingField();
        if (irField == null) {
            return null;
        }
        IrField oldField = irField;
        IrField newField = this.createStaticBackingField(oldField, propertyParent, fieldParent);
        irProperty.setBackingField(newField);
        Map<IrFieldSymbol, IrFieldSymbol> map2 = fieldReplacementMap;
        Object s = oldField.getSymbol();
        Object s2 = newField.getSymbol();
        map2.put((IrFieldSymbol)s, (IrFieldSymbol)s2);
        return newField;
    }

    private final IrAnonymousInitializer moveAnonymousInitializerToStaticParent(IrAnonymousInitializer oldInitializer, IrClass oldParent, IrClass newParent) {
        IrAnonymousInitializerImpl irAnonymousInitializerImpl;
        IrAnonymousInitializer $receiver = oldInitializer;
        IrAnonymousInitializerImpl $receiver2 = irAnonymousInitializerImpl = new IrAnonymousInitializerImpl($receiver.getStartOffset(), $receiver.getEndOffset(), $receiver.getOrigin(), new IrAnonymousInitializerSymbolImpl(newParent.getDescriptor()), true);
        $receiver2.setParent(newParent);
        $receiver2.setBody(this.transferToNewParent(oldInitializer.getBody(), oldParent, newParent));
        return irAnonymousInitializerImpl;
    }

    private final IrBlockBody transferToNewParent(@NotNull IrBlockBody $receiver, IrClass oldParent, IrClass newParent) {
        IrField objectInstanceField = this.context.getDeclarationFactory().getFieldForObjectInstance(oldParent);
        IrElementTransformer irElementTransformer = new IrElementTransformerVoid(oldParent, newParent, objectInstanceField){
            @NotNull
            private final Map<IrVariable, IrVariable> variableMap;
            final /* synthetic */ IrClass $oldParent;
            final /* synthetic */ IrClass $newParent;
            final /* synthetic */ IrField $objectInstanceField;

            @NotNull
            public final Map<IrVariable, IrVariable> getVariableMap() {
                return this.variableMap;
            }

            @NotNull
            public IrStatement visitVariable(@NotNull IrVariable declaration) {
                Intrinsics.checkParameterIsNotNull(declaration, "declaration");
                Annotations annotations2 = declaration.getDescriptor().getAnnotations();
                SourceElement sourceElement = declaration.getDescriptor().getSource();
                Intrinsics.checkExpressionValueIsNotNull(sourceElement, "declaration.descriptor.source");
                WrappedVariableDescriptor newDescriptor2 = new WrappedVariableDescriptor(annotations2, sourceElement);
                if (Intrinsics.areEqual(declaration.getParent(), this.$oldParent)) {
                    Object object = new IrVariableImpl(declaration.getStartOffset(), declaration.getEndOffset(), declaration.getOrigin(), new IrVariableSymbolImpl(newDescriptor2), declaration.getName(), declaration.getType(), declaration.isVar(), declaration.isConst(), declaration.isLateinit());
                    IrVariableImpl $receiver = object;
                    newDescriptor2.bind((IrDeclaration)$receiver);
                    $receiver.setParent(this.$newParent);
                    $receiver.setInitializer(declaration.getInitializer());
                    IrVariableImpl newVariable = object;
                    object = this.variableMap;
                    IrVariableImpl irVariableImpl = newVariable;
                    object.put(declaration, irVariableImpl);
                    return super.visitVariable(newVariable);
                }
                return super.visitVariable(declaration);
            }

            @NotNull
            public IrExpression visitGetValue(@NotNull IrGetValue expression2) {
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                if (Intrinsics.areEqual(expression2.getSymbol().getOwner(), this.$oldParent.getThisReceiver())) {
                    return new IrGetFieldImpl(expression2.getStartOffset(), expression2.getEndOffset(), (IrFieldSymbol)this.$objectInstanceField.getSymbol(), expression2.getType(), null, null, 48, null);
                }
                Object object = this.variableMap;
                IrValueDeclaration irValueDeclaration = expression2.getSymbol().getOwner();
                IrVariable irVariable = object.get(irValueDeclaration);
                if (irVariable != null) {
                    Object newVariable = object = irVariable;
                    return new IrGetValueImpl(expression2.getStartOffset(), expression2.getEndOffset(), expression2.getType(), (IrValueSymbol)newVariable.getSymbol(), expression2.getOrigin());
                }
                return super.visitGetValue(expression2);
            }
            {
                Map map2;
                this.$oldParent = $captured_local_variable$0;
                this.$newParent = $captured_local_variable$1;
                this.$objectInstanceField = $captured_local_variable$2;
                transferToNewParent.1 var4_4 = this;
                var4_4.variableMap = map2 = (Map)new LinkedHashMap<K, V>();
            }
        };
        Object d = null;
        IrBody irBody = $receiver.transform(irElementTransformer, d);
        if (irBody == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrBlockBody");
        }
        return (IrBlockBody)irBody;
    }

    /*
     * Unable to fully structure code
     */
    private final IrField createStaticBackingField(IrField oldField, IrClass propertyParent, IrClass fieldParent) {
        if (Intrinsics.areEqual(fieldParent, propertyParent)) ** GOTO lbl-1000
        v0 = oldField;
        v1 = JvmAbi.JVM_FIELD_ANNOTATION_FQ_NAME;
        Intrinsics.checkExpressionValueIsNotNull(v1, "JVM_FIELD_ANNOTATION_FQ_NAME");
        if (IrUtilsKt.hasAnnotation(v0, v1)) ** GOTO lbl-1000
        v2 = oldField.getCorrespondingProperty();
        if (v2 != null) {
            ** if (!v2.isConst()) goto lbl-1000
        }
        ** GOTO lbl-1000
lbl-1000:
        // 3 sources

        {
            v3 = oldField.getName();
            ** GOTO lbl15
        }
lbl-1000:
        // 2 sources

        {
            v4 = Name.identifier(oldField.getName().toString() + "$companion");
            v3 = v4;
            Intrinsics.checkExpressionValueIsNotNull(v4, "Name.identifier(oldField\u2026String() + \"\\$companion\")");
        }
lbl15:
        // 2 sources

        newName = v3;
        v5 = oldField.getDescriptor().getAnnotations();
        v6 = oldField.getDescriptor().getSource();
        Intrinsics.checkExpressionValueIsNotNull(v6, "oldField.descriptor.source");
        descriptor = new WrappedPropertyDescriptor(v5, v6);
        $receiver = var7_6 = new IrFieldImpl(oldField.getStartOffset(), oldField.getEndOffset(), IrDeclarationOrigin.PROPERTY_BACKING_FIELD.INSTANCE, new IrFieldSymbolImpl(descriptor), newName, oldField.getType(), oldField.getVisibility(), oldField.isFinal(), oldField.isExternal(), true);
        descriptor.bind((IrDeclaration)$receiver);
        $receiver.setParent(fieldParent);
        var9_8 = oldField.getAnnotations();
        destination$iv = $receiver.getAnnotations();
        for (T item$iv : $receiver$iv) {
            var13_12 = (IrCall)item$iv;
            var14_13 = destination$iv;
            var15_14 = it;
            var14_13.add(var15_14);
        }
        field = var7_6;
        oldInitializer = oldField.getInitializer();
        if (oldInitializer != null) {
            v7 = oldInitializer;
            v8 = propertyParent.getThisReceiver();
            if (v8 == null) {
                Intrinsics.throwNpe();
            }
            v9 = LowerUtilsKt.replaceThisByStaticReference(v7, this.context, propertyParent, v8);
            if (v9 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpressionBody");
            }
            field.setInitializer((IrExpressionBody)v9);
        }
        return field;
    }

    @NotNull
    public final CommonBackendContext getContext() {
        return this.context;
    }

    public MoveCompanionObjectFieldsLowering(@NotNull CommonBackendContext context) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        this.context = context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkParameterIsNotNull(irFile, "irFile");
        ClassLoweringPass.DefaultImpls.lower(this, irFile);
    }

    public static final /* synthetic */ IrField access$movePropertyFieldToStaticParent(MoveCompanionObjectFieldsLowering $this, IrProperty irProperty, IrClass propertyParent, IrClass fieldParent, Map fieldReplacementMap) {
        return $this.movePropertyFieldToStaticParent(irProperty, propertyParent, fieldParent, fieldReplacementMap);
    }

    public static final /* synthetic */ IrAnonymousInitializer access$moveAnonymousInitializerToStaticParent(MoveCompanionObjectFieldsLowering $this, IrAnonymousInitializer oldInitializer, IrClass oldParent, IrClass newParent) {
        return $this.moveAnonymousInitializerToStaticParent(oldInitializer, oldParent, newParent);
    }
}

