/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.core;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.ivy.osgi.core.BundleArtifact;
import org.apache.ivy.osgi.core.BundleCapability;
import org.apache.ivy.osgi.core.BundleRequirement;
import org.apache.ivy.osgi.core.ExportPackage;
import org.apache.ivy.osgi.util.Version;

public class BundleInfo {
    public static final Version DEFAULT_VERSION = new Version(1, 0, 0, null);
    private String symbolicName;
    private Version version;
    private Set<BundleRequirement> requirements = new LinkedHashSet<BundleRequirement>();
    private Set<BundleCapability> capabilities = new LinkedHashSet<BundleCapability>();
    private List<String> executionEnvironments = new ArrayList<String>();
    private String description;
    private boolean isSource = false;
    private String symbolicNameTarget;
    private Version versionTarget;
    private boolean hasInnerClasspath;
    private List<String> classpath;
    private List<BundleArtifact> artifacts = new ArrayList<BundleArtifact>();

    public BundleInfo(String name, Version version) {
        this.symbolicName = name;
        this.version = version;
    }

    public String toString() {
        StringBuffer builder = new StringBuffer();
        builder.append("BundleInfo [executionEnvironments=");
        builder.append(this.executionEnvironments);
        builder.append(", capabilities=");
        builder.append(this.capabilities);
        builder.append(", requirements=");
        builder.append(this.requirements);
        builder.append(", symbolicName=");
        builder.append(this.symbolicName);
        builder.append(", version=");
        builder.append(this.version);
        builder.append("]");
        if (this.symbolicNameTarget != null) {
            builder.append(" source of ");
            builder.append(this.symbolicNameTarget);
            builder.append("@");
            builder.append(this.versionTarget);
        }
        return builder.toString();
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public Version getVersion() {
        return this.version == null ? DEFAULT_VERSION : this.version;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void addRequirement(BundleRequirement requirement) {
        this.requirements.add(requirement);
    }

    public Set<BundleRequirement> getRequirements() {
        return this.requirements;
    }

    public void addCapability(BundleCapability capability) {
        this.capabilities.add(capability);
    }

    public List<String> getExecutionEnvironments() {
        return this.executionEnvironments;
    }

    public void setExecutionEnvironments(List<String> executionEnvironments) {
        this.executionEnvironments = executionEnvironments;
        for (String executionEnvironment : executionEnvironments) {
            this.addRequirement(new BundleRequirement("ee", executionEnvironment, null, null));
        }
    }

    public void setSource(boolean isSource) {
        this.isSource = isSource;
    }

    public void setSymbolicNameTarget(String symbolicNameTarget) {
        this.symbolicNameTarget = symbolicNameTarget;
    }

    public void setVersionTarget(Version versionTarget) {
        this.versionTarget = versionTarget;
    }

    public void setHasInnerClasspath(boolean hasInnerClasspath) {
        this.hasInnerClasspath = hasInnerClasspath;
    }

    public boolean hasInnerClasspath() {
        return this.hasInnerClasspath;
    }

    public void setClasspath(List<String> classpath) {
        this.classpath = classpath;
    }

    public void addArtifact(BundleArtifact artifact) {
        this.artifacts.add(artifact);
    }

    public List<BundleArtifact> getArtifacts() {
        return this.artifacts;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.capabilities == null ? 0 : this.capabilities.hashCode());
        result = 31 * result + (this.requirements == null ? 0 : this.requirements.hashCode());
        result = 31 * result + (this.symbolicName == null ? 0 : this.symbolicName.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        result = 31 * result + (this.executionEnvironments == null ? 0 : this.executionEnvironments.hashCode());
        result = 31 * result + (this.symbolicNameTarget == null ? 0 : this.symbolicNameTarget.hashCode());
        result = 31 * result + (this.versionTarget == null ? 0 : this.versionTarget.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BundleInfo)) {
            return false;
        }
        BundleInfo other = (BundleInfo)obj;
        if (this.capabilities == null ? other.capabilities != null : !this.capabilities.equals(other.capabilities)) {
            return false;
        }
        if (this.requirements == null ? other.requirements != null : !this.requirements.equals(other.requirements)) {
            return false;
        }
        if (this.symbolicName == null ? other.symbolicName != null : !this.symbolicName.equals(other.symbolicName)) {
            return false;
        }
        if (this.version == null ? other.version != null : !this.version.equals(other.version)) {
            return false;
        }
        if (this.executionEnvironments == null ? other.executionEnvironments != null : !this.executionEnvironments.equals(other.executionEnvironments)) {
            return false;
        }
        if (this.isSource != other.isSource) {
            return false;
        }
        if (this.symbolicNameTarget == null ? other.symbolicNameTarget != null : !this.symbolicNameTarget.equals(other.symbolicNameTarget)) {
            return false;
        }
        if (this.versionTarget == null ? other.versionTarget != null : !this.versionTarget.equals(other.versionTarget)) {
            return false;
        }
        if (this.hasInnerClasspath != other.hasInnerClasspath) {
            return false;
        }
        return !(this.classpath == null ? other.classpath != null : !this.classpath.equals(other.classpath));
    }

    public Set<ExportPackage> getExports() {
        LinkedHashSet<ExportPackage> set = new LinkedHashSet<ExportPackage>();
        for (BundleCapability capability : this.capabilities) {
            if (!"package".equals(capability.getType())) continue;
            set.add((ExportPackage)capability);
        }
        return set;
    }
}

