/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.event;

import javax.swing.event.EventListenerList;
import org.apache.ivy.core.event.FilteredIvyListener;
import org.apache.ivy.core.event.IvyEvent;
import org.apache.ivy.core.event.IvyEventFilter;
import org.apache.ivy.core.event.IvyListener;
import org.apache.ivy.plugins.repository.TransferEvent;
import org.apache.ivy.plugins.repository.TransferListener;
import org.apache.ivy.util.filter.Filter;

public class EventManager
implements TransferListener {
    private EventListenerList listeners = new EventListenerList();

    public void addIvyListener(IvyListener listener, String eventName) {
        this.addIvyListener(listener, new IvyEventFilter(eventName, null, null));
    }

    public void addIvyListener(IvyListener listener, Filter filter) {
        this.listeners.add(IvyListener.class, new FilteredIvyListener(listener, filter));
    }

    public void removeIvyListener(IvyListener listener) {
        this.listeners.remove(IvyListener.class, listener);
        IvyListener[] listeners = (IvyListener[])this.listeners.getListeners(IvyListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            if (!(listeners[i] instanceof FilteredIvyListener) || !listener.equals(((FilteredIvyListener)listeners[i]).getIvyListener())) continue;
            this.listeners.remove(IvyListener.class, listeners[i]);
        }
    }

    public void fireIvyEvent(IvyEvent evt) {
        Object[] listeners = this.listeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IvyListener.class) continue;
            ((IvyListener)listeners[i + 1]).progress(evt);
        }
    }

    public void addTransferListener(TransferListener listener) {
        this.listeners.add(TransferListener.class, listener);
    }

    protected void fireTransferEvent(TransferEvent evt) {
        Object[] listeners = this.listeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TransferListener.class) continue;
            ((TransferListener)listeners[i + 1]).transferProgress(evt);
        }
    }

    @Override
    public void transferProgress(TransferEvent evt) {
        this.fireTransferEvent(evt);
        this.fireIvyEvent(evt);
    }
}

