/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.version;

import java.util.Comparator;
import java.util.List;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.module.status.Status;
import org.apache.ivy.core.module.status.StatusManager;
import org.apache.ivy.plugins.version.AbstractVersionMatcher;

public class LatestVersionMatcher
extends AbstractVersionMatcher {
    public LatestVersionMatcher() {
        super("latest");
    }

    @Override
    public boolean isDynamic(ModuleRevisionId askedMrid) {
        return askedMrid.getRevision().startsWith("latest.");
    }

    @Override
    public boolean accept(ModuleRevisionId askedMrid, ModuleRevisionId foundMrid) {
        return true;
    }

    @Override
    public boolean needModuleDescriptor(ModuleRevisionId askedMrid, ModuleRevisionId foundMrid) {
        List statuses = StatusManager.getCurrent().getStatuses();
        Status lowest = (Status)statuses.get(statuses.size() - 1);
        String latestLowest = "latest." + lowest.getName();
        return !latestLowest.equals(askedMrid.getRevision());
    }

    @Override
    public boolean accept(ModuleRevisionId askedMrid, ModuleDescriptor foundMD) {
        String askedStatus = askedMrid.getRevision().substring("latest.".length());
        return StatusManager.getCurrent().getPriority(askedStatus) >= StatusManager.getCurrent().getPriority(foundMD.getStatus());
    }

    @Override
    public int compare(ModuleRevisionId askedMrid, ModuleRevisionId foundMrid, Comparator staticComparator) {
        return this.needModuleDescriptor(askedMrid, foundMrid) ? 0 : 1;
    }
}

