/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedDeclarationStub;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtTypeConstraint;
import org.jetbrains.kotlin.psi.KtTypeConstraintList;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterList;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtValVarKeywordOwner;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.stubs.KotlinParameterStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;
import org.jetbrains.kotlin.psi.typeRefHelpers.TypeRefHelpersKt;

public class KtParameter
extends KtNamedDeclarationStub<KotlinParameterStub>
implements KtCallableDeclaration,
KtValVarKeywordOwner {
    private static final TokenSet VAL_VAR_TOKEN_SET = TokenSet.create(KtTokens.VAL_KEYWORD, KtTokens.VAR_KEYWORD);

    public KtParameter(@NotNull ASTNode node) {
        super(node);
    }

    public KtParameter(@NotNull KotlinParameterStub stub) {
        super(stub, KtStubElementTypes.VALUE_PARAMETER);
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data) {
        return visitor2.visitParameter(this, data);
    }

    @Override
    @Nullable
    public KtTypeReference getTypeReference() {
        return (KtTypeReference)this.getStubOrPsiChild(KtStubElementTypes.TYPE_REFERENCE);
    }

    @Override
    @Nullable
    public KtTypeReference setTypeReference(@Nullable KtTypeReference typeRef) {
        return TypeRefHelpersKt.setTypeReference(this, this.getNameIdentifier(), typeRef);
    }

    @Override
    @Nullable
    public PsiElement getColon() {
        return this.findChildByType(KtTokens.COLON);
    }

    @Nullable
    public PsiElement getEqualsToken() {
        return this.findChildByType(KtTokens.EQ);
    }

    public boolean hasDefaultValue() {
        KotlinParameterStub stub = (KotlinParameterStub)this.getStub();
        if (stub != null) {
            return stub.hasDefaultValue();
        }
        return this.getDefaultValue() != null;
    }

    @Nullable
    public KtExpression getDefaultValue() {
        KotlinParameterStub stub = (KotlinParameterStub)this.getStub();
        if (stub != null && !stub.hasDefaultValue()) {
            return null;
        }
        PsiElement equalsToken = this.getEqualsToken();
        return equalsToken != null ? PsiTreeUtil.getNextSiblingOfType(equalsToken, KtExpression.class) : null;
    }

    public boolean isMutable() {
        KotlinParameterStub stub = (KotlinParameterStub)this.getStub();
        if (stub != null) {
            return stub.isMutable();
        }
        return this.findChildByType(KtTokens.VAR_KEYWORD) != null;
    }

    public boolean isVarArg() {
        KtModifierList modifierList = this.getModifierList();
        return modifierList != null && modifierList.hasModifier(KtTokens.VARARG_KEYWORD);
    }

    public boolean hasValOrVar() {
        KotlinParameterStub stub = (KotlinParameterStub)this.getStub();
        if (stub != null) {
            return stub.hasValOrVar();
        }
        return this.getValOrVarKeyword() != null;
    }

    @Override
    @Nullable
    public PsiElement getValOrVarKeyword() {
        KotlinParameterStub stub = (KotlinParameterStub)this.getStub();
        if (stub != null && !stub.hasValOrVar()) {
            return null;
        }
        return this.findChildByType(VAL_VAR_TOKEN_SET);
    }

    @Nullable
    public KtDestructuringDeclaration getDestructuringDeclaration() {
        if (this.getStub() != null) {
            return null;
        }
        return (KtDestructuringDeclaration)this.findChildByType(KtNodeTypes.DESTRUCTURING_DECLARATION);
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    public boolean isLoopParameter() {
        return this.getParent() instanceof KtForExpression;
    }

    @Override
    @Nullable
    public KtParameterList getValueParameterList() {
        return null;
    }

    @Override
    @NotNull
    public List<KtParameter> getValueParameters() {
        return Collections.emptyList();
    }

    @Override
    @Nullable
    public KtTypeReference getReceiverTypeReference() {
        return null;
    }

    @Override
    @Nullable
    public KtTypeParameterList getTypeParameterList() {
        return null;
    }

    @Override
    @Nullable
    public KtTypeConstraintList getTypeConstraintList() {
        return null;
    }

    @Override
    @NotNull
    public List<KtTypeConstraint> getTypeConstraints() {
        return Collections.emptyList();
    }

    @Override
    @NotNull
    public List<KtTypeParameter> getTypeParameters() {
        return Collections.emptyList();
    }

    @Nullable
    public KtDeclarationWithBody getOwnerFunction() {
        PsiElement parent2 = this.getParentByStub();
        if (!(parent2 instanceof KtParameterList)) {
            return null;
        }
        return ((KtParameterList)parent2).getOwnerFunction();
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        KtExpression owner = this.getOwnerFunction();
        if (owner instanceof KtPrimaryConstructor) {
            if (this.hasValOrVar()) {
                return super.getUseScope();
            }
            owner = ((KtPrimaryConstructor)owner).getContainingClassOrObject();
        }
        if (owner == null) {
            owner = PsiTreeUtil.getParentOfType((PsiElement)this, KtExpression.class);
        }
        return new LocalSearchScope(owner != null ? owner : this);
    }
}

