/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.scopes;

import kotlin.Unit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeImpl;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.LocalRedeclarationChecker;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.utils.Printer;

public final class ScopeUtils {
    private ScopeUtils() {
    }

    public static LexicalScope makeScopeForPropertyHeader(@NotNull LexicalScope parent2, @NotNull PropertyDescriptor propertyDescriptor) {
        return new LexicalScopeImpl(parent2, propertyDescriptor, false, null, LexicalScopeKind.PROPERTY_HEADER, LocalRedeclarationChecker.DO_NOTHING.INSTANCE, handler2 -> {
            for (TypeParameterDescriptor typeParameterDescriptor : propertyDescriptor.getTypeParameters()) {
                handler2.addClassifierDescriptor(typeParameterDescriptor);
            }
            return Unit.INSTANCE;
        });
    }

    @NotNull
    public static LexicalScope makeScopeForPropertyInitializer(@NotNull LexicalScope propertyHeader, @NotNull PropertyDescriptor propertyDescriptor) {
        return new LexicalScopeImpl(propertyHeader, propertyDescriptor, false, null, LexicalScopeKind.PROPERTY_INITIALIZER_OR_DELEGATE);
    }

    @NotNull
    public static LexicalScope makeScopeForDelegateConventionFunctions(@NotNull LexicalScope parent2, @NotNull VariableDescriptorWithAccessors variableDescriptor) {
        return new LexicalScopeImpl(parent2, variableDescriptor, true, variableDescriptor.getExtensionReceiverParameter(), LexicalScopeKind.PROPERTY_DELEGATE_METHOD);
    }

    @NotNull
    public static String printStructure(@Nullable MemberScope scope) {
        StringBuilder out = new StringBuilder();
        Printer p = new Printer(out);
        if (scope == null) {
            p.println("null");
        } else {
            scope.printScopeStructure(p);
        }
        return out.toString();
    }
}

