/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.elements;

import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.stubs.KotlinPropertyStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementType;
import org.jetbrains.kotlin.psi.stubs.elements.StubIndexService;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinPropertyStubImpl;

public class KtPropertyElementType
extends KtStubElementType<KotlinPropertyStub, KtProperty> {
    public KtPropertyElementType(@NotNull @NonNls String debugName) {
        super(debugName, KtProperty.class, KotlinPropertyStub.class);
    }

    @Override
    public KotlinPropertyStub createStub(@NotNull KtProperty psi, StubElement parentStub) {
        assert (!psi.isLocal()) : String.format("Should not store local property: %s, parent %s", psi.getText(), psi.getParent() != null ? psi.getParent().getText() : "<no parent>");
        return new KotlinPropertyStubImpl(parentStub, StringRef.fromString(psi.getName()), psi.isVar(), psi.isTopLevel(), psi.hasDelegate(), psi.hasDelegateExpression(), psi.hasInitializer(), psi.getReceiverTypeReference() != null, psi.getTypeReference() != null, KtPsiUtilKt.safeFqNameForLazyResolve(psi));
    }

    @Override
    public void serialize(@NotNull KotlinPropertyStub stub2, @NotNull StubOutputStream dataStream) throws IOException {
        dataStream.writeName(stub2.getName());
        dataStream.writeBoolean(stub2.isVar());
        dataStream.writeBoolean(stub2.isTopLevel());
        dataStream.writeBoolean(stub2.hasDelegate());
        dataStream.writeBoolean(stub2.hasDelegateExpression());
        dataStream.writeBoolean(stub2.hasInitializer());
        dataStream.writeBoolean(stub2.isExtension());
        dataStream.writeBoolean(stub2.hasReturnTypeRef());
        FqName fqName2 = stub2.getFqName();
        dataStream.writeName(fqName2 != null ? fqName2.asString() : null);
    }

    @Override
    @NotNull
    public KotlinPropertyStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        StringRef name = dataStream.readName();
        boolean isVar = dataStream.readBoolean();
        boolean isTopLevel = dataStream.readBoolean();
        boolean hasDelegate = dataStream.readBoolean();
        boolean hasDelegateExpression = dataStream.readBoolean();
        boolean hasInitializer = dataStream.readBoolean();
        boolean hasReceiverTypeRef = dataStream.readBoolean();
        boolean hasReturnTypeRef = dataStream.readBoolean();
        StringRef fqNameAsString = dataStream.readName();
        FqName fqName2 = fqNameAsString != null ? new FqName(fqNameAsString.toString()) : null;
        return new KotlinPropertyStubImpl(parentStub, name, isVar, isTopLevel, hasDelegate, hasDelegateExpression, hasInitializer, hasReceiverTypeRef, hasReturnTypeRef, fqName2);
    }

    @Override
    public void indexStub(@NotNull KotlinPropertyStub stub2, @NotNull IndexSink sink) {
        StubIndexService.getInstance().indexProperty(stub2, sink);
    }
}

