/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.filters.element;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.filters.ClassFilter;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ModifierFilter
extends ClassFilter {
    public final List<ModifierRestriction> myModifierRestrictions;

    public ModifierFilter(@PsiModifier.ModifierConstant String modifier, boolean hasToBe) {
        this(Collections.singletonList(new ModifierRestriction(modifier, hasToBe)));
    }

    public ModifierFilter(String ... modifiers2) {
        this(ContainerUtil.map(modifiers2, modifier -> new ModifierRestriction((String)modifier, true)));
    }

    private ModifierFilter(List<ModifierRestriction> restrictions) {
        super(PsiModifierListOwner.class);
        this.myModifierRestrictions = restrictions;
    }

    @Override
    public boolean isAcceptable(Object element, PsiElement context) {
        if (!(element instanceof PsiModifierListOwner)) {
            return false;
        }
        PsiModifierList list2 = ((PsiModifierListOwner)element).getModifierList();
        if (list2 != null) {
            for (ModifierRestriction psiModifier : this.myModifierRestrictions) {
                boolean shouldHave = psiModifier.isSet;
                if (shouldHave == list2.hasModifierProperty(psiModifier.modifierName)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("modifiers(");
        Iterator<ModifierRestriction> iter = this.myModifierRestrictions.iterator();
        while (iter.hasNext()) {
            ModifierRestriction rest = iter.next();
            sb.append(rest.modifierName).append("=").append(rest.isSet);
            if (!iter.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    private static final class ModifierRestriction {
        public final String modifierName;
        public final boolean isSet;

        ModifierRestriction(String modifierName, boolean isSet) {
            this.modifierName = modifierName;
            this.isSet = isSet;
        }
    }
}

