/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.AttributeList;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.ContentList;
import org.jdom.Element;
import org.jdom.ImmutableAttribute;
import org.jdom.ImmutableSameTypeAttributeList;
import org.jdom.JDOMInterner;
import org.jdom.Namespace;
import org.jdom.Parent;
import org.jdom.Text;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;
import org.jetbrains.annotations.NotNull;

class ImmutableElement
extends Element {
    private static final List<Attribute> EMPTY_LIST = new ImmutableSameTypeAttributeList(new String[0], -1, Namespace.NO_NAMESPACE);
    private final Content[] myContent;
    private static final Content[] EMPTY_CONTENT = new Content[0];
    private final List<Attribute> myAttributes;

    ImmutableElement(@NotNull Element origin, final @NotNull JDOMInterner interner) {
        if (origin == null) {
            ImmutableElement.$$$reportNull$$$0(0);
        }
        if (interner == null) {
            ImmutableElement.$$$reportNull$$$0(1);
        }
        Disposer.clearOwnFields(this, Conditions.alwaysTrue());
        this.name = interner.internString(origin.getName());
        List<Attribute> originAttributes = origin.getAttributes();
        String[] nameValues = new String[originAttributes.size() * 2];
        int type2 = -1;
        Namespace namespace = null;
        for (int i = 0; i < originAttributes.size(); ++i) {
            Attribute origAttribute = originAttributes.get(i);
            if (type2 == -1) {
                type2 = origAttribute.getAttributeType();
                namespace = origAttribute.getNamespace();
            } else if (type2 != origAttribute.getAttributeType() || !origAttribute.getNamespace().equals(namespace)) {
                type2 = -1;
                break;
            }
            String name = interner.internString(origAttribute.getName());
            String value = interner.internString(origAttribute.getValue());
            nameValues[i * 2] = name;
            nameValues[i * 2 + 1] = value;
        }
        List<Attribute> newAttributes = originAttributes.isEmpty() ? EMPTY_LIST : (type2 == -1 ? Collections.unmodifiableList(ContainerUtil.map(originAttributes, new Function<Attribute, Attribute>(){

            @Override
            public Attribute fun(Attribute attribute) {
                return new ImmutableAttribute(interner.internString(attribute.getName()), interner.internString(attribute.getValue()), attribute.getAttributeType(), attribute.getNamespace());
            }
        })) : new ImmutableSameTypeAttributeList(nameValues, type2, namespace));
        this.myAttributes = newAttributes;
        List<Content> origContent = origin.getContent();
        ArrayList<Content> newContent = new ArrayList<Content>(origContent.size());
        for (Content o : origContent) {
            if (o instanceof Element) {
                Element newElement = interner.internElement((Element)o);
                newContent.add(newElement);
                continue;
            }
            if (o instanceof Text) {
                Text newText = interner.internText((Text)o);
                newContent.add(newText);
                continue;
            }
            if (o instanceof Comment) continue;
            throw new RuntimeException(o.toString());
        }
        this.myContent = newContent.isEmpty() ? EMPTY_CONTENT : newContent.toArray(EMPTY_CONTENT);
        this.namespace = origin.getNamespace();
        for (Namespace addns : origin.getAdditionalNamespaces()) {
            super.addNamespaceDeclaration(addns);
        }
    }

    @Override
    @NotNull
    public List<Content> getContent() {
        List<Content> list2 = Arrays.asList(this.myContent);
        if (list2 == null) {
            ImmutableElement.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @Override
    public <T extends Content> List<T> getContent(final Filter<T> filter2) {
        return ContainerUtil.filter(this.myContent, new Condition<Content>(){

            @Override
            public boolean value(Content content) {
                return filter2.matches(content);
            }
        });
    }

    @Override
    @NotNull
    public List<Element> getChildren() {
        List<Element> list2 = this.getContent(new ElementFilter());
        if (list2 == null) {
            ImmutableElement.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<Element> getChildren(String name, Namespace ns) {
        List<Element> list2 = this.getContent(new ElementFilter(name, ns));
        if (list2 == null) {
            ImmutableElement.$$$reportNull$$$0(4);
        }
        return list2;
    }

    @Override
    public Element getChild(String name, Namespace ns) {
        List<Element> children2 = this.getChildren(name, ns);
        return children2.isEmpty() ? null : children2.get(0);
    }

    @Override
    public String getText() {
        if (this.myContent.length == 0) {
            return "";
        }
        if (this.myContent.length == 1) {
            Content obj = this.myContent[0];
            if (obj instanceof Text) {
                return ((Text)obj).getText();
            }
            return "";
        }
        StringBuilder textContent = new StringBuilder();
        boolean hasText = false;
        for (Content content : this.myContent) {
            if (!(content instanceof Text)) continue;
            textContent.append(((Text)content).getText());
            hasText = true;
        }
        return hasText ? textContent.toString() : "";
    }

    @Override
    public List<Attribute> getAttributes() {
        return this.myAttributes;
    }

    @Override
    public Attribute getAttribute(String name, Namespace ns) {
        if (this.myAttributes instanceof ImmutableSameTypeAttributeList) {
            return ((ImmutableSameTypeAttributeList)this.myAttributes).get(name, ns);
        }
        String uri = this.namespace.getURI();
        for (int i = 0; i < this.myAttributes.size(); ++i) {
            Attribute a = this.myAttributes.get(i);
            String oldURI = a.getNamespaceURI();
            String oldName = a.getName();
            if (!oldURI.equals(uri) || !oldName.equals(name)) continue;
            return a;
        }
        return null;
    }

    @Override
    public String getAttributeValue(String name, Namespace ns, String def) {
        if (this.myAttributes instanceof ImmutableSameTypeAttributeList) {
            return ((ImmutableSameTypeAttributeList)this.myAttributes).getValue(name, ns, def);
        }
        Attribute attribute = this.getAttribute(name, ns);
        return attribute == null ? def : attribute.getValue();
    }

    @Override
    public Element clone() {
        Element element = new Element();
        element.content = new ContentList(element);
        element.attributes = new AttributeList(element);
        element.name = this.getName();
        element.namespace = this.getNamespace();
        List<Attribute> attributes = this.getAttributes();
        if (attributes != null) {
            for (Attribute attribute : attributes) {
                element.attributes.add(attribute.clone());
            }
        }
        if (this.additionalNamespaces != null) {
            element.additionalNamespaces = new ArrayList<Namespace>(this.additionalNamespaces);
        }
        List<Content> content = this.getContent();
        for (Content c : content) {
            element.content.add(c.clone());
        }
        return element;
    }

    @Override
    public Element getParent() {
        throw ImmutableElement.immutableError(this);
    }

    public boolean attributesEqual(Element element) {
        List<Attribute> attrs = element.getAttributes();
        if (this.myAttributes instanceof ImmutableSameTypeAttributeList) {
            return this.myAttributes.equals(attrs);
        }
        if (this.myAttributes.size() != attrs.size()) {
            return false;
        }
        for (int i = 0; i < this.myAttributes.size(); ++i) {
            Attribute oAttr;
            Attribute attribute = this.myAttributes.get(i);
            if (ImmutableElement.attributesEqual(attribute, oAttr = attrs.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean attributesEqual(Attribute a1, Attribute a2) {
        return a1.getName().equals(a2.getName()) && Comparing.equal(a1.getValue(), a2.getValue()) && a1.getAttributeType() == a2.getAttributeType() && a1.getNamespace().equals(a2.getNamespace());
    }

    @NotNull
    static IncorrectOperationException immutableError(Object element) {
        IncorrectOperationException incorrectOperationException = new IncorrectOperationException("Can't change immutable element: " + element.getClass() + ". To obtain mutable Element call .clone()");
        if (incorrectOperationException == null) {
            ImmutableElement.$$$reportNull$$$0(5);
        }
        return incorrectOperationException;
    }

    @Override
    public Content detach() {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public Element setName(String name) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public Element setNamespace(Namespace namespace) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public void addNamespaceDeclaration(Namespace additionalNamespace) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public Element addContent(Content child) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public Element addContent(Element child) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public Element addContent(Collection<? extends Content> newContent) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public boolean removeContent(Content child) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public Element setAttribute(@NotNull Attribute attribute) {
        if (attribute == null) {
            ImmutableElement.$$$reportNull$$$0(10);
        }
        throw ImmutableElement.immutableError(this);
    }

    @Override
    protected Content setParent(Parent parent2) {
        throw ImmutableElement.immutableError(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "origin";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interner";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jdom/ImmutableElement";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jdom/ImmutableElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "immutableError";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setAttribute";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

