/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.callTranslator;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsArrayAccess;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.translate.callTranslator.CallInfo;
import org.jetbrains.kotlin.js.translate.callTranslator.CallInfoExtensionsKt;
import org.jetbrains.kotlin.js.translate.callTranslator.DynamicInvokeAndBracketAccessCallCase$WhenMappings;
import org.jetbrains.kotlin.js.translate.callTranslator.FunctionCallCase;
import org.jetbrains.kotlin.js.translate.callTranslator.FunctionCallInfo;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\f\u0010\u0007\u001a\u00020\b*\u00020\u0006H\u0014\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/js/translate/callTranslator/DynamicInvokeAndBracketAccessCallCase;", "Lorg/jetbrains/kotlin/js/translate/callTranslator/FunctionCallCase;", "()V", "canApply", "", "callInfo", "Lorg/jetbrains/kotlin/js/translate/callTranslator/FunctionCallInfo;", "dispatchReceiver", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "js.translator"})
public final class DynamicInvokeAndBracketAccessCallCase
extends FunctionCallCase {
    public static final DynamicInvokeAndBracketAccessCallCase INSTANCE;

    public final boolean canApply(@NotNull FunctionCallInfo callInfo) {
        Intrinsics.checkParameterIsNotNull(callInfo, "callInfo");
        Call call2 = callInfo.getResolvedCall().getCall();
        Intrinsics.checkExpressionValueIsNotNull(call2, "callInfo.resolvedCall.call");
        return call2.getCallType() != Call.CallType.DEFAULT && DynamicCallsKt.isDynamic(CallInfoExtensionsKt.getCallableDescriptor(callInfo));
    }

    @Override
    @NotNull
    protected JsExpression dispatchReceiver(@NotNull FunctionCallInfo $receiver) {
        JsExpression jsExpression;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        List<JsExpression> arguments2 = $receiver.getArgumentsInfo().getTranslateArguments();
        Call call2 = $receiver.getResolvedCall().getCall();
        Intrinsics.checkExpressionValueIsNotNull(call2, "resolvedCall.call");
        Call.CallType callType = call2.getCallType();
        switch (DynamicInvokeAndBracketAccessCallCase$WhenMappings.$EnumSwitchMapping$0[callType.ordinal()]) {
            case 1: {
                JsExpression jsExpression2 = $receiver.getDispatchReceiver();
                if (jsExpression2 == null) {
                    Intrinsics.throwNpe();
                }
                jsExpression = new JsInvocation(jsExpression2, arguments2);
                break;
            }
            case 2: {
                jsExpression = new JsArrayAccess($receiver.getDispatchReceiver(), arguments2.get(0));
                break;
            }
            case 3: {
                JsBinaryOperation jsBinaryOperation = JsAstUtils.assignment(new JsArrayAccess($receiver.getDispatchReceiver(), arguments2.get(0)), arguments2.get(1));
                Intrinsics.checkExpressionValueIsNotNull(jsBinaryOperation, "JsAstUtils.assignment(Js\u2026uments[0]), arguments[1])");
                jsExpression = jsBinaryOperation;
                break;
            }
            default: {
                Void void_ = this.unsupported((CallInfo)$receiver, "Unsupported call type: " + (Object)((Object)callType) + ", callInfo: " + $receiver);
                throw null;
            }
        }
        return jsExpression;
    }

    private DynamicInvokeAndBracketAccessCallCase() {
    }

    static {
        DynamicInvokeAndBracketAccessCallCase dynamicInvokeAndBracketAccessCallCase;
        INSTANCE = dynamicInvokeAndBracketAccessCallCase = new DynamicInvokeAndBracketAccessCallCase();
    }
}

