/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.js;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.descriptors.DescriptorsFactory;
import org.jetbrains.kotlin.builtins.CompanionObjectMapping;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.ClassConstructorDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.PropertyDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrConstructorSymbolImpl;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\nH\u0002J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\nH\u0016J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\nH\u0016J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0007H\u0016J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/backend/js/JsDescriptorsFactory;", "Lorg/jetbrains/kotlin/backend/common/descriptors/DescriptorsFactory;", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "(Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;)V", "innerClassConstructors", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/descriptors/ClassConstructorDescriptor;", "Lorg/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;", "outerThisDescriptors", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "singletonFieldDescriptors", "createInnerClassConstructorWithOuterThisParameter", "oldDescriptor", "createObjectInstanceFieldDescriptor", "objectDescriptor", "getFieldDescriptorForEnumEntry", "enumEntryDescriptor", "getFieldDescriptorForObjectInstance", "getInnerClassConstructorWithOuterThisParameter", "innerClassConstructor", "getOuterThisFieldDescriptor", "innerClassDescriptor", "backend.js"})
public final class JsDescriptorsFactory
implements DescriptorsFactory {
    private final HashMap<ClassDescriptor, PropertyDescriptor> singletonFieldDescriptors;
    private final HashMap<ClassDescriptor, PropertyDescriptor> outerThisDescriptors;
    private final HashMap<ClassConstructorDescriptor, IrConstructorSymbol> innerClassConstructors;
    private final KotlinBuiltIns builtIns;

    @Override
    @NotNull
    public PropertyDescriptor getFieldDescriptorForEnumEntry(@NotNull ClassDescriptor enumEntryDescriptor) {
        Intrinsics.checkParameterIsNotNull(enumEntryDescriptor, "enumEntryDescriptor");
        throw (Throwable)new NotImplementedError(null, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public PropertyDescriptor getOuterThisFieldDescriptor(@NotNull ClassDescriptor innerClassDescriptor) {
        PropertyDescriptor propertyDescriptor;
        Intrinsics.checkParameterIsNotNull(innerClassDescriptor, "innerClassDescriptor");
        if (!innerClassDescriptor.isInner()) {
            throw (Throwable)((Object)new AssertionError((Object)("Class is not inner: " + innerClassDescriptor)));
        }
        Map $receiver$iv = this.outerThisDescriptors;
        Object value$iv = $receiver$iv.get(innerClassDescriptor);
        if (value$iv == null) {
            PropertyDescriptorImpl propertyDescriptorImpl;
            ClassDescriptor classDescriptor = DescriptorUtils.getContainingClass(innerClassDescriptor);
            if (classDescriptor == null) {
                throw (Throwable)((Object)new AssertionError((Object)("No containing class for inner class " + innerClassDescriptor)));
            }
            ClassDescriptor outerClassDescriptor = classDescriptor;
            PropertyDescriptorImpl $receiver = propertyDescriptorImpl = PropertyDescriptorImpl.create(innerClassDescriptor, Annotations.Companion.getEMPTY(), Modality.FINAL, Visibilities.PROTECTED, false, Name.identifier("$this"), CallableMemberDescriptor.Kind.SYNTHESIZED, SourceElement.NO_SOURCE, false, true, false, false, false, false);
            ClassDescriptor classDescriptor2 = outerClassDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(classDescriptor2, "outerClassDescriptor");
            $receiver.setType((KotlinType)classDescriptor2.getDefaultType(), CollectionsKt.emptyList(), innerClassDescriptor.getThisAsReceiverParameter(), (ReceiverParameterDescriptor)null);
            $receiver.initialize(null, null);
            PropertyDescriptorImpl propertyDescriptorImpl2 = propertyDescriptorImpl;
            Intrinsics.checkExpressionValueIsNotNull(propertyDescriptorImpl2, "PropertyDescriptorImpl.c\u2026null, null)\n            }");
            PropertyDescriptor answer$iv = propertyDescriptorImpl2;
            $receiver$iv.put(innerClassDescriptor, answer$iv);
            propertyDescriptor = answer$iv;
        } else {
            void var3_3;
            propertyDescriptor = var3_3;
        }
        return propertyDescriptor;
    }

    @Override
    @NotNull
    public IrConstructorSymbol getInnerClassConstructorWithOuterThisParameter(@NotNull ClassConstructorDescriptor innerClassConstructor) {
        Object object;
        Intrinsics.checkParameterIsNotNull(innerClassConstructor, "innerClassConstructor");
        ClassDescriptor innerClass = innerClassConstructor.getContainingDeclaration();
        boolean bl = innerClass.isInner();
        if (_Assertions.ENABLED && !bl) {
            String string = "Class is not inner: " + innerClass;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Map $receiver$iv = this.innerClassConstructors;
        Object value$iv = $receiver$iv.get(innerClassConstructor);
        if (value$iv == null) {
            IrConstructorSymbol answer$iv = this.createInnerClassConstructorWithOuterThisParameter(innerClassConstructor);
            $receiver$iv.put(innerClassConstructor, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (IrConstructorSymbol)object;
    }

    /*
     * WARNING - void declaration
     */
    private final IrConstructorSymbol createInnerClassConstructorWithOuterThisParameter(ClassConstructorDescriptor oldDescriptor) {
        Collection<ValueParameterDescriptor> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        ClassConstructorDescriptorImpl newDescriptor2;
        ClassDescriptor classDescriptor = oldDescriptor.getContainingDeclaration();
        DeclarationDescriptor declarationDescriptor = classDescriptor.getContainingDeclaration();
        if (declarationDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
        }
        SimpleType outerThisType = ((ClassDescriptor)declarationDescriptor).getDefaultType();
        ClassConstructorDescriptorImpl classConstructorDescriptorImpl = newDescriptor2 = ClassConstructorDescriptorImpl.createSynthesized(classDescriptor, oldDescriptor.getAnnotations(), oldDescriptor.isPrimary(), oldDescriptor.getSource());
        Intrinsics.checkExpressionValueIsNotNull(classConstructorDescriptorImpl, "newDescriptor");
        CallableDescriptor callableDescriptor = classConstructorDescriptorImpl;
        Annotations annotations2 = Annotations.Companion.getEMPTY();
        Name name = Name.identifier("$outer");
        Intrinsics.checkExpressionValueIsNotNull(name, "Name.identifier(\"\\$outer\")");
        SimpleType simpleType2 = outerThisType;
        Intrinsics.checkExpressionValueIsNotNull(simpleType2, "outerThisType");
        KotlinType kotlinType = simpleType2;
        SourceElement sourceElement = SourceElement.NO_SOURCE;
        Intrinsics.checkExpressionValueIsNotNull(sourceElement, "SourceElement.NO_SOURCE");
        ValueParameterDescriptorImpl outerThisValueParameter = new ValueParameterDescriptorImpl(callableDescriptor, null, 0, annotations2, name, kotlinType, false, false, false, null, sourceElement);
        Collection collection2 = CollectionsKt.listOf(outerThisValueParameter);
        List<ValueParameterDescriptor> list2 = oldDescriptor.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, "oldDescriptor.valueParameters");
        Iterable iterable = list2;
        Collection collection3 = collection2;
        void var8_8 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item$iv$iv;
            collection = destination$iv$iv;
            CallableDescriptor callableDescriptor2 = newDescriptor2;
            void v11 = it;
            Intrinsics.checkExpressionValueIsNotNull(v11, "it");
            Name name2 = v11.getName();
            Intrinsics.checkExpressionValueIsNotNull(name2, "it.name");
            ValueParameterDescriptor valueParameterDescriptor2 = it.copy(callableDescriptor2, name2, it.getIndex() + 1);
            collection.add(valueParameterDescriptor2);
        }
        collection = (List)destination$iv$iv;
        List<ValueParameterDescriptor> newValueParameters = CollectionsKt.plus(collection3, (Iterable)collection);
        newDescriptor2.initialize(newValueParameters, oldDescriptor.getVisibility());
        newDescriptor2.setReturnType(oldDescriptor.getReturnType());
        return new IrConstructorSymbolImpl(newDescriptor2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public PropertyDescriptor getFieldDescriptorForObjectInstance(@NotNull ClassDescriptor objectDescriptor) {
        PropertyDescriptor propertyDescriptor;
        Intrinsics.checkParameterIsNotNull(objectDescriptor, "objectDescriptor");
        Map $receiver$iv = this.singletonFieldDescriptors;
        Object value$iv = $receiver$iv.get(objectDescriptor);
        if (value$iv == null) {
            PropertyDescriptor answer$iv = this.createObjectInstanceFieldDescriptor(objectDescriptor);
            $receiver$iv.put(objectDescriptor, answer$iv);
            propertyDescriptor = answer$iv;
        } else {
            void var3_3;
            propertyDescriptor = var3_3;
        }
        return propertyDescriptor;
    }

    private final PropertyDescriptor createObjectInstanceFieldDescriptor(ClassDescriptor objectDescriptor) {
        PropertyDescriptorImpl propertyDescriptorImpl;
        PropertyDescriptorImpl $receiver;
        boolean bl;
        boolean bl2 = bl = objectDescriptor.getKind() == ClassKind.OBJECT;
        if (_Assertions.ENABLED && !bl) {
            String string = "Should be an object: " + objectDescriptor;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        boolean isNotMappedCompanion = objectDescriptor.isCompanionObject() && !CompanionObjectMapping.INSTANCE.isMappedIntrinsicCompanionObject(objectDescriptor);
        Name name = isNotMappedCompanion ? objectDescriptor.getName() : Name.identifier("INSTANCE");
        DeclarationDescriptor containingDeclaration = isNotMappedCompanion ? objectDescriptor.getContainingDeclaration() : (DeclarationDescriptor)objectDescriptor;
        PropertyDescriptorImpl propertyDescriptorImpl2 = $receiver = (propertyDescriptorImpl = PropertyDescriptorImpl.create(containingDeclaration, Annotations.Companion.getEMPTY(), Modality.FINAL, Visibilities.PUBLIC, false, name, CallableMemberDescriptor.Kind.SYNTHESIZED, SourceElement.NO_SOURCE, false, false, false, false, false, false));
        KotlinType kotlinType = objectDescriptor.getDefaultType();
        List list2 = CollectionsKt.emptyList();
        Object v4 = null;
        Object v5 = null;
        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor");
    }

    public JsDescriptorsFactory(@NotNull KotlinBuiltIns builtIns) {
        Intrinsics.checkParameterIsNotNull(builtIns, "builtIns");
        this.builtIns = builtIns;
        this.singletonFieldDescriptors = new HashMap();
        this.outerThisDescriptors = new HashMap();
        this.innerClassConstructors = new HashMap();
    }
}

