/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBIterator;
import com.intellij.util.containers.TreeTraversal;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FilteredTraverserBase<T, Self extends FilteredTraverserBase<T, Self>>
implements Iterable<T> {
    private final Meta<T> myMeta;
    private final Function<T, ? extends Iterable<? extends T>> myTree;

    protected FilteredTraverserBase(@Nullable Meta<T> meta, @NotNull Function<T, ? extends Iterable<? extends T>> tree) {
        if (tree == null) {
            FilteredTraverserBase.$$$reportNull$$$0(0);
        }
        this.myTree = tree;
        this.myMeta = meta == null ? Meta.empty() : meta;
    }

    @NotNull
    public Function<T, ? extends Iterable<? extends T>> getTree() {
        Function<T, ? extends Iterable<? extends T>> function2 = this.myTree;
        if (function2 == null) {
            FilteredTraverserBase.$$$reportNull$$$0(1);
        }
        return function2;
    }

    @NotNull
    public final T getRoot() {
        Object t = this.myMeta.roots.iterator().next();
        if (t == null) {
            FilteredTraverserBase.$$$reportNull$$$0(2);
        }
        return t;
    }

    @NotNull
    public final Iterable<? extends T> getRoots() {
        Iterable iterable = this.myMeta.roots;
        if (iterable == null) {
            FilteredTraverserBase.$$$reportNull$$$0(3);
        }
        return iterable;
    }

    @Override
    public final Iterator<T> iterator() {
        return this.traverse().iterator();
    }

    @NotNull
    protected abstract Self newInstance(Meta<T> var1);

    @NotNull
    public final JBIterable<T> traverse(@NotNull TreeTraversal traversal) {
        if (traversal == null) {
            FilteredTraverserBase.$$$reportNull$$$0(4);
        }
        Function adjusted = new Function<T, Iterable<? extends T>>(){

            @Override
            public Iterable<? extends T> fun(T t) {
                return FilteredTraverserBase.this.children(t);
            }
        };
        JBIterable jBIterable = this.myMeta.interceptor.fun(traversal).traversal(this.getRoots(), adjusted).filter(this.myMeta.filter.AND);
        if (jBIterable == null) {
            FilteredTraverserBase.$$$reportNull$$$0(5);
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<T> traverse() {
        JBIterable<T> jBIterable = this.traverse(this.myMeta.traversal);
        if (jBIterable == null) {
            FilteredTraverserBase.$$$reportNull$$$0(6);
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<T> biOrderDfsTraversal() {
        JBIterable<T> jBIterable = this.traverse(TreeTraversal.BI_ORDER_DFS);
        if (jBIterable == null) {
            FilteredTraverserBase.$$$reportNull$$$0(7);
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<T> preOrderDfsTraversal() {
        JBIterable<T> jBIterable = this.traverse(TreeTraversal.PRE_ORDER_DFS);
        if (jBIterable == null) {
            FilteredTraverserBase.$$$reportNull$$$0(8);
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<T> postOrderDfsTraversal() {
        JBIterable<T> jBIterable = this.traverse(TreeTraversal.POST_ORDER_DFS);
        if (jBIterable == null) {
            FilteredTraverserBase.$$$reportNull$$$0(9);
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<T> bfsTraversal() {
        JBIterable<T> jBIterable = this.traverse(TreeTraversal.PLAIN_BFS);
        if (jBIterable == null) {
            FilteredTraverserBase.$$$reportNull$$$0(10);
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<T> tracingBfsTraversal() {
        JBIterable<T> jBIterable = this.traverse(TreeTraversal.TRACING_BFS);
        if (jBIterable == null) {
            FilteredTraverserBase.$$$reportNull$$$0(11);
        }
        return jBIterable;
    }

    @NotNull
    public final Self reset() {
        Self Self = this.newInstance(this.myMeta.reset());
        if (Self == null) {
            FilteredTraverserBase.$$$reportNull$$$0(12);
        }
        return Self;
    }

    @NotNull
    public final Self withRoot(@Nullable T root2) {
        Self Self = this.newInstance(this.myMeta.withRoots(ContainerUtil.createMaybeSingletonList(root2)));
        if (Self == null) {
            FilteredTraverserBase.$$$reportNull$$$0(13);
        }
        return Self;
    }

    @NotNull
    public final Self withRoots(@NotNull Iterable<? extends T> roots2) {
        if (roots2 == null) {
            FilteredTraverserBase.$$$reportNull$$$0(14);
        }
        Self Self = this.newInstance(this.myMeta.withRoots(roots2));
        if (Self == null) {
            FilteredTraverserBase.$$$reportNull$$$0(15);
        }
        return Self;
    }

    @NotNull
    public final Self withTraversal(TreeTraversal type2) {
        Self Self = this.newInstance(this.myMeta.withTraversal(type2));
        if (Self == null) {
            FilteredTraverserBase.$$$reportNull$$$0(16);
        }
        return Self;
    }

    @NotNull
    public final Self expand(@NotNull Condition<? super T> c) {
        if (c == null) {
            FilteredTraverserBase.$$$reportNull$$$0(17);
        }
        Self Self = this.newInstance(this.myMeta.expand(c));
        if (Self == null) {
            FilteredTraverserBase.$$$reportNull$$$0(18);
        }
        return Self;
    }

    @NotNull
    public final Self regard(@NotNull Condition<? super T> c) {
        if (c == null) {
            FilteredTraverserBase.$$$reportNull$$$0(19);
        }
        Self Self = this.newInstance(this.myMeta.regard(c));
        if (Self == null) {
            FilteredTraverserBase.$$$reportNull$$$0(20);
        }
        return Self;
    }

    @NotNull
    public final Self expandAndFilter(Condition<? super T> c) {
        Self Self = this.newInstance(this.myMeta.expand(c).filter(c));
        if (Self == null) {
            FilteredTraverserBase.$$$reportNull$$$0(21);
        }
        return Self;
    }

    @NotNull
    public final Self expandAndSkip(Condition<? super T> c) {
        Self Self = this.newInstance(this.myMeta.expand(c).filter(Conditions.not(c)));
        if (Self == null) {
            FilteredTraverserBase.$$$reportNull$$$0(22);
        }
        return Self;
    }

    @NotNull
    public final Self filter(@NotNull Condition<? super T> c) {
        if (c == null) {
            FilteredTraverserBase.$$$reportNull$$$0(23);
        }
        Self Self = this.newInstance(this.myMeta.filter(c));
        if (Self == null) {
            FilteredTraverserBase.$$$reportNull$$$0(24);
        }
        return Self;
    }

    @NotNull
    public final <C> JBIterable<C> filter(@NotNull Class<C> type2) {
        if (type2 == null) {
            FilteredTraverserBase.$$$reportNull$$$0(25);
        }
        JBIterable<C> jBIterable = this.traverse().filter(type2);
        if (jBIterable == null) {
            FilteredTraverserBase.$$$reportNull$$$0(26);
        }
        return jBIterable;
    }

    @NotNull
    public final Self unique() {
        Self Self = this.unique(Functions.identity());
        if (Self == null) {
            FilteredTraverserBase.$$$reportNull$$$0(27);
        }
        return Self;
    }

    @NotNull
    public final Self unique(final @NotNull Function<? super T, Object> identity) {
        if (identity == null) {
            FilteredTraverserBase.$$$reportNull$$$0(28);
        }
        Self Self = this.interceptTraversal(new Function<TreeTraversal, TreeTraversal>(){

            @Override
            public TreeTraversal fun(TreeTraversal traversal) {
                return traversal.unique(identity);
            }
        });
        if (Self == null) {
            FilteredTraverserBase.$$$reportNull$$$0(29);
        }
        return Self;
    }

    @NotNull
    public Self onRange(final @NotNull Condition<? super T> rangeCondition) {
        if (rangeCondition == null) {
            FilteredTraverserBase.$$$reportNull$$$0(30);
        }
        Self Self = this.interceptTraversal(new Function<TreeTraversal, TreeTraversal>(){

            @Override
            public TreeTraversal fun(TreeTraversal traversal) {
                return traversal.onRange(rangeCondition);
            }
        });
        if (Self == null) {
            FilteredTraverserBase.$$$reportNull$$$0(31);
        }
        return Self;
    }

    @NotNull
    public final Self forceIgnore(@NotNull Condition<? super T> c) {
        if (c == null) {
            FilteredTraverserBase.$$$reportNull$$$0(32);
        }
        Self Self = this.newInstance(this.myMeta.forceIgnore(c));
        if (Self == null) {
            FilteredTraverserBase.$$$reportNull$$$0(33);
        }
        return Self;
    }

    @NotNull
    public final Self forceDisregard(@NotNull Condition<? super T> c) {
        if (c == null) {
            FilteredTraverserBase.$$$reportNull$$$0(34);
        }
        Self Self = this.newInstance(this.myMeta.forceDisregard(c));
        if (Self == null) {
            FilteredTraverserBase.$$$reportNull$$$0(35);
        }
        return Self;
    }

    @NotNull
    public final Self interceptTraversal(@NotNull Function<TreeTraversal, TreeTraversal> transform) {
        if (transform == null) {
            FilteredTraverserBase.$$$reportNull$$$0(36);
        }
        Self Self = this.newInstance(this.myMeta.interceptTraversal(transform));
        if (Self == null) {
            FilteredTraverserBase.$$$reportNull$$$0(37);
        }
        return Self;
    }

    @NotNull
    public final JBIterable<T> children(@Nullable T node) {
        if (node == null || this.isAlwaysLeaf(node)) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                FilteredTraverserBase.$$$reportNull$$$0(38);
            }
            return jBIterable;
        }
        if (this.myMeta.regard.next == null && this.myMeta.forceDisregard.next == null) {
            JBIterable jBIterable = JBIterable.from(this.myTree.fun(node)).filter(Conditions.not(this.myMeta.forceIgnore.OR));
            if (jBIterable == null) {
                FilteredTraverserBase.$$$reportNull$$$0(39);
            }
            return jBIterable;
        }
        JBIterable<T> jBIterable = TreeTraversal.GUIDED_TRAVERSAL(this.myMeta.createChildrenGuide(node)).traversal(node, this.myTree);
        if (jBIterable == null) {
            FilteredTraverserBase.$$$reportNull$$$0(40);
        }
        return jBIterable;
    }

    protected boolean isAlwaysLeaf(@NotNull T node) {
        if (node == null) {
            FilteredTraverserBase.$$$reportNull$$$0(41);
        }
        return !this.myMeta.expand.valueAnd(node);
    }

    @NotNull
    public final List<T> toList() {
        List<T> list2 = this.traverse().toList();
        if (list2 == null) {
            FilteredTraverserBase.$$$reportNull$$$0(42);
        }
        return list2;
    }

    @NotNull
    public final Set<T> toSet() {
        Set<T> set = this.traverse().toSet();
        if (set == null) {
            FilteredTraverserBase.$$$reportNull$$$0(43);
        }
        return set;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{traversal=" + this.myMeta.traversal + '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/FilteredTraverserBase";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "traversal";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 17: 
            case 19: 
            case 23: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identity";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeCondition";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transform";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/FilteredTraverserBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTree";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "traverse";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "biOrderDfsTraversal";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "preOrderDfsTraversal";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "postOrderDfsTraversal";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "bfsTraversal";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "tracingBfsTraversal";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "reset";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "withRoot";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "withRoots";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "withTraversal";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "expand";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "regard";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "expandAndFilter";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "expandAndSkip";
                break;
            }
            case 24: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "filter";
                break;
            }
            case 27: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "unique";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "onRange";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "forceIgnore";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "forceDisregard";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "interceptTraversal";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "children";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "toList";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "toSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "traverse";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "withRoots";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "expand";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "regard";
                break;
            }
            case 23: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "filter";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "unique";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "onRange";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "forceIgnore";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "forceDisregard";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "interceptTraversal";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isAlwaysLeaf";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Cond<T> {
        static final Cond TRUE = new Cond<Object>(Conditions.TRUE, null);
        static final Cond FALSE = new Cond<Object>(Conditions.FALSE, null);
        final Condition<? super T> impl;
        final Cond<T> next;
        final Condition<? super T> OR = new Condition<T>(){

            @Override
            public boolean value(T t) {
                return Cond.this.valueOr(t);
            }
        };
        final Condition<? super T> AND = new Condition<T>(){

            @Override
            public boolean value(T t) {
                return Cond.this.valueAnd(t);
            }
        };

        Cond(Condition<? super T> impl, Cond<T> next) {
            this.impl = impl;
            this.next = next;
        }

        Cond<T> append(Condition<? super T> impl) {
            return new Cond<T>(impl, this);
        }

        boolean valueAnd(T t) {
            Cond<T> c = this;
            while (c != null) {
                if (!c.impl.value(t)) {
                    return false;
                }
                c = c.next;
            }
            return true;
        }

        boolean valueOr(T t) {
            Cond<T> c = this;
            while (c != null) {
                if (c.impl.value(t)) {
                    return true;
                }
                c = c.next;
            }
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Cond{");
            Cond<T> c = this;
            while (c != null) {
                sb.append(JBIterator.toShortString(c.impl));
                if (c.next != null) {
                    sb.append(", ");
                }
                c = c.next;
            }
            return sb.append("}").toString();
        }
    }

    protected static class Meta<T> {
        final TreeTraversal traversal;
        final Iterable<? extends T> roots;
        final Cond<T> expand;
        final Cond<T> regard;
        final Cond<T> filter;
        final Cond<T> forceIgnore;
        final Cond<T> forceDisregard;
        final Function<TreeTraversal, TreeTraversal> interceptor;
        private static final Meta<?> EMPTY = new Meta(JBIterable.empty(), TreeTraversal.PRE_ORDER_DFS, Cond.TRUE, Cond.TRUE, Cond.TRUE, Cond.FALSE, Cond.FALSE, Functions.<TreeTraversal>id());

        public Meta(@NotNull Iterable<? extends T> roots2, @NotNull TreeTraversal traversal, @NotNull Cond<T> expand2, @NotNull Cond<T> regard, @NotNull Cond<T> filter2, @NotNull Cond<T> forceIgnore, @NotNull Cond<T> forceDisregard, @NotNull Function<TreeTraversal, TreeTraversal> interceptor) {
            if (roots2 == null) {
                Meta.$$$reportNull$$$0(0);
            }
            if (traversal == null) {
                Meta.$$$reportNull$$$0(1);
            }
            if (expand2 == null) {
                Meta.$$$reportNull$$$0(2);
            }
            if (regard == null) {
                Meta.$$$reportNull$$$0(3);
            }
            if (filter2 == null) {
                Meta.$$$reportNull$$$0(4);
            }
            if (forceIgnore == null) {
                Meta.$$$reportNull$$$0(5);
            }
            if (forceDisregard == null) {
                Meta.$$$reportNull$$$0(6);
            }
            if (interceptor == null) {
                Meta.$$$reportNull$$$0(7);
            }
            this.roots = roots2;
            this.traversal = traversal;
            this.expand = expand2;
            this.regard = regard;
            this.filter = filter2;
            this.forceIgnore = forceIgnore;
            this.forceDisregard = forceDisregard;
            this.interceptor = interceptor;
        }

        public Meta<T> reset() {
            Meta<T> e = Meta.empty();
            return new Meta<T>(this.roots, e.traversal, e.expand, e.regard, e.filter, this.forceIgnore, this.forceDisregard, e.interceptor);
        }

        public Meta<T> withRoots(@NotNull Iterable<? extends T> roots2) {
            if (roots2 == null) {
                Meta.$$$reportNull$$$0(8);
            }
            return new Meta<T>(roots2, this.traversal, this.expand, this.regard, this.filter, this.forceIgnore, this.forceDisregard, this.interceptor);
        }

        public Meta<T> withTraversal(TreeTraversal traversal) {
            return new Meta<T>(this.roots, traversal, this.expand, this.regard, this.filter, this.forceIgnore, this.forceDisregard, this.interceptor);
        }

        public Meta<T> expand(@NotNull Condition<? super T> c) {
            if (c == null) {
                Meta.$$$reportNull$$$0(9);
            }
            return new Meta<T>(this.roots, this.traversal, this.expand.append(c), this.regard, this.filter, this.forceIgnore, this.forceDisregard, this.interceptor);
        }

        public Meta<T> regard(@NotNull Condition<? super T> c) {
            if (c == null) {
                Meta.$$$reportNull$$$0(10);
            }
            return new Meta<T>(this.roots, this.traversal, this.expand, this.regard.append(c), this.filter, this.forceIgnore, this.forceDisregard, this.interceptor);
        }

        public Meta<T> filter(@NotNull Condition<? super T> c) {
            if (c == null) {
                Meta.$$$reportNull$$$0(11);
            }
            return new Meta<T>(this.roots, this.traversal, this.expand, this.regard, this.filter.append(c), this.forceIgnore, this.forceDisregard, this.interceptor);
        }

        public Meta<T> forceIgnore(Condition<? super T> c) {
            return new Meta<T>(this.roots, this.traversal, this.expand, this.regard, this.filter, this.forceIgnore.append(c), this.forceDisregard, this.interceptor);
        }

        public Meta<T> forceDisregard(Condition<? super T> c) {
            return new Meta<T>(this.roots, this.traversal, this.expand, this.regard, this.filter, this.forceIgnore, this.forceDisregard.append(c), this.interceptor);
        }

        public Meta<T> interceptTraversal(Function<TreeTraversal, TreeTraversal> transform) {
            if (transform == Function.ID) {
                return this;
            }
            Function<TreeTraversal, TreeTraversal> newTransform = this.interceptor == Function.ID ? transform : Functions.compose(this.interceptor, transform);
            return new Meta<T>(this.roots, this.traversal, this.expand, this.regard, this.filter, this.forceIgnore, this.forceDisregard, newTransform);
        }

        TreeTraversal.GuidedIt.Guide<T> createChildrenGuide(final T parent2) {
            return new TreeTraversal.GuidedIt.Guide<T>(){
                final Condition<? super T> expand;
                {
                    this.expand = Meta.this.buildExpandConditionForChildren(parent2);
                }

                @Override
                public void guide(@NotNull TreeTraversal.GuidedIt<T> guidedIt) {
                    if (guidedIt == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    Meta.this.doPerformChildrenGuidance(guidedIt, this.expand);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "guidedIt", "com/intellij/util/containers/FilteredTraverserBase$Meta$1", "guide"));
                }
            };
        }

        private void doPerformChildrenGuidance(TreeTraversal.GuidedIt<T> it, Condition<? super T> expand2) {
            if (it.curChild == null) {
                return;
            }
            if (this.forceIgnore.valueOr(it.curChild)) {
                return;
            }
            if (it.curParent == null || expand2.value(it.curChild)) {
                it.queueNext(it.curChild);
            } else {
                it.result(it.curChild);
            }
        }

        private Condition<? super T> buildExpandConditionForChildren(T parent2) {
            Cond copy = null;
            boolean invert = true;
            Cond<T> c = this.regard;
            while (c != null) {
                Condition impl = JBIterable.Stateful.copy(c.impl);
                if (impl != (invert ? Condition.TRUE : Condition.FALSE)) {
                    copy = new Cond(invert ? Conditions.not(impl) : impl, copy);
                    if (impl instanceof EdgeFilter) {
                        ((EdgeFilter)impl).edgeSource = parent2;
                    }
                }
                if (c.next == null) {
                    c = invert ? this.forceDisregard : null;
                    invert = false;
                    continue;
                }
                c = c.next;
            }
            return copy == null ? Condition.FALSE : copy.OR;
        }

        public static <T> Meta<T> empty() {
            return EMPTY;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "traversal";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expand";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "regard";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filter";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "forceIgnore";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "forceDisregard";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interceptor";
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "c";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/containers/FilteredTraverserBase$Meta";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "withRoots";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "expand";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "regard";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "filter";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class EdgeFilter<T>
    extends JBIterable.SCond<T> {
        protected T edgeSource;
    }
}

