/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform.internal;

import java.io.File;
import java.util.List;
import net.rubygrapefruit.platform.DirEntry;
import net.rubygrapefruit.platform.FileInfo;
import net.rubygrapefruit.platform.FilePermissionException;
import net.rubygrapefruit.platform.NativeException;
import net.rubygrapefruit.platform.PosixFileInfo;
import net.rubygrapefruit.platform.PosixFiles;
import net.rubygrapefruit.platform.internal.AbstractFiles;
import net.rubygrapefruit.platform.internal.DirList;
import net.rubygrapefruit.platform.internal.FileStat;
import net.rubygrapefruit.platform.internal.FunctionResult;
import net.rubygrapefruit.platform.internal.jni.PosixFileFunctions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPosixFiles
extends AbstractFiles
implements PosixFiles {
    @Override
    public PosixFileInfo stat(File file) throws NativeException {
        return this.stat(file, false);
    }

    @Override
    public PosixFileInfo stat(File file, boolean linkTarget) throws NativeException {
        FunctionResult result = new FunctionResult();
        FileStat stat = new FileStat(file.getPath());
        PosixFileFunctions.stat(file.getPath(), linkTarget, stat, result);
        if (result.isFailed()) {
            if (result.getFailure() == FunctionResult.Failure.Permissions) {
                throw new FilePermissionException(String.format("Could not get file details of %s: permission denied", file));
            }
            throw new NativeException(String.format("Could not get file details of %s: %s", file, result.getMessage()));
        }
        return stat;
    }

    public List<DirEntry> listDir(File dir) throws NativeException {
        return this.listDir(dir, false);
    }

    public List<DirEntry> listDir(File dir, boolean linkTarget) throws NativeException {
        FunctionResult result = new FunctionResult();
        DirList dirList = new DirList();
        PosixFileFunctions.readdir(dir.getPath(), linkTarget, dirList, result);
        if (result.isFailed()) {
            throw this.listDirFailure(dir, result);
        }
        return dirList.files;
    }

    @Override
    public void setMode(File file, int perms) {
        FunctionResult result = new FunctionResult();
        PosixFileFunctions.chmod(file.getPath(), perms, result);
        if (result.isFailed()) {
            throw new NativeException(String.format("Could not set UNIX mode on %s: %s", file, result.getMessage()));
        }
    }

    @Override
    public int getMode(File file) {
        PosixFileInfo stat = this.stat(file);
        if (stat.getType() == FileInfo.Type.Missing) {
            throw new NativeException(String.format("Could not get UNIX mode on %s: file does not exist.", file));
        }
        return stat.getMode();
    }

    @Override
    public String readLink(File link) throws NativeException {
        FunctionResult result = new FunctionResult();
        String contents = PosixFileFunctions.readlink(link.getPath(), result);
        if (result.isFailed()) {
            throw new NativeException(String.format("Could not read symlink %s: %s", link, result.getMessage()));
        }
        return contents;
    }

    @Override
    public void symlink(File link, String contents) throws NativeException {
        FunctionResult result = new FunctionResult();
        PosixFileFunctions.symlink(link.getPath(), contents, result);
        if (result.isFailed()) {
            throw new NativeException(String.format("Could not create symlink %s: %s", link, result.getMessage()));
        }
    }
}

