/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitutor;

public class SubstitutionUtils {
    private SubstitutionUtils() {
    }

    @NotNull
    public static TypeSubstitutor buildDeepSubstitutor(@NotNull KotlinType type2) {
        HashMap<TypeConstructor, TypeProjection> substitution2 = Maps.newHashMap();
        TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(substitution2);
        SubstitutionUtils.fillInDeepSubstitutor(type2, typeSubstitutor2, substitution2, null);
        return typeSubstitutor2;
    }

    @NotNull
    public static Multimap<TypeParameterDescriptor, TypeProjection> buildDeepSubstitutionMultimap(@NotNull KotlinType type2) {
        LinkedHashMultimap<TypeParameterDescriptor, TypeProjection> fullSubstitution = LinkedHashMultimap.create();
        HashMap<TypeConstructor, TypeProjection> substitution2 = Maps.newHashMap();
        TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(substitution2);
        SubstitutionUtils.fillInDeepSubstitutor(type2, typeSubstitutor2, substitution2, fullSubstitution);
        return fullSubstitution;
    }

    private static void fillInDeepSubstitutor(@NotNull KotlinType context, @NotNull TypeSubstitutor substitutor2, @NotNull Map<TypeConstructor, TypeProjection> substitution2, @Nullable Multimap<TypeParameterDescriptor, TypeProjection> typeParameterMapping) {
        List<TypeParameterDescriptor> parameters2 = context.getConstructor().getParameters();
        List<TypeProjection> arguments2 = context.getArguments();
        if (parameters2.size() != arguments2.size()) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < arguments2.size(); ++i) {
            TypeProjection argument = arguments2.get(i);
            TypeParameterDescriptor parameter = parameters2.get(i);
            TypeProjection substitute2 = substitutor2.substitute(argument);
            assert (substitute2 != null);
            substitution2.put(parameter.getTypeConstructor(), substitute2);
            if (typeParameterMapping == null) continue;
            typeParameterMapping.put(parameter, substitute2);
        }
        if (KotlinBuiltIns.isNothingOrNullableNothing(context)) {
            return;
        }
        for (KotlinType supertype : context.getConstructor().getSupertypes()) {
            SubstitutionUtils.fillInDeepSubstitutor(supertype, substitutor2, substitution2, typeParameterMapping);
        }
    }
}

