/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.utils;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FindClassInModuleKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModalityKt;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsConditional;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperator;
import org.jetbrains.kotlin.js.backend.ast.metadata.BoxingKind;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SpecialFunction;
import org.jetbrains.kotlin.js.translate.context.TemporaryConstVariable;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.expression.InlineMetadata;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.KotlinType;

public final class TranslationUtils {
    private static final Set<FqNameUnsafe> CLASSES_WITH_NON_BOXED_CHARS = new HashSet<FqNameUnsafe>(Arrays.asList(new FqNameUnsafe("kotlin.collections.CharIterator"), new FqNameUnsafe("kotlin.ranges.CharProgression"), new FqNameUnsafe("kotlin.js.internal.CharCompanionObject"), new FqNameUnsafe("kotlin.Char.Companion"), KotlinBuiltIns.FQ_NAMES.charSequence, KotlinBuiltIns.FQ_NAMES.number));

    private TranslationUtils() {
    }

    @NotNull
    public static JsPropertyInitializer translateFunctionAsEcma5PropertyDescriptor(@NotNull JsFunction function2, @NotNull FunctionDescriptor descriptor2, @NotNull TranslationContext context) {
        JsExpression functionExpression = function2;
        if (InlineUtil.isInline(descriptor2)) {
            InlineMetadata metadata2 = InlineMetadata.compose(function2, descriptor2, context);
            PsiElement sourceInfo = KotlinSourceElementKt.getPsi(descriptor2.getSource());
            functionExpression = metadata2.functionWithMetadata(context, sourceInfo);
        }
        if (DescriptorUtils.isExtension(descriptor2) || descriptor2 instanceof PropertyAccessorDescriptor && TranslationUtils.shouldAccessViaFunctions(((PropertyAccessorDescriptor)descriptor2).getCorrespondingProperty())) {
            return TranslationUtils.translateExtensionFunctionAsEcma5DataDescriptor(functionExpression, descriptor2, context);
        }
        JsStringLiteral getOrSet = new JsStringLiteral(TranslationUtils.getAccessorFunctionName(descriptor2));
        return new JsPropertyInitializer(getOrSet, functionExpression);
    }

    @NotNull
    private static String getAccessorFunctionName(@NotNull FunctionDescriptor descriptor2) {
        boolean isGetter = descriptor2 instanceof PropertyGetterDescriptor || descriptor2 instanceof LocalVariableAccessorDescriptor.Getter;
        return isGetter ? "get" : "set";
    }

    @NotNull
    public static JsFunction simpleReturnFunction(@NotNull JsScope functionScope, @NotNull JsExpression returnExpression) {
        JsReturn jsReturn = new JsReturn(returnExpression);
        jsReturn.setSource(returnExpression.getSource());
        return new JsFunction(functionScope, new JsBlock((JsStatement)jsReturn), "<simpleReturnFunction>");
    }

    @NotNull
    private static JsPropertyInitializer translateExtensionFunctionAsEcma5DataDescriptor(@NotNull JsExpression functionExpression, @NotNull FunctionDescriptor descriptor2, @NotNull TranslationContext context) {
        JsObjectLiteral meta = JsAstUtils.createDataDescriptor(functionExpression, ModalityKt.isOverridable(descriptor2), false);
        return new JsPropertyInitializer(context.getNameForDescriptor(descriptor2).makeRef(), meta);
    }

    @NotNull
    public static JsExpression translateExclForBinaryEqualLikeExpr(@NotNull JsBinaryOperation baseBinaryExpression) {
        JsBinaryOperator negatedOperator = TranslationUtils.notOperator(baseBinaryExpression.getOperator());
        assert (negatedOperator != null) : "Can't negate operator: " + baseBinaryExpression.getOperator();
        return new JsBinaryOperation(negatedOperator, baseBinaryExpression.getArg1(), baseBinaryExpression.getArg2());
    }

    public static boolean isEqualLikeOperator(@NotNull JsBinaryOperator operator) {
        return TranslationUtils.notOperator(operator) != null;
    }

    @Nullable
    private static JsBinaryOperator notOperator(@NotNull JsBinaryOperator operator) {
        switch (operator) {
            case REF_EQ: {
                return JsBinaryOperator.REF_NEQ;
            }
            case REF_NEQ: {
                return JsBinaryOperator.REF_EQ;
            }
            case EQ: {
                return JsBinaryOperator.NEQ;
            }
            case NEQ: {
                return JsBinaryOperator.EQ;
            }
        }
        return null;
    }

    @NotNull
    public static JsBinaryOperation isNullCheck(@NotNull JsExpression expressionToCheck) {
        return TranslationUtils.nullCheck(expressionToCheck, false);
    }

    @NotNull
    private static JsBinaryOperation isNotNullCheck(@NotNull JsExpression expressionToCheck) {
        return TranslationUtils.nullCheck(expressionToCheck, true);
    }

    @NotNull
    public static JsBinaryOperation nullCheck(@NotNull JsExpression expressionToCheck, boolean isNegated) {
        JsBinaryOperator operator = isNegated ? JsBinaryOperator.NEQ : JsBinaryOperator.EQ;
        return new JsBinaryOperation(operator, expressionToCheck, new JsNullLiteral());
    }

    @NotNull
    public static JsConditional notNullConditional(@NotNull JsExpression expression2, @NotNull JsExpression elseExpression, @NotNull TranslationContext context) {
        JsExpression thenExpression;
        JsBinaryOperation testExpression;
        if (TranslationUtils.isCacheNeeded(expression2)) {
            TemporaryConstVariable tempVar = context.getOrDeclareTemporaryConstVariable(expression2);
            testExpression = TranslationUtils.isNotNullCheck(tempVar.value());
            thenExpression = tempVar.value();
        } else {
            testExpression = TranslationUtils.isNotNullCheck(expression2);
            thenExpression = expression2;
        }
        return new JsConditional(testExpression, thenExpression, elseExpression);
    }

    @NotNull
    public static JsName getNameForBackingField(@NotNull TranslationContext context, @NotNull PropertyDescriptor descriptor2) {
        if (TranslationUtils.isReferenceToSyntheticBackingField(descriptor2)) {
            return context.getNameForBackingField(descriptor2);
        }
        DeclarationDescriptor containingDescriptor = descriptor2.getContainingDeclaration();
        return containingDescriptor instanceof PackageFragmentDescriptor ? context.getInnerNameForDescriptor(descriptor2) : context.getNameForDescriptor(descriptor2);
    }

    public static boolean isReferenceToSyntheticBackingField(@NotNull PropertyDescriptor descriptor2) {
        DeclarationDescriptor containingDescriptor = descriptor2.getContainingDeclaration();
        return !JsDescriptorUtils.isSimpleFinalProperty(descriptor2) && !(containingDescriptor instanceof PackageFragmentDescriptor);
    }

    @NotNull
    public static JsNameRef backingFieldReference(@NotNull TranslationContext context, @NotNull PropertyDescriptor descriptor2) {
        DeclarationDescriptor containingDescriptor = descriptor2.getContainingDeclaration();
        JsExpression receiver = containingDescriptor instanceof PackageFragmentDescriptor ? null : context.getDispatchReceiver(JsDescriptorUtils.getReceiverParameterForDeclaration(containingDescriptor));
        JsNameRef result2 = new JsNameRef(TranslationUtils.getNameForBackingField(context, descriptor2), receiver);
        MetadataProperties.setType(result2, TranslationUtils.getReturnTypeForCoercion(descriptor2, true));
        return result2;
    }

    @NotNull
    public static JsExpression assignmentToBackingField(@NotNull TranslationContext context, @NotNull PropertyDescriptor descriptor2, @NotNull JsExpression assignTo) {
        JsNameRef backingFieldReference = TranslationUtils.backingFieldReference(context, descriptor2);
        return JsAstUtils.assignment(backingFieldReference, assignTo);
    }

    @Nullable
    public static JsExpression translateInitializerForProperty(@NotNull KtProperty declaration, @NotNull TranslationContext context) {
        JsExpression jsInitExpression = null;
        KtExpression initializer2 = declaration.getInitializer();
        if (initializer2 != null) {
            jsInitExpression = Translation.translateAsExpression(initializer2, context);
            KotlinType propertyType = BindingContextUtils.getNotNull(context.bindingContext(), BindingContext.VARIABLE, declaration).getType();
            jsInitExpression = TranslationUtils.coerce(context, jsInitExpression, propertyType);
        }
        return jsInitExpression;
    }

    @NotNull
    public static JsExpression translateBaseExpression(@NotNull TranslationContext context, @NotNull KtUnaryExpression expression2) {
        KtExpression baseExpression = PsiUtils.getBaseExpression(expression2);
        return Translation.translateAsExpression(baseExpression, context);
    }

    @NotNull
    public static JsExpression translateRightExpression(@NotNull TranslationContext context, @NotNull KtBinaryExpression expression2, @NotNull JsBlock block) {
        KtExpression rightExpression = expression2.getRight();
        assert (rightExpression != null) : "Binary expression should have a right expression";
        return Translation.translateAsExpression(rightExpression, context, block);
    }

    public static boolean hasCorrespondingFunctionIntrinsic(@NotNull TranslationContext context, @NotNull KtOperationExpression expression2) {
        CallableDescriptor operationDescriptor = BindingUtils.getCallableDescriptorForOperationExpression(context.bindingContext(), expression2);
        if (operationDescriptor == null || !(operationDescriptor instanceof FunctionDescriptor)) {
            return true;
        }
        KotlinType returnType = operationDescriptor.getReturnType();
        if (returnType != null && (KotlinBuiltIns.isChar(returnType) || KotlinBuiltIns.isLong(returnType) || KotlinBuiltIns.isInt(returnType))) {
            return false;
        }
        return context.intrinsics().getFunctionIntrinsic((FunctionDescriptor)operationDescriptor).exists();
    }

    @NotNull
    public static List<JsExpression> generateInvocationArguments(@NotNull JsExpression receiver, @NotNull List<? extends JsExpression> arguments2) {
        ArrayList<JsExpression> argumentList2 = new ArrayList<JsExpression>(1 + arguments2.size());
        argumentList2.add(receiver);
        argumentList2.addAll(arguments2);
        return argumentList2;
    }

    public static boolean isCacheNeeded(@NotNull JsExpression expression2) {
        if (expression2 instanceof JsLiteral.JsValueLiteral) {
            return false;
        }
        if (expression2 instanceof JsNameRef && ((JsNameRef)expression2).getQualifier() == null) {
            return false;
        }
        if (expression2 instanceof JsBinaryOperation) {
            JsBinaryOperation operation = (JsBinaryOperation)expression2;
            JsBinaryOperator operator = operation.getOperator();
            if (operator.isAssignment() || operator == JsBinaryOperator.COMMA) {
                return true;
            }
            return TranslationUtils.isCacheNeeded(operation.getArg1()) || TranslationUtils.isCacheNeeded(operation.getArg2());
        }
        if (expression2 instanceof JsUnaryOperation) {
            JsUnaryOperation operation = (JsUnaryOperation)expression2;
            JsUnaryOperator operator = operation.getOperator();
            switch (operator) {
                case BIT_NOT: 
                case NEG: 
                case POS: 
                case NOT: 
                case TYPEOF: 
                case VOID: {
                    return TranslationUtils.isCacheNeeded(operation.getArg());
                }
            }
            return true;
        }
        return true;
    }

    @NotNull
    public static JsExpression sure(@NotNull JsExpression expression2, @NotNull TranslationContext context) {
        return new JsInvocation(context.getReferenceToIntrinsic("ensureNotNull"), expression2);
    }

    public static boolean isSimpleNameExpressionNotDelegatedLocalVar(@Nullable KtExpression expression2, @NotNull TranslationContext context) {
        if (!(expression2 instanceof KtSimpleNameExpression)) {
            return false;
        }
        DeclarationDescriptor descriptor2 = context.bindingContext().get(BindingContext.REFERENCE_TARGET, (KtSimpleNameExpression)expression2);
        return !(descriptor2 instanceof LocalVariableDescriptor && ((LocalVariableDescriptor)descriptor2).isDelegated() || descriptor2 instanceof PropertyDescriptor && TranslationUtils.propertyAccessedByFunctionsInternally((PropertyDescriptor)descriptor2, context));
    }

    private static boolean propertyAccessedByFunctionsInternally(@NotNull PropertyDescriptor p, @NotNull TranslationContext context) {
        return !JsDescriptorUtils.isSimpleFinalProperty(p) && context.isFromCurrentModule(p) || TranslationUtils.shouldAccessViaFunctions(p);
    }

    public static boolean shouldAccessViaFunctions(@NotNull CallableDescriptor descriptor2) {
        if (descriptor2 instanceof PropertyDescriptor) {
            return TranslationUtils.shouldAccessViaFunctions((PropertyDescriptor)descriptor2);
        }
        if (descriptor2 instanceof PropertyAccessorDescriptor) {
            return TranslationUtils.shouldAccessViaFunctions(((PropertyAccessorDescriptor)descriptor2).getCorrespondingProperty());
        }
        return false;
    }

    private static boolean shouldAccessViaFunctions(@NotNull PropertyDescriptor property) {
        if (AnnotationsUtils.hasJsNameInAccessors(property)) {
            return true;
        }
        for (PropertyDescriptor propertyDescriptor : property.getOverriddenDescriptors()) {
            if (!TranslationUtils.shouldAccessViaFunctions(propertyDescriptor)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static JsExpression translateContinuationArgument(@NotNull TranslationContext context) {
        VariableDescriptor continuationDescriptor = TranslationUtils.getEnclosingContinuationParameter(context);
        return ReferenceTranslator.translateAsValueReference(continuationDescriptor, context);
    }

    @NotNull
    public static VariableDescriptor getEnclosingContinuationParameter(@NotNull TranslationContext context) {
        VariableDescriptor result2 = context.getContinuationParameterDescriptor();
        if (result2 == null) {
            assert (context.getParent() != null);
            result2 = TranslationUtils.getEnclosingContinuationParameter(context.getParent());
        }
        return result2;
    }

    @NotNull
    public static ClassDescriptor getCoroutineBaseClass(@NotNull TranslationContext context) {
        FqName className2 = DescriptorUtils.COROUTINES_PACKAGE_FQ_NAME.child(Name.identifier("CoroutineImpl"));
        ClassDescriptor descriptor2 = FindClassInModuleKt.findClassAcrossModuleDependencies(context.getCurrentModule(), ClassId.topLevel(className2));
        assert (descriptor2 != null);
        return descriptor2;
    }

    @NotNull
    public static PropertyDescriptor getCoroutineProperty(@NotNull TranslationContext context, @NotNull String name) {
        return TranslationUtils.getCoroutineBaseClass(context).getUnsubstitutedMemberScope().getContributedVariables(Name.identifier(name), NoLookupLocation.FROM_DESERIALIZATION).iterator().next();
    }

    @NotNull
    public static FunctionDescriptor getCoroutineDoResumeFunction(@NotNull TranslationContext context) {
        return TranslationUtils.getCoroutineBaseClass(context).getUnsubstitutedMemberScope().getContributedFunctions(Name.identifier("doResume"), NoLookupLocation.FROM_DESERIALIZATION).iterator().next();
    }

    public static boolean isOverridableFunctionWithDefaultParameters(@NotNull FunctionDescriptor descriptor2) {
        return DescriptorUtilsKt.hasOrInheritsParametersWithDefaultValue(descriptor2) && !(descriptor2 instanceof ConstructorDescriptor) && descriptor2.getContainingDeclaration() instanceof ClassDescriptor && ModalityKt.isOverridable(descriptor2);
    }

    @NotNull
    public static KotlinType getReturnTypeForCoercion(@NotNull CallableDescriptor descriptor2) {
        return TranslationUtils.getReturnTypeForCoercion(descriptor2, false);
    }

    @NotNull
    public static KotlinType getReturnTypeForCoercion(@NotNull CallableDescriptor descriptor2, boolean forcePrivate) {
        if (FunctionTypesKt.getFunctionalClassKind(descriptor2 = descriptor2.getOriginal()) != null || descriptor2 instanceof AnonymousFunctionDescriptor) {
            return TranslationUtils.getAnyTypeFromSameModule(descriptor2);
        }
        Collection<? extends CallableDescriptor> overridden = descriptor2.getOverriddenDescriptors();
        if (overridden.isEmpty()) {
            ClassDescriptor containingClass;
            FqNameUnsafe containingClassName;
            boolean isPublic;
            KotlinType returnType = descriptor2.getReturnType();
            if (returnType == null) {
                return TranslationUtils.getAnyTypeFromSameModule(descriptor2);
            }
            DeclarationDescriptor container2 = descriptor2.getContainingDeclaration();
            boolean bl = isPublic = descriptor2.getVisibility().effectiveVisibility(descriptor2, true).getPublicApi() && !forcePrivate;
            if (KotlinBuiltIns.isCharOrNullableChar(returnType) && container2 instanceof ClassDescriptor && isPublic && !CLASSES_WITH_NON_BOXED_CHARS.contains(containingClassName = DescriptorUtilsKt.getFqNameUnsafe(containingClass = (ClassDescriptor)container2)) && !KotlinBuiltIns.isPrimitiveType(containingClass.getDefaultType()) && !KotlinBuiltIns.isPrimitiveArray(containingClassName)) {
                return TranslationUtils.getAnyTypeFromSameModule(descriptor2);
            }
            return returnType;
        }
        Set typesFromOverriddenCallables = overridden.stream().map(o -> TranslationUtils.getReturnTypeForCoercion(o, forcePrivate)).collect(Collectors.toSet());
        return typesFromOverriddenCallables.size() == 1 ? (KotlinType)typesFromOverriddenCallables.iterator().next() : TranslationUtils.getAnyTypeFromSameModule(descriptor2);
    }

    @NotNull
    private static KotlinType getAnyTypeFromSameModule(@NotNull DeclarationDescriptor descriptor2) {
        return DescriptorUtils.getContainingModule(descriptor2).getBuiltIns().getAnyType();
    }

    @NotNull
    public static KotlinType getDispatchReceiverTypeForCoercion(@NotNull CallableDescriptor descriptor2) {
        if ((descriptor2 = descriptor2.getOriginal()).getDispatchReceiverParameter() == null) {
            throw new IllegalArgumentException("This method can only be used for class members; given descriptor is not a member of a class " + descriptor2);
        }
        Collection<? extends CallableDescriptor> overridden = descriptor2.getOverriddenDescriptors();
        if (overridden.isEmpty()) {
            return descriptor2.getDispatchReceiverParameter().getType();
        }
        Set typesFromOverriddenCallables = overridden.stream().map(TranslationUtils::getDispatchReceiverTypeForCoercion).collect(Collectors.toSet());
        return typesFromOverriddenCallables.size() == 1 ? (KotlinType)typesFromOverriddenCallables.iterator().next() : TranslationUtils.getAnyTypeFromSameModule(descriptor2);
    }

    @NotNull
    public static JsExpression coerce(@NotNull TranslationContext context, @NotNull JsExpression value, @NotNull KotlinType to) {
        if (DynamicTypesKt.isDynamic(to)) {
            return value;
        }
        KotlinType from = MetadataProperties.getType(value);
        if (from == null) {
            from = context.getCurrentModule().getBuiltIns().getAnyType();
        }
        if (from.equals(to)) {
            return value;
        }
        if (KotlinBuiltIns.isCharOrNullableChar(to)) {
            if (!KotlinBuiltIns.isCharOrNullableChar(from) && !(value instanceof JsNullLiteral)) {
                value = TranslationUtils.boxedCharToChar(context, value);
            }
        } else if (KotlinBuiltIns.isUnit(to)) {
            if (!KotlinBuiltIns.isUnit(from)) {
                value = TranslationUtils.unitToVoid(value);
            }
        } else if (KotlinBuiltIns.isCharOrNullableChar(from)) {
            if (!KotlinBuiltIns.isCharOrNullableChar(to) && !(value instanceof JsNullLiteral)) {
                value = TranslationUtils.charToBoxedChar(context, value);
            }
        } else if (KotlinBuiltIns.isUnit(from) && !KotlinBuiltIns.isUnit(to) && !MetadataProperties.isUnit(value)) {
            ClassDescriptor unit = context.getCurrentModule().getBuiltIns().getUnit();
            JsExpression unitRef = ReferenceTranslator.translateAsValueReference(unit, context);
            value = JsAstUtils.newSequence(Arrays.asList(value, unitRef));
        }
        MetadataProperties.setType(value, to);
        return value;
    }

    @NotNull
    private static JsExpression unitToVoid(@NotNull JsExpression expression2) {
        JsBinaryOperation binary;
        if (expression2 instanceof JsBinaryOperation && (binary = (JsBinaryOperation)expression2).getOperator() == JsBinaryOperator.COMMA && MetadataProperties.isUnit(binary.getArg2())) {
            return binary.getArg1();
        }
        return expression2;
    }

    @NotNull
    public static JsExpression charToBoxedChar(@NotNull TranslationContext context, @NotNull JsExpression expression2) {
        if (expression2 instanceof JsInvocation) {
            JsInvocation invocation = (JsInvocation)expression2;
            BoxingKind existingKind = MetadataProperties.getBoxing(invocation);
            switch (existingKind) {
                case UNBOXING: {
                    return invocation.getArguments().get(0);
                }
                case BOXING: {
                    return expression2;
                }
            }
        }
        JsInvocation result2 = TranslationUtils.invokeSpecialFunction(context, SpecialFunction.TO_BOXED_CHAR, expression2);
        result2.setSource(expression2.getSource());
        MetadataProperties.setBoxing(result2, BoxingKind.BOXING);
        return result2;
    }

    @NotNull
    private static JsExpression boxedCharToChar(@NotNull TranslationContext context, @NotNull JsExpression expression2) {
        if (expression2 instanceof JsInvocation) {
            JsInvocation invocation = (JsInvocation)expression2;
            BoxingKind existingKind = MetadataProperties.getBoxing(invocation);
            switch (existingKind) {
                case BOXING: {
                    return invocation.getArguments().get(0);
                }
                case UNBOXING: {
                    return expression2;
                }
            }
        }
        JsInvocation result2 = TranslationUtils.invokeSpecialFunction(context, SpecialFunction.UNBOX_CHAR, expression2);
        result2.setSource(expression2.getSource());
        MetadataProperties.setBoxing(result2, BoxingKind.UNBOXING);
        return result2;
    }

    @NotNull
    public static JsInvocation invokeSpecialFunction(@NotNull TranslationContext context, @NotNull SpecialFunction function2, JsExpression ... arguments2) {
        JsName name = context.getNameForSpecialFunction(function2);
        return new JsInvocation((JsExpression)JsAstUtils.pureFqn(name, null), arguments2);
    }

    @NotNull
    public static String getTagForSpecialFunction(@NotNull SpecialFunction specialFunction) {
        return "special:" + specialFunction.name();
    }

    @NotNull
    public static JsExpression getIntrinsicFqn(@NotNull String name) {
        JsNameRef fqn = JsAstUtils.pureFqn("Kotlin", null);
        for (String part : StringUtil.split(name, ".")) {
            fqn = JsAstUtils.pureFqn(part, (JsExpression)fqn);
        }
        return fqn;
    }
}

