/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.kt.externalsources;

import java.io.File;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.javacs.kt.LoggerKt;
import org.javacs.kt.externalsources.Decompiler;
import org.javacs.kt.util.KotlinLSException;
import org.javacs.kt.util.UtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.decompiler.main.decompiler.ConsoleDecompiler;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\u0004H\u0002J\u0016\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004H\u0016J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004H\u0002R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lorg/javacs/kt/externalsources/FernflowerDecompiler;", "Lorg/javacs/kt/externalsources/Decompiler;", "()V", "outputDir", "Ljava/nio/file/Path;", "getOutputDir", "()Ljava/nio/file/Path;", "outputDir$delegate", "Lkotlin/Lazy;", "createOutputDirectory", "decompile", "compiledClassOrJar", "newFileExtension", "", "decompileClass", "compiledClass", "decompileJar", "compiledJar", "invokeDecompiler", "", "input", "output", "server"})
@SourceDebugExtension(value={"SMAP\nFernflowerDecompiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FernflowerDecompiler.kt\norg/javacs/kt/externalsources/FernflowerDecompiler\n+ 2 Utils.kt\norg/javacs/kt/util/UtilsKt\n*L\n1#1,47:1\n31#2,5:48\n*S KotlinDebug\n*F\n+ 1 FernflowerDecompiler.kt\norg/javacs/kt/externalsources/FernflowerDecompiler\n*L\n32#1:48,5\n*E\n"})
public final class FernflowerDecompiler
implements Decompiler {
    @NotNull
    private final Lazy outputDir$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Path>((Object)this){

        @NotNull
        public final Path invoke() {
            return FernflowerDecompiler.access$createOutputDirectory((FernflowerDecompiler)this.receiver);
        }
    }));

    private final Path getOutputDir() {
        Lazy lazy = this.outputDir$delegate;
        return (Path)lazy.getValue();
    }

    @Override
    @NotNull
    public Path decompileClass(@NotNull Path compiledClass) {
        Intrinsics.checkNotNullParameter((Object)compiledClass, (String)"compiledClass");
        return this.decompile(compiledClass, ".java");
    }

    @Override
    @NotNull
    public Path decompileJar(@NotNull Path compiledJar) {
        Intrinsics.checkNotNullParameter((Object)compiledJar, (String)"compiledJar");
        return this.decompile(compiledJar, ".jar");
    }

    @NotNull
    public final Path decompile(@NotNull Path compiledClassOrJar, @NotNull String newFileExtension) {
        Intrinsics.checkNotNullParameter((Object)compiledClassOrJar, (String)"compiledClassOrJar");
        Intrinsics.checkNotNullParameter((Object)newFileExtension, (String)"newFileExtension");
        this.invokeDecompiler(compiledClassOrJar, this.getOutputDir());
        Path path = compiledClassOrJar.getFileName();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getFileName(...)");
        Path srcOutName = UtilsKt.replaceExtensionWith((Path)path, (String)newFileExtension);
        Path srcOutPath = this.getOutputDir().resolve(srcOutName);
        if (!Files.exists(srcOutPath, new LinkOption[0])) {
            throw new KotlinLSException("Could not decompile " + compiledClassOrJar.getFileName() + ": Fernflower did not generate sources at " + srcOutPath.getFileName());
        }
        Intrinsics.checkNotNull((Object)srcOutPath);
        return srcOutPath;
    }

    private final void invokeDecompiler(Path input, Path output) {
        Object[] objectArray = new Object[]{input.getFileName()};
        LoggerKt.getLOG().info("Decompiling {} using Fernflower...", objectArray);
        PrintStream delegateOut$iv = (PrintStream)LoggerKt.getLOG().getOutStream();
        boolean $i$f$withCustomStdout = false;
        PrintStream actualOut$iv = System.out;
        System.setOut(delegateOut$iv);
        boolean bl = false;
        String[] stringArray = new String[]{((Object)input).toString(), ((Object)output).toString()};
        ConsoleDecompiler.main((String[])stringArray);
        System.setOut(actualOut$iv);
    }

    private final Path createOutputDirectory() {
        Path out = Files.createTempDirectory("fernflowerOut", new FileAttribute[0]);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> FernflowerDecompiler.createOutputDirectory$lambda$1(out)));
        Intrinsics.checkNotNull((Object)out);
        return out;
    }

    @Override
    @NotNull
    public Path fetchSourceArchive(@NotNull Path compiledArchive) {
        return Decompiler.DefaultImpls.fetchSourceArchive(this, compiledArchive);
    }

    private static final void createOutputDirectory$lambda$1(Path $out) {
        File file = $out.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        FilesKt.deleteRecursively((File)file);
    }

    public static final /* synthetic */ Path access$createOutputDirectory(FernflowerDecompiler $this) {
        return $this.createOutputDirectory();
    }
}

