/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.clean;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsArrayAccess;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsConditional;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.js.backend.ast.metadata.HasMetadata;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\b\u001a\u00020\u0007J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003H\u0002J\u001c\u0010\u000f\u001a\u00020\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/IfStatementReduction;", "", "root", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "<init>", "(Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;)V", "hasChanges", "", "apply", "visitor", "Lorg/jetbrains/kotlin/js/backend/ast/JsVisitorWithContextImpl;", "getVisitor", "()Lorg/jetbrains/kotlin/js/backend/ast/JsVisitorWithContextImpl;", "extractSingleStatement", "statement", "lhsEqual", "a", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "b", "js.translator"})
public final class IfStatementReduction {
    @NotNull
    private final JsStatement root;
    private boolean hasChanges;
    @NotNull
    private final JsVisitorWithContextImpl visitor;

    public IfStatementReduction(@NotNull JsStatement root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.root = root;
        this.visitor = new JsVisitorWithContextImpl(this){
            final /* synthetic */ IfStatementReduction this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean visit(JsIf x, JsContext<JsNode> ctx) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                JsStatement jsStatement = x.getThenStatement();
                Intrinsics.checkNotNullExpressionValue((Object)jsStatement, (String)"getThenStatement(...)");
                JsStatement thenStatementRaw = jsStatement;
                JsStatement elseStatementRaw = x.getElseStatement();
                if (MetadataProperties.getSynthetic(x) && elseStatementRaw != null) {
                    JsStatement thenStatement = IfStatementReduction.access$extractSingleStatement(this.this$0, thenStatementRaw);
                    JsStatement elseStatement = IfStatementReduction.access$extractSingleStatement(this.this$0, elseStatementRaw);
                    if (thenStatement instanceof JsExpressionStatement && elseStatement instanceof JsExpressionStatement) {
                        Pair<JsExpression, JsExpression> thenAssignment = JsAstUtils.decomposeAssignment(((JsExpressionStatement)thenStatement).getExpression());
                        Pair<JsExpression, JsExpression> elseAssignment = JsAstUtils.decomposeAssignment(((JsExpressionStatement)elseStatement).getExpression());
                        if (thenAssignment != null && elseAssignment != null) {
                            JsExpression thenTarget = (JsExpression)thenAssignment.component1();
                            JsExpression thenValue = (JsExpression)thenAssignment.component2();
                            JsExpression elseTarget = (JsExpression)elseAssignment.component1();
                            JsExpression elseValue = (JsExpression)elseAssignment.component2();
                            if (IfStatementReduction.access$lhsEqual(this.this$0, thenTarget, elseTarget)) {
                                IfStatementReduction.access$setHasChanges$p(this.this$0, true);
                                JsConditional ternary = new JsConditional(x.getIfExpression(), thenValue, elseValue);
                                JsExpressionStatement replacement = new JsExpressionStatement(JsAstUtils.assignment(thenTarget, ternary));
                                MetadataProperties.setSynthetic(replacement, MetadataProperties.getSynthetic((HasMetadata)((Object)thenStatement)) && MetadataProperties.getSynthetic((HasMetadata)((Object)elseStatement)));
                                ctx.replaceMe((JsNode)replacement);
                                this.accept((JsNode)replacement);
                                return false;
                            }
                        }
                    } else if (thenStatement instanceof JsVars && elseStatement instanceof JsVars) {
                        if (((JsVars)thenStatement).getVars().size() == 1 && ((JsVars)elseStatement).getVars().size() == 1) {
                            JsVars.JsVar thenVar = ((JsVars)thenStatement).getVars().get(0);
                            JsVars.JsVar elseVar = ((JsVars)elseStatement).getVars().get(0);
                            JsExpression thenValue = thenVar.getInitExpression();
                            JsExpression elseValue = elseVar.getInitExpression();
                            if (Intrinsics.areEqual((Object)thenVar.getName(), (Object)elseVar.getName()) && thenValue != null && elseValue != null) {
                                IfStatementReduction.access$setHasChanges$p(this.this$0, true);
                                JsConditional ternary = new JsConditional(x.getIfExpression(), thenValue, elseValue);
                                JsVars jsVars = JsAstUtils.newVar(thenVar.getName(), ternary);
                                Intrinsics.checkNotNullExpressionValue((Object)jsVars, (String)"newVar(...)");
                                JsVars replacement = jsVars;
                                MetadataProperties.setSynthetic(replacement, MetadataProperties.getSynthetic((HasMetadata)((Object)thenStatement)) && MetadataProperties.getSynthetic((HasMetadata)((Object)elseStatement)));
                                ctx.replaceMe((JsNode)replacement);
                                this.accept((JsNode)replacement);
                                return false;
                            }
                        }
                    } else if (thenStatement instanceof JsReturn && elseStatement instanceof JsReturn) {
                        JsExpression thenValue = ((JsReturn)thenStatement).getExpression();
                        JsExpression elseValue = ((JsReturn)elseStatement).getExpression();
                        if (thenValue != null && elseValue != null) {
                            IfStatementReduction.access$setHasChanges$p(this.this$0, true);
                            JsConditional ternary = new JsConditional(x.getIfExpression(), thenValue, elseValue);
                            JsReturn replacement = new JsReturn(ternary);
                            this.accept((JsNode)replacement);
                            ctx.replaceMe((JsNode)replacement);
                            return false;
                        }
                    }
                }
                return super.visit(x, ctx);
            }
        };
    }

    public final boolean apply() {
        this.visitor.accept((JsNode)this.root);
        return this.hasChanges;
    }

    @NotNull
    public final JsVisitorWithContextImpl getVisitor() {
        return this.visitor;
    }

    private final JsStatement extractSingleStatement(JsStatement statement) {
        JsStatement result2 = statement;
        while (result2 instanceof JsBlock && ((JsBlock)result2).getStatements().size() == 1) {
            result2 = ((JsBlock)result2).getStatements().get(0);
        }
        return result2;
    }

    private final boolean lhsEqual(JsExpression a, JsExpression b) {
        return a == null && b == null ? true : (a instanceof JsNameRef && b instanceof JsNameRef ? Intrinsics.areEqual((Object)((JsNameRef)a).getName(), (Object)((JsNameRef)b).getName()) && this.lhsEqual(((JsNameRef)a).getQualifier(), ((JsNameRef)b).getQualifier()) : (a instanceof JsArrayAccess && b instanceof JsArrayAccess ? this.lhsEqual(((JsArrayAccess)a).getArrayExpression(), ((JsArrayAccess)b).getArrayExpression()) && this.lhsEqual(((JsArrayAccess)a).getIndexExpression(), ((JsArrayAccess)b).getIndexExpression()) : false));
    }

    public static final /* synthetic */ JsStatement access$extractSingleStatement(IfStatementReduction $this, JsStatement statement) {
        return $this.extractSingleStatement(statement);
    }

    public static final /* synthetic */ boolean access$lhsEqual(IfStatementReduction $this, JsExpression a, JsExpression b) {
        return $this.lhsEqual(a, b);
    }

    public static final /* synthetic */ void access$setHasChanges$p(IfStatementReduction $this, boolean bl) {
        $this.hasChanges = bl;
    }
}

