/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.lightTree;

import com.intellij.lang.LighterASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lang.impl.PsiBuilderImpl;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtIoFileSourceFile;
import org.jetbrains.kotlin.KtSourceFile;
import org.jetbrains.kotlin.KtSourceFileLinesMapping;
import org.jetbrains.kotlin.KtSourceFileLinesMappingKt;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.lightTree.LightTreeParsingErrorListener;
import org.jetbrains.kotlin.fir.lightTree.LightTreeParsingErrorListenerKt;
import org.jetbrains.kotlin.fir.lightTree.converter.LightTreeRawFirDeclarationBuilder;
import org.jetbrains.kotlin.fir.scopes.FirScopeProvider;
import org.jetbrains.kotlin.lexer.KotlinLexer;
import org.jetbrains.kotlin.parsing.KotlinLightParser;
import org.jetbrains.kotlin.parsing.KotlinParserDefinition;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011J$\u0010\f\u001a\u00020\r2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/fir/lightTree/LightTree2Fir;", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeProvider", "Lorg/jetbrains/kotlin/fir/scopes/FirScopeProvider;", "diagnosticsReporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/scopes/FirScopeProvider;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "buildFirFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "path", "Ljava/nio/file/Path;", "file", "Ljava/io/File;", "lightTree", "Lcom/intellij/util/diff/FlyweightCapableTreeStructure;", "Lcom/intellij/lang/LighterASTNode;", "sourceFile", "Lorg/jetbrains/kotlin/KtSourceFile;", "linesMapping", "Lorg/jetbrains/kotlin/KtSourceFileLinesMapping;", "code", "", "makeErrorListener", "Lorg/jetbrains/kotlin/fir/lightTree/LightTreeParsingErrorListener;", "Companion", "light-tree2fir"})
public final class LightTree2Fir {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FirSession session;
    @NotNull
    private final FirScopeProvider scopeProvider;
    @Nullable
    private final DiagnosticReporter diagnosticsReporter;
    @NotNull
    private static final KotlinParserDefinition parserDefinition = new KotlinParserDefinition();

    public LightTree2Fir(@NotNull FirSession session2, @NotNull FirScopeProvider scopeProvider, @Nullable DiagnosticReporter diagnosticsReporter) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)scopeProvider, (String)"scopeProvider");
        this.session = session2;
        this.scopeProvider = scopeProvider;
        this.diagnosticsReporter = diagnosticsReporter;
    }

    public /* synthetic */ LightTree2Fir(FirSession firSession, FirScopeProvider firScopeProvider, DiagnosticReporter diagnosticReporter, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            diagnosticReporter = null;
        }
        this(firSession, firScopeProvider, diagnosticReporter);
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @NotNull
    public final FirFile buildFirFile(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File file2 = path.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
        return this.buildFirFile(file2);
    }

    @NotNull
    public final FirFile buildFirFile(@NotNull File file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        KtIoFileSourceFile sourceFile = new KtIoFileSourceFile(file2);
        InputStreamReader $this$buildFirFile_u24lambda_u240 = new InputStreamReader((InputStream)new FileInputStream(file2), Charsets.UTF_8);
        boolean bl = false;
        Pair<CharSequence, KtSourceFileLinesMapping> pair = KtSourceFileLinesMappingKt.readSourceFileWithMapping($this$buildFirFile_u24lambda_u240);
        CharSequence code = (CharSequence)pair.component1();
        KtSourceFileLinesMapping linesMapping = (KtSourceFileLinesMapping)pair.component2();
        return this.buildFirFile(code, (KtSourceFile)sourceFile, linesMapping);
    }

    @NotNull
    public final FirFile buildFirFile(@NotNull FlyweightCapableTreeStructure<LighterASTNode> lightTree, @NotNull KtSourceFile sourceFile, @NotNull KtSourceFileLinesMapping linesMapping) {
        Intrinsics.checkNotNullParameter(lightTree, (String)"lightTree");
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        Intrinsics.checkNotNullParameter((Object)linesMapping, (String)"linesMapping");
        LightTreeRawFirDeclarationBuilder lightTreeRawFirDeclarationBuilder = new LightTreeRawFirDeclarationBuilder(this.session, this.scopeProvider, lightTree, null, 8, null);
        LighterASTNode lighterASTNode = lightTree.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)lighterASTNode, (String)"getRoot(...)");
        return lightTreeRawFirDeclarationBuilder.convertFile(lighterASTNode, sourceFile, linesMapping);
    }

    @NotNull
    public final FirFile buildFirFile(@NotNull CharSequence code, @NotNull KtSourceFile sourceFile, @NotNull KtSourceFileLinesMapping linesMapping) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        Intrinsics.checkNotNullParameter((Object)linesMapping, (String)"linesMapping");
        LightTreeParsingErrorListener errorListener = this.makeErrorListener(sourceFile);
        FlyweightCapableTreeStructure<LighterASTNode> lightTree = Companion.buildLightTree(code, errorListener);
        return this.buildFirFile(lightTree, sourceFile, linesMapping);
    }

    private final LightTreeParsingErrorListener makeErrorListener(KtSourceFile sourceFile) {
        DiagnosticReporter diagnosticReporter = this.diagnosticsReporter;
        if (diagnosticReporter == null) {
            return null;
        }
        DiagnosticReporter diagnosticsReporter = diagnosticReporter;
        return LightTreeParsingErrorListenerKt.toKotlinParsingErrorListener(diagnosticsReporter, sourceFile, FirLanguageSettingsComponentKt.getLanguageVersionSettings(this.session));
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0002J\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ>\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\n2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\r\u001a\u00020\u000e2\u0016\b\u0002\u0010\u0013\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u00150\u0014H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/fir/lightTree/LightTree2Fir$Companion;", "", "<init>", "()V", "parserDefinition", "Lorg/jetbrains/kotlin/parsing/KotlinParserDefinition;", "makeLexer", "Lorg/jetbrains/kotlin/lexer/KotlinLexer;", "buildLightTree", "Lcom/intellij/util/diff/FlyweightCapableTreeStructure;", "Lcom/intellij/lang/LighterASTNode;", "code", "", "errorListener", "Lorg/jetbrains/kotlin/fir/lightTree/LightTreeParsingErrorListener;", "reportErrors", "", "node", "tree", "ref", "Lcom/intellij/openapi/util/Ref;", "", "light-tree2fir"})
    public static final class Companion {
        private Companion() {
        }

        private final KotlinLexer makeLexer() {
            return new KotlinLexer();
        }

        @NotNull
        public final FlyweightCapableTreeStructure<LighterASTNode> buildLightTree(@NotNull CharSequence code, @Nullable LightTreeParsingErrorListener errorListener) {
            FlyweightCapableTreeStructure<LighterASTNode> flyweightCapableTreeStructure;
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            PsiBuilder psiBuilder = PsiBuilderFactory.getInstance().createBuilder(parserDefinition, (Lexer)this.makeLexer(), code);
            Intrinsics.checkNotNullExpressionValue((Object)psiBuilder, (String)"createBuilder(...)");
            PsiBuilder builder = psiBuilder;
            FlyweightCapableTreeStructure<LighterASTNode> it = flyweightCapableTreeStructure = KotlinLightParser.parse(builder);
            boolean bl = false;
            if (errorListener != null) {
                LighterASTNode lighterASTNode = it.getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)lighterASTNode, (String)"getRoot(...)");
                Intrinsics.checkNotNull(it);
                org.jetbrains.kotlin.fir.lightTree.LightTree2Fir$Companion.reportErrors$default(Companion, lighterASTNode, it, errorListener, null, 8, null);
            }
            FlyweightCapableTreeStructure<LighterASTNode> flyweightCapableTreeStructure2 = flyweightCapableTreeStructure;
            Intrinsics.checkNotNullExpressionValue(flyweightCapableTreeStructure2, (String)"also(...)");
            return flyweightCapableTreeStructure2;
        }

        private final void reportErrors(LighterASTNode node, FlyweightCapableTreeStructure<LighterASTNode> tree, LightTreeParsingErrorListener errorListener, Ref<LighterASTNode[]> ref) {
            tree.getChildren(node, ref);
            LighterASTNode[] lighterASTNodeArray = ref.get();
            if (lighterASTNodeArray == null) {
                return;
            }
            for (LighterASTNode kid : lighterASTNodeArray) {
                if (kid == null) break;
                IElementType tokenType = kid.getTokenType();
                if (Intrinsics.areEqual((Object)tokenType, (Object)TokenType.ERROR_ELEMENT)) {
                    String message = PsiBuilderImpl.getErrorMessage(kid);
                    errorListener.onError(kid.getStartOffset(), kid.getEndOffset(), message);
                }
                ref.set(null);
                this.reportErrors(kid, tree, errorListener, ref);
            }
        }

        static /* synthetic */ void reportErrors$default(Companion companion, LighterASTNode lighterASTNode, FlyweightCapableTreeStructure flyweightCapableTreeStructure, LightTreeParsingErrorListener lightTreeParsingErrorListener, Ref ref, int n, Object object) {
            if ((n & 8) != 0) {
                ref = new Ref<LighterASTNode[]>();
            }
            companion.reportErrors(lighterASTNode, flyweightCapableTreeStructure, lightTreeParsingErrorListener, ref);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

