/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.kt.j2k;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiLambdaExpressionType;
import com.intellij.psi.PsiMethodReferenceType;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.javacs.kt.LoggerKt;
import org.javacs.kt.j2k.PlatformTypeConverterKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00022\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u00022\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u00022\u0006\u0010'\u001a\u00020(H\u0016\u00a8\u0006)"}, d2={"Lorg/javacs/kt/j2k/JavaTypeConverter;", "Lcom/intellij/psi/PsiTypeVisitor;", "", "<init>", "()V", "visitType", "type", "Lcom/intellij/psi/PsiType;", "visitPrimitiveType", "primitiveType", "Lcom/intellij/psi/PsiPrimitiveType;", "visitArrayType", "arrayType", "Lcom/intellij/psi/PsiArrayType;", "visitClassType", "classType", "Lcom/intellij/psi/PsiClassType;", "visitCapturedWildcardType", "capturedWildcardType", "Lcom/intellij/psi/PsiCapturedWildcardType;", "visitWildcardType", "wildcardType", "Lcom/intellij/psi/PsiWildcardType;", "visitEllipsisType", "ellipsisType", "Lcom/intellij/psi/PsiEllipsisType;", "visitDisjunctionType", "disjunctionType", "Lcom/intellij/psi/PsiDisjunctionType;", "visitIntersectionType", "intersectionType", "Lcom/intellij/psi/PsiIntersectionType;", "visitDiamondType", "diamondType", "Lcom/intellij/psi/PsiDiamondType;", "visitLambdaExpressionType", "lambdaExpressionType", "Lcom/intellij/psi/PsiLambdaExpressionType;", "visitMethodReferenceType", "methodReferenceType", "Lcom/intellij/psi/PsiMethodReferenceType;", "server"})
@SourceDebugExtension(value={"SMAP\nJavaTypeConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaTypeConverter.kt\norg/javacs/kt/j2k/JavaTypeConverter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,78:1\n1#2:79\n*E\n"})
public final class JavaTypeConverter
extends PsiTypeVisitor<String> {
    @NotNull
    public static final JavaTypeConverter INSTANCE = new JavaTypeConverter();

    private JavaTypeConverter() {
    }

    @NotNull
    public String visitType(@NotNull PsiType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        String string = type.getPresentableText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPresentableText(...)");
        return string;
    }

    @NotNull
    public String visitPrimitiveType(@NotNull PsiPrimitiveType primitiveType) {
        String string;
        Intrinsics.checkNotNullParameter((Object)primitiveType, (String)"primitiveType");
        String string2 = primitiveType.getCanonicalText();
        switch (string2.hashCode()) {
            case 3625364: {
                if (string2.equals("void")) {
                    string = "Unit";
                    break;
                }
            }
            default: {
                String string3 = primitiveType.getCanonicalText();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getCanonicalText(...)");
                String string4 = string3;
                if (((CharSequence)string4).length() > 0) {
                    char it = string4.charAt(0);
                    boolean bl = false;
                    char c = Character.toUpperCase(it);
                    String string5 = string4;
                    int n = 1;
                    String string6 = string5.substring(n);
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
                    string5 = string6;
                    string = c + string5;
                    break;
                }
                string = string4;
            }
        }
        return string;
    }

    @NotNull
    public String visitArrayType(@NotNull PsiArrayType arrayType) {
        Object object;
        String string;
        Intrinsics.checkNotNullParameter((Object)arrayType, (String)"arrayType");
        try {
            string = arrayType.getComponentType().getCanonicalText();
        }
        catch (IllegalStateException e) {
            Object[] objectArray = new Object[]{e};
            LoggerKt.getLOG().warn("Error while fetching text representation of array type: {}", objectArray);
            string = "?";
        }
        switch (string) {
            case "byte": {
                object = "ByteArray";
                break;
            }
            case "short": {
                object = "ShortArray";
                break;
            }
            case "int": {
                object = "IntArray";
                break;
            }
            case "long": {
                object = "LongArray";
                break;
            }
            case "char": {
                object = "CharArray";
                break;
            }
            case "boolean": {
                object = "BooleanArray";
                break;
            }
            case "float": {
                object = "FloatArray";
                break;
            }
            case "double": {
                object = "DoubleArray";
                break;
            }
            default: {
                object = "Array<" + arrayType.getComponentType().accept((PsiTypeVisitor)this) + ">";
            }
        }
        return object;
    }

    @NotNull
    public String visitClassType(@NotNull PsiClassType classType) {
        Intrinsics.checkNotNullParameter((Object)classType, (String)"classType");
        PsiType[] psiTypeArray = classType.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)psiTypeArray, (String)"getParameters(...)");
        String it = SequencesKt.joinToString$default((Sequence)SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])psiTypeArray), JavaTypeConverter::visitClassType$lambda$1), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
        boolean bl = false;
        Object translatedTypeArgs = ((CharSequence)it).length() > 0 ? "<" + it + ">" : "";
        String string = classType.getClassName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getClassName(...)");
        return PlatformTypeConverterKt.platformType(string) + (String)translatedTypeArgs;
    }

    @NotNull
    public String visitCapturedWildcardType(@NotNull PsiCapturedWildcardType capturedWildcardType) {
        Intrinsics.checkNotNullParameter((Object)capturedWildcardType, (String)"capturedWildcardType");
        String string = (String)super.visitCapturedWildcardType(capturedWildcardType);
        if (string == null) {
            string = "?";
        }
        return string;
    }

    @NotNull
    public String visitWildcardType(@NotNull PsiWildcardType wildcardType) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)wildcardType, (String)"wildcardType");
        if (wildcardType.isSuper()) {
            PsiType psiType = wildcardType.getBound();
            object = "in " + (psiType != null ? (String)psiType.accept((PsiTypeVisitor)this) : null);
        } else if (wildcardType.isExtends()) {
            PsiType psiType = wildcardType.getBound();
            object = "out " + (psiType != null ? (String)psiType.accept((PsiTypeVisitor)this) : null);
        } else {
            object = (String)super.visitWildcardType(wildcardType);
            if (object == null) {
                object = "?";
            }
        }
        return object;
    }

    @NotNull
    public String visitEllipsisType(@NotNull PsiEllipsisType ellipsisType) {
        Intrinsics.checkNotNullParameter((Object)ellipsisType, (String)"ellipsisType");
        String string = (String)super.visitEllipsisType(ellipsisType);
        if (string == null) {
            string = "?";
        }
        return string;
    }

    @NotNull
    public String visitDisjunctionType(@NotNull PsiDisjunctionType disjunctionType) {
        Intrinsics.checkNotNullParameter((Object)disjunctionType, (String)"disjunctionType");
        String string = (String)super.visitDisjunctionType(disjunctionType);
        if (string == null) {
            string = "?";
        }
        return string;
    }

    @NotNull
    public String visitIntersectionType(@NotNull PsiIntersectionType intersectionType) {
        Intrinsics.checkNotNullParameter((Object)intersectionType, (String)"intersectionType");
        String string = (String)super.visitIntersectionType(intersectionType);
        if (string == null) {
            string = "?";
        }
        return string;
    }

    @NotNull
    public String visitDiamondType(@NotNull PsiDiamondType diamondType) {
        Intrinsics.checkNotNullParameter((Object)diamondType, (String)"diamondType");
        String string = (String)super.visitDiamondType(diamondType);
        if (string == null) {
            string = "?";
        }
        return string;
    }

    @NotNull
    public String visitLambdaExpressionType(@NotNull PsiLambdaExpressionType lambdaExpressionType) {
        Intrinsics.checkNotNullParameter((Object)lambdaExpressionType, (String)"lambdaExpressionType");
        String string = (String)super.visitLambdaExpressionType(lambdaExpressionType);
        if (string == null) {
            string = "?";
        }
        return string;
    }

    @NotNull
    public String visitMethodReferenceType(@NotNull PsiMethodReferenceType methodReferenceType) {
        Intrinsics.checkNotNullParameter((Object)methodReferenceType, (String)"methodReferenceType");
        Object object = super.visitMethodReferenceType(methodReferenceType);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"visitMethodReferenceType(...)");
        return (String)object;
    }

    private static final String visitClassType$lambda$1(PsiType it) {
        return (String)it.accept((PsiTypeVisitor)INSTANCE);
    }
}

