#ifndef _KOIO_PRIVATE_H
#define _KOIO_PRIVATE_H
#include <stdbool.h>

struct ko_hashtable_entry {
	struct ko_hashtable_entry *next;
	unsigned int hash;
	char *key;
	void *value;
};

struct ko_hashtable {
	struct ko_hashtable_entry *buckets[256];
};

extern struct ko_hashtable koio_vfs;

void *ko_hashtable_get(struct ko_hashtable *table, const char *key);
void *ko_hashtable_set(struct ko_hashtable *table, const char *key, void *value);
void *ko_hashtable_del(struct ko_hashtable *table, const void *key);

struct file_entry {
	char *data;
	size_t len;
};

struct path_alias {
	char *prefix;
	char *path;
	struct path_alias *next;
};

extern struct path_alias koio_aliases;

#endif
